/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.impl.query;

import java.util.ArrayList;
import java.util.List;
import order.dto.MallTempOrderDto;
import order.model.po.MallTempOrder;
import order.model.repository.MallTempOrderRepo;
import order.service.service.query.MallTempOrderQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class MallTempOrderQueryServiceImpl
implements MallTempOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(MallTempOrderQueryServiceImpl.class);
    @Autowired
    private MallTempOrderRepo mallTempOrderRepo;

    @Transactional
    public List<MallTempOrderDto> findAllMallTempOrder(String memeberId) {
        List mallTempOrders = this.mallTempOrderRepo.findByMemberId(memeberId);
        if (!Lang.isEmpty((Object)mallTempOrders)) {
            List mallTempOrderDtos = BeanMapper.mapList((Iterable)mallTempOrders, MallTempOrder.class, MallTempOrderDto.class);
            return mallTempOrderDtos;
        }
        return new ArrayList<MallTempOrderDto>();
    }

    @Transactional
    public MallTempOrderDto findMallTempOrderById(String orderId) {
        MallTempOrder mallTempOrder = this.mallTempOrderRepo.findById(orderId);
        MallTempOrderDto mallTempOrderDto = (MallTempOrderDto)BeanMapper.map((Object)mallTempOrder, MallTempOrderDto.class);
        return mallTempOrderDto;
    }

    public Integer countMallTempOrder(String memberId) {
        List mallTempOrderList = this.mallTempOrderRepo.findByMemberId(memberId);
        Integer size = 0;
        if (!Lang.isEmpty((Object)mallTempOrderList)) {
            size = mallTempOrderList.size();
        }
        return size;
    }
}

