/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.query;

import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.order.CartSimpleMallOrderDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsPictureDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import member.api.dto.shop.MemberAddressDto;
import order.dto.OrderQueryDto;
import order.model.po.OrderMain;
import order.model.po.OrderMain_;
import order.model.po.SubOrder;
import order.model.po.SubOrderItem;
import order.model.po.SubOrder_;
import order.model.repository.OrderRepos;
import order.model.repository.SubOrderRepos;
import order.model.specification.OrderMainSpecification;
import order.service.specification.QueryProviderOrdersSpecification;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.ShippingInfoApiStub;
import order.vo.OrderItemVo;
import order.vo.OrderKey;
import order.vo.query.OrderDetailQueryVo;
import order.vo.query.OrdersQueryVo;
import order.vo.query.SubOrderItemQueryVo;
import order.vo.query.SubOrderItemWithSubOrderNo;
import order.vo.query.SubOrderShippingListVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import store.api.MallShippingApi;
import utils.Lang;
import utils.collection.CollectionUtil;
import utils.sql.PageVo;

@Service
@Transactional(readOnly=true)
public class OrderMainQueryService {
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    SubOrderRepos subOrderRepos;
    @Autowired
    MemberAddressApiStub memberAddressApi;
    @Autowired
    ShippingInfoApiStub shippingInfoApi;
    @MotanReferer
    GoodsApi goodsapi;
    @MotanReferer
    MallShippingApi mallShippingApi;

    @Transactional
    public BaseResponse queryProviderOrdersDetails(String orderNo) {
        if (Lang.isEmpty((Object)orderNo)) {
            return new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
        }
        OrderDetailQueryVo orderDetailQueryVo = new OrderDetailQueryVo();
        OrderMain byOrderNo = this.orderRepos.findByOrderNo(orderNo);
        if (!Lang.isEmpty((Object)byOrderNo)) {
            orderDetailQueryVo.setOrderId(byOrderNo.getId());
            orderDetailQueryVo.setOrderNo(byOrderNo.getOrderNo());
            orderDetailQueryVo.setStoreName(byOrderNo.getStoreName());
            orderDetailQueryVo.setAddressName(byOrderNo.getAddressName());
            orderDetailQueryVo.setCreatedTime(byOrderNo.getCreateTime());
            orderDetailQueryVo.setSumCostPrice(byOrderNo.getSumPrice());
            MemberAddressDto byId = this.memberAddressApi.findById(byOrderNo.getAddressId());
            if (byId != null) {
                orderDetailQueryVo.setMemberName(byId.getUsername());
                orderDetailQueryVo.setMemberTel(byId.getPhone());
            }
            ArrayList list = new ArrayList();
            List orderItems = byOrderNo.getOrderItems();
            if (!Lang.isEmpty((Object)orderItems)) {
                orderItems.stream().forEach(orderItem -> {
                    OrderItemVo orderItemVo = new OrderItemVo();
                    orderItemVo.setProductName(orderItem.getProductName());
                    orderItemVo.setProductPic(orderItem.getProductPic());
                    orderItemVo.setCount(orderItem.getCount());
                    orderItemVo.setFinalPrice(orderItem.getFinalPrice());
                    orderItemVo.setGoodsId(orderItem.getGoodsId());
                    orderItemVo.setProductPrice(orderItem.getProductPrice());
                    list.add(orderItemVo);
                });
            }
            orderDetailQueryVo.setChildren(list);
            BigDecimal totalPrice = new BigDecimal(0);
            List subOrders = byOrderNo.getSubOrders();
            ArrayList<SubOrderItemWithSubOrderNo> subOrderItemWithSubOrderNos = new ArrayList<SubOrderItemWithSubOrderNo>();
            if (!Lang.isEmpty((Object)subOrders)) {
                for (SubOrder subOrder : subOrders) {
                    ArrayList<SubOrderItemQueryVo> subOrderItemQueryVos = new ArrayList<SubOrderItemQueryVo>();
                    BigDecimal SubOrderSumPrice = new BigDecimal(0);
                    SubOrderItemWithSubOrderNo subOrderItemWithSubOrderNo = new SubOrderItemWithSubOrderNo();
                    BigDecimal subOrderStatusAfterSendOrder = new BigDecimal(0);
                    if (TrdSpOrderStatus.Sent.getCode().equals(subOrder.getTrdOrderState()) || TrdSpOrderStatus.Received.getCode().equals(subOrder.getTrdOrderState()) || TrdSpOrderStatus.Rejected.getCode().equals(subOrder.getTrdOrderState())) {
                        subOrderStatusAfterSendOrder = subOrderStatusAfterSendOrder.add(new BigDecimal(1));
                    }
                    for (SubOrderItem subOrderItem : subOrder.getSubOrderItems()) {
                        SubOrderItemQueryVo subOrderItemQueryVo = new SubOrderItemQueryVo();
                        subOrderItemQueryVo.setCount(subOrderItem.getCount());
                        subOrderItemQueryVo.setId(subOrderItem.getId());
                        subOrderItemQueryVo.setNakedPrice(subOrderItem.getNakedPrice());
                        subOrderItemQueryVo.setTaxPrice(subOrderItem.getTaxPrice());
                        subOrderItemQueryVo.setCount(subOrderItem.getOrderItem().getCount());
                        subOrderItemQueryVo.setSkuId(subOrderItem.getOrderItem().getSku());
                        subOrderItemQueryVo.setPrice(subOrderItem.getOrderItem().getFinalPrice());
                        subOrderItemQueryVo.setName(subOrderItem.getOrderItem().getProductName());
                        subOrderItemQueryVo.setGoodsId(subOrderItem.getOrderItem().getGoodsId());
                        List picturesBySku = this.goodsapi.getPicturesBySku(subOrderItem.getSkuId());
                        if (!Lang.isEmpty((Object)picturesBySku) && !Lang.isEmpty(picturesBySku.get(0))) {
                            subOrderItemQueryVo.setPicturePath(((GoodsPictureDto)picturesBySku.get(0)).getPicturePath());
                        }
                        totalPrice = totalPrice.add(subOrderItem.getOrderItem().getFinalPrice().multiply(new BigDecimal(subOrderItem.getOrderItem().getCount())));
                        SubOrderSumPrice = SubOrderSumPrice.add(subOrderItem.getOrderItem().getFinalPrice().multiply(new BigDecimal(subOrderItem.getOrderItem().getCount())));
                        subOrderItemQueryVos.add(subOrderItemQueryVo);
                    }
                    orderDetailQueryVo.setTotalPrice(totalPrice);
                    orderDetailQueryVo.setSingleSubOrderStatus(subOrder.getTrdOrderState());
                    ArrayList subOrderShippingListVos = new ArrayList();
                    List mallShipping = this.mallShippingApi.findMallShipping(subOrder.getOrder().getOrderNo());
                    String[] shippingNo = new String[]{""};
                    if (!Lang.isEmpty((Object)mallShipping)) {
                        mallShipping.forEach(mallShippingDto -> {
                            SubOrderShippingListVo subOrderShippingListVo = new SubOrderShippingListVo();
                            subOrderShippingListVo.setLogisticNo(mallShippingDto.getShippingNo());
                            subOrderShippingListVo.setShippingCompanyName(mallShippingDto.getShippingCompany());
                            subOrderShippingListVo.setShippingRemark(mallShippingDto.getRemark());
                            subOrderShippingListVo.setShippingType(mallShippingDto.getShippingType());
                            subOrderShippingListVo.setShippingStatus(subOrder.getTrdOrderState());
                            subOrderShippingListVos.add(subOrderShippingListVo);
                        });
                    }
                    subOrderItemWithSubOrderNo.setSubOrderShippingListVos(subOrderShippingListVos);
                    subOrderItemWithSubOrderNo.setSubOrderStatusAfterSendOrder(subOrderStatusAfterSendOrder);
                    subOrderItemWithSubOrderNo.setSubOrderStatus(subOrder.getTrdOrderState());
                    subOrderItemWithSubOrderNo.setSubOrderNo(subOrder.getSubOrderNo());
                    subOrderItemWithSubOrderNo.setSubOrderItemQueryVos(subOrderItemQueryVos);
                    subOrderItemWithSubOrderNo.setSubOrderSumPrice(SubOrderSumPrice);
                    subOrderItemWithSubOrderNos.add(subOrderItemWithSubOrderNo);
                    orderDetailQueryVo.setSubOrderItemWithSubOrderNo(subOrderItemWithSubOrderNos);
                }
            }
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)orderDetailQueryVo, "0000");
    }

    @Transactional
    public BaseResponse queryProviderOrdersPage(OrderQueryDto orderQueryDto) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            if (!Lang.isEmpty((Object)orderQueryDto) && Lang.isEmpty((Object)orderQueryDto.getPageNo())) {
                orderQueryDto.setPageNo(Integer.valueOf(0));
            }
            if (!Lang.isEmpty((Object)orderQueryDto) && Lang.isEmpty((Object)orderQueryDto.getPageSize())) {
                orderQueryDto.setPageSize(Integer.valueOf(10));
            }
            if (Lang.isEmpty((Object)orderQueryDto)) {
                orderQueryDto = new OrderQueryDto();
                orderQueryDto.setPageNo(Integer.valueOf(0));
                orderQueryDto.setPageSize(Integer.valueOf(10));
            }
            int pageNo = orderQueryDto.getPageNo();
            int pageSize = orderQueryDto.getPageSize();
            String sortName = SubOrder_.order.getName() + "." + OrderMain_.createTime.getName();
            Sort sort = new Sort(Sort.Direction.DESC, new String[]{sortName});
            PageRequest pageable = new PageRequest(pageNo, pageSize, sort);
            QueryProviderOrdersSpecification specification = new QueryProviderOrdersSpecification(orderQueryDto, Boolean.valueOf(false));
            Page page = this.subOrderRepos.findAll((Specification)specification, (Pageable)pageable);
            List providerGoodsList = page.getContent();
            ArrayList providerGoodsVoList = new ArrayList();
            providerGoodsList.stream().forEach(subOrders -> {
                OrdersQueryVo orderVo = new OrdersQueryVo();
                orderVo.setAddressName(subOrders.getOrder().getAddressName());
                orderVo.setCreatedTime(subOrders.getOrder().getCreateTime());
                List mallShipping = this.mallShippingApi.findMallShipping(subOrders.getOrder().getOrderNo());
                String[] shippingNo = new String[]{""};
                if (!Lang.isEmpty((Object)mallShipping)) {
                    mallShipping.forEach(mallShippingDto -> {
                        shippingNo[0] = shippingNo[0] == "" ? shippingNo[0] + mallShippingDto.getShippingNo() : shippingNo[0] + "," + mallShippingDto.getShippingNo();
                    });
                }
                orderVo.setLogisticsNo(shippingNo[0]);
                orderVo.setOrderNo(subOrders.getOrder().getOrderNo());
                orderVo.setSumCostPrice(subOrders.getSumCostPrice());
                orderVo.setTrdOrderState(subOrders.getTrdOrderState());
                orderVo.setSubOrderNo(subOrders.getSubOrderNo());
                providerGoodsVoList.add(orderVo);
            });
            PageVo pageVo = new PageVo();
            pageVo.setResult(providerGoodsVoList);
            long totalElements = page.getTotalElements();
            pageVo.setTotalCount(Integer.valueOf((int)totalElements));
            pageVo.setPageNum(Integer.valueOf(page.getNumber()));
            pageVo.setPageSize(Integer.valueOf(page.getSize()));
            baseResponse = new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)pageVo, "0000");
        }
        catch (Exception e) {
            baseResponse = new BaseResponse(false, "\u5185\u90e8\u9519\u8bef", (Object)"", "110013");
            e.printStackTrace();
        }
        return baseResponse;
    }

    public OrderMain getOrder(String id) {
        return Lang.isEmpty((Object)id) ? null : this.orderRepos.findById(id);
    }

    public OrderMain findByOrderNo(String orderNo) {
        return Lang.isEmpty((Object)orderNo) ? null : this.orderRepos.findByOrderNo(orderNo);
    }

    public List<OrderMain> findByOrderNos(List<String> orderNos) {
        return this.orderRepos.findByOrderNoIn(orderNos);
    }

    public List<CartSimpleMallOrderDto> getMallSubOrderNos(String parentOrderId) {
        OrderMain orderMainExam = new OrderMain();
        orderMainExam.setParentOrderId(parentOrderId);
        OrderMainSpecification orderMainSpecification = new OrderMainSpecification(orderMainExam);
        List orderMains = this.orderRepos.findAll((Specification)orderMainSpecification);
        ArrayList<CartSimpleMallOrderDto> cartSimpleMallOrderDtos = new ArrayList<CartSimpleMallOrderDto>();
        if (CollectionUtil.isNoneEmpty((Collection)orderMains)) {
            orderMains.forEach(orderMain -> {
                CartSimpleMallOrderDto cartSimpleMallOrderDto = new CartSimpleMallOrderDto();
                cartSimpleMallOrderDto.setOrderId(orderMain.getId());
                cartSimpleMallOrderDto.setOrderNo(orderMain.getOrderNo());
                cartSimpleMallOrderDtos.add(cartSimpleMallOrderDto);
            });
        }
        return cartSimpleMallOrderDtos;
    }

    public List<OrderMain> findByKey(List<OrderKey> orderKeys) {
        if (orderKeys == null || orderKeys.size() <= 0) {
            return null;
        }
        if (orderKeys.stream().filter(i -> !i.isEmpty()).count() <= 0L) {
            return null;
        }
        return this.orderRepos.findAll((root, query, cb) -> {
            ArrayList keyQuerys = new ArrayList();
            ArrayList<Predicate> orQuerys = new ArrayList<Predicate>();
            for (OrderKey key : orderKeys) {
                if (!Lang.isEmpty((Object)key.getOrderId())) {
                    orQuerys.add(cb.equal((Expression)root.get(OrderMain_.id), (Object)key.getOrderId()));
                    continue;
                }
                if (Lang.isEmpty((Object)key.getOrderNo())) continue;
                orQuerys.add(cb.equal((Expression)root.get(OrderMain_.orderNo), (Object)key.getOrderNo()));
            }
            return cb.or(orQuerys.toArray(new Predicate[0]));
        });
    }

    public OrderMain findByKey(OrderKey orderKey) {
        if (orderKey == null) {
            return null;
        }
        if (Lang.isEmpty((Object)orderKey.getOrderId()) && Lang.isEmpty((Object)orderKey.getOrderNo())) {
            return null;
        }
        List r = this.findByKey((List)new /* Unavailable Anonymous Inner Class!! */);
        return r != null && r.size() > 0 ? (OrderMain)r.get(0) : null;
    }

    public String findOrderNoById(String orderId) {
        return this.orderRepos.findOrderNoById(orderId);
    }

    public String findOrderNoByThirdOrderNo(String trdOrderNo) {
        OrderMain om = this.orderRepos.findByThirdOrderNo(trdOrderNo);
        return om == null ? null : om.getOrderNo();
    }
}

