/*
 * Decompiled with CFR 0.152.
 */
package order.service.specification;

import cart.api.difinication.TrdSpOrderStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import order.dto.OrderQueryDto;
import order.model.po.OrderMain_;
import order.model.po.OrderTemplateAdapterConfig_;
import order.model.po.SubOrder;
import order.model.po.SubOrder_;
import order.service.specification.QuerySpecification;
import utils.Lang;

public class QueryProviderOrdersSpecification
extends QuerySpecification<SubOrder, OrderQueryDto> {
    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance) {
        this(queryInstance, Boolean.valueOf(true));
    }

    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance, Boolean ignoreNull) {
        super((Object)queryInstance, ignoreNull);
        this.ignoreNullExcluded.add(OrderTemplateAdapterConfig_.id);
    }

    public QueryProviderOrdersSpecification(OrderQueryDto queryInstance, Boolean ignoreNull, List<SingularAttribute> ignoreNullExcluded) {
        super((Object)queryInstance, ignoreNull, ignoreNullExcluded);
    }

    public Predicate toPredicate(Root<SubOrder> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Date beginTime = ((OrderQueryDto)super.getQueryInstance()).getBeginTime();
        Date endTime = ((OrderQueryDto)super.getQueryInstance()).getEndTime();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!Lang.isEmpty((Object)super.getQueryInstance())) {
            if (!Lang.isEmpty((Object)((OrderQueryDto)super.getQueryInstance()).getStoreId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.join(SubOrder_.order, JoinType.LEFT).get(OrderMain_.storeId), (Object)((OrderQueryDto)super.getQueryInstance()).getStoreId()));
            }
            if (!Lang.isEmpty((Object)((OrderQueryDto)super.getQueryInstance()).getOrderNo())) {
                predicates.add(criteriaBuilder.equal((Expression)root.join(SubOrder_.order, JoinType.LEFT).get(OrderMain_.orderNo), (Object)((OrderQueryDto)super.getQueryInstance()).getOrderNo()));
            }
        }
        if (!Lang.isEmpty((Object)((OrderQueryDto)super.getQueryInstance()).getTrdOrderState())) {
            if (!TrdSpOrderStatus.All.getCode().equals(((OrderQueryDto)super.getQueryInstance()).getTrdOrderState()) && !TrdSpOrderStatus.Canceled.getCode().equals(((OrderQueryDto)super.getQueryInstance()).getTrdOrderState())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get(SubOrder_.trdOrderState), (Object)((OrderQueryDto)super.getQueryInstance()).getTrdOrderState()));
            }
            if (TrdSpOrderStatus.Canceled.getCode().equals(((OrderQueryDto)super.getQueryInstance()).getTrdOrderState())) {
                predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get(SubOrder_.trdOrderState), (Object)((OrderQueryDto)super.getQueryInstance()).getTrdOrderState()), (Expression)criteriaBuilder.equal((Expression)root.get("trdOrderState"), (Object)TrdSpOrderStatus.SystemCanceled.getCode())));
            }
        }
        if (!Lang.isEmpty((Object)beginTime) && !Lang.isEmpty((Object)endTime)) {
            Date endDate = new Date(endTime.getTime() + 999L);
            predicates.add(criteriaBuilder.between((Expression)root.get(SubOrder_.order).get(OrderMain_.createTime), (Comparable)beginTime, (Comparable)endDate));
        } else if (!Lang.isEmpty((Object)beginTime) && Lang.isEmpty((Object)endTime)) {
            predicates.add(criteriaBuilder.greaterThan((Expression)root.get(SubOrder_.order).get(OrderMain_.createTime), (Comparable)beginTime));
        } else if (Lang.isEmpty((Object)beginTime) && !Lang.isEmpty((Object)endTime)) {
            predicates.add(criteriaBuilder.lessThan((Expression)root.get(SubOrder_.order).get(OrderMain_.createTime), (Comparable)endTime));
        }
        predicates.add(criteriaBuilder.equal((Expression)root.get(SubOrder_.isDelete), (Object)false));
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
    }
}

