/*
 * Decompiled with CFR 0.152.
 */
package order.service.stubs;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import cms.api.dto.SalesPriceRateDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

@Component
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class OrganizationApiStub {
    private static final Logger log = LoggerFactory.getLogger(OrganizationApiStub.class);
    private static Map<String, String> orgIdCodeMap = new ConcurrentHashMap();
    @MotanReferer
    OrganizationApi organizationApi;

    public OrganizationDto findOrganizationById(String id) {
        return this.organizationApi.findOrganizationById(id);
    }

    public List<OrganizationDto> findOrganizationByOrgName(String name) {
        return this.organizationApi.findOrganizationByOrgName(name);
    }

    public List<OrganizationDto> findOrganizationByOrgNameAndIsDelete(String name) {
        return this.organizationApi.findOrganizationByOrgNameAndIsDelete(name);
    }

    public Page<OrganizationDto> findOrganizationByOrgName(String orgName, Pageable pageable) {
        return this.organizationApi.findOrganizationByOrgName(orgName, pageable);
    }

    public List<OrganizationDto> findOrganizationAll() {
        return this.organizationApi.findOrganizationAll();
    }

    public Map listToMap() {
        return this.organizationApi.listToMap();
    }

    public OrganizationDto findOrganizationByOrgCode(String organizationCode) {
        return this.organizationApi.findOrganizationByOrgCode(organizationCode);
    }

    public List<SalesPriceRateDto> getOrgNameList(Page<SalesPriceRateDto> salesPriceRates) {
        return this.organizationApi.getOrgNameList(salesPriceRates);
    }

    public void insPectPrepaidDeposit() {
        this.organizationApi.insPectPrepaidDeposit();
    }

    public String findOrganizationIdByOrgCode(String organizationCode) {
        String id;
        Optional<Map.Entry> me = orgIdCodeMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(organizationCode)).findFirst();
        if (me.isPresent()) {
            id = (String)me.get().getKey();
        } else {
            id = this.organizationApi.findOrganizationIdByOrgCode(organizationCode);
            orgIdCodeMap.put(id, organizationCode);
        }
        return id;
    }

    public String findOrganizationNameByOrgCode(String organizationCode) {
        return this.organizationApi.findOrganizationNameByOrgCode(organizationCode);
    }

    public String findOrganizationCodeById(String id) {
        String code = (String)orgIdCodeMap.get(id);
        if (Lang.isEmpty((Object)code)) {
            code = this.organizationApi.findOrganizationCodeById(id);
            orgIdCodeMap.put(id, code);
        }
        return code;
    }
}

