/*
 * Decompiled with CFR 0.152.
 */
package order.service.stubs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductDto;
import goods.dto.product.ProductFashionDto;
import goods.vo.FashionIdAndCountVo;
import goods.vo.FashionStockRequest;
import goods.vo.FashionStockResult;
import goods.vo.ProductFashionVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Component
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class ProductFashionApiStub {
    private static final Logger log = LoggerFactory.getLogger(ProductFashionApiStub.class);
    public static final String PRODUCT_FASHION_STUB_CACHING_KEY_PREFIX = "order-service:stub:productfashion:cache";
    public static final Integer PRODUCT_FASHION_STUB_CACHING_TIMEOUT = 5000;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @MotanReferer
    ProductFashionApi productFashionApi;

    private Map getCachingMap() {
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)PRODUCT_FASHION_STUB_CACHING_KEY_PREFIX);
        String mapJson = (String)operations.get();
        if (!Lang.isEmpty((Object)mapJson)) {
            try {
                HashMap cachingMap = (HashMap)JSON.parseObject((String)mapJson, HashMap.class);
                return cachingMap;
            }
            catch (JSONException e) {
                log.error("\u89e3\u6790\u7f13\u5b58JSON\u62a5\u9519\uff0cJSON\u539f\u6587:{}", (Object)mapJson, (Object)e);
            }
        }
        return null;
    }

    private ProductFashionDto getInCache(String id) {
        try {
            Map cachingMap = this.getCachingMap();
            if (cachingMap != null) {
                ProductFashionDto bean = (ProductFashionDto)cachingMap.get(id);
                return bean;
            }
        }
        catch (ClassCastException ce) {
            log.error("\u7f13\u5b58\u5bf9\u8c61\u7c7b\u578b\u8f6c\u6362\u5931\u8d25", (Throwable)ce);
        }
        return null;
    }

    private void addToCache(List<ProductFashionDto> entitys) {
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)PRODUCT_FASHION_STUB_CACHING_KEY_PREFIX);
        Map cachingMap = this.getCachingMap();
        entitys.forEach(e -> {
            if (e != null) {
                cachingMap.put(e.getId(), e);
            }
        });
        operations.set((Object)JSON.toJSONString((Object)cachingMap), (long)PRODUCT_FASHION_STUB_CACHING_TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
    }

    public ProductFashionDto findById(String id, Boolean useCache) {
        ProductFashionDto bean = this.getInCache(id);
        if (!useCache.booleanValue() || bean == null) {
            bean = this.productFashionApi.findById(id);
        }
        return bean;
    }

    public ProductFashionDto findDtoById(String id, Boolean useCache) {
        ProductFashionDto bean = this.getInCache(id);
        if (!useCache.booleanValue() || bean == null) {
            bean = this.productFashionApi.findDtoById(id);
        }
        return bean;
    }

    public ProductFashionDto findSimple(String id) {
        return this.productFashionApi.findSimple(id);
    }

    public List<ProductFashionDto> findByProduct(ProductDto product) {
        return this.productFashionApi.findByProduct(product);
    }

    public ProductFashionVo findByGoodsId(String goodsId) {
        return this.productFashionApi.findByGoodsId(goodsId);
    }

    public List<ProductFashionDto> findAllBySku(List<String> skus) {
        return this.productFashionApi.findAllBySku(skus);
    }

    public List<String> findProductFashionIdBySku(String sku) {
        return this.productFashionApi.findProductFashionIdBySku(sku);
    }

    public String findSkuByProductFashionId(String productFashionId) {
        return this.productFashionApi.findSkuByProductFashionId(productFashionId);
    }

    public Map<String, Object> getStockCounts(List<String> fashionIds, String areaCode) {
        return this.productFashionApi.getStockCounts(fashionIds, areaCode);
    }

    public ProductFashionDto findOne(String id) {
        return this.productFashionApi.findOne(id);
    }

    public List<ProductFashionDto> findByIds(List<String> ids) {
        return this.productFashionApi.findByIds(ids);
    }

    public BaseResponse<FashionStockResult> queryFashionStockStatus(FashionStockRequest request) {
        return this.productFashionApi.queryFashionStockStatus(request);
    }

    public Map queryFashionStockStatus(List<FashionIdAndCountVo> fashionIdAndCountVoList, String areaCode, String orgId) {
        return this.productFashionApi.queryFashionStockStatus(fashionIdAndCountVoList, areaCode, orgId);
    }

    public List<ProductFashionVo> findByProductId(String productId) {
        return this.productFashionApi.findByProductId(productId);
    }

    public List<String> findIdsByProductId(String productId) {
        return this.productFashionApi.findIdsByProductId(productId);
    }

    public String findIdByGoodsId(String goodsId) {
        return this.productFashionApi.findIdByGoodsId(goodsId);
    }
}

