/*
 * Decompiled with CFR 0.152.
 */
package order.service.utils;

import order.service.factory.BatchOrderTemplateFactory;
import order.service.factory.OrderTemplateFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OrderTemplateFactoryUtil
implements ApplicationContextAware {
    private static final String ORDER_FACTORY_BEAN_CONFIG_KEY = "orderservice.ordertemplate.factor.beanname";
    private static final String BATCH_ORDER_FACTORY_BEAN_CONFIG_KEY = "orderservice.batchordertemplate.factor.beanname";
    private ApplicationContext applicationContext;
    @Autowired
    private Environment env;

    public OrderTemplateFactory getOrderTemplateFactory() {
        OrderTemplateFactory f = (OrderTemplateFactory)this.getFactory(this.readProp(ORDER_FACTORY_BEAN_CONFIG_KEY), OrderTemplateFactory.class);
        if (f == null) {
            throw new RuntimeException("the OrderTemplateFactory named " + this.readProp(ORDER_FACTORY_BEAN_CONFIG_KEY) + " is NOT FOUND!");
        }
        return f;
    }

    public BatchOrderTemplateFactory getBatchOrderTemplateFactory() {
        BatchOrderTemplateFactory f = (BatchOrderTemplateFactory)this.getFactory(this.readProp(BATCH_ORDER_FACTORY_BEAN_CONFIG_KEY), BatchOrderTemplateFactory.class);
        if (f == null) {
            throw new RuntimeException("the BatchOrderTemplateFactory named " + this.readProp(BATCH_ORDER_FACTORY_BEAN_CONFIG_KEY) + " is NOT FOUND!");
        }
        return f;
    }

    public <T> T getFactory(String factoryBeanName, Class<T> factoryClass) {
        T factory = factoryClass.cast(this.applicationContext.getBean(factoryBeanName));
        return factory;
    }

    public String readProp(String key) {
        return this.env.getProperty(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

