package order.web.config;

import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/2/7.
 */
@Configuration
@EnableCaching
public class CacheConfig {
    @Bean
    public CacheManager cacheManager(
            @SuppressWarnings("rawtypes") RedisTemplate redisTemplate) {
        RedisCacheManager cacheManager = new RedisCacheManager(redisTemplate);
        Map<String, Long> cacheExpires = new HashMap<>();
        //TODO: 更灵活的配置--读取配置文件
        cacheExpires.put(Constant.CACHE_NAMES_API_STORE, 60L);
        cacheManager.setExpires(cacheExpires);
        // 默认缓存过期，10s
        cacheManager.setDefaultExpiration(10L);

        return new RedisCacheManager(redisTemplate);
    }
}
