package order.web.service;

import cart.api.vo.TempOrderVo;
import member.api.dto.core.CoreCompanyDto;
import member.api.vo.MemberVo;
import order.web.vo.*;
import sinomall.global.common.response.BaseResponse;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
public interface MallBatchOrderService {
    /**
     * 查询购物车商品
     *
     *
     * @param addressId
     * @param userId
     * @param storeNo
     * @param goodsCode
     * @return
     */
    BaseResponse getCartGoods(String userId, String storeNo, String goodsCode,String addressId);

    /**
     * 获取所有店铺
     *
     * @return
     */
    BaseResponse getAllStore();

    /**
     * 校验商品状态
     *
     * @param checkGoodsStockVo
     * @param userId
     * @return
     */
    BaseResponse checkGoodsStatus(CheckGoodsStockVo checkGoodsStockVo, String userId);

    /**
     * 保存临时订单
     *
     * @param mallTempOrderVo
     * @return
     */
    BaseResponse saveTempOrder(MallTempOrderVo mallTempOrderVo);

    /**
     * 临时订单查询
     *
     * @param memberId
     * @return
     */
    BaseResponse queryTempOrder(String memberId);

    /**
     * 提交订单
     *
     * @param mallOrderSubmitVo
     * @param memberId
     * @param request
     * @return
     */
    BaseResponse submitMallOrder(MallOrderSubmitVo mallOrderSubmitVo, String memberId, HttpServletRequest request);

    /**
     * 下单校验
     *
     * @param sumfreight
     * @param memberId
     * @param request
     * @return
     */
    BaseResponse checkMallOrder(String sumfreight, String memberId, String userId, HttpServletRequest request);

    /**
     * 获取运费
     *
     * @param memberId
     * @param request
     * @return
     */
    BaseResponse getOrderFee(String memberId, HttpServletRequest request);

    /**
     * 获取保存的订单信息
     *
     * @param memberId
     * @return
     */
    BaseResponse getTempOrderInfo(String memberId);

    /**
     * 批量上传
     *
     * @param req
     * @return
     */
    BaseResponse batchImport(HttpServletRequest req);

    /**
     * 下载模板
     *
     * @param req
     */
    void downLoadExcel(HttpServletRequest req, HttpServletResponse response, String parame);

    /**
     * 保存临时订单扩展信息
     *
     * @param mallTempOrderInfoVo
     * @param memberId
     * @return
     */
    BaseResponse saveTempOrderInfo(MallTempOrderInfoVo mallTempOrderInfoVo, String memberId);

    /**
     * 查询开票机构信息
     *
     * @param companyId
     * @return
     */
    CoreCompanyDto getCoreCompanyInfoById(String companyId);

    /**
     * 删除临时订单
     *
     * @param temOrderId
     * @return
     */
    BaseResponse deleteOrderInfo(List<String> temOrderId);

    /**
     * 修改临时订单
     *
     * @param temOrderId
     * @return
     */
    BaseResponse updateOrderInfo(String temOrderId);

    /**
     * 修改会员地址编码
     */
    void changeMemberAddressNo();

    TiaoXianCompanyVo getBatchOrderiaoXianCompany(TiaoXianRequestVo tianXianRequestVo);

    /**
     * 根据会员id获取临时订单并生成订单，供导出协议提供数据
     *
     * @param memberId
     * @return
     */
    List<TempOrderVo> getMallTempOrderData(String memberId);

    /**
     * 获取会员信息
     *
     * @param memberId
     * @param userId
     * @return
     */
    public MemberVo findMemberVo(String memberId, String userId);

    /**
     * 批量打包
     *
     * @param dataList
     * @return
     */
    byte[] Zip(List<ZipExportStructure> dataList) throws IOException;

    MallTempOrderVo saveNewTempOrder(MallTempOrderVo mallTempOrderVo);
}
