package order.web.service.impl;

import cart.api.CartApi;
import cart.api.OrderMainApi;
import cart.api.QuotaApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.vo.*;
import cms.api.AddressApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.dto.MallBatchResponDto;
import goods.dto.ValidataGoodsResp;
import goods.dto.goods.GoodsConfigDto;
import goods.vo.ValidataGoods;
import goods.vo.query.GoodsConfigQuery;
import member.api.*;
import member.api.dto.common.TianXianDepartmentDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CorePositionDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.order.OrderInvoiceDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.*;
import member.api.vo.cart.InvoiceItemInfoVo;
import order.api.MallAttachmentApi;
import order.api.MallParentOrderApi;
import order.api.MallTempOrderApi;
import order.api.MallTempOrderInfoApi;
import order.api.query.MallParentOrderQueryApi;
import order.api.query.MallTempOrderInfoQueryApi;
import order.api.query.MallTempOrderQueryApi;
import order.definication.BatchOrderStatus;
import order.definication.GoodsStockStatus;
import order.definication.MallAttachmentBusinessCode;
import order.dto.*;
import order.web.service.MallBatchOrderService;
import order.web.utils.ReadExcel;
import order.web.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import shipping.api.InvoiceInfoApi;
import sinomall.global.common.response.BaseResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreNavDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemConfigDto;
import sysmg.dto.SystemLogDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.ReadExcelUtil;
import workflow.api.WfWorkFlowRelationApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.definition.AuditFlowImplInstance;
import workflow.definition.WorkFlowCode;
import workflow.dto.WfWorkFlowDefinitionDto;
import workflow.dto.WfWorkFlowRelationDto;
import workflow.dto.WorkFlowRequestDto;
import workflow.exceptions.AuditorNotFoundException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.*;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Service
public class MallBatchOrderServiceImpl implements MallBatchOrderService, InitializingBean, DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MallBatchOrderServiceImpl.class);

    // 定义获取运费线程池
    public static ExecutorService getFreightPool = null;
    public static ExecutorService pool = null;
    public static ExecutorService occupyStockPool = null;
//    static {
//        pool = Executors.newFixedThreadPool(3);
//        getFreightPool = Executors.newFixedThreadPool(4);
//        occupyStockPool = Executors.newFixedThreadPool(20);
//    }


    private static final String ORGANIZATIONCODE = "jicai";
    private static final Integer CONSIGNEE_FLAG_TRUE = 1;
    private static final Integer CONSIGNEE_FLAG_FALSE = 0;
    private static final Integer CONSIGNEE_FLAG_NOT = 2;
    private static final String BATCH_ORDER_TYPE = "批量订单";
    private static final String USER_TEMPORDER_KEY= "user_tempOrder_key";
    private static final String USER_DEALORDER_KEY= "user_dealOrder_key";
    // 是否与收件人地址相同 ，此处取不相同
    private static final Integer CONSIGNEE_FLAG = 0;
    //将上传的结果保存在session中
    public static final String UPLOAD_RESULT_DATA_SESSION = "BATCH_UPLOAD_RESULT_DATA";
    //导入结果下载标记位
    public static final String UPLOAD_RESULT_DATA_FLAG= "导入结果下载";

    //发票类型
    public final static String VALUE_ADDED_TAX_SPECIAL_INVOICE = "增值税专用发票";
    public final static String VALUE_ADDED_TAX_NOMAL_INVOICE = "增值税普通发票";

    //批量导入结果
    public static final String IMPORT_SUCCESS = "导入成功";
    //默认地址标记
    public static final String DEFAULT_ADDRESS_YES = "是";
    public static final String DEFAULT_ADDRESS_NO = "否";

    // 支付方式 1：在线支付
    private static final String PAY_TYPE_CODE="1";
    // 订单用途 1：资产 2：激励品 3：福利
    private static final String ORDER_USE_ASSET="1";
    private static final String ORDER_USE_IMPEL="2";
    private static final String ORDER_USE_GIFT="3";
    
    @MotanReferer
    private MallTempOrderApi mallTempOrderApi;
    @MotanReferer
    private MallTempOrderQueryApi mallTempOrderQueryApi;
    @MotanReferer
    private MallTempOrderInfoQueryApi mallTempOrderInfoQueryApi;
    @MotanReferer
    private MallTempOrderInfoApi mallTempOrderInfoApi;
    @MotanReferer
    private MallParentOrderApi mallParentOrderApi;
    @MotanReferer
    private MallParentOrderQueryApi mallParentOrderQueryApi;
    @MotanReferer
    private CartApi cartApi;
    @MotanReferer
    private GoodsConfigApi goodsConfigApi;
    @MotanReferer
    private OutsideProductApi outsideProductApi;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private StoreApi storeApi;
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private MemberApi memberApi;
    @MotanReferer
    private MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    private MallAttachmentApi mallAttachmentApi;
   @MotanReferer
    private InvoiceInfoApi invoiceInfoApi;
    @MotanReferer
    private ProductFashionApi productFashionApi;
    @MotanReferer
    private CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    private GoodsApi goodsApi;
    @MotanReferer
    private CoreCompanyApi coreCompanyApi;
    @MotanReferer
    private AddressApi addressApi;
    @MotanReferer
    private QueryInformationApi queryInformationApi;
    @MotanReferer
    private WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;
    @MotanReferer
    private WfWorkFlowRelationApi wfWorkFlowRelationApi;
    @MotanReferer
    private CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    private SystemLogApi systemLogApi;
    @MotanReferer
    private QuotaApi quotaApi;

    ThreadPoolExecutor orderValidatePool = null;




    @Override
    public BaseResponse getCartGoods(String userId, String storeNo, String goodsCode,String addressId) {
        if (Lang.isEmpty(userId)) {
            return new BaseResponse(false, "查询失败，请重新登录");
        }
        MemberAddressDto memberAddressDto = memberAddressApi.findDtoByIdAndIsDelete(addressId, false);
        CartDto userCart = cartApi.getUserCart(userId);
        List<CartItemDto> allCartItem = new ArrayList<>();
        if (!Lang.isEmpty(userCart)) {
            allCartItem.addAll(userCart.getCartItems());
        }
        /**
         * 筛选分为下列几种情况：
         *  1、店铺未选择，商品编码未填写---得到所有店铺下的购物车商品
         *  2、店铺已选择，商品编码已填写---从该店铺下筛选指定的购物车商品
         *  3、店铺未选择，商品编码已填写---筛选指定的购物车商品
         *  4、店铺已选择，商品编码未填写---从该店铺下筛选所有的购物车商品
         */
        // 存放筛选后的商品
        List<CartGoodsVo> cartGoodsVos = new ArrayList<>();
        if (!Lang.isEmpty(storeNo) && !Lang.isEmpty(goodsCode)) {
//            List<GoodsConfigDto> goods = goodsConfigApi.findBySkuAndOrganizationCode(goodsCode, ORGANIZATIONCODE);
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(new String[] {goodsCode}));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List<GoodsConfigDto> goods = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

            if (!Lang.isEmpty(goods)) {
                List<String> goodsIds = new ArrayList<>();
                for (CartItemDto cartItemDto : allCartItem) {
                    goodsIds.add(cartItemDto.getGoodsId());
                    if (StringUtils.equals(storeNo, cartItemDto.getStoreId())
                            && StringUtils.equals(goods.get(0).getGoodsId(), cartItemDto.getGoodsId())) {
                        buildCartGoodsVoData(cartItemDto, goods.get(0), cartGoodsVos,memberAddressDto);
                        break;
                    }
                }
                if (!goodsIds.contains(goods.get(0).getGoodsId())) {
                    CartGoodsVo cartGoodsVo = new CartGoodsVo();
                    cartGoodsVo.setGoodsId(goods.get(0).getGoodsId());
                    List<String> productFashionId = productFashionApi.findProductFashionIdBySku(goods.get(0).getSku());
                    cartGoodsVo.setProductFashId(productFashionId.get(0));
                    cartGoodsVo.setStoreId(goods.get(0).getUserId());
                    cartGoodsVo.setSalePrice(goods.get(0).getPrice());
                    cartGoodsVo.setProductName(goods.get(0).getTitle());
                    cartGoodsVo.setProductPicture(goods.get(0).getLogoUrl());
                    cartGoodsVo.setSku(goods.get(0).getSku());
                    cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode()==null?"":memberAddressDto.getProvinceCode());
                    cartGoodsVo.setCityCode(memberAddressDto.getCityCode()==null?"":memberAddressDto.getCityCode());
                    cartGoodsVo.setTownCode(memberAddressDto.getTownCode()==null?"":memberAddressDto.getTownCode());
                    cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode()==null?"":memberAddressDto.getCountryCode());
                    cartGoodsVos.add(cartGoodsVo);
                }
            }
            return new BaseResponse<>(true, "查询成功", cartGoodsVos);
        } else if (Lang.isEmpty(storeNo) && !Lang.isEmpty(goodsCode)) {
//            List<GoodsConfigDto> goods = goodsConfigApi.findBySkuAndOrganizationCode(goodsCode, ORGANIZATIONCODE);
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(new String[] {goodsCode}));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List<GoodsConfigDto> goods = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

            if (!Lang.isEmpty(goods)) {
                List<String> goodsIds = new ArrayList<>();
                for (CartItemDto cartItemDto : allCartItem) {
                    goodsIds.add(cartItemDto.getGoodsId());
                    if (StringUtils.equals(goods.get(0).getGoodsId(), cartItemDto.getGoodsId())) {
                        buildCartGoodsVoData(cartItemDto, goods.get(0), cartGoodsVos,memberAddressDto);
                        break;
                    }
                }
                if (!goodsIds.contains(goods.get(0).getGoodsId())) {
                    CartGoodsVo cartGoodsVo = new CartGoodsVo();
                    cartGoodsVo.setGoodsId(goods.get(0).getGoodsId());
                    List<String> productFashionId = productFashionApi.findProductFashionIdBySku(goods.get(0).getSku());
                    cartGoodsVo.setProductFashId(productFashionId.get(0));
                    cartGoodsVo.setStoreId(goods.get(0).getUserId());
                    cartGoodsVo.setSalePrice(goods.get(0).getPrice());
                    cartGoodsVo.setProductName(goods.get(0).getTitle());
                    cartGoodsVo.setProductPicture(goods.get(0).getLogoUrl());
                    cartGoodsVo.setSku(goods.get(0).getSku());
                    cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode()==null?"":memberAddressDto.getProvinceCode());
                    cartGoodsVo.setCityCode(memberAddressDto.getCityCode()==null?"":memberAddressDto.getCityCode());
                    cartGoodsVo.setTownCode(memberAddressDto.getTownCode()==null?"":memberAddressDto.getTownCode());
                    cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode()==null?"":memberAddressDto.getCountryCode());
                    cartGoodsVos.add(cartGoodsVo);
                }

            }
            return new BaseResponse<>(true, "查询成功", cartGoodsVos);
        } else if (!Lang.isEmpty(storeNo) && Lang.isEmpty(goodsCode)) {
            for (CartItemDto cartItemDto : allCartItem) {
                if (StringUtils.equals(storeNo, cartItemDto.getStoreId())) {
                    String sku = productFashionApi.findSkuByProductFashionId(cartItemDto.getProductFashId());
                    GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                    goodsConfigQuery.setSkus(Arrays.asList(new String[] {sku}));
                    goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                    goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                    List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//                    List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(sku, ORGANIZATIONCODE);
                    if (!Lang.isEmpty(goodsConfigDtos)) {
                        buildCartGoodsVoData(cartItemDto, goodsConfigDtos.get(0), cartGoodsVos,memberAddressDto);
                    }
                }
            }
            return new BaseResponse<>(true, "查询成功", cartGoodsVos);
        } else {
            for (CartItemDto cartItemDto : allCartItem) {
                String sku = productFashionApi.findSkuByProductFashionId(cartItemDto.getProductFashId());
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                goodsConfigQuery.setSkus(Arrays.asList(new String[] {sku}));
                goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//                List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(sku, ORGANIZATIONCODE);
                if (!Lang.isEmpty(goodsConfigDtos)) {
                    buildCartGoodsVoData(cartItemDto, goodsConfigDtos.get(0), cartGoodsVos,memberAddressDto);
                }
            }
            return new BaseResponse<>(true, "查询成功", cartGoodsVos);
        }
    }

    /**
     * 数据封装
     * @param cartItemDto
     * @param goodsConfigDto
     * @param cartGoodsVos
     */
    private void buildCartGoodsVoData(CartItemDto cartItemDto, GoodsConfigDto goodsConfigDto, List<CartGoodsVo> cartGoodsVos,MemberAddressDto memberAddressDto) {
        CartGoodsVo cartGoodsVo = new CartGoodsVo();
        cartGoodsVo.setGoodsId(cartItemDto.getGoodsId());
        cartGoodsVo.setStoreId(cartItemDto.getStoreId());
        cartGoodsVo.setSalePrice(goodsConfigDto.getPrice());
        cartGoodsVo.setProductFashId(cartItemDto.getProductFashId());
        cartGoodsVo.setProductName(goodsConfigDto.getTitle());
        cartGoodsVo.setProductPicture(goodsConfigDto.getLogoUrl());
        cartGoodsVo.setSku(goodsConfigDto.getSku());
        cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode()==null?"":memberAddressDto.getProvinceCode());
        cartGoodsVo.setCityCode(memberAddressDto.getCityCode()==null?"":memberAddressDto.getCityCode());
        cartGoodsVo.setTownCode(memberAddressDto.getTownCode()==null?"":memberAddressDto.getTownCode());
        cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode()==null?"":memberAddressDto.getCountryCode());
        cartGoodsVos.add(cartGoodsVo);
    }
    private CartGoodsVo buildCartGoodsVoData(GoodsConfigDto goodsConfigDto, MemberAddressDto addressDto) {
        CartGoodsVo cartGoodsVo = new CartGoodsVo();
        cartGoodsVo.setGoodsId(goodsConfigDto.getGoodsId());
        List<String> productFashionId= productFashionApi.findProductFashionIdBySku(goodsConfigDto.getSku());
        cartGoodsVo.setProductFashId(productFashionId.get(0));
        cartGoodsVo.setStoreId(goodsConfigDto.getUserId());
        cartGoodsVo.setSalePrice(goodsConfigDto.getPrice());
        cartGoodsVo.setProductName(goodsConfigDto.getTitle());
        cartGoodsVo.setProductPicture(goodsConfigDto.getLogoUrl());
        cartGoodsVo.setSku(goodsConfigDto.getSku());
        cartGoodsVo.setProvinceCode(addressDto.getProvinceCode()==null?"":addressDto.getProvinceCode());
        cartGoodsVo.setCityCode(addressDto.getCityCode()==null?"":addressDto.getCityCode());
        cartGoodsVo.setCountyCode(addressDto.getCountryCode()==null?"":addressDto.getCountryCode());
        cartGoodsVo.setTownCode(addressDto.getTownCode()==null?"":addressDto.getTownCode());
        return cartGoodsVo;
    }

    @Override
    public BaseResponse getAllStore() {
        List<StoreDto> stores = storeApi.findByTpye(StoreDto.STORE_TYPE_SUPLIER);
        for (StoreDto store : stores) {
            store.getStoreExt().setStore(null);
            if (!Lang.isEmpty(store.getNavs())) {
                for (StoreNavDto storeNavDto : store.getNavs()) {
                    storeNavDto.setStore(null);
                }
            }
            if (!Lang.isEmpty(store.getCategory())) {
                store.getCategory().setStores(null);
            }
        }
        return new BaseResponse<>(true, "查询成功", stores);
    }

    @Override
    public BaseResponse checkGoodsStatus(CheckGoodsStockVo checkGoodsStockVo, String userId) {
        log.info("*****************校验商品状态和库存参数:{}", JSON.toJSONString(checkGoodsStockVo));
        if (Lang.isEmpty(checkGoodsStockVo.getGoodsCode())){
            return new BaseResponse(false,"请输入商品编码");
        }else if(Lang.isEmpty(checkGoodsStockVo.getNums())){
            return new BaseResponse(false,"请输入商品数量");
        }
        GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
        goodsConfigQuery.setSkus(Arrays.asList(new String[] {checkGoodsStockVo.getGoodsCode()}));
        goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
        goodsConfigApi.findGoodsConfig(goodsConfigQuery);
        List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//        List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(checkGoodsStockVo.getGoodsCode(), ORGANIZATIONCODE);
        if(Lang.isEmpty(goodsConfigDtos)){
            return new BaseResponse(false,"商品不存在,请重新输入");
        }
        MemberAddressDto addressDto =  memberAddressApi.findDtoByIdAndIsDelete(checkGoodsStockVo.getAddressId(), false);
        if(Lang.isEmpty(addressDto)){
            return new BaseResponse(false,"请先选择地址");
        }
        GoodsConfigDto goodsConfigDto = goodsConfigDtos.get(0);
        // 重新封装数据
        CartGoodsVo cartGoodsVo = buildCartGoodsVoData(goodsConfigDto,addressDto);
        if(!Lang.isEmpty(checkGoodsStockVo.getStoreId())){
            if(!StringUtils.equals(cartGoodsVo.getStoreId(),checkGoodsStockVo.getStoreId())){
                return new BaseResponse(false,"商品不在该店铺下,请重新输入");
            }
        }
        // 支持输入不在购物车中的商品
        CartDto userCart = cartApi.getUserCart(userId);
        List<String> skus = new ArrayList<>();
        if (!Lang.isEmpty(userCart)) {
            List<CartItemDto> cartItems = userCart.getCartItems();
            cartItems.forEach(cartItem -> {
                String sku = productFashionApi.findSkuByProductFashionId(cartItem.getProductFashId());
                skus.add(sku);
            });
        }
        // 封装校验库存请求参数
        FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
        StoreDto store = new StoreDto();
        //MemberAddressDto addressDto =  memberAddressApi.findDtoByIdAndIsDelete(checkGoodsStockVo.getAddressId(), false);
        requetVo.setProvinceCode(addressDto.getProvinceCode());
        requetVo.setCityCode(addressDto.getCityCode());
        requetVo.setCountyCode(addressDto.getAreaCode());
        requetVo.setTownCode(addressDto.getTownCode());
        List<FashionNumsVo> fashionNums = new ArrayList<>();
        FashionNumsVo fashionNumsVo = new FashionNumsVo(cartGoodsVo.getProductFashId(),
                checkGoodsStockVo.getGoodsCode(), new Long(checkGoodsStockVo.getNums()));
        fashionNums.add(fashionNumsVo);
        requetVo.setFashionNums(fashionNums);
        // 店铺
        store.setId(cartGoodsVo.getStoreId());
        log.info("开始进行库存校验......");
        long queryFashionStockStateTime = System.currentTimeMillis();
        HandlerRespVo<List<FashionStockStateVo>> fashionStockState = outsideProductApi.getFashionStockState(store, requetVo);
        log.info("查询第三方库存状态耗时 {} ms", System.currentTimeMillis() - queryFashionStockStateTime);
        if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
            log.info("调用库存查询接口异常：{}",fashionStockState.getMessage());
            return new BaseResponse(false,"商品库存不足,请重新选择");
        } else {
            List<FashionStockStateVo> data = fashionStockState.getData();
            if(Lang.isEmpty(data)){
                return new BaseResponse(false,"商品不存在，不可购买");
            }
            FashionStockStateVo fashionStockStateVo = data.get(0);
            if(!fashionStockStateVo.getOnSale()){
                return new BaseResponse(false,"商品已下架，不可购买");
            }
            if(FashionStockStateVo.STOCK_FLAG_NO_STOCK == fashionStockStateVo.getStockFlag()){
                return new BaseResponse(false,"商品库存不足，不可购买");
            }
        }
        // 校验商品是否在购物车
        if (!Lang.isEmpty(skus) && !skus.contains(checkGoodsStockVo.getGoodsCode())){
            log.info("库存校验通过，商品不在购物车.....");
            return new BaseResponse<>(true, "校验通过",cartGoodsVo);
        }else{
            // 处理是购物车中的商品
            if(!checkGoodsStockVo.isChoiceFlag()){
                return new BaseResponse<>(true, "校验通过",cartGoodsVo);
            }else{
                return new BaseResponse(true,"校验通过");
            }
        }
    }

    @Override
    public BaseResponse saveTempOrder(MallTempOrderVo mallTempOrderVo) {
        // 处理数据
        mallTempOrderVo.setOrganizationCode(ORGANIZATIONCODE);
        if (Lang.isEmpty(mallTempOrderVo.getMemberAddressId())){
            return new BaseResponse(false,"收货地址信息为空，保存失败");
        }else if(Lang.isEmpty(mallTempOrderVo.getInvoiceTitle()) && Lang.isEmpty(mallTempOrderVo.getCompanyId())){
            return new BaseResponse(false,"开票机构信息为空，保存失败");
        }
        MallTempOrderDto mallTempOrderDto = BeanMapper.map(mallTempOrderVo, MallTempOrderDto.class);
        return  mallTempOrderApi.saveMallTempOrder(mallTempOrderDto);
    }

    @Override
    public BaseResponse queryTempOrder(String memberId) {
        long start = System.currentTimeMillis();
        long queryStart = System.currentTimeMillis();
        List<MallTempOrderDto> mallTempOrders = mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        log.info("查询临时订单耗时：{}ms",System.currentTimeMillis()-queryStart);
        List<TempBatchOrderVo> tempBatchOrderVos = new ArrayList<>();
        mallTempOrders.parallelStream().forEach(mallTempOrder->{
            TempBatchOrderVo tempBatchOrderVo = new TempBatchOrderVo();
            tempBatchOrderVo.setTempOrderId(mallTempOrder.getId());
            tempBatchOrderVo.setMemberAddressId(mallTempOrder.getMemberAddressId());
            tempBatchOrderVo.setProvinceCode(mallTempOrder.getProvinceCode());
            tempBatchOrderVo.setCityCode(mallTempOrder.getCityCode());
            tempBatchOrderVo.setTownCode(mallTempOrder.getTownCode());
            tempBatchOrderVo.setCountryCode(mallTempOrder.getCountryCode());
            //String memberAddressId = mallTempOrder.getMemberAddressId();
//            long addressStart = System.currentTimeMillis();
//            MemberAddressDto memberAddressDto = memberAddressApi.findDtoByIdAndIsDelete(memberAddressId, false);
//            log.info("查询地址耗时：{}ms",System.currentTimeMillis()-addressStart);
            //StringBuffer memberBuffer = new StringBuffer();
//            if(!Lang.isEmpty(memberAddressDto)){
//                memberBuffer.append(memberAddressDto.getProvinceName())
//                        .append(memberAddressDto.getCityName()==null?"":memberAddressDto.getCityName())
//                        .append(memberAddressDto.getAreaName()==null?"":memberAddressDto.getAreaName())
//                        .append(memberAddressDto.getTownName()==null?"":memberAddressDto.getTownName())
//                        .append(memberAddressDto.getAddressDetail());
//            }
            tempBatchOrderVo.setMemberAddressDetail(mallTempOrder.getMemberAddress());
            if (CONSIGNEE_FLAG_NOT.equals(mallTempOrder.getConsigneeFlag())){
//                MemberAddressDto invoiceAddress = memberAddressApi.findByAddressNoAndIsDelete(mallTempOrder.getInvoiceAddressNo(), memberId);
//                if(!Lang.isEmpty(invoiceAddress)){
//                    StringBuffer invoiceBuffer = new StringBuffer();
//                    invoiceBuffer.append(invoiceAddress.getProvinceName())
//                            .append(invoiceAddress.getCityName()==null?"":invoiceAddress.getCityName())
//                            .append(invoiceAddress.getAreaName()==null?"":invoiceAddress.getAreaName())
//                            .append(invoiceAddress.getTownName()==null?"":invoiceAddress.getTownName())
//                            .append(invoiceAddress.getAddressDetail());
//                }
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getInvoiceAddress());

            } else if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())){
                // 自定义地址
//                String provinceName = addressApi.findShortNameById(mallTempOrder.getConsigneeProvinceCode());
//                StringBuffer stringBuffer = new StringBuffer();
//                if (!Lang.isEmpty(mallTempOrder.getConsigneeCityCode())){
//                    String cityName = addressApi.findShortNameById(mallTempOrder.getConsigneeCityCode());
//                    stringBuffer.append(provinceName)
//                            .append(cityName)
//                            .append(mallTempOrder.getAddressDetail());
//                }
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getAddressDetail());
            }else if(CONSIGNEE_FLAG_TRUE.equals(mallTempOrder.getConsigneeFlag())){
                // 与收件人地址相同
//                if(!Lang.isEmpty(memberAddressDto)){
//                }
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getMemberAddress());
            }
            if (GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(mallTempOrder.getInvoiceType())){
                // 专用发票
                long companyStart = System.currentTimeMillis();
                if(!Lang.isEmpty(mallTempOrder.getCompanyId())){
                    CoreCompanyDto coreCompanyDto = coreCompanyApi.getCoreCompanyInfoById(mallTempOrder.getCompanyId());
                    log.info("查询开票机构信息耗时:{}ms",System.currentTimeMillis()-companyStart);
                    tempBatchOrderVo.setBankAccount(coreCompanyDto.getBankAccount());
                    tempBatchOrderVo.setBankInfo(coreCompanyDto.getBankDeposit());
                    tempBatchOrderVo.setCompanyAddress(coreCompanyDto.getAddress());
                    tempBatchOrderVo.setCompanyPhone(coreCompanyDto.getPhone());
                    tempBatchOrderVo.setInvoiceTitle(coreCompanyDto.getInvoiceName());
                    tempBatchOrderVo.setInvoiceOrganization(coreCompanyDto.getName());
                    tempBatchOrderVo.setTaxIdentification(coreCompanyDto.getTaxpayerNum());
                }
            }else if(GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN.equals(mallTempOrder.getInvoiceType())){
                // 普通发票
                tempBatchOrderVo.setInvoiceTitle(mallTempOrder.getInvoiceTitle());
                tempBatchOrderVo.setTaxIdentification(mallTempOrder.getTaxIdentification());
            }
            // 商品信息
            List<TempBatchListVo> tempBatchListVos = new ArrayList<>();
            mallTempOrder.getMallTempGoods().parallelStream().forEach(mallTempGoods->{
                long goodsStart = System.currentTimeMillis();
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                goodsConfigQuery.setSkus(Arrays.asList(new String[] {mallTempGoods.getSku()}));
                goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//                List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(mallTempGoods.getSku(), ORGANIZATIONCODE);
                log.info("查询goods耗时：{}ms",System.currentTimeMillis()-goodsStart);
                if(!Lang.isEmpty(goodsConfigDtos)){
                    GoodsConfigDto goodsConfigDto = goodsConfigDtos.get(0);
                    TempBatchListVo tempBatchListVo = new TempBatchListVo();
                    tempBatchListVo.setNum(mallTempGoods.getNum());
                    tempBatchListVo.setGoodsId(goodsConfigDto.getGoodsId());
                    long priceStart = System.currentTimeMillis();
                    BigDecimal salePrice = goodsApi.findSalePriceById(goodsConfigDto.getGoodsId());
                    //ProductFashionVo productFashion = productFashionApi.find(goodsConfigDto.get());
                    log.info("查询价格耗时：{}ms",System.currentTimeMillis()-priceStart);
                    tempBatchListVo.setPrice(salePrice);
                    tempBatchListVo.setSku(mallTempGoods.getSku());
                    BigDecimal sumPrice = salePrice.multiply(new BigDecimal(mallTempGoods.getNum()));
                    sumPrice.setScale(2,BigDecimal.ROUND_DOWN);
                    tempBatchListVo.setTotalPrice(sumPrice);
                    tempBatchListVo.setGoodsName(goodsConfigDto.getTitle());
                    tempBatchListVo.setStoreName(goodsConfigDto.getStoreName());
                    tempBatchListVos.add(tempBatchListVo);
                }
            });
            tempBatchOrderVo.setTempBatchLists(tempBatchListVos);
            tempBatchOrderVos.add(tempBatchOrderVo);
        });
        log.info("临时订单查询处理总耗时{}ms",System.currentTimeMillis()-start);
        return new BaseResponse<>(true,"查询成功",tempBatchOrderVos);
    }

    @Override
    public BaseResponse submitMallOrder(MallOrderSubmitVo mallOrderSubmitVoData, String memberId, HttpServletRequest request) {
        log.info("mallOrderSubmitVoData ->{}",JSON.toJSONString(mallOrderSubmitVoData));

        MallOrderSubmitVo mallOrderSubmitVo = new MallOrderSubmitVo();
        mallOrderSubmitVo.setOrderUse(mallOrderSubmitVoData.getOrderUse());
        mallOrderSubmitVo.setPayType(mallOrderSubmitVoData.getPayType());
        mallOrderSubmitVo.setRemark(mallOrderSubmitVoData.getRemark());
        mallOrderSubmitVo.setFreight(mallOrderSubmitVoData.getFreight());
        mallOrderSubmitVo.setMallAttachments(mallOrderSubmitVoData.getMallAttachments());
        //long dealDataStart = System.currentTimeMillis();
        //String tempOrderDataJson = (String) request.getSession().getAttribute(USER_DEALORDER_KEY + memberId);
        //List<TempMallOrderVo> mallOrderList = JSONArray.parseArray(tempOrderDataJson,TempMallOrderVo.class);
        //List<TempMallOrderVo> mallOrderList = dealMallTempOrderData(memberId);
        //mallOrderSubmitVo.setMallTempOrderVos(mallOrderList);
        String tempOrderJson = (String) request.getSession().getAttribute(USER_TEMPORDER_KEY + memberId);
        List<TempOrderVo> tempOrderVos =JSONArray.parseArray(tempOrderJson,TempOrderVo.class);

        List<OrderMainDto> orderMainDtos = null;
        MemberDto memberDto = memberApi.findMemberById(memberId);
        long buildOrderStart = System.currentTimeMillis();
        // 生成父订单
        BaseResponse<MallParentOrderDto> parentOrderSaveResult = saveParentOrderInfo(mallOrderSubmitVo, memberId);
        log.info("处理父订单数据保存耗时：{}ms",System.currentTimeMillis()-buildOrderStart);
        // 存放子订单订单号
        List<String> sucOrderNos = new ArrayList<>();
        // 批量订单类型
        if (parentOrderSaveResult.isSuccess() && !Lang.isEmpty(tempOrderVos)){
            MallParentOrderDto mallParentOrderDto = parentOrderSaveResult.getResult();
            tempOrderVos.forEach(tempOrder->{
                tempOrder.setParentOrderId(mallParentOrderDto.getId());
                String requestId=String.format("%s-%s", tempOrder.getTmpOrderNo(),tempOrder.getMemberAddrId());
                tempOrder.setRequestId(requestId);
                tempOrder.getStoreList().forEach(tempOrderStoreVo -> {
                    tempOrderStoreVo.setType(OrderMainDto.STORE_TYPE_BATCH);
                });
            });
            long createOrderTime = System.currentTimeMillis();
            BaseResponse<List<OrderMainDto>> orderBaseRsp = orderMainApi.batchCreateOrder(tempOrderVos, memberId, mallOrderSubmitVo.getOrderUse(), mallOrderSubmitVo.getPayType());
            //Map rsMap = new HashMap();
            //String errorCode = "";
            if (orderBaseRsp.isSuccess()){
                orderMainDtos = orderBaseRsp.getResult();
                log.info("......生成订单为{}", orderMainDtos.stream().map(OrderMainDto::getOrderNo).collect(Collectors.toList()).toString());
                // 过滤错误订单，如果有一个下单金额为0，则此次下单失败
                List<BigDecimal> sumPrices = orderMainDtos.stream().map(OrderMainDto::getSumPrice).collect(Collectors.toList());
                for (BigDecimal sumPrice : sumPrices) {
                    if(BigDecimal.ZERO.compareTo(sumPrice) == 0){
                        cancelAllOrder(orderMainDtos,mallParentOrderDto);
                        return new BaseResponse<>("error","订单有误,请联系管理员");
                    }
                }
                long quotaPrice = System.currentTimeMillis();
                // TODO 累计金额 ,需要批量进行处理
                BaseResponse<Boolean> quotaSumPrice = quotaApi.setQuotaSumPrice(orderMainDtos);
                log.info("累加金额耗时：{}ms",System.currentTimeMillis()-quotaPrice);
                if(!quotaSumPrice.isSuccess()){
                    log.info("限额管理累加金额失败:{}",quotaSumPrice.getResultMessage());
                    cancelAllOrder(orderMainDtos, mallParentOrderDto);
                    return new BaseResponse("error","下单金额已超出限制额度,下单失败");
                }
                // 生成发票
                batchCreateInvoices(orderMainDtos, mallOrderSubmitVo, memberDto);
                // 补充父订单数据
                MallParentOrderDto parentOrderDto = supplyParentOrderData(orderMainDtos, mallOrderSubmitVo.getFreight());
                log.info("......生成订单总耗时{}ms",System.currentTimeMillis()-createOrderTime);


                log.info(".................开始预占库存.........");
                //预占库存
                boolean takeOrderFlag = true;
                String errorMsg = "";
                Long occupyStockTime = System.currentTimeMillis();
                //Map infoMap = new HashMap();
                // 暂时存放一份映射
                Map<String,OrderMainDto> orderMap = new HashMap<>();
                // 存放错误信息映射
                Map<String,String> errorMap = new HashMap<>();
                //List<Future<Map<String, Object>>> resultList = new ArrayList<>();
                Map<String,Future<Map<String, Object>>> resultMap = new HashMap<>();
                try{
                    for (OrderMainDto orderMainDto : orderMainDtos) {
                        sucOrderNos.add(orderMainDto.getOrderNo());
                        orderMap.put(orderMainDto.getOrderNo(),orderMainDto);
                        log.info("订单[{}]开始预占库存....",orderMainDto.getOrderNo());
                        Future<Map<String, Object>> mapFuture = pool.submit(() -> {
                            Map<String, Object> returnMap = orderMainApi.occupyStock(orderMainDto);
                            return returnMap;
                        });
                        resultMap.put(orderMainDto.getOrderNo(),mapFuture);
                    }
                    if(!Lang.isEmpty(resultMap)){
                        Set<Map.Entry<String, Future<Map<String, Object>>>> resultSet = resultMap.entrySet();
                        for (Map.Entry<String, Future<Map<String, Object>>> futureEntry : resultSet) {
                            String orderNo = futureEntry.getKey();
                            Future<Map<String, Object>> returnFuture = futureEntry.getValue();
                            Map<String, Object> returnMap = returnFuture.get();
                            String returnCode = returnMap.get("returnCode").toString();
                            if (!GlobalContants.ResponseStatus.SUCCESS.equals(returnCode)) {
                                takeOrderFlag = false;
                                errorMsg = (String) returnMap.get("returnMsg");
                                log.info("订单[{}]：预占库存失败：errorCode:{},msg:{}",orderNo,returnCode,errorMsg);
                                errorMap.put(orderNo,errorMsg);
                            }
                        }
                    }

                }catch (Exception e){
                    log.info("预占库存失败:{}",e);
                    try{
                        // TODO  减少累计金额
                        quotaApi.subtractPrice(orderMainDtos);
                        cancelAllOrder(orderMainDtos, mallParentOrderDto);
                        return new BaseResponse<>("error","系统异常，创建订单失败");
                    }catch (Exception re){
                        log.info("取消订单异常:{}",re);
                        return new BaseResponse<>("error","系统异常，创建订单失败");
                    }
                }
                log.info("##预占库存总耗时##：{}ms", System.currentTimeMillis() - occupyStockTime);

                if(takeOrderFlag){
                    log.info("...........开启审核流.............");
                    // 开启审核流
                    WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
                    Map<String, Object> bussinessDataMap = new HashMap<>();
                    UserInformationVo operateInformation = getOperateInformation(memberId);
                    String organizationName = operateInformation.getWholeJobName();
                    bussinessDataMap.put("organizationName", organizationName);
                    bussinessDataMap.put("orderTime",new Date());
                    MemberVo memberInfo = memberApi.getMemberInfo(memberId);
                    List<String> list = new ArrayList<>();
                    if (!Lang.isEmpty(parentOrderDto)){
                        list.add(parentOrderDto.getParentOrderNo());
                        flowRequestDto.setTotalMoney(parentOrderDto.getTotalMoney());
                    }
                    flowRequestDto.setMemberId(memberId);
                    flowRequestDto.setBussinessDataMap(bussinessDataMap);
                    flowRequestDto.setOrderIds(list);
                    flowRequestDto.setWorkflowId(mallOrderSubmitVoData.getProcessId());
                    flowRequestDto.setUserId(memberInfo.getUser().getId());
                    flowRequestDto.setRealName(memberInfo.getMember().getRealName());
                    flowRequestDto.setReason(mallOrderSubmitVoData.getRemark());
                    flowRequestDto.setBussinessCode(AuditBusinessCode.JICAI_BATCH_ORDER_AUDIT.getBusinessCode());
                    flowRequestDto.setFlowIdentificationCode(WorkFlowCode.ORDER_WORKFLOW_CODE.getCode());
                    flowRequestDto.setCorePositionCode(CorePositionDto.POSITION_JC_BUYER);
                    flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.JICAI_BATCH_ORDER_AUDIT.getInstance());
                    flowRequestDto.setTiaoxian(mallOrderSubmitVoData.getTianxianDepartMentId());
                    log.info("............开启审核流请求数据：{}",JSON.toJSONString(flowRequestDto));
                    try {
                        long startWorkFlow = System.currentTimeMillis();
                        workFlowServiceApi.startWorkFlow(flowRequestDto);
                        log.info("............审核流开启耗时：{}ms", System.currentTimeMillis() - startWorkFlow);
                        takeOrderFlag = true;
                    }catch (Exception e){
                        log.error("提交订单审核工作流失败！", e);
                        try{
                            cancelAllOrder(orderMainDtos,mallParentOrderDto);
                            // TODO  减少金额
                            quotaApi.subtractPrice(orderMainDtos);
                        }catch (Exception re){
                            log.info("取消订单异常：{}",e);
                        }
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        e.printStackTrace(printWriter);
                        final String stackTraceStr = stringWriter.toString();
                        //工作流出错日志保存
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                systemLogApi.saveBean(new SystemLogDto("orderSubmit", SystemLogDto.LOG_SOURCE_JICAI, SystemLogDto.LOG_TYPE_ERROR, stackTraceStr));
                            }
                        }).start();
                        if (e instanceof AuditorNotFoundException) {
                            //infoMap.put("returnMsg", Lang.isEmpty(e.getMessage()) ? "机构负责人未配置" : e.getLocalizedMessage());
                            log.info(Lang.isEmpty(e.getMessage()) ? "机构负责人未配置" : e.getLocalizedMessage());
                        } else {
                            log.info("提交审核流失败");
                            //infoMap.put("returnMsg", "提交审核流失败，请联系管理员！");
                        }
                        takeOrderFlag = false;
                    }
                }

                if(!takeOrderFlag){
                    Map<String,String> errorInfoMap = new HashMap<>();
                    if(!Lang.isEmpty(errorMap)){
                        Set<Map.Entry<String, String>> errorEntry = errorMap.entrySet();
                        //Map<String,String> map = new HashMap<>();
                        errorEntry.forEach(entry->{
                            OrderMainDto orderMainDto = orderMap.get(entry.getKey());
                            //List<Map<String,String>> mapList = new ArrayList<>();
                            orderMainDto.getOrderItems().forEach(orderItem->{
                                //map.put(orderItem.getSku(),entry.getValue());
                                errorInfoMap.put(orderItem.getSku(),entry.getValue());
                                //mapList.add(map);
                            });
                            //errorInfoMap.put(orderMainDto.getAddressId(),entry.getValue());
                            // 保存下单错误信息
                            saveErrorInfo(entry.getValue(),memberId,orderMainDto.getAddressId());
                        });
                        // TODO  减少金额
                        try{
                            // 取消所有订单
                            cancelAllOrder(orderMainDtos,parentOrderDto);
                            quotaApi.subtractPrice(orderMainDtos);
                        }catch (Exception e){
                            log.info("....减少累额失败:{}",e);
                        }
                        return new BaseResponse<>("error","下单失败",errorInfoMap);
                    }else{
                        // TODO  减少金额
                        try{
                            // 取消所有订单
                            cancelAllOrder(orderMainDtos,parentOrderDto);
                            quotaApi.subtractPrice(orderMainDtos);
                        }catch (Exception e){
                            log.info("....减少累额失败:{}",e);
                            return new BaseResponse("error","系统异常，创建订单失败");
                        }
                        return new BaseResponse("error","系统异常，创建订单失败");
                    }

                }else{
                    // 清空临时订单信息
                    mallTempOrderApi.deleteMallTempOrder(memberId);
                    log.info("............清空临时订单成功...........");
                }
            }else{
                log.info("创建订单失败原因：{}",orderBaseRsp.getResultMessage());
                return new BaseResponse<>("error","系统异常，创建订单失败");
            }
        }else{
            log.info("创建订单失败原因：{}",parentOrderSaveResult.getResultMessage());
            return new BaseResponse<>("error","系统异常，创建订单失败");
        }
        log.info("生成订单总耗时:{}ms", System.currentTimeMillis() - buildOrderStart);
        // 取出订单号，方便前端跳转至订单成功页面
        String orderNos = Joiner.on(",").skipNulls().join(sucOrderNos);
        return new BaseResponse<>("success", "下单成功", orderNos);
    }

    private void saveErrorInfo(String addressId,String memberId, String errorInfo) {
        mallTempOrderApi.updateTempOrder(errorInfo,addressId,memberId);
    }

    /**
     * 取消所有订单
     */
    private void cancelAllOrder(List<OrderMainDto> orderMainDtos, MallParentOrderDto mallParentOrderDto){
        try{
            List<String> orderIds = orderMainDtos.stream().map(OrderMainDto::getId).collect(Collectors.toList());
            orderMainApi.changeStatus(orderIds,OrderMainDto.order_status_error);
            mallParentOrderApi.changeStatus(BatchOrderStatus.ORDER_STATUS_ERROR.getCode(),mallParentOrderDto.getId());
        }catch (Exception e){
            log.info(".......取消订单异常{}",e);
        }
    }

    /**
     * 提交订单时校验商品库存和状态
     *
     * @param sumfreight
     * @param memberId
     * @param request
     * @return
     */
    @Override
    public BaseResponse checkMallOrder(String sumfreight, String memberId, String userId, HttpServletRequest request) {
//        List<TempMallOrderVo> tempMallOrders = dealMallTempOrderData(memberId);
//        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = dealMallBatchPurchaseData(tempMallOrders);
//        BaseResponse<List<TempOrderVo>> baseResponse = orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        String tempOrderJson = (String) request.getSession().getAttribute(USER_TEMPORDER_KEY + memberId);
        List<TempOrderVo> tempOrderVos =JSONArray.parseArray(tempOrderJson,TempOrderVo.class);
        String tempOrderDataJson = (String) request.getSession().getAttribute(USER_DEALORDER_KEY + memberId);
        List<TempMallOrderVo> mallOrderList = JSONArray.parseArray(tempOrderDataJson,TempMallOrderVo.class);

        log.info(".............校验订单限额..............");
        // 本次下单总额
        BigDecimal newOrderSumPirce = tempOrderVos.stream().map(TempOrderVo::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<List<TempOrderStoreVo>> tempOrderStores = tempOrderVos.stream().map(TempOrderVo::getStoreList).collect(Collectors.toList());
        List<TempOrderItemVo> tempOrderItemList = new ArrayList<>();
        tempOrderStores.parallelStream().forEach(tempOrderStoreVo->{
            tempOrderStoreVo.stream().forEach(orderStoreVo->{
                tempOrderItemList.addAll(orderStoreVo.getOrderItems());
            });
        });
        String values = systemConfigApi.getConfigValue(ORGANIZATIONCODE, SystemConfigDto.LIMIT_ORDER_PRICE, SystemConfigValueDto.LIMIT_ORDER_PRICE, true, true);
        newOrderSumPirce = newOrderSumPirce.add(new BigDecimal(sumfreight));
        BigDecimal limit = new BigDecimal(values).multiply(new BigDecimal(10000));
        if (newOrderSumPirce.setScale(2,BigDecimal.ROUND_HALF_DOWN).compareTo(limit.setScale(2,BigDecimal.ROUND_HALF_DOWN)) > 0) {
            return new BaseResponse<>("001", "您此次下单的金额超过" + values + "万，不可下单");
        }
        // TODO  加入限额管理 对商品累积下单金额进行校验
        long quotaStart = System.currentTimeMillis();
        BaseResponse<String> quotaResponse = quotaApi.batchIsExceedQuota(tempOrderItemList, userId);
        if (quotaResponse.isSuccess()){
            return new BaseResponse("001",quotaResponse.getResultMessage());
        }
        log.info("..................订单限额校验通过.................");
        log.info("校验订单限额耗时：{}ms",System.currentTimeMillis()-quotaStart);
        //log.info(".....................开始校验商品...................");
//        long startTime = System.currentTimeMillis();
//        Map<String, String> orderCheckResult = submitOrderCheckGoods(memberId,mallOrderList);
//        log.info("................校验商品耗时:{}ms", System.currentTimeMillis() - startTime);
//        if (!Lang.isEmpty(orderCheckResult)) {
//            return new BaseResponse<>("002", "下单失败！可在批量订单列表中的“下单失败原因”列，查看具体失败原因", orderCheckResult);
//        }
        log.info("...................校验通过,执行下单流程...............");
        return new BaseResponse("003", "共生成" + tempOrderVos.size() + "张订单，总下单金额为" + newOrderSumPirce + "元，是否确认下单？");
    }

    @Override
    public BaseResponse getOrderFee(String memberId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        long dealDatatTime = System.currentTimeMillis();
        List<TempMallOrderVo> tempMallOrderVos = dealMallTempOrderData(memberId);
        log.info("处理订单数据耗时：{}ms",System.currentTimeMillis()-dealDatatTime);
        long mergeStart = System.currentTimeMillis();
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = dealMallBatchPurchaseData(new ArrayList<>(tempMallOrderVos));
        log.info("合并订单处理耗时：{}ms",System.currentTimeMillis()-mergeStart);
        long buildTempOrder = System.currentTimeMillis();
        BaseResponse<List<TempOrderVo>> baseResponse = orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        log.info("生成临时订单耗时：{}ms",System.currentTimeMillis()-buildTempOrder);
        BigDecimal sumOrdersFee = BigDecimal.ZERO;
        if (baseResponse.isSuccess()) {
            List<TempOrderVo> tempOrderVos = baseResponse.getResult();
            if (!Lang.isEmpty(tempOrderVos)) {
                // 处理好的数据放入缓存
                //request.getSession().setAttribute(USER_DEALORDER_KEY + memberId,JSON.toJSONString(tempMallOrderVos));
                // 已生成的临时订单放入缓存
                request.getSession().setAttribute(USER_TEMPORDER_KEY + memberId,JSON.toJSONString(tempOrderVos));
                try{
                    Future<BaseResponse<BigDecimal>> responseFuture = getFreightPool.submit(new GetFreightThread(tempOrderVos));
                    if (!Lang.isEmpty(responseFuture.get())){
                        BaseResponse<BigDecimal> response = responseFuture.get();
                        if (!Lang.isEmpty(response.getResult())){
                            sumOrdersFee = response.getResult();
                        }
//                        else{
//                            return new BaseResponse(false,response.getResultMessage());
//                        }
                        //sumOrdersFee = sumFeeFuture.get();
                    }

                    log.info("订单总运费：{}",sumOrdersFee);

                } catch (Exception e){
                    log.info("获取运费失败：{}",e);
                    return new BaseResponse(false,"系统异常,请稍后再试");
                }
            }
        }else {
            return new BaseResponse<>(false,"生成临时订单时失败，请联系管理员");
        }
        log.info("查询运费总耗时：{}ms",System.currentTimeMillis()-startTime);
        return new BaseResponse<>(true, "获取运费成功！", sumOrdersFee);
    }

    @Override
    public BaseResponse getTempOrderInfo(String memberId) {
        MallTempOrderInfoFindVo mallTempOrderInfoFindVo = new MallTempOrderInfoFindVo();
        // 查询保存的扩展信息
        MallTempOrderInfoDto mallTempOrderInfo = mallTempOrderInfoQueryApi.findMallOrderInfoByMemberId(memberId);
        MallTempOrderInfoVo mallTempOrderInfoVo = BeanMapper.map(mallTempOrderInfo, MallTempOrderInfoVo.class);
        mallTempOrderInfoFindVo.setMallTempOrderInfoVo(mallTempOrderInfoVo);
        // 获取附件
        List<MallAttachmentDto> mallAttachmentDtos = mallAttachmentApi.findMallAttachments(memberId);
        List<MallAttachmentVo> mallAttachmentVos = BeanMapper.mapList(mallAttachmentDtos, MallAttachmentDto.class, MallAttachmentVo.class);
        mallTempOrderInfoFindVo.setMallAttachmentVos(mallAttachmentVos);
        return new BaseResponse<>(true, "查询成功", mallTempOrderInfoFindVo);
    }

    @Override
    public BaseResponse saveTempOrderInfo(MallTempOrderInfoVo mallTempOrderInfoVo, String memberId) {
        MallTempOrderInfoDto mallTempOrderInfo = mallTempOrderInfoQueryApi.findMallOrderInfoByMemberId(memberId);
        if (!Lang.isEmpty(mallTempOrderInfo)) {
            mallTempOrderInfoApi.deleteTempOrderInfo(mallTempOrderInfo);
        }
        MallTempOrderInfoDto mallTempOrderInfoDto = BeanMapper.map(mallTempOrderInfoVo, MallTempOrderInfoDto.class);
        mallTempOrderInfoDto.setMemberId(memberId);
        BaseResponse baseResponse = mallTempOrderInfoApi.saveMallTempOrderInfo(mallTempOrderInfoDto);
        return baseResponse;
    }

    @Override
    public CoreCompanyDto getCoreCompanyInfoById(String companyId) {
        return coreCompanyApi.getCoreCompanyInfoById(companyId);
    }

    @Override
    public BaseResponse deleteOrderInfo(List<String> temOrderId) {
        BaseResponse baseResponse = mallTempOrderApi.deleteMallTempOrder(temOrderId);
        return baseResponse;
    }

    @Override
    public BaseResponse updateOrderInfo(String temOrderId) {
        long startTime = System.currentTimeMillis();
        MallTempOrderDto mallTempOrder = mallTempOrderQueryApi.findMallTempOrderById(temOrderId);
        long queryAddress = System.currentTimeMillis();
        MemberAddressDto memberAddress = memberAddressApi.findById(mallTempOrder.getMemberAddressId());
        log.info("查询地址耗时：{}ms",System.currentTimeMillis()-queryAddress);
        MallOrderUpdateVo mallOrderUpdateVo = BeanMapper.map(mallTempOrder, MallOrderUpdateVo.class);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(memberAddress.getProvinceName())
                .append(memberAddress.getCityName()==null?"":memberAddress.getCityName())
                .append(memberAddress.getAreaName()==null?"":memberAddress.getAreaName())
                .append(memberAddress.getTownName()==null?"":memberAddress.getTownName())
                .append(memberAddress.getAddressDetail());
        mallOrderUpdateVo.setMemberAddressName(strBuffer.toString());
        mallOrderUpdateVo.setMemberProviceCode(memberAddress.getProvinceCode()==null?"":memberAddress.getProvinceCode());
        mallOrderUpdateVo.setMemberCityCode(memberAddress.getCityCode()==null?"":memberAddress.getCityCode());
        mallOrderUpdateVo.setMemberAreaCode(memberAddress.getAreaCode()==null?"":memberAddress.getAreaCode());
        mallOrderUpdateVo.setMemberTownCode(memberAddress.getTownCode()==null?"":memberAddress.getTownCode());
        mallOrderUpdateVo.setCountryCode(memberAddress.getCountryCode()==null?"":memberAddress.getCountryCode());
        mallOrderUpdateVo.setMemberProviceName(memberAddress.getProvinceName());
        mallOrderUpdateVo.setMemberCityName(memberAddress.getCityName());
        mallOrderUpdateVo.setMemberAreaName(memberAddress.getAreaName());
        mallOrderUpdateVo.setMemberTownName(memberAddress.getTownName());
        mallOrderUpdateVo.setMemberName(memberAddress.getUsername());
        mallOrderUpdateVo.setMemberAddressNo(memberAddress.getAddressNo());
        mallOrderUpdateVo.setTel(memberAddress.getTel());
        if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())) {
            long addrStart = System.currentTimeMillis();
            String consigneeProvinceName = addressApi.findShortNameById(mallTempOrder.getConsigneeProvinceCode());
            String consigneeCityName = addressApi.findShortNameById(mallTempOrder.getConsigneeCityCode());
            log.info("查询地址耗时：{}",System.currentTimeMillis()-addrStart);
            mallOrderUpdateVo.setConsigneeProvinceName(consigneeProvinceName);
            mallOrderUpdateVo.setConsigneeCityName(consigneeCityName);
            StringBuffer invoiceAddress = new StringBuffer();
            invoiceAddress.append(consigneeProvinceName)
                    .append(consigneeCityName)
                    .append(mallOrderUpdateVo.getAddressDetail());
            invoiceAddress.append(consigneeProvinceName);
            invoiceAddress.append(consigneeCityName);
            invoiceAddress.append(mallOrderUpdateVo.getAddressDetail());
            mallOrderUpdateVo.setInvoiceAddress(invoiceAddress.toString());
        }
        // 封装商品集合
        List<MallGoodsUpdateVo> mallGoodsUpdateVos = new ArrayList<>();
        MallGoodsUpdateVo mallGoodsUpdateVo = null;
        for (MallTempGoodsDto mallTempGoodsDto : mallTempOrder.getMallTempGoods()) {
            mallGoodsUpdateVo = new MallGoodsUpdateVo();
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(new String[] {mallTempGoodsDto.getSku()}));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//            List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(mallTempGoodsDto.getSku(), ORGANIZATIONCODE);
            GoodsConfigDto goodsConfig = goodsConfigDtos.get(0);
            mallGoodsUpdateVo.setGoodsId(mallTempGoodsDto.getGoodsId());
            mallGoodsUpdateVo.setNum(mallTempGoodsDto.getNum());
            mallGoodsUpdateVo.setProductFashId(mallTempGoodsDto.getProductFashionId());
            mallGoodsUpdateVo.setProductName(goodsConfig.getTitle());
            mallGoodsUpdateVo.setProductPicture(goodsConfig.getLogoUrl());
            mallGoodsUpdateVo.setSalePrice(goodsConfig.getPrice());
            mallGoodsUpdateVo.setSku(mallTempGoodsDto.getSku());
            mallGoodsUpdateVo.setStoreId(goodsConfig.getUserId());
            mallGoodsUpdateVos.add(mallGoodsUpdateVo);
        }
        mallOrderUpdateVo.setMallGoodsUpdateVos(mallGoodsUpdateVos);
        // 发票信息
        if (GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(mallOrderUpdateVo.getInvoiceType())) {
            // 公司地址及电话
            CoreCompanyDto coreCompanyDto = coreCompanyApi.findById(mallTempOrder.getCompanyId());
            mallOrderUpdateVo.setCompanyAddressAndPhone(coreCompanyDto.getAddress() + " " + coreCompanyDto.getPhone());
            mallOrderUpdateVo.setBankAndAccount(coreCompanyDto.getBankDeposit() + " " + coreCompanyDto.getBankAccount());
        }
        log.info("修改信息查询处理耗时：{}ms",System.currentTimeMillis()-startTime);
        return new BaseResponse<>(true, "信息查询成功", mallOrderUpdateVo);
    }

    /**
     * 保存订单父订单
     *
     * @param mallOrderSubmitVo
     * @param memberId
     * @return
     */
    private BaseResponse<MallParentOrderDto> saveParentOrderInfo(MallOrderSubmitVo mallOrderSubmitVo, String memberId) {
        UserInformationVo operateInformation = getOperateInformation(memberId);
        String organizationName = operateInformation.getWholeJobName();
        MallParentOrderDto mallParentOrder = new MallParentOrderDto();
        mallParentOrder.setMemberId(memberId);
        mallParentOrder.setMemberName(operateInformation.getMember().getRealName());
        if (ORDER_USE_ASSET.equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("资产");
        } else if (ORDER_USE_IMPEL.equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("激励品");
        } else if (ORDER_USE_GIFT.equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("福利");
        }
        if (PAY_TYPE_CODE.equals(mallOrderSubmitVo.getPayType())) {
            mallParentOrder.setPayType("在线支付");
        }
        mallParentOrder.setFreight(mallOrderSubmitVo.getFreight());
        mallParentOrder.setRemark(mallOrderSubmitVo.getRemark());
        mallParentOrder.setCompanyName(organizationName);
        mallParentOrder.setParentOrderNo(orderMainApi.generateOrderNo());
        mallParentOrder.setPurchaseNo(orderMainApi.generateOrderNo());
        mallParentOrder.setStatus(BatchOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        mallParentOrder.setSupplierName("");
        mallParentOrder.setOrderType(BATCH_ORDER_TYPE);
        MallParentOrderDto mallParentOrderDto = null;
        try {
            mallParentOrderDto = mallParentOrderApi.saveMallParentOrder(mallParentOrder);
            //保存附件
            List<MallAttachmentVo> mallAttachmentVos = mallOrderSubmitVo.getMallAttachments();

            MallParentOrderDto finalMallParentOrderDto = mallParentOrderDto;
            mallAttachmentVos.parallelStream().forEach(mallAttachmentVo -> {
                mallAttachmentVo.setAttachmentCorrelation(finalMallParentOrderDto.getParentOrderNo());
                mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.MALL_BATCH_ORDER_ATTACHMENT.getValue());
                mallAttachmentVo.setBusinessDescription(MallAttachmentBusinessCode.MALL_BATCH_ORDER_ATTACHMENT.getDescription());
                mallAttachmentVo.setOrganizationCode(GlobalContants.ORGANIZATION_CODES.JICAI);
            });

            if (!Lang.isEmpty(mallAttachmentVos)) {
                List<MallAttachmentDto> mallAttachmentDtos = BeanMapper.mapList(mallAttachmentVos, MallAttachmentVo.class, MallAttachmentDto.class);
                mallAttachmentApi.batchSave(mallAttachmentDtos);
            }
        } catch (Exception e) {
            log.info("*****************系统异常，父订单保存失败*****************8");
            return new BaseResponse<>(false, "父订单保存失败");
        }
        return new BaseResponse<>(true, "父订单保存成功", mallParentOrderDto);

    }

    /**
     * 补充父订单信息
     *
     * @param orderMainDtos
     * @param freight
     */
    private MallParentOrderDto supplyParentOrderData(List<OrderMainDto> orderMainDtos, BigDecimal freight) {
        BigDecimal totalPriceOfAllOrders = BigDecimal.ZERO;
        BigDecimal totalFreight = BigDecimal.ZERO;
        OrderMainDto orderMainDto = null;
        MallParentOrderDto mallParentOrder = null;
        if (!Lang.isEmpty(orderMainDtos)) {
            totalPriceOfAllOrders = orderMainDtos.stream().map(OrderMainDto::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalFreight = orderMainDtos.stream().map(OrderMainDto::getFreight).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderMainDto = orderMainDtos.get(0);
            MallParentOrderDto mallParentOrderDto = mallParentOrderQueryApi.findParentOrderById(orderMainDto.getParentOrderId());
            mallParentOrderDto.setTotalMoney(totalPriceOfAllOrders);
            mallParentOrderDto.setFreight(totalFreight);
            if (!Lang.isEmpty(freight)) {
                mallParentOrderDto.setGoodsPrice(totalPriceOfAllOrders.subtract(freight));
            } else {
                mallParentOrderDto.setGoodsPrice(totalPriceOfAllOrders);
            }
            mallParentOrder = mallParentOrderApi.saveMallParentOrder(mallParentOrderDto);
        }
        //MallParentOrderDto mallParentOrder = mallParentOrderApi.updateMallParentOrder(orderMainDto.getParentOrderId(),totalPriceOfAllOrders,goodsPrice);
        return mallParentOrder;

    }

    /**
     * 获取用户信息
     * 若memberid为经办人的，则companyName为经办人直属机构到科室的完整组织机构拼接，否则为空字符串
     *
     * @param memberId
     * @return
     */
    public UserInformationVo getOperateInformation(String memberId) {
        UserInformationVo informationVo = new UserInformationVo();
        Map<String, Object> queryUser = queryInformationApi.queryUser(memberId);
        //获取多个职位的信息
        List<Map<String, Object>> companyPositions = (List<Map<String, Object>>) queryUser.get("companyPositions");
        StringBuilder companyName = new StringBuilder();
        //筛选出职位为采购经办人的职位信息
        companyPositions.forEach(companyPosition -> {
            String positionCode = (String) companyPosition.get("positionCode");
            List<String> companyNameList = (List) companyPosition.get("companyNames");
            //拼接科室信息
            companyNameList.forEach(name -> {
                companyName.append(name);
            });
        });
        informationVo.setMember((MemberDto) queryUser.get("member"));
        informationVo.setUser((CoreUserDto) queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }

    private BaseResponse batchCreateInvoices(List<OrderMainDto> orderMainDtos, MallOrderSubmitVo mallOrderSubmitVo, MemberDto memberDto) {
        Long invoiceStart = System.currentTimeMillis();
        BaseResponse baseResponse = new BaseResponse();
        //处理发票信息，考虑异步
        List<OrderInvoiceDto> orderInvoiceDtos = new ArrayList<>();
        orderMainDtos.forEach(n -> {
            OrderInvoiceDto orderInvoiceDto = new OrderInvoiceDto();
            member.api.vo.cart.OrderSubmitVo orderSubmitVo = new member.api.vo.cart.OrderSubmitVo();
            orderSubmitVo.setInvoiceInfos(new ArrayList<>());
            orderSubmitVo.setAddressId(n.getAddressId());
            orderSubmitVo.setNeedBills(true);
            orderSubmitVo.setOrderUsageCode(mallOrderSubmitVo.getOrderUse());
            orderSubmitVo.setPayMethodCode(mallOrderSubmitVo.getPayType());

            List<TempInvoiceVo> tempInvoiceVos = n.getTempInvoiceVoList();
            Boolean hasShippingFee = false;
            BigDecimal freight = n.getFreight();
            BigDecimal evenShippingFee = BigDecimal.ZERO;
            if (freight.compareTo(BigDecimal.ZERO) > 0) {
                hasShippingFee = true;
                //按照总运费均分到各个发票
                evenShippingFee = freight.divide(new BigDecimal(tempInvoiceVos.size()), 2, BigDecimal.ROUND_HALF_UP);
            }
            List<member.api.vo.cart.InvoiceInfoVo> invoiceInfoVos = new ArrayList<>();
            for (int i = 0; i < tempInvoiceVos.size(); i++) {
                TempInvoiceVo tempInvoiceVo = tempInvoiceVos.get(i);
                List<member.api.vo.cart.InvoiceItemInfoVo> invoiceInfoItems = new ArrayList<>();
                member.api.vo.cart.InvoiceInfoVo invoiceInfoVo = new member.api.vo.cart.InvoiceInfoVo();
                String invocieType = tempInvoiceVo.getInvoiceType();
                invoiceInfoVo.setInvoiceType(invocieType);
                if (invocieType.equals(TempInvoiceVo.INVOICE_TYPE_COMMON)) {//针对普票，增加抬头的保存
                    String invoiceName = tempInvoiceVo.getInvoiceName();
                    String identificationCode = tempInvoiceVo.getInvoiceCode();
                    if (!Lang.isEmpty(invoiceName) || !Lang.isEmpty(identificationCode)) {
                        invoiceInfoVo.setName(invoiceName);
                        invoiceInfoVo.setIdentificationCode(identificationCode);
                    }
                }
                invoiceInfoVo.setCoreConpanyId(tempInvoiceVo.getCompanyId());
                List<TempInvoiceItemVo> tempInvoiceItemVos = tempInvoiceVo.getTempInvoiceItemVos();
                for (TempInvoiceItemVo tempInvoiceItemVo : tempInvoiceItemVos) {
                    member.api.vo.cart.InvoiceItemInfoVo invoiceItemInfoVo = new member.api.vo.cart.InvoiceItemInfoVo();
                    invoiceItemInfoVo.setCount(tempInvoiceItemVo.getCount());
                    invoiceItemInfoVo.setFreigh(Lang.isEmpty(tempInvoiceItemVo.getFreigh()) ? false : tempInvoiceItemVo.getFreigh());
                    invoiceItemInfoVo.setGoodsId(tempInvoiceItemVo.getGoodsId());
                    //价格
                    invoiceItemInfoVo.setPrice(tempInvoiceItemVo.getSalePrice());
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                //有运费则设置运费
                if (hasShippingFee) {
                    member.api.vo.cart.InvoiceItemInfoVo invoiceItemInfoVo = new member.api.vo.cart.InvoiceItemInfoVo();
                    invoiceItemInfoVo.setGoodsId("shippingFee");
                    invoiceItemInfoVo.setPrice(evenShippingFee);
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                member.api.vo.cart.InvoiceReceiverVo receiverVo = new member.api.vo.cart.InvoiceReceiverVo();
                TempInvoiceAddrVo tempInvoiceAddrVo = tempInvoiceVo.getTempInvoiceAddrVo();
                if (tempInvoiceAddrVo.isSameAsAchiever()) {
                    receiverVo.setSameAsAchiever(true);
                } else {
                    receiverVo.setSameAsAchiever(false);
                }
                receiverVo.setAddress(tempInvoiceAddrVo.getAddress());
                receiverVo.setName(tempInvoiceAddrVo.getName());
                receiverVo.setPhone(tempInvoiceAddrVo.getPhone());
                receiverVo.setCityCode(tempInvoiceAddrVo.getCityCode());
                receiverVo.setProvinceCode(tempInvoiceAddrVo.getProvinceCode());

                invoiceInfoVo.setInvoiceItems(invoiceInfoItems);
                invoiceInfoVo.setInvoiceReceiver(receiverVo);
                invoiceInfoVos.add(invoiceInfoVo);
            }
            // 适配发票，最后一张发票金额重新计算
            for (InvoiceItemInfoVo invoiceItemInfoVo : invoiceInfoVos.get(invoiceInfoVos.size() - 1).getInvoiceItems()) {
                if ("shippingFee".equals(invoiceItemInfoVo.getGoodsId())) {
                    invoiceItemInfoVo.setPrice(freight.subtract(evenShippingFee.multiply(new BigDecimal(invoiceInfoVos.size() - 1))));
                }
            }
            orderSubmitVo.setInvoiceInfos(invoiceInfoVos);

            orderInvoiceDto.setMemberDto(memberDto);
            member.api.dto.order.OrderMainDto memberOrderMainDto = BeanMapper.map(n, member.api.dto.order.OrderMainDto.class);
            orderInvoiceDto.setOrderMainDto(memberOrderMainDto);
            orderInvoiceDto.setOrderSubmitVo(orderSubmitVo);

            orderInvoiceDtos.add(orderInvoiceDto);
        });
        baseResponse = memberInvoinceApi.createOrderInvoices(orderInvoiceDtos);
        log.info("生成发票用时：{}ms", System.currentTimeMillis() - invoiceStart);
        if (baseResponse.isSuccess()) {
            log.info("生成发票成功");
        } else {
            log.info("生成发票失败");
        }
        return baseResponse;
    }

    private Map<String, String> submitOrderCheckGoods(String memberId, List<TempMallOrderVo> mallOrderList) {
        List<MallTempOrderDto> mallTempOrders = mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        // 存放校验结果 key:sku,value:结果
        Map<String, String> checkResultMap = new HashMap<>();
        mallOrderList.parallelStream().forEach(mallTempOrder->{
            FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
            MemberAddressDto addressDto = memberAddressApi.findDtoByIdAndIsDelete(mallTempOrder.getMemberAddrId(), false);
            requetVo.setProvinceCode(addressDto.getProvinceCode());
            requetVo.setCityCode(addressDto.getCityCode());
            requetVo.setCountyCode(addressDto.getAreaCode());
            requetVo.setTownCode(addressDto.getTownCode());
            List<FashionNumsVo> fashionNums = new ArrayList<>();
            FashionNumsVo fashionNumsVo = new FashionNumsVo(mallTempOrder.getProductFashionId(),
                    mallTempOrder.getSku(), new Long(mallTempOrder.getCount()));
            fashionNums.add(fashionNumsVo);
            requetVo.setFashionNums(fashionNums);
            StoreDto store = new StoreDto();
            store.setId(mallTempOrder.getStoreId());
            HandlerRespVo<List<FashionStockStateVo>> fashionStockState = outsideProductApi.getFashionStockState(store, requetVo);
            if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                log.info("调用库存查询接口异常：{}",fashionStockState.getMessage());
            } else {
                List<FashionStockStateVo> data = fashionStockState.getData();
                if (Lang.isEmpty(data)) {
                    checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_NOT.getDescription());
                } else {
                    for (FashionStockStateVo stockStateVo : data) {
                        if (!stockStateVo.getOnSale()
                                && FashionStockStateVo.NOTSALE_REASON_PRODUCT_DOWN.equals(stockStateVo.getNotsaleReason())) {
                            checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_UNDER.getDescription());
                            break;
                        } else if (FashionStockStateVo.STOCK_FLAG_NO_STOCK == stockStateVo.getStockFlag()) {
                            checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_LESS.getDescription());
                            break;
                        }
                    }
                }
            }
        });
        return checkResultMap;
    }

    /**
     * 将订单维度转为商品维度，合并订单
     *
     * @param memberId
     * @return
     */
    private List<TempMallOrderVo> dealMallTempOrderData(String memberId) {
        List<MallTempOrderDto> mallTempOrders = mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        List<TempMallOrderVo> tempMallOrders = new Vector<TempMallOrderVo>();
        mallTempOrders.parallelStream().forEach(mallTempOrder->{
            mallTempOrder.getMallTempGoods().forEach(tempGoods -> {
                TempMallOrderVo orderVo = new TempMallOrderVo();
                orderVo.setSku(tempGoods.getSku());
                orderVo.setCount(tempGoods.getNum());
                orderVo.setMemberAddrId(mallTempOrder.getMemberAddressId());
                orderVo.setStoreId(tempGoods.getStoreId());
                orderVo.setProductFashionId(tempGoods.getProductFashionId());
                orderVo.setGoodsId(tempGoods.getGoodsId());
                MemberAddressDto memberAddressDto = memberAddressApi.findByIdAndIsDelete(mallTempOrder.getMemberAddressId(), false);
                orderVo.setProvinceCode(memberAddressDto.getProvinceCode());
                orderVo.setCityCode(memberAddressDto.getCityCode());
                orderVo.setTownCode(memberAddressDto.getTownCode());
                orderVo.setAreaCode(memberAddressDto.getAreaCode());
                orderVo.setAddressDetail(memberAddressDto.getAddressDetail());
                orderVo.setPhone(memberAddressDto.getPhone());
                orderVo.setUsername(memberAddressDto.getUsername());
                MemberInVoiceVo inVoiceVO = new MemberInVoiceVo();
                inVoiceVO.setType(mallTempOrder.getInvoiceType());
                // 兼容批量导入发票收件地址取值
                if (CONSIGNEE_FLAG_NOT.equals(mallTempOrder.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(true);
                    MemberAddressDto invoiceAddress = memberAddressApi.findByAddressNoAndIsDelete(mallTempOrder.getInvoiceAddressNo(), memberId);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(invoiceAddress.getProvinceName())
                            .append(invoiceAddress.getCityName()==null?"":invoiceAddress.getCityName())
                            .append(invoiceAddress.getAreaName()==null?"":invoiceAddress.getAreaName())
                            .append(invoiceAddress.getTownName()==null?"":invoiceAddress.getTownName())
                            .append(invoiceAddress.getAddressDetail());
                    inVoiceVO.setAddressDetail(stringBuffer.toString());
                    inVoiceVO.setConsigneeName(invoiceAddress.getUsername());
                    inVoiceVO.setConsigneeCityCode(invoiceAddress.getCityCode());
                    inVoiceVO.setConsigneeProvinceCode(invoiceAddress.getProvinceCode());
                    inVoiceVO.setInvoiceAddressNo(invoiceAddress.getAddressNo());
                    inVoiceVO.setConsigneePhone(invoiceAddress.getPhone());
                } else if (CONSIGNEE_FLAG_TRUE.equals(mallTempOrder.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(true);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(memberAddressDto.getProvinceName()==null?"":memberAddressDto.getProvinceName())
                            .append(memberAddressDto.getCityName()==null?"":memberAddressDto.getCityName())
                            .append(memberAddressDto.getAreaName()==null?"":memberAddressDto.getAreaName())
                            .append(memberAddressDto.getTownName()==null?"":memberAddressDto.getTownName())
                            .append(memberAddressDto.getAddressDetail());
                    inVoiceVO.setAddressDetail(stringBuffer.toString());
                    inVoiceVO.setConsigneeName(memberAddressDto.getUsername());
                    inVoiceVO.setConsigneeCityCode(memberAddressDto.getCityCode());
                    inVoiceVO.setConsigneeProvinceCode(memberAddressDto.getProvinceCode());
                    inVoiceVO.setConsigneePhone(memberAddressDto.getPhone());
                    inVoiceVO.setInvoiceAddressNo(memberAddressDto.getAddressNo());
                } else if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(false);
                    inVoiceVO.setAddressDetail(mallTempOrder.getAddressDetail());
                    inVoiceVO.setConsigneeName(mallTempOrder.getConsigneeName());
                    inVoiceVO.setConsigneeCityCode(mallTempOrder.getConsigneeCityCode());
                    inVoiceVO.setConsigneeProvinceCode(mallTempOrder.getConsigneeProvinceCode());
                    inVoiceVO.setConsigneePhone(mallTempOrder.getConsigneePhone());
                }
                if (GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(mallTempOrder.getInvoiceType())) {
                    inVoiceVO.setCompanyId(mallTempOrder.getCompanyId());
                } else if (GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN.equals(mallTempOrder.getInvoiceType())) {
                    inVoiceVO.setInvoiceName(mallTempOrder.getInvoiceTitle());
                    inVoiceVO.setInvoiceCode(mallTempOrder.getTaxIdentification());
                }
                orderVo.setMemberInVoiceVo(inVoiceVO);
                tempMallOrders.add(orderVo);
            });
        });
        return tempMallOrders;
    }

    /**
     * 合并订单处理
     *
     * @param mallTempOrderVos
     * @return
     */
    private List<TempBatchPurchaseOrderVo> dealMallBatchPurchaseData(List<TempMallOrderVo> mallTempOrderVos) {
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = new ArrayList<>();
        for (TempMallOrderVo tempMallOrderVo : mallTempOrderVos) {
            MemberInvoiceItemVo memberInvoiceItemVo = new MemberInvoiceItemVo();
            memberInvoiceItemVo.setSku(tempMallOrderVo.getSku());
            memberInvoiceItemVo.setCount(tempMallOrderVo.getCount());
            memberInvoiceItemVo.setGoodsId(tempMallOrderVo.getGoodsId());
            List<MemberInvoiceItemVo> memberInvoiceItemVoList = new ArrayList<>();
            memberInvoiceItemVoList.add(memberInvoiceItemVo);
            tempMallOrderVo.getMemberInVoiceVo().setMemberInvoiceItemVos(memberInvoiceItemVoList);
        }
        while (mallTempOrderVos.size() > 0) {
            List<FashionDetailVo> fashionDetailVoList = new ArrayList<>();
            List<FashionDetailVo> tempDetailVoList = new ArrayList<>();
            TempMallOrderVo orderVoA = mallTempOrderVos.get(0);
            FashionDetailVo fashionDetailVoA = new FashionDetailVo();
            fashionDetailVoA.setCount(orderVoA.getCount());
            fashionDetailVoA.setGoodsId(orderVoA.getGoodsId());
            fashionDetailVoA.setProductFashionId(orderVoA.getProductFashionId());
            fashionDetailVoList.add(fashionDetailVoA);

            String memberAddrId = orderVoA.getMemberAddrId();
            String areaCode = orderVoA.getMemberAddrId();

            MemberInVoiceVo memberInVoiceA = orderVoA.getMemberInVoiceVo();
            List<MemberInVoiceVo> toBeHandledIvoiceVos = new ArrayList<>();
            toBeHandledIvoiceVos.add(memberInVoiceA);
            // 存放比较后的结果
            List<TempMallOrderVo> doneTempMallOrderVos = new ArrayList<>();
            doneTempMallOrderVos.add(orderVoA);
            for (int i = 1; i <= mallTempOrderVos.size() - 1; i++) {
                TempMallOrderVo orderVoB = mallTempOrderVos.get(i);
                if (StringUtils.equals(orderVoA.getUsername(), orderVoB.getUsername()) && StringUtils.equals(orderVoA.getProvinceCode(), orderVoB.getProvinceCode())
                        && StringUtils.equals(orderVoA.getCityCode(), orderVoB.getCityCode()) && StringUtils.equals(orderVoA.getTownCode(), orderVoB.getTownCode())
                        && StringUtils.equals(orderVoA.getAreaCode(), orderVoB.getAreaCode()) && StringUtils.equals(orderVoA.getAddressDetail(), orderVoB.getAddressDetail())
                        && StringUtils.equals(orderVoA.getPhone(), orderVoB.getPhone()) && StringUtils.equals(orderVoA.getStoreId(), orderVoB.getStoreId())
                        ) {
                    Optional<FashionDetailVo> detailVoOptional = fashionDetailVoList.stream().filter(fashionDetailVo -> StringUtils.equals(fashionDetailVo.getGoodsId(), orderVoB.getGoodsId())).findFirst();
                    FashionDetailVo detailVo=null;
                    if(detailVoOptional.isPresent()){
                        detailVo=detailVoOptional.get();
                    }
                    if (!Lang.isEmpty(detailVo)){
                        detailVo.setCount(detailVo.getCount()+orderVoB.getCount());
                    }else {
                        FashionDetailVo fashionDetailVoB = new FashionDetailVo();
                        fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
                        fashionDetailVoB.setCount(orderVoB.getCount());
                        fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
                        fashionDetailVoList.add(fashionDetailVoB) ;
                    }
                 /*   if (StringUtils.equals(orderVoA.getSku(), orderVoB.getSku())) {
                        fashionDetailVoA.setCount(fashionDetailVoA.getCount() + orderVoB.getCount());
                    } */
                    /*else {
                        FashionDetailVo fashionDetailVoB = new FashionDetailVo();
                        fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
                        fashionDetailVoB.setCount(orderVoB.getCount());
                        fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
                        for (FashionDetailVo detailVo : fashionDetailVoList) {
                            if (orderVoB.getGoodsId().equals(detailVo.getGoodsId())) {
                                fashionDetailVoB.setCount(fashionDetailVoB.getCount() + detailVo.getCount());
                                tempDetailVoList.add(detailVo);
                            }
                        }
                        fashionDetailVoList.add(fashionDetailVoB);
                    }*/
                    doneTempMallOrderVos.add(orderVoB);
                    toBeHandledIvoiceVos.add(orderVoB.getMemberInVoiceVo());
                }
            }
//            if (!Lang.isEmpty(tempDetailVoList)) {
//                fashionDetailVoList.removeAll(tempDetailVoList);
//            }
            mallTempOrderVos.removeAll(doneTempMallOrderVos);
            List<TempInvoiceVo> tempInvoiceVoList = new ArrayList<>();//发票
            List<MemberInVoiceVo> doneComparedInvoiceVos = new ArrayList<>();
            while (toBeHandledIvoiceVos.size() > 0) {
                MemberInVoiceVo inVoiceVOA = toBeHandledIvoiceVos.get(0);
                TempInvoiceVo tempInvoiceVoA = dealMemberInvoice(inVoiceVOA);
                List<MemberInvoiceItemVo> memberInvoiceItemVos = inVoiceVOA.getMemberInvoiceItemVos();
                doneComparedInvoiceVos.add(inVoiceVOA);
                for (int j = 1; j <= toBeHandledIvoiceVos.size() - 1; j++) {
                    MemberInVoiceVo inVoiceVOB = toBeHandledIvoiceVos.get(j);
                    if (StringUtils.equals(inVoiceVOA.getType(), inVoiceVOB.getType()) && StringUtils.equals(inVoiceVOA.getInvoiceCode(), inVoiceVOB.getInvoiceCode())
                            && StringUtils.equals(inVoiceVOA.getConsigneeName(), inVoiceVOB.getConsigneeName()) && StringUtils.equals(inVoiceVOA.getConsigneePhone(), inVoiceVOB.getConsigneePhone())
                            && StringUtils.equals(inVoiceVOA.getConsigneeProvinceCode(), inVoiceVOB.getConsigneeProvinceCode()) && StringUtils.equals(inVoiceVOA.getConsigneeCityCode(), inVoiceVOB.getConsigneeCityCode())
                            && StringUtils.equals(inVoiceVOA.getAddressDetail(), inVoiceVOB.getAddressDetail()) && StringUtils.equals(inVoiceVOA.getInvoiceName(), inVoiceVOB.getInvoiceName())
                            && StringUtils.equals(inVoiceVOA.getCompanyId(), inVoiceVOB.getCompanyId())) {
                        memberInvoiceItemVos.addAll(inVoiceVOB.getMemberInvoiceItemVos());
                        doneComparedInvoiceVos.add(inVoiceVOB);
                    }
                }
                //将商品set回Invoice
                List<TempInvoiceItemVo> tempInvoiceItemVos = BeanMapper.mapList(memberInvoiceItemVos, MemberInvoiceItemVo.class, TempInvoiceItemVo.class);
                tempInvoiceVoA.setTempInvoiceItemVos(tempInvoiceItemVos);
                tempInvoiceVoList.add(tempInvoiceVoA);
                toBeHandledIvoiceVos.removeAll(doneComparedInvoiceVos);
            }
            TempBatchPurchaseOrderVo tempBatchPurchaseOrderVo = new TempBatchPurchaseOrderVo();
            tempBatchPurchaseOrderVo.setFashionDetailVoList(fashionDetailVoList);
            tempBatchPurchaseOrderVo.setTempInvoiceVoList(tempInvoiceVoList);
            tempBatchPurchaseOrderVo.setAreaCode(areaCode);
            tempBatchPurchaseOrderVo.setOrganizationCode(ORGANIZATIONCODE);
            tempBatchPurchaseOrderVo.setMemberAddrId(memberAddrId);
            tempBatchPurchaseOrderVos.add(tempBatchPurchaseOrderVo);

        }
        return tempBatchPurchaseOrderVos;
    }

    /**
     * 处理发票信息
     *
     * @param inVoiceVOA
     * @return
     */
    private TempInvoiceVo dealMemberInvoice(MemberInVoiceVo inVoiceVOA) {
        TempInvoiceVo tempInvoiceVo = new TempInvoiceVo();
        tempInvoiceVo.setInvoiceName(inVoiceVOA.getInvoiceName());
        tempInvoiceVo.setInvoiceCode(inVoiceVOA.getInvoiceCode());
        tempInvoiceVo.setInvoiceType(inVoiceVOA.getType());
        tempInvoiceVo.setCompanyId(inVoiceVOA.getCompanyId());

        TempInvoiceAddrVo tempInvoiceAddrVo = new TempInvoiceAddrVo();
        tempInvoiceAddrVo.setProvinceCode(inVoiceVOA.getConsigneeProvinceCode());
        tempInvoiceAddrVo.setCityCode(inVoiceVOA.getConsigneeCityCode());
        tempInvoiceAddrVo.setName(inVoiceVOA.getConsigneeName());
        tempInvoiceAddrVo.setPhone(inVoiceVOA.getConsigneePhone());
        tempInvoiceAddrVo.setAddress(inVoiceVOA.getAddressDetail());
        tempInvoiceAddrVo.setSameAsAchiever(inVoiceVOA.isSameAsAchiever());
        tempInvoiceVo.setTempInvoiceAddrVo(tempInvoiceAddrVo);
        return tempInvoiceVo;
    }


    /**
     * 批量下单Excel导入
     *
     * @param req
     */
    @Override
    public BaseResponse batchImport(HttpServletRequest req) {
        String memberId = (String) req.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
//        String memberId="eeea060b-b662-47dc-aaf3-44639405850b";
        log.info("memberId={}", memberId);
        long startImport = System.currentTimeMillis();
        MultipartHttpServletRequest mReq = (MultipartHttpServletRequest) req;
        MultipartFile file = mReq.getFile("file");
        String fileName = file.getOriginalFilename();
        int startRow = 2;
        if (Lang.isEmpty(fileName)) {
            return new BaseResponse("获取不到文件名");
        }
        List<Object> excelRow;
        Object cell;
        List<ExcelImportDataVo> importDataVoList = new ArrayList<>();
        ExcelImportDataVo importDataVo;
        Map<String, ExcelImportDataVo> importMap = new HashMap<>();
        try {
            InputStream inputStream = file.getInputStream();
            List excelData = ReadExcel.readSingleExcel(inputStream, file.getOriginalFilename());

            //导入失败的数据数量
            Integer falseDataCount = 0;
            //导入数据总数量
            Integer successDataCount = 0;
            int size = excelData.size();
            //批量校验商品编号，地址编号，纳税人识别号，发票地址编号
            int pageSize = 200;
            log.info("批量处理{}条数据",pageSize);
            for (int i = startRow; i < size; i++) {
                importDataVo = new ExcelImportDataVo();
                /** 处理分类代码行 */
                excelRow = (List<Object>) excelData.get(i);
                if(excelRow.size()<10){
                    continue;
                }
                boolean emptyRow = true;
                for (int j = 1; j < 9; j++) {
                    if (!Lang.isEmpty(excelRow.get(j))) {
                        emptyRow = false;
                        break;
                    }
                }
                if (emptyRow) {
                    continue;
                }
                if (size > 2) {
                    importDataVo.setStoreName(excelRow.get(1).toString());
                    importDataVo.setSku(excelRow.get(2).toString());
                    importDataVo.setNum(Integer.parseInt(excelRow.get(3).toString()));
                    importDataVo.setMemberAddressCode(excelRow.get(4).toString());
                    importDataVo.setInvoiceType(excelRow.get(5).toString());
                    importDataVo.setInvoiceTitle(excelRow.get(6).toString());
                    importDataVo.setTaxIdentification(excelRow.get(7).toString());
                    importDataVo.setInvoiceAddressCode(excelRow.get(8).toString());
                    importDataVo.setDataFlage(String.valueOf(i - 1));
                    importMap.put(String.valueOf(i - 1), importDataVo);
                    importDataVoList.add(importDataVo);
                }
            }

            Integer importSize=importDataVoList.size();
            Integer integer = mallTempOrderQueryApi.countMallTempOrder(memberId);
            if (integer+importSize > 1000) {
                log.error("最多可添加1000条数据，无法上传，请返回修改");
                return new BaseResponse("最多可添加1000条数据，无法上传，请返回修改");
            }

            if(!Lang.isEmpty(importDataVoList)){
                int importDataVoListSize = importDataVoList.size();
                List<Future<Map<String, ValidataGoodsResp>>> goodFutureList = new ArrayList<>();
                List<Future<Map<String, ValidataMemberAddressResp>>> memberAddressFutureList = new ArrayList<>();
                List<Future<Map<String, ValidateTaxIdentificationResp>>> validateTaxIdentificationRespFutureList = new ArrayList<>();
                List<Future<Map<String, ValidateInvoiceAddressResp>>> validateInvoiceAddressRespFutureList = new ArrayList<>();
                for (int pageIndex = 1; pageIndex <= Math.ceil((double)importDataVoListSize/ pageSize); pageIndex++) {
                    int startIndex = (pageIndex - 1) * pageSize;
                    int endIndex = pageSize * pageIndex;
                    endIndex = endIndex < importDataVoListSize ? endIndex : importDataVoListSize;
                    List<ExcelImportDataVo> list = importDataVoList.subList(startIndex, endIndex);

                    List<ValidataGoods> validataGoodsList = new ArrayList<>();
                    List<ValidataMemberAddress> validataMemberAddressList = new ArrayList<>();
                    List<ValidateTaxIdentification> validateTaxIdentificationList = new ArrayList<>();
                    List<ValidateInvoiceAddress> validateInvoiceAddressList = new ArrayList<>();
//                    for (int j = 0; j < list.size(); j++) {
                    for(ExcelImportDataVo excelImportDataVo:list){
                        String dataFlage =excelImportDataVo.getDataFlage();
                        ValidataGoods validataGoods = new ValidataGoods();
                        ValidataMemberAddress validataMemberAddress = new ValidataMemberAddress();
                        ValidateTaxIdentification validateTaxIdentification = new ValidateTaxIdentification();
                        ValidateInvoiceAddress validateInvoiceAddress = new ValidateInvoiceAddress();
                        //封装校验商品参数
                        validataGoods.setStoreName(excelImportDataVo.getStoreName());
                        validataGoods.setSku(excelImportDataVo.getSku());
                        validataGoods.setDataFlag(dataFlage);
                        validataGoodsList.add(validataGoods);
                        //封装校验会员地址参数
                        validataMemberAddress.setMemberId(memberId);
                        validataMemberAddress.setDataFlag(dataFlage);
                        validataMemberAddress.setAddressNo(excelImportDataVo.getMemberAddressCode());
                        validataMemberAddressList.add(validataMemberAddress);
                        //封装校验纳税人识别号请求参数
                        validateTaxIdentification.setTaxIdentification(excelImportDataVo.getTaxIdentification());
                        validateTaxIdentification.setDataFlag(dataFlage);
                        validateTaxIdentificationList.add(validateTaxIdentification);
                        //封装校验发票收货地址请求参数
                        validateInvoiceAddress.setMemberId(memberId);
                        validateInvoiceAddress.setDataFlag(dataFlage);
                        validateInvoiceAddress.setInvoiceAddressNo(excelImportDataVo.getInvoiceAddressCode());
                        validateInvoiceAddressList.add(validateInvoiceAddress);
                    }

                    //商品编码批量校验
                    Future<Map<String, ValidataGoodsResp>> goodsFuture = orderValidatePool.submit(new Callable<Map<String, ValidataGoodsResp>>() {
                        @Override
                        public Map<String, ValidataGoodsResp> call() throws Exception {
                            Map<String, ValidataGoodsResp> validataGoodsMap = goodsConfigApi.validataGoods(validataGoodsList, ORGANIZATIONCODE);
                            return validataGoodsMap;
                        }
                    });
                    goodFutureList.add(goodsFuture);
                    //收货地址编码校验
                    Future<Map<String, ValidataMemberAddressResp>> memberAddressFuture = orderValidatePool.submit(new Callable<Map<String, ValidataMemberAddressResp>>() {
                        @Override
                        public Map<String, ValidataMemberAddressResp> call() throws Exception {
                            Map<String, ValidataMemberAddressResp> validataMemberAddressMap = memberAddressApi.validataMemberAddress(validataMemberAddressList);
                            return validataMemberAddressMap;
                        }
                    });
                    memberAddressFutureList.add(memberAddressFuture);
                    //纳税人识别号校验
                    Future<Map<String, ValidateTaxIdentificationResp>> taxIdentificationFuture = orderValidatePool.submit(new Callable<Map<String, ValidateTaxIdentificationResp>>() {
                        @Override
                        public Map<String, ValidateTaxIdentificationResp> call() throws Exception {
                            Map<String,ValidateTaxIdentificationResp> validateTaxIdentificationMap = coreCompanyApi.validataTaxIdentification(validateTaxIdentificationList);
                            return validateTaxIdentificationMap;
                        }
                    });
                    validateTaxIdentificationRespFutureList.add(taxIdentificationFuture);
                    //发票收货地址校验
                    Future<Map<String, ValidateInvoiceAddressResp>> invoiceAddressFuture = orderValidatePool.submit(new Callable<Map<String, ValidateInvoiceAddressResp>>() {
                        @Override
                        public Map<String, ValidateInvoiceAddressResp> call() throws Exception {
                            Map<String,ValidateInvoiceAddressResp> validateInvoiceAddressRespMap = memberAddressApi.validataInvoiceAddress(validateInvoiceAddressList);
                            return validateInvoiceAddressRespMap;
                        }
                    });
                    validateInvoiceAddressRespFutureList.add(invoiceAddressFuture);

                    if (endIndex == importDataVoListSize) {
                        break;
                    }
                }
                for (Future<Map<String, ValidataGoodsResp>> goodMapFuture : goodFutureList) {
                    Map<String, ValidataGoodsResp> validataGoodsRespMap = goodMapFuture.get();
                    for(String key:validataGoodsRespMap.keySet()){
                        ValidataGoodsResp validataGoodsResp = validataGoodsRespMap.get(key);
                        importDataVo = importMap.get(key);
                        if(GlobalContants.NO_EXIST.equals(validataGoodsResp.getResult())){
                            if(!Lang.isEmpty(importDataVo.getSku())&&!Lang.isEmpty(importDataVo.getStoreName())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("商品编码不存在，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("商品编码不存在，");
                                }
                            }else if(Lang.isEmpty(importDataVo.getSku())){
                                if(!Lang.isEmpty(importDataVo.getStoreName())){
                                    if(!Lang.isEmpty(importDataVo.getImportResult())){
                                        importDataVo.setImportResult(new StringBuffer("商品编码未填写，").append(importDataVo.getImportResult()).toString());
                                    }else{
                                        importDataVo.setImportResult("商品编码未填写，");
                                    }
                                }else{
                                    if(!Lang.isEmpty(importDataVo.getImportResult())){
                                        importDataVo.setImportResult(new StringBuffer("店铺未填写，商品编码未填写，").append(importDataVo.getImportResult()).toString());
                                    }else{
                                        importDataVo.setImportResult("店铺未填写，商品编码未填写，");
                                    }
                                }
                            }else{
                                if(Lang.isEmpty(importDataVo.getStoreName())){
                                    if(!Lang.isEmpty(importDataVo.getImportResult())){
                                        importDataVo.setImportResult(new StringBuffer("店铺未填写，").append(importDataVo.getImportResult()).toString());
                                    }else {
                                        importDataVo.setImportResult("店铺未填写，");
                                    }
                                }
                            }
                        }
                    }
                }
                for (Future<Map<String, ValidataMemberAddressResp>> memberAddressMapFuture : memberAddressFutureList) {
                    Map<String, ValidataMemberAddressResp> validataMemberAddressRespMap = memberAddressMapFuture.get();
                    for(String key:validataMemberAddressRespMap.keySet()){
                        ValidataMemberAddressResp validataMemberAddressResp = validataMemberAddressRespMap.get(key);
                        importDataVo = importMap.get(key);
                        if(GlobalContants.NO_EXIST.equals(validataMemberAddressResp.getResult())){
                            if(!Lang.isEmpty(importDataVo.getMemberAddressCode())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("收货地址编号不存在，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("收货地址编号不存在，");
                                }
                            }else{
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("收货地址编号未填写，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("收货地址编号未填写，");
                                }
                            }
                        }else{
                            importDataVo.setMemberAddressId(validataMemberAddressResp.getMemberAddressId());
                            importDataVo.setMemberAddress(validataMemberAddressResp.getMemberAddress());
                            importDataVo.setMemberProviceCode(validataMemberAddressResp.getMemberProviceCode());
                            importDataVo.setMemberCityCode(validataMemberAddressResp.getMemberCityCode());
                            importDataVo.setMemberCountryCode(validataMemberAddressResp.getMemberCountryCode());
                            importDataVo.setMemberTownCode(validataMemberAddressResp.getMemberTownCode());
                        }
                    }
                }
                for (Future<Map<String, ValidateTaxIdentificationResp>> validateTaxIdentificationRespMapFuture : validateTaxIdentificationRespFutureList) {
                    Map<String, ValidateTaxIdentificationResp> validateTaxIdentificationRespMap = validateTaxIdentificationRespMapFuture.get();
                    for(String key:validateTaxIdentificationRespMap.keySet()){
                        ValidateTaxIdentificationResp validateTaxIdentificationResp = validateTaxIdentificationRespMap.get(key);
                        importDataVo = importMap.get(key);
                        if(GlobalContants.NO_EXIST.equals(validateTaxIdentificationResp.getResult())){
                            if(!Lang.isEmpty(importDataVo.getTaxIdentification())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("纳税人识别号不存在，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("纳税人识别号不存在，");
                                }
                            }else{
                                if(GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(validateTaxIdentificationResp.getInvoiceType())){
                                    if(!Lang.isEmpty(importDataVo.getImportResult())){
                                        importDataVo.setImportResult(new StringBuffer("纳税人识别号未填写，").append(importDataVo.getImportResult()).toString());
                                    }else{
                                        importDataVo.setImportResult("纳税人识别号未填写，");
                                    }
                                }
                            }
                        }else{
                            importDataVo.setCompanyId(validateTaxIdentificationResp.getCoreCompanyId());
                        }
                    }
                }
                for (Future<Map<String,  ValidateInvoiceAddressResp>>  validateInvoiceAddressRespMapFuture : validateInvoiceAddressRespFutureList) {
                    Map<String, ValidateInvoiceAddressResp> validateInvoiceAddressRespMap = validateInvoiceAddressRespMapFuture.get();
                    for(String key:validateInvoiceAddressRespMap.keySet()){
                        ValidateInvoiceAddressResp validateInvoiceAddressResp = validateInvoiceAddressRespMap.get(key);
                        importDataVo = importMap.get(key);
                        if(GlobalContants.NO_EXIST.equals(validateInvoiceAddressResp.getResult())){
                            if(!Lang.isEmpty(importDataVo.getInvoiceAddressCode())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("发票地址编码不存在，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("发票地址编码不存在，");
                                }
                            }else{
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("发票地址编码未填写，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("发票地址编码未填写，");
                                }
                            }
                        }else{
                            importDataVo.setInvoiceAddressId(validateInvoiceAddressResp.getMemberAddressId());
                            importDataVo.setInvoiceAddress(validateInvoiceAddressResp.getInvoiceAddress());
                        }
                    }
                }
                for(int i=0;i<importDataVoList.size();i++){
                    importDataVo  = importDataVoList.get(i);
                    if(Lang.isEmpty(importDataVo.getNum())){
                        if(!Lang.isEmpty(importDataVo.getImportResult())){
                            importDataVo.setImportResult(new StringBuffer("商品数量未填写，").append(importDataVo.getImportResult()).toString());
                        }else{
                            importDataVo.setImportResult("商品数量未填写，");
                        }
                    }
                    if(Lang.isEmpty(importDataVo.getInvoiceType())){
                        if(!Lang.isEmpty(importDataVo.getImportResult())){
                            importDataVo.setImportResult(new StringBuffer("发票类型未填写，").append(importDataVo.getImportResult()).toString());
                        }else{
                            importDataVo.setImportResult("发票类型未填写，");
                        }
                    }else{
                        if(VALUE_ADDED_TAX_NOMAL_INVOICE.equals(importDataVo.getInvoiceType())){
                            if(Lang.isEmpty(importDataVo.getInvoiceTitle())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("发票抬头未填写，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("发票抬头未填写，");
                                }
                            }
                        }
                        if(VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(importDataVo.getInvoiceType())){
                            if(Lang.isEmpty(importDataVo.getTaxIdentification())){
                                if(!Lang.isEmpty(importDataVo.getImportResult())){
                                    importDataVo.setImportResult(new StringBuffer("纳税人识别号未填写，").append(importDataVo.getImportResult()).toString());
                                }else{
                                    importDataVo.setImportResult("纳税人识别号未填写，");
                                }
                            }
                            importDataVo.setInvoiceTitle("");
                        }
                    }
                    if(Lang.isEmpty(importDataVo.getImportResult())){
                        successDataCount++;
                        importDataVo.setImportResult(IMPORT_SUCCESS);
                    }else {
                        falseDataCount++;
                        importDataVo.setImportResult(new StringBuffer("导入失败：").append(importDataVo.getImportResult()).toString());
                        importDataVo.setImportResult(importDataVo.getImportResult().substring(0,importDataVo.getImportResult().length()-1));
                    }
                }
            }
            UploadCountVo uploadCountVo = new UploadCountVo();
            uploadCountVo.setFalseDataCount(falseDataCount);
            uploadCountVo.setSuccessDataCount(successDataCount);
            long l = System.currentTimeMillis();
            BaseResponse baseResponse = uploadSave(importDataVoList, memberId);
            log.info("保存耗时{}",System.currentTimeMillis()-l);
            log.info("我保存完上传数据喽-_-");
            log.info("批量导入数据上传完成{}",System.currentTimeMillis()-startImport);
            if (baseResponse.isSuccess()) {
                //将导入结果的数据保存在缓存中
                req.getSession().setAttribute(UPLOAD_RESULT_DATA_SESSION, JSON.toJSONString(importDataVoList));
                log.info("我已经将导入结果存入session了-_-:{}", JSON.toJSONString(importDataVoList));
                return new BaseResponse(true, "文件上传成功", uploadCountVo);
            }
        } catch (Exception e) {
            log.error("文件上传失败{}", e);
            return new BaseResponse("文件导入出错");
        }
        return new BaseResponse("文件上传失败");
    }

    /**
     * 文件上传成功后保存
     *
     * @param importDataVoList
     * @return
     */
    public BaseResponse uploadSave(List<ExcelImportDataVo> importDataVoList, String memberId) {
        MallTempOrderVo mallTempOrderVo = new MallTempOrderVo();
        try {
            if (!Lang.isEmpty(importDataVoList)) {
                for (ExcelImportDataVo excelImportData : importDataVoList) {
                    if (IMPORT_SUCCESS.equals(excelImportData.getImportResult())) {
                        List<MallTempGoodsVo> tempGoodsVoList = new ArrayList<>();
                        MallTempGoodsVo tempGoodsVo = new MallTempGoodsVo();
                        // 根据sku查询供应商响应价格
                        GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                        goodsConfigQuery.setSkus(Arrays.asList(new String[] {excelImportData.getSku()}));
                        goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                        goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                        List<GoodsConfigDto> goods = goodsConfigApi.findGoodsConfig(goodsConfigQuery);

//                        List<GoodsConfigDto> goods = goodsConfigApi.findBySkuAndOrganizationCode(excelImportData.getSku(), ORGANIZATIONCODE);
                        List<String> productFashionIds = productFashionApi.findProductFashionIdBySku(excelImportData.getSku());
                        if (!Lang.isEmpty(goods) && !Lang.isEmpty(productFashionIds)) {
                            tempGoodsVo.setStoreId(goods.get(0).getUserId());
                            tempGoodsVo.setGoodsId(goods.get(0).getGoodsId());
                            tempGoodsVo.setProductFashionId(productFashionIds.get(0));
                        }
                        tempGoodsVo.setSku(excelImportData.getSku());
                        tempGoodsVo.setNum(excelImportData.getNum());
                        tempGoodsVoList.add(tempGoodsVo);
                        mallTempOrderVo.setMallTempGoods(tempGoodsVoList);

                        mallTempOrderVo.setMemberAddressId(excelImportData.getMemberAddressId());
                        mallTempOrderVo.setInvoiceAddressId(excelImportData.getInvoiceAddressId());
                        mallTempOrderVo.setInvoiceAddress(excelImportData.getInvoiceAddress());
                        mallTempOrderVo.setMemberAddress(excelImportData.getMemberAddress());
                        if (VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(excelImportData.getInvoiceType())) {
                            mallTempOrderVo.setInvoiceType(GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL);
                        } else {
                            mallTempOrderVo.setInvoiceType(GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN);
                        }
                        mallTempOrderVo.setInvoiceTitle(excelImportData.getInvoiceTitle());
                        mallTempOrderVo.setTaxIdentification(excelImportData.getTaxIdentification());

                        mallTempOrderVo.setInvoiceAddressNo(excelImportData.getInvoiceAddressCode());
                        mallTempOrderVo.setMemberAddressNo(excelImportData.getMemberAddressCode());

                        mallTempOrderVo.setProvinceCode(excelImportData.getMemberProviceCode());
                        mallTempOrderVo.setCityCode(excelImportData.getMemberCityCode());
                        mallTempOrderVo.setCountryCode(excelImportData.getMemberCountryCode());
                        mallTempOrderVo.setTownCode(excelImportData.getMemberTownCode());

                        mallTempOrderVo.setMemberId(memberId);
                        mallTempOrderVo.setCompanyId(excelImportData.getCompanyId());
                        // 收件人地址编号和发票收件地址编号相同
                        if (StringUtils.equals(excelImportData.getInvoiceAddressCode(), excelImportData.getMemberAddressCode())) {
                            mallTempOrderVo.setConsigneeFlag(CONSIGNEE_FLAG_TRUE);
                        } else {
                            // 编号不同
                            mallTempOrderVo.setConsigneeFlag(CONSIGNEE_FLAG_NOT);
                        }
                        saveTempOrder(mallTempOrderVo);
                    }
                }
            }
        } catch (Exception e) {
            log.error("临时订单保存失败{}", e);
            return new BaseResponse("临时订单保存失败");
        }
        return new BaseResponse(true, "临时订单数据保存成功");
    }

    /**
     * 模板下载(导入结果下载)
     *
     * @param req
     */
    @Override
    public void downLoadExcel(HttpServletRequest req, HttpServletResponse response, String parame) {
        //获取用户memberID
        String memberId = (String) req.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
//        String memberId="c387779d-d456-4c22-8646-251e22892928";
        log.info("memberId={}", memberId);
        try {
            String fileName = "batchImportTemplete.xlsx";
            ClassPathResource resource = new ClassPathResource(fileName);
            InputStream inputStream = resource.getInputStream();

            Workbook workbook = ReadExcelUtil.getWorkbook(inputStream, fileName);
            log.info("=======================workbook={}", workbook);
            String headerValue = String.format("attachment; filename=\"%s\"", fileName);
            response.setHeader("Content-Disposition", headerValue);
            response.setContentType("application/vnd.ms-excel");
            OutputStream out = response.getOutputStream();
            //====================================数据准备==============================================================
            List<AttachmentAddressVo> attachmentAddressVos = new ArrayList<>();
            List<AttachmentGoodsVo> attachmentGoodsVos = new ArrayList<>();
            List<AttachmentInvoiceVo> attachmentInvoiceVos = new ArrayList<>();
            List<ExcelImportDataVo> excelImportDataVos = new ArrayList<>();
            //获取导入结果（根据标记位判断获不获取）
            if (UPLOAD_RESULT_DATA_FLAG.equals(parame)) {
                Object importResult = req.getSession().getAttribute(UPLOAD_RESULT_DATA_SESSION);
                if (importResult != null) {
                    excelImportDataVos = JSON.parseArray(importResult.toString(), ExcelImportDataVo.class);
                    log.info("我获取到缓存中的导入数据了-_-");
                }
            }
            //获取地址清单
            List<MemberAddressDto> memberAddress = memberAddressApi.findByMemberId(memberId);
            if (!Lang.isEmpty(memberAddress)) {
                for (MemberAddressDto address : memberAddress) {
                    AttachmentAddressVo attachmentAddressVo = BeanMapper.map(address, AttachmentAddressVo.class);
                    if(Lang.isEmpty(address.getProvinceName())){
                        address.setProvinceName("");
                    }
                    if(Lang.isEmpty(address.getCityName())){
                        address.setCityName("");
                    }
                    if(Lang.isEmpty(address.getAreaName())){
                        address.setAreaName("");
                    }
                    if(Lang.isEmpty(address.getTownName())){
                        address.setTownName("");
                    }
                    attachmentAddressVo.setAddress(new StringBuffer().append(address.getProvinceName()).append(address.getCityName()).append(address.getAreaName()).append(address.getTownName()).toString());
                    if (!Lang.isEmpty(address.getIsDefault())) {
                        if (address.getIsDefault()) {
                            attachmentAddressVo.setDefaultAddess(DEFAULT_ADDRESS_YES);
                        } else {
                            attachmentAddressVo.setDefaultAddess(DEFAULT_ADDRESS_NO);
                        }
                    } else {
                        attachmentAddressVo.setDefaultAddess("");
                    }
                    attachmentAddressVos.add(attachmentAddressVo);
                }
            }
            log.info("我获取到地址清单了-_-");
            //获取购物车商品清单
            DecimalFormat df = new DecimalFormat("#.00");
            MemberDto memberDto = memberApi.findMemberById(memberId);
            if (!Lang.isEmpty(memberDto.getCoreUser())) {
                CartDto userCart = cartApi.getUserCart(memberDto.getCoreUser().getId());
                if (!Lang.isEmpty(userCart)) {
                    long start = System.currentTimeMillis();
                    for (CartItemDto cartItem : userCart.getCartItems()) {
                        AttachmentGoodsVo attachmentGoodsVo = new AttachmentGoodsVo();
                        long queryCartItem = System.currentTimeMillis();
//                        GoodsDto good = goodsApi.findById(cartItem.getGoodsId());
                        MallBatchResponDto good = goodsApi.mallBatchGoodsQuery(cartItem.getGoodsId());
                        log.info("调用goodsApi{}",System.currentTimeMillis()-queryCartItem);
                        if (!Lang.isEmpty(good)) {
                            attachmentGoodsVo.setSku(good.getSku());
                            attachmentGoodsVo.setName(good.getName());
                            attachmentGoodsVo.setPrice(good.getSalePrice().toString());
                            attachmentGoodsVo.setNum(cartItem.getCount().toString());
                            long queryStore = System.currentTimeMillis();
                            StoreDto store = storeApi.findByStoreId(cartItem.getStoreId());
                            log.info("查询店铺信息{}",System.currentTimeMillis()-queryStore);
                            attachmentGoodsVo.setStore(store.getStoreExt().getStoreName());
                            attachmentGoodsVo.setTotal(good.getSalePrice().multiply(new BigDecimal(df.format(cartItem.getCount().doubleValue()))).toString());
                            attachmentGoodsVos.add(attachmentGoodsVo);
                        }
                    }
                    long end = System.currentTimeMillis();
                    log.info("查询商品清单消耗时间{}",start-end);
                }
            }
            log.info("我获取到商品清单了-_-");
            //获取开票清单
            long coreCompanyTime = System.currentTimeMillis();
            CoreCompanyDto coreCompany = coreCompDepartUserApi.getBuyerCompany(memberDto.getCoreUser().getId());
            //CoreCompanyDto coreCompany = coreCompanyApi.getCompanyInfo(coreCompanyDto.getId());
            log.info("查询当前机构耗时{}",System.currentTimeMillis()-coreCompanyTime);
            List<CoreCompanyDto> userRelatedCompany = new ArrayList<>();
            long time = System.currentTimeMillis();
            userRelatedCompany.add(coreCompany);
            //获取上级
            getParentCompny(coreCompany, userRelatedCompany);
            log.info("查询上级机构耗时{}",System.currentTimeMillis()-time);
            //获取下级
            long time2 = System.currentTimeMillis();
            getChildCompany(coreCompany, userRelatedCompany);
            log.info("获取下级机构耗时{}",System.currentTimeMillis()-time2);
            long time3 = System.currentTimeMillis();
            if (!Lang.isEmpty(userRelatedCompany)) {
                for (CoreCompanyDto userCompany : userRelatedCompany) {
                    AttachmentInvoiceVo attachmentInvoiceVo = new AttachmentInvoiceVo();
                    if (GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(userCompany.getInvoiceType())) {
                        attachmentInvoiceVo.setInvoiceType(VALUE_ADDED_TAX_SPECIAL_INVOICE);
                    } else {
                        attachmentInvoiceVo.setInvoiceType(VALUE_ADDED_TAX_NOMAL_INVOICE);
                    }
                    attachmentInvoiceVo.setName(userCompany.getName());
                    attachmentInvoiceVo.setPhone(userCompany.getPhone());
                    attachmentInvoiceVo.setAddress(userCompany.getAddress());
                    attachmentInvoiceVo.setTaxpayerNum(userCompany.getTaxpayerNum());
                    attachmentInvoiceVo.setBankDeposit(userCompany.getBankDeposit());
                    attachmentInvoiceVo.setBankAccount(userCompany.getBankAccount());
                    attachmentInvoiceVos.add(attachmentInvoiceVo);
                }
            }
            log.info("处理开票信息耗时{}",System.currentTimeMillis()-time3);
            log.info("我获取到开票信息了-_-");
            //=======================================读取导入模板处理数据===============================================
//            Workbook workbook= ReadExcelUtil.getWorkbook(excelTemplate);

            //第一个sheet(批量下单)
            Sheet sheetFirst = workbook.getSheetAt(0);
            Integer initRowIndex = 2;
            Integer initIndex = 1;
            if (!Lang.isEmpty(excelImportDataVos)) {
                for (ExcelImportDataVo excelImportDataVo : excelImportDataVos) {
                    if (!Lang.isEmpty(excelImportDataVo)) {
                        // 设置表格默认列宽度为20个字节
                        sheetFirst.setDefaultColumnWidth((short) 20);
                        // 生成一个样式
                        CellStyle cellStyle = workbook.createCellStyle();
                        // 设置这些样式
                        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
                        // 生成一个字体
                        Font font = workbook.createFont();
                        if (IMPORT_SUCCESS.equals(excelImportDataVo.getImportResult())) {
                            font.setColor(HSSFColor.BLACK.index);
                        } else {
                            font.setColor(HSSFColor.RED.index);
                        }
                        font.setFontHeightInPoints((short) 12);
                        // 把字体应用到当前的样式
                        cellStyle.setFont(font);

                        Row row = sheetFirst.createRow(initRowIndex);
                        Cell cell0 = row.createCell(0);
                        cell0.setCellValue(initIndex);
                        if (IMPORT_SUCCESS.equals(excelImportDataVo.getImportResult())) {
                            cell0.setCellStyle(cellStyle);
                        } else {
                            CellStyle cellStyle1 = workbook.createCellStyle();
                            cellStyle1.setBorderBottom(HSSFCellStyle.BORDER_THIN);
                            cellStyle1.setBorderLeft(HSSFCellStyle.BORDER_THIN);
                            cellStyle1.setBorderRight(HSSFCellStyle.BORDER_THIN);
                            cellStyle1.setBorderTop(HSSFCellStyle.BORDER_THIN);
                            cellStyle1.setAlignment(HSSFCellStyle.ALIGN_CENTER);

                            Font font1 = workbook.createFont();
                            font1.setColor(HSSFColor.BLACK.index);
                            font1.setFontHeightInPoints((short) 12);

                            cellStyle1.setFont(font1);
                            cell0.setCellStyle(cellStyle1);
                        }
                        Cell cell1 = row.createCell(1);
                        cell1.setCellValue(excelImportDataVo.getStoreName());
                        cell1.setCellStyle(cellStyle);
                        Cell cell2 = row.createCell(2);
                        cell2.setCellValue(excelImportDataVo.getSku());
                        cell2.setCellStyle(cellStyle);
                        Cell cell3 = row.createCell(3);
                        if (Lang.isEmpty(excelImportDataVo.getNum())) {
                            cell3.setCellValue("");
                        } else {
                            cell3.setCellValue(excelImportDataVo.getNum());
                        }
                        cell3.setCellStyle(cellStyle);
                        Cell cell4 = row.createCell(4);
                        cell4.setCellValue(excelImportDataVo.getMemberAddressCode());
                        cell4.setCellStyle(cellStyle);
                        Cell cell5 = row.createCell(5);
                        cell5.setCellValue(excelImportDataVo.getInvoiceType());
                        cell5.setCellStyle(cellStyle);
                        Cell cell6 = row.createCell(6);
                        cell6.setCellValue(excelImportDataVo.getInvoiceTitle());
                        cell6.setCellStyle(cellStyle);
                        Cell cell7 = row.createCell(7);
                        cell7.setCellValue(excelImportDataVo.getTaxIdentification());
                        cell7.setCellStyle(cellStyle);
                        Cell cell8 = row.createCell(8);
                        cell8.setCellValue(excelImportDataVo.getInvoiceAddressCode());
                        cell8.setCellStyle(cellStyle);
                        Cell cell9 = row.createCell(9);
                        cell9.setCellValue(excelImportDataVo.getImportResult());
                        cell9.setCellStyle(cellStyle);
                        initRowIndex++;
                        initIndex++;
                    }
                }
                log.info("我已经完成第一个sheet的创建-_-");
            }
            //第二个sheet(地址清单)
            Sheet sheetSecond = workbook.getSheetAt(1);
            Integer initRowIndexSecond = 2;
            if (!Lang.isEmpty(attachmentAddressVos)) {
                for (AttachmentAddressVo attachmentAddressVo : attachmentAddressVos) {
                    if (!Lang.isEmpty(attachmentAddressVo)) {
                        // 设置表格默认列宽度为20个字节
                        sheetSecond.setDefaultColumnWidth((short) 20);
                        // 生成一个样式
                        CellStyle cellStyle = workbook.createCellStyle();
                        // 设置这些样式
                        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
                        // 生成一个字体
                        Font font = workbook.createFont();
                        font.setColor(HSSFColor.BLACK.index);
                        font.setFontHeightInPoints((short) 12);
                        // 把字体应用到当前的样式
                        cellStyle.setFont(font);

                        Row row = sheetSecond.createRow(initRowIndexSecond);
                        Cell cell0 = row.createCell(0);
                        cell0.setCellValue(attachmentAddressVo.getAddressNo());
                        cell0.setCellStyle(cellStyle);
                        Cell cell1 = row.createCell(1);
                        cell1.setCellValue(attachmentAddressVo.getUsername());
                        cell1.setCellStyle(cellStyle);
                        Cell cell2 = row.createCell(2);
                        cell2.setCellValue(attachmentAddressVo.getAddress());
                        cell2.setCellStyle(cellStyle);
                        Cell cell3 = row.createCell(3);
                        cell3.setCellValue(attachmentAddressVo.getAddressDetail());
                        cell3.setCellStyle(cellStyle);
                        Cell cell4 = row.createCell(4);
                        cell4.setCellValue(attachmentAddressVo.getPhone());
                        cell4.setCellStyle(cellStyle);
                        Cell cell5 = row.createCell(5);
                        cell5.setCellValue(attachmentAddressVo.getDefaultAddess());
                        cell5.setCellStyle(cellStyle);
                        initRowIndexSecond++;
                    }
                }
                log.info("我已经完成第二个sheet的创建-_-");
            }

            //第三个sheet(商品清单)
            Sheet sheetThird = workbook.getSheetAt(2);
            Integer initRowIndexThird = 2;
            Integer initIndexThird = 1;
            if (!Lang.isEmpty(attachmentGoodsVos)) {
                for (AttachmentGoodsVo attachmentGoodsVo : attachmentGoodsVos) {
                    if (!Lang.isEmpty(attachmentGoodsVo)) {
                        // 设置表格默认列宽度为20个字节
                        sheetThird.setDefaultColumnWidth((short) 20);
                        // 生成一个样式
                        CellStyle cellStyle = workbook.createCellStyle();
                        // 设置这些样式
                        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
                        // 生成一个字体
                        Font font = workbook.createFont();
                        font.setColor(HSSFColor.BLACK.index);
                        font.setFontHeightInPoints((short) 12);
                        // 把字体应用到当前的样式
                        cellStyle.setFont(font);

                        Row row = sheetThird.createRow(initRowIndexThird);
                        Cell cell0 = row.createCell(0);
                        cell0.setCellValue(initIndexThird);
                        cell0.setCellStyle(cellStyle);
                        Cell cell1 = row.createCell(1);
                        cell1.setCellValue(attachmentGoodsVo.getStore());
                        cell1.setCellStyle(cellStyle);
                        Cell cell2 = row.createCell(2);
                        cell2.setCellValue(attachmentGoodsVo.getSku());
                        cell2.setCellStyle(cellStyle);
                        Cell cell3 = row.createCell(3);
                        cell3.setCellValue(attachmentGoodsVo.getName());
                        cell3.setCellStyle(cellStyle);
                        Cell cell4 = row.createCell(4);
                        cell4.setCellValue(String.valueOf(attachmentGoodsVo.getPrice()));
                        cell4.setCellStyle(cellStyle);
                        Cell cell5 = row.createCell(5);
                        cell5.setCellValue(String.valueOf(attachmentGoodsVo.getNum()));
                        cell5.setCellStyle(cellStyle);
                        Cell cell6 = row.createCell(6);
                        cell6.setCellValue(String.valueOf(attachmentGoodsVo.getTotal()));
                        cell6.setCellStyle(cellStyle);
                        initRowIndexThird++;
                        initIndexThird++;
                    }
                }
                log.info("我已经完成第三个sheet的创建-_-");
            }

            //第四个sheet(开票清单)
            Sheet sheetFourth = workbook.getSheetAt(3);
            Integer initRowIndexFourth = 2;
            Integer initIndexFourth = 1;
            if (!Lang.isEmpty(attachmentInvoiceVos)) {
                for (AttachmentInvoiceVo attachmentInvoiceVo : attachmentInvoiceVos) {
                    if (!Lang.isEmpty(attachmentInvoiceVo)) {
                        // 设置表格默认列宽度为20个字节
                        sheetFourth.setDefaultColumnWidth((short) 20);
                        // 生成一个样式
                        CellStyle cellStyle = workbook.createCellStyle();
                        // 设置这些样式
                        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
                        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
                        // 生成一个字体
                        Font font = workbook.createFont();
                        font.setColor(HSSFColor.BLACK.index);
                        font.setFontHeightInPoints((short) 12);
                        // 把字体应用到当前的样式
                        cellStyle.setFont(font);

                        Row row = sheetFourth.createRow(initRowIndexFourth);
                        Cell cell0 = row.createCell(0);
                        cell0.setCellValue(initIndexFourth);
                        cell0.setCellStyle(cellStyle);
                        Cell cell1 = row.createCell(1);
                        cell1.setCellValue(attachmentInvoiceVo.getInvoiceType());
                        cell1.setCellStyle(cellStyle);
                        Cell cell2 = row.createCell(2);
                        cell2.setCellValue(attachmentInvoiceVo.getName());
                        cell2.setCellStyle(cellStyle);
                        Cell cell3 = row.createCell(3);
                        cell3.setCellValue(attachmentInvoiceVo.getTaxpayerNum());
                        cell3.setCellStyle(cellStyle);
                        Cell cell4 = row.createCell(4);
                        cell4.setCellValue(attachmentInvoiceVo.getAddress());
                        cell4.setCellStyle(cellStyle);
                        Cell cell5 = row.createCell(5);
                        cell5.setCellValue(attachmentInvoiceVo.getPhone());
                        cell5.setCellStyle(cellStyle);
                        Cell cell6 = row.createCell(6);
                        cell6.setCellValue(attachmentInvoiceVo.getBankDeposit());
                        cell6.setCellStyle(cellStyle);
                        Cell cell7 = row.createCell(7);
                        cell7.setCellValue(attachmentInvoiceVo.getBankAccount());
                        cell7.setCellStyle(cellStyle);
                        initRowIndexFourth++;
                        initIndexFourth++;
                    }
                }
                log.info("我已经完成第四个sheet的创建-_-");
            }

            workbook.write(out);
            out.close();
            log.info("流已关闭 新鲜的表格出炉了-_-");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getParentCompny(CoreCompanyDto company, List<CoreCompanyDto> userRelatedCompany) {
        CoreCompanyDto companyParent = company.getParent();
        if (companyParent.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_ONE) {
//            CoreCompanyDto companyInfo = coreCompanyApi.getCompanyInfo(companyParent.getId());
//            userRelatedCompany.add(companyInfo);
        }else{
            CoreCompanyDto companyInfo = coreCompanyApi.getCoreCompanyInfoById(companyParent.getId());
            userRelatedCompany.add(companyInfo);
            getParentCompny(companyParent, userRelatedCompany);
        }
    }


    private void getChildCompany(CoreCompanyDto company, List<CoreCompanyDto> userRelatedCompany) {
        List<CoreCompanyDto> childCompany =coreCompanyApi.getChildByParentId(company.getId());// company.getChild();
        if (childCompany == null) {
            log.debug("获取父节点" + company.getName() + "下的所有孩子节点:null");
            return;
        }
        for (CoreCompanyDto companyChild : childCompany) {
            CoreCompanyDto companyInfo = coreCompanyApi.getCoreCompanyInfoById(companyChild.getId());
            userRelatedCompany.add(companyInfo);
            getChildCompany(companyInfo, userRelatedCompany);
        }
    }
    @MotanReferer
    HandleAddressNoApi handleAddressNoApi;

    /**
     * 修改会员地址编码
     */
    @Override
    public void changeMemberAddressNo() {
        handleAddressNoApi.handleAddressNo();
    }

    @Override
    public TiaoXianCompanyVo getBatchOrderiaoXianCompany(TiaoXianRequestVo tianXianRequestVo) {
        return getTiaoXianCompany(tianXianRequestVo);
    }

    public TiaoXianCompanyVo getTiaoXianCompany(TiaoXianRequestVo tianXianRequestVo) {
        TiaoXianCompanyVo tiaoXianCompanyVo = new TiaoXianCompanyVo();
        CoreCompanyDto coreCompany = null;
//        long startTime = System.currentTimeMillis();
        coreCompany = coreCompDepartUserApi.getCompanyByUserIdAndPositon(tianXianRequestVo.getUserId(), CorePositionDto.POSITION_JC_CGJBR);
//        log.info("获取coreCompany耗时：{}",System.currentTimeMillis()-startTime);
        if (!Lang.isEmpty(coreCompany)) {
            if (coreCompany.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_FOUR) {//如果是三级机构，需要判断是否走调线
                String parentCode = getParentCode(coreCompany);
                Boolean isIncludeCode = false;//默认走调线
                String excuArray = systemConfigApi.getConfigValue(ORGANIZATIONCODE, SystemConfigDto.CONFIG_CODE_WORK_FLOW_STRIPER_EXCU, SystemConfigValueDto.CONFIG_VALUE_TYPE_WORK_FLOW_STRIPER_EXCU, true, true);
                if (!Lang.isEmpty(excuArray) && !Lang.isEmpty(parentCode)) {
                    String[] includeArray = excuArray.split(",");
                    for (String value : includeArray) {
                        if (value.equals(parentCode)) {
                            isIncludeCode = true;
                            break;
                        }
                    }
                }
                if (!isIncludeCode) {
                    String isOpen = systemConfigApi.getConfigValue(ORGANIZATIONCODE, SystemConfigDto.CONFIG_CODE_OPEN_CONFIG_WORK_FLOW_STRIPER, SystemConfigValueDto.CONFIG_VALUE_TYPE_OPEN_CONFIG_WORK_FLOW_STRIPER, true, true);
                    if (!Lang.isEmpty(isOpen)) { //是否开启工作流调线
                        if (isOpen.equals("true")) {
                            //工作流人员关联表
                            List<WfWorkFlowRelationDto> workFlowRelations = wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
                            WfWorkFlowDefinitionDto wfWorkFlowDefinition = null; //工作流定义表
                            if (!Lang.isEmpty(workFlowRelations)) {
                                WfWorkFlowRelationDto wfWorkFlowRelation = workFlowRelations.get(0);
                                if (!Lang.isEmpty(wfWorkFlowRelation)) {
                                    wfWorkFlowDefinition = wfWorkFlowRelation.getWorkFlowDefinition();
                                }
                            }
                            ///工作流调线金额
                            String valus = systemConfigApi.getConfigValue(ORGANIZATIONCODE, SystemConfigDto.CONFIG_CODE_WORK_FLOW_STRIPER_MOMEY, SystemConfigValueDto.CONFIG_VALUE_TYPE_WORK_FLOW_STRIPER_MOMEY, true, true);
                            Double thirdTiaoxianMoney = 0D;
                            String thirdTiaoxianUnit = "5万";
                            String thirdTiaoxianMoneyStr = "50000";
                            if (!Lang.isEmpty(valus)) {
                                if (!Lang.isEmpty(wfWorkFlowDefinition)) {
                                    JSONArray jsonArray = JSON.parseArray(valus);
                                    for (int i = 0; i < jsonArray.size(); i++) {
                                        JSONObject obj = jsonArray.getJSONObject(i);
                                        String companyCode = obj.getString("companyCode");
                                        if (wfWorkFlowDefinition.getCompanyCode().equals(companyCode)) {
                                            thirdTiaoxianMoneyStr = obj.getString("money");
                                            thirdTiaoxianUnit = obj.getString("unit");
                                        }
                                    }
                                }
                                try {
                                    thirdTiaoxianMoney = Double.parseDouble(thirdTiaoxianMoneyStr);
                                } catch (Exception e) {
                                    log.info("调线价格转换失败");
                                    e.printStackTrace();
                                }
                            }
                            BigDecimal totalMoney = tianXianRequestVo.getTotalMoney();
                            //添加三级部门采购员申请条线
                            if (coreCompany != null) {
                                switch (coreCompany.getCompanyLevel()) {
                                    case 4: //三级机构 处理条线
//                                         startTime = System.currentTimeMillis();
                                        handleThirdTiaoXian(tiaoXianCompanyVo, totalMoney.doubleValue(), coreCompany, thirdTiaoxianMoney, thirdTiaoxianUnit);
//                                        log.info("获取条线部门耗时：{}",System.currentTimeMillis()-startTime);
                                    default:
                                }
                            }
                        }
                    }
                }
            }

            // 获取审核流程
            List<WfWorkFlowRelationDto> workFlowRelations = wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
            List<WfWorkFlowDefinitionDto> wfWorkFlowDefinitions = new ArrayList<>();
            for (WfWorkFlowRelationDto wf_r : workFlowRelations) {
                if (wf_r.getWorkFlowDefinition().getIsDelete() == null || !wf_r.getWorkFlowDefinition().getIsDelete()) {
                    wfWorkFlowDefinitions.add(wf_r.getWorkFlowDefinition());
                }
            }
            tiaoXianCompanyVo.setWfWorkFlowDefinitions(wfWorkFlowDefinitions);
        }
        return tiaoXianCompanyVo;
    }

    private String getParentCode(CoreCompanyDto coreCompany) {
        String parentId = coreCompany.getParent().getId();
        CoreCompanyDto coreCompanyP1 = coreCompanyApi.getParentCompany(parentId, CoreCompanyDto.COMPANY_LEVEL_TWO);
        return coreCompanyP1.getCode();
    }

    //三级机构 处理条线
    public void handleThirdTiaoXian(TiaoXianCompanyVo tiaoXianCompanyVo, Double sumCartPrice, CoreCompanyDto
            coreCompany, Double thirdTiaoxianMoney, String thirdTiaoxianUnit) {
        if (sumCartPrice > thirdTiaoxianMoney) {
            CoreCompanyDto coreCompanyParent = coreCompany.getParent();
            Integer departmentLevel = 1;
            List<TianXianDepartmentDto> tiaoXianDepartment = coreDepartmentApi.findTiaoXianDepartment(coreCompanyParent.getId(), departmentLevel);
            tiaoXianCompanyVo.setIsTiaoXian(true);
            tiaoXianCompanyVo.setTianXianDepartmentDtos(tiaoXianDepartment);
            tiaoXianCompanyVo.setThirdTiaoxianMoney(new BigDecimal(thirdTiaoxianMoney));
        }
    }

    @Override
    public List<TempOrderVo> getMallTempOrderData(String memberId) {
        List<TempMallOrderVo> mallOrderList = dealMallTempOrderData(memberId);
        // 合并订单
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = dealMallBatchPurchaseData(mallOrderList);
        log.info("..........订单合并结果：{}", JSON.toJSONString(tempBatchPurchaseOrderVos));
        //生成临时订单
        BaseResponse<List<TempOrderVo>> baseResponse = orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        if (baseResponse.isSuccess()) {
            return baseResponse.getResult();
        }
        return null;
    }

    @Override
    public MemberVo findMemberVo(String memberId, String userId) {
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank(memberId)) {
            log.info("memberId:{}", memberId);
            memberVo = memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank(userId)) {
            log.info("userId:{}", userId);
            memberVo = memberApi.getMemberInfoByUserId(userId);

        }
        return memberVo;
    }

    @Override
    public byte[] Zip(List<ZipExportStructure> dataList) throws IOException {
        long time = Calendar.getInstance().getTimeInMillis();
        byte[] b = new byte[]{};
        if (dataList == null || dataList.size() <= 0)
            return b;
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        ZipOutputStream zipOS = new ZipOutputStream(ms);
        zipOS.setLevel(6);
        for (ZipExportStructure ob : dataList) {
            ZipEntry entry = new ZipEntry(ob.getFileName());
            byte[] filecontent = ob.getContent();
            entry.setTime(time);
            entry.setSize(filecontent.length);
            zipOS.putNextEntry(entry);
            zipOS.write(filecontent, 0, filecontent.length);
        }
        if (zipOS != null) {
            zipOS.finish();
            b = ms.toByteArray();
            zipOS.close();
            ms.close();
        }
        return b;
    }

    @Override
    public MallTempOrderVo saveNewTempOrder(MallTempOrderVo mallTempOrderVo) {
        MemberAddressDto memberAddressDto = memberAddressApi.findDtoByIdAndIsDelete(mallTempOrderVo.getMemberAddressId(), false);
        StringBuffer memberBuffer = new StringBuffer();
        if(!Lang.isEmpty(memberAddressDto)){
            memberBuffer.append(memberAddressDto.getProvinceName())
                    .append(memberAddressDto.getCityName()==null?"":memberAddressDto.getCityName())
                    .append(memberAddressDto.getAreaName()==null?"":memberAddressDto.getAreaName())
                    .append(memberAddressDto.getTownName()==null?"":memberAddressDto.getTownName())
                    .append(memberAddressDto.getAddressDetail());
            mallTempOrderVo.setMemberAddress(memberBuffer.toString());
        }
        mallTempOrderVo.setProvinceCode(memberAddressDto.getProvinceCode()==null?"":memberAddressDto.getProvinceCode());
        mallTempOrderVo.setCityCode(memberAddressDto.getCityCode()==null?"":memberAddressDto.getCityCode());
        mallTempOrderVo.setTownCode(memberAddressDto.getTownCode()==null?"":memberAddressDto.getTownCode());
        mallTempOrderVo.setCountryCode(memberAddressDto.getCountryCode()==null?"":memberAddressDto.getCountryCode());
        if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrderVo.getConsigneeFlag())){
            // 自定义地址
            String provinceName = addressApi.findShortNameById(mallTempOrderVo.getConsigneeProvinceCode());
            StringBuffer stringBuffer = new StringBuffer();
            if (!Lang.isEmpty(mallTempOrderVo.getConsigneeCityCode())){
                String cityName = addressApi.findShortNameById(mallTempOrderVo.getConsigneeCityCode());
                stringBuffer.append(provinceName)
                        .append(cityName)
                        .append(mallTempOrderVo.getAddressDetail());
            }
            mallTempOrderVo.setAddressDetail(stringBuffer.toString());
        }else if(CONSIGNEE_FLAG_TRUE.equals(mallTempOrderVo.getConsigneeFlag())){
            // 与收件人地址相同
            mallTempOrderVo.setInvoiceAddress(mallTempOrderVo.getMemberAddress());
            mallTempOrderVo.setInvoiceAddressId(mallTempOrderVo.getMemberAddressId());
            mallTempOrderVo.setInvoiceAddressNo(mallTempOrderVo.getMemberAddressNo());
        }
        return mallTempOrderVo;
    }


    private class GetFreightThread implements Callable<BaseResponse<BigDecimal>>{
        private List<TempOrderVo> tempOrderVos;
        public GetFreightThread(List<TempOrderVo> tempOrderVos){
            this.tempOrderVos = tempOrderVos;
        }

        @Override
        public BaseResponse<BigDecimal> call() throws Exception {
            log.info("启动查询运费线程........");
            BigDecimal singleOrderFee = BigDecimal.ZERO;
            BigDecimal orderFee = BigDecimal.ZERO;
            try{
                List<Future<BaseResponse<BigDecimal>>> feeALLFutures = new ArrayList<>();
                tempOrderVos.forEach(tempOrderVo1 -> {
                    List<Future<BaseResponse<BigDecimal>>> feeFutures = new ArrayList<>();
                    log.info("临时订单[{}]:开始查询运费.....",tempOrderVo1.getTmpOrderNo());
                    tempOrderVo1.getStoreList().forEach(tempOrderStoreVo -> {
                        Future<BaseResponse<BigDecimal>> feeFuture = pool.submit(() -> {
                            BaseResponse<BigDecimal> feeBaseRespone = orderMainApi.queryOrderShippingFee(tempOrderStoreVo.getStoreId(), tempOrderStoreVo.getOrderItems(),
                                    tempOrderVo1.getMemberAddrId());
                            return feeBaseRespone;
                        });
                        feeFutures.add(feeFuture);
                    });
                    feeALLFutures.addAll(feeFutures);
                });
                for (Future<BaseResponse<BigDecimal>> feeFuture : feeALLFutures) {
                    BaseResponse<BigDecimal> feeBaseResponse = feeFuture.get();
                    if (feeBaseResponse.isSuccess()){
                        BigDecimal fee = feeBaseResponse.getResult();
                        orderFee = orderFee.add(fee);
                    }else{
                        return feeBaseResponse;
                    }
                }
                return new BaseResponse<>(true,"获取运费成功",orderFee);
            }catch (Exception e){
                log.info("查询运费线程异常.......");
                return new BaseResponse<>(false,"系统异常，查询运费失败");
            }
        }

        public List<TempOrderVo> getTempOrderVos() {
            return tempOrderVos;
        }

        public void setTempOrderVos(List<TempOrderVo> tempOrderVos) {
            this.tempOrderVos = tempOrderVos;
        }
    }

    private class OccupyStockThread implements Callable<List<Future<Map<String, Object>>>>{
        private List<OrderMainDto> orderMainDtos;

        public OccupyStockThread(List<OrderMainDto> orderMainDtos) {
            this.orderMainDtos = orderMainDtos;
        }

        @Override
        public List<Future<Map<String, Object>>> call() throws Exception {
            log.info("预占库存线程启动......");
            List<Future<Map<String, Object>>> resultList = new ArrayList<>();
            try{
                for (OrderMainDto orderMainDto : orderMainDtos) {
                    log.info("订单[{}]开始预占库存....",orderMainDto.getOrderNo());
                    Future<Map<String, Object>> mapFuture = pool.submit(() -> {
                        Map<String, Object> returnMap = orderMainApi.occupyStock(orderMainDto);
                        return returnMap;
                    });
                    resultList.add(mapFuture);
                }
                return resultList;
            }catch (Exception e){
                log.info("预占库存线程异常:{}",e);
                return null;
            }
        }

        public List<OrderMainDto> getOrderMainDtos() {
            return orderMainDtos;
        }

        public void setOrderMainDtos(List<OrderMainDto> orderMainDtos) {
            this.orderMainDtos = orderMainDtos;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        orderValidatePool = new ThreadPoolExecutor(5, 20, 5, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        pool = new ThreadPoolExecutor(5, 20, 5, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        occupyStockPool = new ThreadPoolExecutor(5, 20, 5, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        getFreightPool = new ThreadPoolExecutor(5, 20, 5, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
    }

    @Override
    public void destroy() throws Exception {
        orderValidatePool.shutdown();
    }
}
