package order.web.utils;


import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;
import utils.excel.excelcreate.vo.ColumnInfoVo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-04-01
 **/
public class AnnotationUtil {
    public static <T> ColumnInfoVo getExcelData(Class<T> classType, List<T> data) {
        if (!classType.isAnnotationPresent(Excel.class)) {
            /**
             * 需要添加Excel注解标识需要导出excel
             */
            throw new RuntimeException("please add @Excel annotation in title");
        }
        Field[] declaredFields = classType.getDeclaredFields();
        Field.setAccessible(declaredFields, true);
        List<String> titles = new ArrayList<String>();
        /**
         * 获取标题
         */
        for (Field declaredField : declaredFields) {
            if (declaredField.isAnnotationPresent(ColumnName.class)) {
                titles.add(declaredField.getAnnotation(ColumnName.class).column());
            }
        }
        if (titles.isEmpty()) {
            /**
             * 需要添加ColumnName注解标识需要导出的列
             */
            throw new RuntimeException("please add @ColumnName annotation in title");
        }
        List<List<Object>> datas = new ArrayList<List<Object>>();
        /**
         * 获取列数据
         */
        for (T datum : data) {
            List<Object> dataList = new ArrayList<>();
            for (Field declaredField : declaredFields) {
                try {
                    if (declaredField.isAnnotationPresent(ColumnName.class)) {
                        dataList.add(declaredField.get(datum));
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            datas.add(dataList);
        }
        return new ColumnInfoVo(titles, datas);
    }
}
