package order.web.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/17
 */
@Data
public class MallOrderUpdateVo implements Serializable {
    /**
     * 主键.
     */
    private String id;

    /**
     * 收件人地址id（memberAddress表主键）
     */
    private String memberAddressId;

    /**
     * 收件人地址名
     */
    private String memberAddressName;
    /**
     * 收件人地址省编码
     */
    private String memberProviceCode;
    /**
     * 收件人地址省名
     */
    private String memberProviceName;
    /**
     * 收件人地址市编码
     */
    private String memberCityCode;
    /**
     * 收件人地址市名
     */
    private String memberCityName;
    /**
     * 收件人地址县/区编码
     */
    private String memberAreaCode;
    /**
     * 收件人地址县/区名
     */
    private String memberAreaName;

    /**
     * 收件人地址镇编码
     */
    private String memberTownCode;

    private String countryCode;

    /**
     * 收件人地址镇名
     */
    private String memberTownName;

    /**
     * 收件人姓名
     */
    private String memberName;

    /**
     * 会员地址编号
     */
    private String memberAddressNo;

    /**
     * 收件人电话
     */
    private String tel;

    /**
     * 商品sku集合
     */
    private List<MallGoodsUpdateVo> mallGoodsUpdateVos;

    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    private String invoiceType;

    /**
     * 发票机构id
     */
    private String companyId;

    /**
     * 开票机构
     */
    private String invoiceOrganization;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 公司地址及电话
     */
    private String companyAddressAndPhone;
    /**
     * 开户行及账号
     */
    private String bankAndAccount;

    /**
     * 纳税人识别号
     */
    private String taxIdentification;

    /**
     * 是否同收件人
     */
    private boolean sameAsAchiever;
    /**
     * 发票收件人
     */
    private String consigneeName;
    /**
     * 发票收件人电话
     */
    private String consigneePhone;
    /**
     * 发票收件人地址
     */
    private String invoiceAddress;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;
    /**
     * 发票收件人省名
     */
    private String consigneeProvinceName;
    /**
     * 发票收件人市
     */
    private String consigneeCityCode;
    /**
     * 发票收件人市名
     */
    private String consigneeCityName;
    /**
     * 详细地址
     */
    private String addressDetail;

    /**
     * 发票收件地址是否同收件人地址:1是0否
     */
    private String consigneeFlag;
}
