package order.web.vo;

import lombok.Data;
import order.dto.MallTempGoodsDto;

import java.io.Serializable;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 * 商城临时订单表VO
 */
@Data
public class MallTempOrderVo implements Serializable {
    /**
     * 主键.
     */
    private String id;

    private List<MallTempGoodsVo> mallTempGoods;

    /**
     * 渠道代码
     */
    private String organizationCode;

    /**
     * 会员id
     */
    private String memberId;

    /**
     * 会员地址表id
     */
    private String memberAddressId;

    /**
     * 会员地址编号
     */
    private String memberAddressNo;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    private String taxIdentification;

    /**
     * 开票机构
     */
    private String invoiceOrganization;

    /**
     * 发票收件人
     */
    private String consigneeName;

    /**
     * 发票收件人电话
     */
    private String consigneePhone;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;

    /**
     * 发票收件人市
     */
    private String consigneeCityCode;
    /**
     * 详细地址
     */
    private String addressDetail;
    /**
     * 发票地址全地址
     */
    private String invoiceAddress;
    /**
     * 会员地址全地址
     */
    private String memberAddress;

    /**
     * 发票会员地址表id
     */
    private String invoiceAddressId;

    /**
     * 发票会员地址表编号
     */
    private String invoiceAddressNo;

    /**
     * 发票地址是否同收件地址
     */
    private Integer consigneeFlag;

    /**
     * 发票机构id
     */
    private String companyId;

//    /**
//     * 是否勾选协议
//     */
//    private Integer isCheckOffAgree;
    /**
     * 收件人省市码
     */
    private String provinceCode;
    private String cityCode;
    private String townCode;
    private String countryCode;

}
