package order.web.vo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import order.vo.TempOrderItemVo;
import order.vo.TmpOrderGiftVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 临时订单的子订单
 * Created by Liang Wenxu on 2017/1/19.
 */
@Data
public class WebTempSubOrderVo implements Serializable {
    /**
     * 临时订单号
     */
    private String tmpOrderNo;

    /**
     * 订单的店铺ID
     */
    private String storeId;

    /**
     * 订单的店铺代码
     */
    private String storeCode;

    /**
     * 店铺标题
     */
    private String storeTitle;

    /**
     * 店铺简称
     */
    private String storeShortName;

    /**
     * 店铺路径
     */
    private String storePath;

    /**
     * 店铺是否需要运费
     */
    private Boolean storeNeedFeright;

    /**
     * 店铺类型名称
     */
    private String storeType;

    /**
     * 店铺分类名称
     */
    private String storeCatName;

    /**
     * 订单模式，normal | batch 常规订单 | 批量订单 等
     */
    public String orderMode;

    /**
     * 商品类型，如一次购买多个类型商品，实际要分别调用其对应的Template
     */
    public String goodsType;

    /**
     * 渠道代码
     */
    public String orgCode;

    /**
     * 父订单的单号
     */
    private String pOrderNo;

    /**
     * 创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 订单总价（实际应付总价，不含运费）
     */
    private BigDecimal sumPrice;

    /**
     * 订单总市场价
     */
    private BigDecimal sumMarketPrice;

    /**
     * 订单总成本价
     */
    private BigDecimal sumCostPrice;

    /**
     * 订单总原始销售价
     */
    private BigDecimal sumOrginalPrice;

    /**
     * 订单应收总价（含运费）
     */
    private BigDecimal needPayPrice;

    /**
     * 订单总运费
     */
    private BigDecimal sumShippingFee;

    private Boolean isFreeShippingFee = false;

    /**
     * 临时订单商品
     * <p>当该临时订单是父订单时将包括所有子订单的商品</p>
     */
    private List<TempOrderItemVo> orderItems;

    /**
     * 子订单
     * <p>当前订单下还有子订单时存在</p>
     */
    private List<WebTempSubOrderVo> subOrders;

    /**
     * 订单礼品
     */
    private List<TmpOrderGiftVo> tmpOrderGifts;

    /**
     * 返回总商品数量(一个商品购买多件仍视为一个商品)
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsCount() {
        return this.orderItems.size();
    }

    /**
     * 返回购买商品件数合计（计算各商品的购买件数）
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsBuyCount() {
        int sumGoodsCount = 0;
        for(TempOrderItemVo oi : this.orderItems) {
            sumGoodsCount += oi.getCount();
        }

        return sumGoodsCount;
    }
}
