package order.web.vo.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Liang Wenxu
 * @since 2018/7/25
 */
@Data
@ApiModel(value = "WebOrderItemPrice", description = "订单商品价格实体")
public class WebOrderItemPrice {
    /**
     * 原始售价
     */
    @ApiModelProperty("商品原始售价")
    private BigDecimal orginalSumPrice;

    /**
     * 总销售价格
     */
    @ApiModelProperty("总销售价格")
    private BigDecimal sumSalesPrice;

    /**
     * 总成本价
     */
    @ApiModelProperty("总成本价")
    private BigDecimal sumCostPrice;

    /**
     * 总市场价
     */
    @ApiModelProperty("总市场价")
    private BigDecimal sumMarketPrice;

    /**
     * 销售价
     */
    @ApiModelProperty("销售价（单价）")
    private BigDecimal salesPrice;

    /**
     * 成本价
     */
    @ApiModelProperty("成本价（单价）")
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    @ApiModelProperty("市场价（单价）")
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    @ApiModelProperty("购买数量")
    private Integer count;

    @ApiModelProperty("商品规格ID")
    private String fashionId;
}
