package order.web.vo.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018/7/25
 */
@Data
@ApiModel(value = "WebOrderItemStock", description = "商品库存详情实体")
public class WebOrderItemStock implements Serializable {
    public static final String STOCK_FLAG_NO_STOCK = "0"; // 无货
    public static final String STOCK_FLAG_HAS_STOCK = "1"; // 有货
    public static final String STOCK_FLAG_PRE_ORDER = "2"; // 预定

    /**
     * 不可销售理由代码{@value}: 产品下架
     */
    public static final String NOTSALE_REASON_PRODUCT_DOWN = "1";

    /**
     * 不可销售理由代码{@value}: 机构无权购买该商品
     */
    public static final String NOTSALE_REASON_NOCOMPANY_PREM = "2";

    @ApiModelProperty("规格ID")
    private String fashionId; // 规格ID
    @ApiModelProperty("第三方平台对应的产品代码")
    private String sku; // 第三方平台对应的产品代码
    @ApiModelProperty("是否可销售")
    private Boolean onSale; // 是否可销售
    @ApiModelProperty("库存数量")
    private Long stockCount; // 库存数量
    @ApiModelProperty("是否限制销售地区")
    private Boolean isAreaRestrict; // 是否限制销售地区
    @ApiModelProperty(value = "是否有货<br/>0-- 无货，1--有货，2--预定（延后发货）", allowableValues = "0,1,2")
    private String stockFlag; // 是否有货 0-- 无货，1--有货，2--预定（延后发货）

    /**
     * 限售原因，当onSale为false时可能有值
     * 取值见NOTSALE_REASON_开头常量
     */
    @ApiModelProperty(value = "限售原因，当onSale为false时可能有值<br/>1--产品下架<br/>2--机构无权限购买", allowableValues = "1,2")
    private String notsaleReason;
}
