/*
 * Decompiled with CFR 0.152.
 */
package order.web.config;

import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.filter.CNTPSSOLoginCheckFilter;
import utils.filter.FrontEndLoginCheckFilter;
import utils.filter.InjectionAttackFilter;
import utils.filter.JicaiSeparateLoginCheckFilter;
import utils.filter.JicaiSeparateLoginFilter;
import utils.io.JarResourceUtil;

@Configuration
@ConfigurationProperties(prefix="security")
public class WebConfig {
    List<String> callbackignore;
    private List<String> urls;

    public FrontEndLoginCheckFilter frontEndLoginCheckFilter(@Value(value="${login.excludeUrls}") String excludeUrls, @Value(value="${login.loginUrl}") String loginUrl, @Value(value="${login.checkUrls}") String checkUrls, @Value(value="${login.defaultSuccessUrl}") String defaultSuccessUrl) {
        FrontEndLoginCheckFilter frontEndLoginCheckFilter = new FrontEndLoginCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
        return frontEndLoginCheckFilter;
    }

    @Bean
    public CNTPSSOLoginCheckFilter frontEndLoginCheckFilter(@Value(value="${login.excludeUrls}") String excludeUrls, @Value(value="${login.loginUrl}") String loginUrl, @Value(value="${login.checkUrls}") String checkUrls, @Value(value="${login.defaultSuccessUrl}") String defaultSuccessUrl, @Value(value="${login.sso.authCookiesName}") String authCookiesName, @Value(value="${login.sso.tokenServerCertPath}") String tokenServerCertPath, @Value(value="${login.sso.appKeyStorePath}") String appKeyStorePath, @Value(value="${login.sso.appKeyStoreAlias}") String appKeyStoreAlias, @Value(value="${login.sso.appKeyStoreAliasPwd}") String appKeyStoreAliasPwd, @Value(value="${login.sso.keyStoreType}") String keyStoreType, @Value(value="${login.sso.appid}") String appid, @Value(value="${login.sso.returnUrl}") String returnUrl, @Value(value="${login.sso.serverUrl}") String serverUrl, @Value(value="${login.sso.authMethod:1}") String authMethod, @Value(value="${login.sso.logout.serverUrl}") String logoutServUrl, @Value(value="${login.forbidRoles}") String forbidRoles) {
        JicaiSeparateLoginFilter frontEndLoginCheckFilter = new JicaiSeparateLoginFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
        frontEndLoginCheckFilter.setAppid(appid);
        frontEndLoginCheckFilter.setAppKeyStoreAlias(appKeyStoreAlias);
        frontEndLoginCheckFilter.setAppKeyStoreAliasPwd(appKeyStoreAliasPwd);
        frontEndLoginCheckFilter.setAppKeyStorePath(appKeyStorePath);
        frontEndLoginCheckFilter.setAuthCookiesName(authCookiesName);
        frontEndLoginCheckFilter.setKeyStoreType(keyStoreType);
        frontEndLoginCheckFilter.setTokenServerCertPath(tokenServerCertPath);
        frontEndLoginCheckFilter.setReturnUrl(returnUrl);
        frontEndLoginCheckFilter.setServerUrl(serverUrl);
        frontEndLoginCheckFilter.setAuthMethod(authMethod);
        frontEndLoginCheckFilter.setLogoutServUrl(logoutServUrl);
        frontEndLoginCheckFilter.setIgnoreCallBackPattens(this.callbackignore);
        frontEndLoginCheckFilter.setForbidRoles(forbidRoles);
        return frontEndLoginCheckFilter;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public List<String> getCallbackignore() {
        return this.callbackignore;
    }

    public void setCallbackignore(List<String> callbackignore) {
        this.callbackignore = callbackignore;
    }

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setUrlPatterns((Collection)this.urls);
        return registrationBean;
    }

    @Bean
    FilterRegistrationBean jiFilterRegistrationBean(@Value(value="${login.excludeUrls}") String excludeUrls, @Value(value="${login.checkUrls}") String checkUrls) {
        JicaiSeparateLoginCheckFilter filter = new JicaiSeparateLoginCheckFilter();
        filter.setCheckUrls(checkUrls).setExcludeUrls(excludeUrls);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        return registrationBean;
    }

    @Bean
    JarResourceUtil jarResourceUtil() {
        return new JarResourceUtil();
    }
}

