/*
 * Decompiled with CFR 0.152.
 */
package order.web.controller;

import cart.api.OrderMainApi;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.QueryInformationApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import order.web.service.MallBatchOrderService;
import order.web.vo.CheckGoodsStockVo;
import order.web.vo.MallOrderSubmitVo;
import order.web.vo.MallTempOrderInfoVo;
import order.web.vo.MallTempOrderVo;
import order.web.vo.TiaoXianCompanyVo;
import order.web.vo.TiaoXianRequestVo;
import order.web.vo.ZipExportStructure;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import springfox.documentation.annotations.ApiIgnore;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import utils.Lang;
import utils.file.FileUtils;
import utils.number.MoneyConvert;
import utils.pdf.PDFUtils;
import workflow.definition.WorkFlowCode;

@ApiIgnore
@RestController
@RequestMapping(value={"mallBatchOrder"})
public class MallBatchOrderController {
    Logger logger = LoggerFactory.getLogger(MallBatchOrderController.class);
    @Value(value="${templete.agreement.url}")
    private String tplpath;
    @Autowired
    private MallBatchOrderService mallBatchOrderService;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    private CoreCompanyApi coreCompanyApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;
    @MotanReferer
    QueryInformationApi queryInformationApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @Autowired
    RedissonClient redisClient;
    @Value(value="${mall.organizationCode}")
    private String organizationCode;
    public static final String VALUE_ADDED_TAX_SPECIAL_INVOICE = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
    public static final String VALUE_ADDED_TAX_NOMAL_INVOICE = "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";

    @RequestMapping(value={"/queryCartGoods"})
    @ResponseBody
    public BaseResponse getCartGoods(String storeNo, String goodsCode, String addressId, HttpServletRequest request) {
        String userId = (String)request.getSession().getAttribute("user_id");
        BaseResponse baseResponse = this.mallBatchOrderService.getCartGoods(userId, storeNo, goodsCode, addressId);
        return baseResponse;
    }

    @RequestMapping(value={"/queryAllStore"})
    @ResponseBody
    public BaseResponse getAllStore() {
        BaseResponse baseResponse = this.mallBatchOrderService.getAllStore();
        return baseResponse;
    }

    @RequestMapping(value={"/checkGoodsStatus"})
    @ResponseBody
    public BaseResponse checkGoodsStatus(@RequestBody CheckGoodsStockVo checkGoodsStockVo, HttpServletRequest request) {
        String userId = (String)request.getSession().getAttribute("user_id");
        BaseResponse baseResponse = this.mallBatchOrderService.checkGoodsStatus(checkGoodsStockVo, userId);
        return baseResponse;
    }

    @RequestMapping(value={"/saveTempOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveTempOrder(@RequestBody MallTempOrderVo mallTempOrderVo, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            mallTempOrderVo.setMemberId(memberId);
            MallTempOrderVo tempOrderVo = this.mallBatchOrderService.saveNewTempOrder(mallTempOrderVo);
            BaseResponse baseResponse = this.mallBatchOrderService.saveTempOrder(tempOrderVo);
            return baseResponse;
        }
        return new BaseResponse(false, "\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/queryTempOrder"})
    @ResponseBody
    public BaseResponse queryTempOrder(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            BaseResponse baseResponse = this.mallBatchOrderService.queryTempOrder(memberId);
            return baseResponse;
        }
        return new BaseResponse(true, "\u67e5\u8be2\u5931\u8d25\uff0c\u767b\u5f55\u5df2\u5931\u6548");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/submitMallOrder"})
    @ResponseBody
    public BaseResponse submitMallOrder(@RequestBody MallOrderSubmitVo mallOrderSubmitVo, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        RLock lock = this.redisClient.getLock(memberId);
        lock.lock(5L, TimeUnit.MINUTES);
        this.logger.info(" isLocked{}", (Object)lock.isLocked());
        try {
            if (!Lang.isEmpty((Object)memberId)) {
                String orderTmpId = UUID.randomUUID().toString().replace("-", "");
                String resultSessionKey = "SUBMIT_RESULT_INFOES_" + orderTmpId;
                BaseResponse baseResponse = this.mallBatchOrderService.submitMallOrder(mallOrderSubmitVo, memberId, request);
                if ("error".equals(baseResponse.getResultCode())) {
                    if (!Lang.isEmpty((Object)baseResponse.getResult())) {
                        Map errorInfoMap = (Map)baseResponse.getResult();
                        BaseResponse baseResponse2 = new BaseResponse(false, "\u4e0b\u5355\u5931\u8d25\uff01\u53ef\u5728\u6279\u91cf\u8ba2\u5355\u5217\u8868\u4e2d\u7684\u201c\u4e0b\u5355\u5931\u8d25\u539f\u56e0\u201d\u5217\uff0c\u67e5\u770b\u5177\u4f53\u5931\u8d25\u539f\u56e0", (Object)errorInfoMap);
                        return baseResponse2;
                    }
                    BaseResponse errorInfoMap = new BaseResponse(false, baseResponse.getResultMessage());
                    return errorInfoMap;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                String orderNos = (String)baseResponse.getResult();
                map.put("orderNos", orderNos);
                request.getSession().setAttribute(resultSessionKey, map);
                BaseResponse baseResponse3 = new BaseResponse(true, "\u4e0b\u5355\u6210\u529f", (Object)orderTmpId);
                return baseResponse3;
            }
        }
        catch (Exception e) {
            this.logger.error("[memberId:{}]\u4e0b\u5355\u5931\u8d25....", (Object)memberId, (Object)e);
            BaseResponse baseResponse = new BaseResponse(false, "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return baseResponse;
        }
        finally {
            lock.unlock();
        }
        return new BaseResponse(false, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/checkMallOrder"})
    @ResponseBody
    public BaseResponse checkMallOrder(String sumfreight, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        String userId = (String)request.getSession().getAttribute("user_id");
        if (!Lang.isEmpty((Object)memberId)) {
            BaseResponse baseResponse = this.mallBatchOrderService.checkMallOrder(sumfreight, memberId, userId, request);
            return baseResponse;
        }
        return new BaseResponse(true, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/getOrderFee"})
    @ResponseBody
    public BaseResponse getOrderFee(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            BaseResponse baseResponse = this.mallBatchOrderService.getOrderFee(memberId, request);
            return baseResponse;
        }
        return new BaseResponse(false, "\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/queryTempOrderInfo"})
    @ResponseBody
    public BaseResponse queryTempOrderInfo(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            BaseResponse baseResponse = this.mallBatchOrderService.getTempOrderInfo(memberId);
            return baseResponse;
        }
        return new BaseResponse(false, "\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/excel/receiverImport"})
    @ResponseBody
    public BaseResponse importExcel(HttpServletRequest req) {
        BaseResponse baseResponse = this.mallBatchOrderService.batchImport(req);
        return baseResponse;
    }

    @RequestMapping(value={"downLoadExcel"})
    public void downLoadExcel(HttpServletRequest req, HttpServletResponse res, String parame) {
        this.mallBatchOrderService.downLoadExcel(req, res, parame);
    }

    @RequestMapping(value={"/saveTempOrderInfo"})
    @ResponseBody
    public BaseResponse saveTempOrderInfo(@RequestBody MallTempOrderInfoVo mallTempOrderInfoVo, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            BaseResponse baseResponse = this.mallBatchOrderService.saveTempOrderInfo(mallTempOrderInfoVo, memberId);
            return baseResponse;
        }
        return new BaseResponse(true, "\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestMapping(value={"/companyInfo", "/companyInfo.json"})
    @ResponseBody
    public Map getCompanyInvoiceInfo(String companyId, String companyLevel) {
        if (Lang.isEmpty((Object)companyId)) {
            return null;
        }
        HashMap<String, CoreCompanyDto> map = new HashMap<String, CoreCompanyDto>();
        CoreCompanyDto coreCompany = this.mallBatchOrderService.getCoreCompanyInfoById(companyId);
        map.put("company", coreCompany);
        return map;
    }

    @RequestMapping(value={"/deleteOrderInfo"})
    @ResponseBody
    public BaseResponse deleteOrderInfo(@RequestBody List<String> temOrderId) {
        BaseResponse baseResponse = this.mallBatchOrderService.deleteOrderInfo(temOrderId);
        return baseResponse;
    }

    @RequestMapping(value={"/updateOrderInfo"})
    @ResponseBody
    public BaseResponse updateOrderInfo(String temOrderId) {
        BaseResponse baseResponse = this.mallBatchOrderService.updateOrderInfo(temOrderId);
        return baseResponse;
    }

    @RequestMapping(value={"/changeMemberAddressNo"})
    public void changeMemberAddressNo() {
        this.mallBatchOrderService.changeMemberAddressNo();
    }

    @RequestMapping(value={"/getBatchOrderiaoXianCompany"})
    public TiaoXianCompanyVo getBatchOrderiaoXianCompany(HttpServletRequest request, BigDecimal totalMoney) {
        String userId = (String)request.getSession().getAttribute("user_id");
        TiaoXianRequestVo tianXianRequestVo = new TiaoXianRequestVo();
        tianXianRequestVo.setUserId(userId);
        tianXianRequestVo.setUseCode(WorkFlowCode.ORDER_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setTotalMoney(totalMoney);
        return this.mallBatchOrderService.getBatchOrderiaoXianCompany(tianXianRequestVo);
    }

    @RequestMapping(value={"/exportProtocol"})
    public ResponseEntity<byte[]> exportProtocol(HttpServletRequest request, HttpServletResponse response) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        String userId = (String)request.getSession().getAttribute("user_id");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        ArrayList<ZipExportStructure> dataList = new ArrayList<ZipExportStructure>();
        byte[] zipData = null;
        MemberAddressDto address = null;
        boolean isProtocolStore = false;
        StringBuilder logsb = new StringBuilder();
        try {
            headers.setContentDispositionFormData("attachment", FileUtils.transCharacter((HttpServletRequest)request, (String)"\u96c6\u56e2\u96c6\u91c7\u7f51\u4e0a\u5546\u57ce\u4ea4\u6613\u534f\u8bae.zip"));
            for (Map.Entry entry : headers.entrySet()) {
                response.setHeader((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            MemberVo memberVo = this.mallBatchOrderService.findMemberVo(memberId, userId);
            CoreCompanyDto coreCompany = this.coreCompDepartUserApi.getBuyerCompany(memberVo.getUser().getId());
            List mallTempOrderData = this.mallBatchOrderService.getMallTempOrderData(memberId);
            ArrayList<Object> orderMaps = new ArrayList<Object>();
            if (!Lang.isEmpty((Object)mallTempOrderData)) {
                for (TempOrderVo order : mallTempOrderData) {
                    HashMap orderDataMap = new HashMap();
                    ArrayList<TempOrderItemVo> arrayList = new ArrayList<TempOrderItemVo>();
                    address = this.memberAddressApi.findById(order.getMemberAddrId());
                    BigDecimal sumOrderFee = BigDecimal.ZERO;
                    for (TempOrderStoreVo group : order.getStoreList()) {
                        for (TempOrderItemVo item2 : group.getOrderItems()) {
                            arrayList.add(item2);
                            BigDecimal singleFee = this.orderMainApi.queryShippingFee(group.getStoreId(), group.getOrderItems(), order.getMemberAddrId());
                            if (Lang.isEmpty((Object)singleFee)) continue;
                            sumOrderFee = sumOrderFee.add(singleFee);
                        }
                    }
                    List protocolStoreList = order.getStoreList().stream().filter(item -> StoreDto.STORE_TYPE_PROTOCOL.equals(item.getType())).collect(Collectors.toList());
                    isProtocolStore = protocolStoreList != null && protocolStoreList.size() > 0;
                    orderDataMap.put("storeName", ((TempOrderStoreVo)order.getStoreList().get(0)).getStoreName());
                    orderDataMap.put("orderItems", arrayList);
                    orderDataMap.put("order", order);
                    orderDataMap.put("chinaMoney", MoneyConvert.digitUppercase((String)order.getSumPrice().toString()));
                    orderDataMap.put("freight", sumOrderFee.doubleValue());
                    orderDataMap.put("coreCompany", coreCompany);
                    orderDataMap.put("address", address);
                    orderMaps.add(orderDataMap);
                }
            }
            byte[] data = null;
            Integer number = 1;
            for (Map map : orderMaps) {
                CoreCompanyDto coreCompanyTwo = this.coreCompanyApi.getParentCompany(coreCompany.getId(), CoreCompanyDto.COMPANY_LEVEL_TWO);
                String agreeConfigStr = this.systemConfigApi.getConfigValue(this.organizationCode, "ORG_AGREEMENT", "ORG_AGREE_CONFIG", Boolean.valueOf(true), Boolean.valueOf(true));
                Map tplMap = (Map)JSONObject.parseObject((String)agreeConfigStr, Map.class);
                String tplName = (String)tplMap.get(coreCompanyTwo.getCode());
                if (Lang.isEmpty((Object)tplName)) {
                    tplName = "tpl.ftl";
                }
                if (isProtocolStore) {
                    tplName = "protocol.ftl";
                }
                TempOrderVo order = (TempOrderVo)map.get("order");
                String fileName = order.getTmpOrderNo() + "_" + number + ".pdf";
                data = PDFUtils.generateToServletOutputStream((String)this.tplpath, (String)tplName, (String)"", (Object)map);
                ZipExportStructure ob = new ZipExportStructure();
                ob.setFileName(fileName);
                ob.setContent(data);
                dataList.add(ob);
                Integer n = number;
                Integer n2 = number = Integer.valueOf(number + 1);
                logsb.append(order.getTmpOrderNo() + ":\u5bfc\u51fapdf\u6210\u529f\r\n");
            }
            logsb.append("finished\r\n");
            ZipExportStructure ob = new ZipExportStructure();
            ob.setFileName("\u5bfc\u51fa\u65e5\u5fd7.log");
            ob.setContent(logsb.toString().getBytes());
            dataList.add(ob);
            zipData = this.mallBatchOrderService.Zip(dataList);
        }
        catch (Exception e) {
            this.logger.error("......\u5bfc\u51fa\u534f\u8bae\u5931\u8d25.....", (Throwable)e);
        }
        return new ResponseEntity(zipData, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveOrderAddress"})
    @ResponseBody
    public Map saveOrderAddress(MemberAddressDto memberAddress, Map model, HttpServletRequest request, HttpServletResponse response) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "success");
        rsMap.put("error", 0);
        try {
            MemberAddressDto res = this.memberAddressApi.saveOrderAddress(memberAddress, memberId);
            res.setMember(null);
            rsMap.put("data", res);
        }
        catch (Exception e) {
            e.printStackTrace();
            rsMap.put("status", "error");
            rsMap.put("error", 1);
            rsMap.put("message", e.getLocalizedMessage());
        }
        return rsMap;
    }
}

