/*
 * Decompiled with CFR 0.152.
 */
package order.web.service;

import cart.api.CartApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductApi;
import goods.dto.product.ProductDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.CoreCompDepartUserApi;
import member.api.MemberApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.vo.MemberVo;
import order.api.OrderApi;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.temporder.TempOrderCreateException;
import order.vo.GoodsInfoVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import order.web.vo.TempOrderCreateWebRequest;
import order.web.vo.TempOrderProduct;
import order.web.vo.WebTempInvoiceItemVo;
import order.web.vo.WebTempInvoiceVo;
import order.web.vo.WebTempOrderItemVo;
import order.web.vo.WebTempOrderVo;
import order.web.vo.response.WebOrderPrice;
import order.web.vo.response.WebOrderStock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import sinomall.global.dto.WebResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

@Component
public class OrderWebService {
    private static final Logger log = LoggerFactory.getLogger(OrderWebService.class);
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    OrderApi orderApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    AddressCommonApi addressApi;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    ProductApi productApi;
    @MotanReferer
    CartApi cartApi;
    @Autowired
    MapperFacade orderMapperFacade;
    @Autowired
    StringRedisTemplate redisTemplate;

    public WebResponse<WebOrderStock> getOrderStock(WebTempOrderVo tempOrderVo) {
        WebOrderStock webOrderStock = null;
        try {
            OrderStock orderStock = this.orderApi.tempOrderStock((TempOrderVo)this.orderMapperFacade.map((Object)tempOrderVo, TempOrderVo.class));
            webOrderStock = (WebOrderStock)this.orderMapperFacade.map((Object)orderStock, WebOrderStock.class);
        }
        catch (IllegalAreaCodeException e) {
            return WebResponse.ERROR((String)"1001", (String)e.getMessage());
        }
        return WebResponse.SUCCESS((Object)webOrderStock);
    }

    public WebResponse<WebTempOrderVo> createTempOrder(TempOrderCreateWebRequest webRequest, MemberVo memberVo, HttpSession session) {
        WebResponse webResponse = null;
        CoreCompanyDto coreCompany = this.coreCompDepartUserApi.getBuyerCompany(memberVo.getUser().getId());
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(webRequest.getOrganizationCode());
        WebTempOrderVo tempOrder = null;
        TempOrderCreateRequest tempOrderCreateRequest = new TempOrderCreateRequest();
        tempOrderCreateRequest.setOrganizationCode(webRequest.getOrganizationCode());
        tempOrderCreateRequest.setOrgainzationId(organization.getId());
        tempOrderCreateRequest.setUserAgent(webRequest.getUserAgent());
        Map areaNodeList = this.addressApi.areaCodeNodeList(webRequest.getAreaCode());
        tempOrderCreateRequest.setProvinceCode((String)areaNodeList.get(1));
        tempOrderCreateRequest.setCityCode((String)areaNodeList.get(2));
        tempOrderCreateRequest.setCountyCode((String)areaNodeList.get(3));
        tempOrderCreateRequest.setTownCode((String)areaNodeList.get(4));
        tempOrderCreateRequest.setUserId(memberVo.getUser().getId());
        tempOrderCreateRequest.setMemberId(memberVo.getMember().getId());
        tempOrderCreateRequest.setOrderMode("1");
        if (webRequest.getProducts() != null && !Lang.isEmpty((Object)webRequest.getProducts())) {
            tempOrderCreateRequest.setGoodsInfoVos(this.requestProduct2GoodsInfoes(webRequest.getProducts()));
        } else if (webRequest.getCartItemIds() != null && !Lang.isEmpty((Object)webRequest.getCartItemIds())) {
            tempOrderCreateRequest.setGoodsInfoVos(this.requestCartItems2GoodsInfoes(webRequest.getCartItemIds(), memberVo.getUser().getId()));
        }
        try {
            TempOrderVo tempOrderRs = this.orderApi.newTempOrder(tempOrderCreateRequest);
            tempOrder = (WebTempOrderVo)this.orderMapperFacade.map((Object)tempOrderRs, WebTempOrderVo.class);
            tempOrder.getSubOrders().forEach(it -> {
                StoreDto store = this.getStore(it.getStoreId());
                it.setStoreTitle(store.getStoreExt().getStoreName());
                it.setStoreShortName(store.getStoreExt().getShortName());
                it.setStoreNeedFeright(Boolean.valueOf(it.getIsFreeShippingFee() == false));
                if (store.getCategory() != null) {
                    it.setStoreCatName(store.getCategory().getName());
                }
                it.setStoreType(store.getStoreExt().getType());
                it.setStorePath(store.getStoreExt().getStorePath());
            });
            tempOrder = this.addInvoiceToNewTempOrder(tempOrder, coreCompany == null ? null : coreCompany.getId());
            webResponse = WebResponse.SUCCESS((Object)tempOrder);
            this.addTempOrder2Session(tempOrder, session);
        }
        catch (TempOrderCreateException e) {
            webResponse = WebResponse.ERROR((String)e.getCode().getValue(), (String)e.getMessage());
        }
        return webResponse;
    }

    public WebResponse<WebOrderPrice> getOrderPrice(WebTempOrderVo tempOrderVo) {
        WebOrderPrice webOrderPrice = null;
        TempOrderVo tempOrderVoApiReq = (TempOrderVo)this.orderMapperFacade.map((Object)tempOrderVo, TempOrderVo.class);
        Map areaCodeMap = this.addressApi.areaCodeNodeList(tempOrderVo.getAreaCode());
        if (areaCodeMap != null) {
            tempOrderVoApiReq.setAreaCodeList(areaCodeMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        }
        try {
            OrderPrice orderPrice = this.orderApi.tempOrderPrice(tempOrderVoApiReq);
            webOrderPrice = (WebOrderPrice)this.orderMapperFacade.map((Object)orderPrice, WebOrderPrice.class);
        }
        catch (IllegalAreaCodeException e) {
            return WebResponse.ERROR((String)"1001", (String)e.getMessage());
        }
        return WebResponse.SUCCESS((Object)webOrderPrice);
    }

    private List<GoodsInfoVo> requestProduct2GoodsInfoes(List<TempOrderProduct> products) {
        List productIds = products.stream().map(TempOrderProduct::getProductId).distinct().collect(Collectors.toList());
        List productList = this.productApi.findByIds(productIds);
        List storeIds = productList.stream().map(ProductDto::getStoreId).collect(Collectors.toList());
        List storeDtos = this.storeApi.findByStoreIds(storeIds);
        Map productMap = productList.stream().collect(Collectors.toMap(ProductDto::getId, Function.identity()));
        Map storeMap = storeDtos.stream().collect(Collectors.toMap(StoreDto::getId, Function.identity()));
        ArrayList<GoodsInfoVo> goodsInfoVoList = new ArrayList<GoodsInfoVo>();
        for (TempOrderProduct p : products) {
            ProductDto tmpProduct = (ProductDto)productMap.get(p.getProductId());
            StoreDto tmpStore = (StoreDto)storeMap.get(tmpProduct.getStoreId());
            if (tmpProduct == null || tmpStore == null) continue;
            GoodsInfoVo goodsInfoVo = new GoodsInfoVo();
            goodsInfoVo.setProductType(tmpProduct.getType());
            goodsInfoVo.setCount(p.getCounts());
            goodsInfoVo.setProductFashionId(p.getProductFashionId());
            goodsInfoVo.setGoodsId(p.getGoodsId());
            goodsInfoVo.setGoodsType("1");
            goodsInfoVo.setStoreCode(tmpStore.getStoreExt().getCode());
            goodsInfoVo.setStoreType(tmpStore.getStoreExt().getType());
            goodsInfoVo.setStoreId(tmpStore.getId());
            if (p.getAccessories() != null && !Lang.isEmpty((Object)p.getAccessories())) {
                goodsInfoVo.setChildren(this.requestProduct2GoodsInfoes(p.getAccessories()));
            }
            goodsInfoVoList.add(goodsInfoVo);
        }
        return goodsInfoVoList;
    }

    private List<GoodsInfoVo> requestCartItems2GoodsInfoes(List<String> cartItemIds, String userId) {
        CartDto userCart = this.cartApi.getUserCart(userId, Boolean.valueOf(false));
        List goodsInfoVoList = null;
        if (userCart != null) {
            List<Object> selectedCartItems = new ArrayList();
            selectedCartItems = userCart.getCartItems().stream().filter(it -> it.getIsDelete() == false && cartItemIds.contains(it.getId())).collect(Collectors.toList());
            goodsInfoVoList = this.requestCartItems2GoodsInfoes(selectedCartItems);
        }
        return goodsInfoVoList;
    }

    private List<GoodsInfoVo> requestCartItems2GoodsInfoes(List<CartItemDto> cartItemDtoList) {
        ArrayList<GoodsInfoVo> goodsInfoVoList = null;
        if (cartItemDtoList.size() > 0) {
            goodsInfoVoList = new ArrayList<GoodsInfoVo>();
            List productIds = cartItemDtoList.stream().map(CartItemDto::getProductId).distinct().collect(Collectors.toList());
            List productList = this.productApi.findByIds(productIds);
            List storeIds = productList.stream().map(ProductDto::getStoreId).collect(Collectors.toList());
            List storeDtos = this.storeApi.findByStoreIds(storeIds);
            Map productMap = productList.stream().collect(Collectors.toMap(ProductDto::getId, Function.identity()));
            Map storeMap = storeDtos.stream().collect(Collectors.toMap(StoreDto::getId, Function.identity()));
            for (CartItemDto cartItem : cartItemDtoList) {
                StoreDto tmpStore;
                ProductDto tmpProduct = (ProductDto)productMap.get(cartItem.getProductId());
                if (tmpProduct == null || (tmpStore = (StoreDto)storeMap.get(tmpProduct.getStoreId())) == null) continue;
                GoodsInfoVo goodsInfoVo = new GoodsInfoVo();
                goodsInfoVo.setStoreId(cartItem.getStoreId());
                goodsInfoVo.setStoreCode(tmpStore.getStoreExt().getCode());
                goodsInfoVo.setStoreType(tmpStore.getStoreExt().getType());
                goodsInfoVo.setCount(cartItem.getCount());
                goodsInfoVo.setProductType(tmpProduct.getType());
                goodsInfoVo.setProductFashionId(cartItem.getProductFashId());
                goodsInfoVo.setGoodsType("1");
                goodsInfoVo.setGoodsId(cartItem.getGoodsId());
                if (cartItem.getChildren() != null && !Lang.isEmpty((Object)cartItem.getChildren())) {
                    goodsInfoVo.setChildren(this.requestCartItems2GoodsInfoes(cartItem.getChildren()));
                }
                goodsInfoVoList.add(goodsInfoVo);
            }
        }
        return goodsInfoVoList;
    }

    public MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        String userId = (String)request.getSession().getAttribute("user_id");
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            log.info("memberId" + memberId);
            memberVo = this.memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            log.info("userId" + userId);
            memberVo = this.memberApi.getMemberInfoByUserId(userId);
        }
        return memberVo;
    }

    public WebTempOrderVo addInvoiceToNewTempOrder(WebTempOrderVo tempOrder, String coreCompanyId) {
        Vector<WebTempInvoiceItemVo> invoiceItemVos = new Vector<WebTempInvoiceItemVo>();
        for (WebTempOrderItemVo orderItemVo : tempOrder.getOrderItems()) {
            WebTempInvoiceItemVo item = new WebTempInvoiceItemVo();
            item.setCount(orderItemVo.getCount().intValue());
            item.setProductFashionId(orderItemVo.getProductFashionId());
            item.setGoodsId(orderItemVo.getGoodsId());
            invoiceItemVos.add(item);
            if (Lang.isEmpty((Object)orderItemVo.getChildren())) continue;
            orderItemVo.getChildren().stream().forEach(chl -> {
                WebTempInvoiceItemVo itemChild = new WebTempInvoiceItemVo();
                itemChild.setCount(orderItemVo.getCount() * chl.getCount());
                itemChild.setProductFashionId(chl.getProductFashionId());
                invoiceItemVos.add(itemChild);
            });
        }
        WebTempInvoiceVo invoiceVo = new WebTempInvoiceVo();
        invoiceVo.setTempInvoiceItemVos(invoiceItemVos);
        invoiceVo.setCompanyId(coreCompanyId);
        invoiceVo.setInvoiceType("02");
        tempOrder.setTempInvoiceVos(Arrays.asList(invoiceVo));
        return tempOrder;
    }

    @Cacheable(cacheNames={"CACHE_API_STORE"}, key="#storeId")
    public StoreDto getStore(String storeId) {
        return this.storeApi.getStoreInfo(storeId);
    }

    public void addTempOrder2Session(WebTempOrderVo tempOrder, HttpSession session) {
        session.setAttribute("TEMP_ORDER_ID:" + tempOrder.getTmpOrderNo(), (Object)JSON.toJSONString((Object)tempOrder));
        List tmpIdList = this.getSessionTmpOrderIds(session);
        tmpIdList.add(tempOrder.getTmpOrderNo());
        this.putSessionTmpOrderIds(tmpIdList, session);
    }

    public Boolean tmpOrderIdExists(String tmpId, HttpSession session) {
        List tmpIdList = this.getSessionTmpOrderIds(session);
        return tmpIdList.contains(tmpId);
    }

    public void removeSessionTmpOrderId(String tmpId, HttpSession session) {
        List tmpIdList = this.getSessionTmpOrderIds(session);
        tmpIdList.removeIf(p -> p.equals(tmpId));
        this.putSessionTmpOrderIds(tmpIdList, session);
        String s = (String)session.getAttribute("TEMP_ORDER_ID:" + tmpId);
        if (!Lang.isEmpty((Object)s)) {
            session.removeAttribute("TEMP_ORDER_ID:" + tmpId);
        }
    }

    public List<String> getSessionTmpOrderIds(HttpSession session) {
        String tmpIdsJoined = (String)session.getAttribute("ORDER_TEMP_LIST_ID");
        ArrayList<String> tmpIdList = new ArrayList<String>();
        if (!Lang.isEmpty((Object)tmpIdsJoined)) {
            tmpIdList.addAll(Arrays.asList(tmpIdsJoined.split(",")));
        } else {
            tmpIdList = new ArrayList();
        }
        return tmpIdList;
    }

    public void putSessionTmpOrderIds(List<String> tmpIdList, HttpSession session) {
        if (tmpIdList != null && !Lang.isEmpty(tmpIdList)) {
            session.setAttribute("ORDER_TEMP_LIST_ID", (Object)Joiner.on((String)",").skipNulls().join(tmpIdList));
        }
    }

    public WebTempOrderVo getTempOrder(String tempOrderNo, HttpSession session) {
        String json = (String)session.getAttribute("TEMP_ORDER_ID:" + tempOrderNo);
        if (Lang.isEmpty((Object)json)) {
            return null;
        }
        return (WebTempOrderVo)JSON.parseObject((String)json, WebTempOrderVo.class);
    }
}

