/*
 * Decompiled with CFR 0.152.
 */
package order.web.service.impl;

import cart.api.CartApi;
import cart.api.OrderMainApi;
import cart.api.QuotaApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempBatchPurchaseOrderVo;
import cart.api.vo.TempInvoiceAddrVo;
import cart.api.vo.TempInvoiceItemVo;
import cart.api.vo.TempInvoiceVo;
import cart.api.vo.TempOrderVo;
import cms.api.AddressApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.dto.MallBatchResponDto;
import goods.dto.ValidataGoodsResp;
import goods.dto.goods.GoodsConfigDto;
import goods.vo.ValidataGoods;
import goods.vo.query.GoodsConfigQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.CoreDepartmentApi;
import member.api.HandleAddressNoApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.MemberInvoinceApi;
import member.api.QueryInformationApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.order.OrderInvoiceDto;
import member.api.dto.order.OrderMainDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import member.api.vo.ValidataMemberAddress;
import member.api.vo.ValidataMemberAddressResp;
import member.api.vo.ValidateInvoiceAddress;
import member.api.vo.ValidateInvoiceAddressResp;
import member.api.vo.ValidateTaxIdentification;
import member.api.vo.ValidateTaxIdentificationResp;
import member.api.vo.cart.InvoiceInfoVo;
import member.api.vo.cart.InvoiceItemInfoVo;
import member.api.vo.cart.InvoiceReceiverVo;
import member.api.vo.cart.OrderSubmitVo;
import order.api.MallAttachmentApi;
import order.api.MallParentOrderApi;
import order.api.MallTempOrderApi;
import order.api.MallTempOrderInfoApi;
import order.api.query.MallParentOrderQueryApi;
import order.api.query.MallTempOrderInfoQueryApi;
import order.api.query.MallTempOrderQueryApi;
import order.definication.BatchOrderStatus;
import order.definication.GoodsStockStatus;
import order.definication.MallAttachmentBusinessCode;
import order.dto.MallAttachmentDto;
import order.dto.MallParentOrderDto;
import order.dto.MallTempGoodsDto;
import order.dto.MallTempOrderDto;
import order.dto.MallTempOrderInfoDto;
import order.web.service.MallBatchOrderService;
import order.web.service.impl.MallBatchOrderServiceImpl;
import order.web.utils.ReadExcel;
import order.web.vo.AttachmentAddressVo;
import order.web.vo.AttachmentGoodsVo;
import order.web.vo.AttachmentInvoiceVo;
import order.web.vo.CartGoodsVo;
import order.web.vo.CheckGoodsStockVo;
import order.web.vo.ExcelImportDataVo;
import order.web.vo.MallAttachmentVo;
import order.web.vo.MallGoodsUpdateVo;
import order.web.vo.MallOrderSubmitVo;
import order.web.vo.MallOrderUpdateVo;
import order.web.vo.MallTempGoodsVo;
import order.web.vo.MallTempOrderInfoFindVo;
import order.web.vo.MallTempOrderInfoVo;
import order.web.vo.MallTempOrderVo;
import order.web.vo.MemberInVoiceVo;
import order.web.vo.MemberInvoiceItemVo;
import order.web.vo.TempBatchListVo;
import order.web.vo.TempBatchOrderVo;
import order.web.vo.TempMallOrderVo;
import order.web.vo.TiaoXianCompanyVo;
import order.web.vo.TiaoXianRequestVo;
import order.web.vo.UploadCountVo;
import order.web.vo.UserInformationVo;
import order.web.vo.ZipExportStructure;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import shipping.api.InvoiceInfoApi;
import sinomall.global.common.response.BaseResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreNavDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.ReadExcelUtil;
import workflow.api.WfWorkFlowRelationApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.definition.AuditFlowImplInstance;
import workflow.definition.WorkFlowCode;
import workflow.dto.WfWorkFlowDefinitionDto;
import workflow.dto.WfWorkFlowRelationDto;
import workflow.dto.WorkFlowRequestDto;
import workflow.exceptions.AuditorNotFoundException;

@Service
public class MallBatchOrderServiceImpl
implements MallBatchOrderService,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MallBatchOrderServiceImpl.class);
    public static ExecutorService getFreightPool = null;
    public static ExecutorService pool = null;
    public static ExecutorService occupyStockPool = null;
    private static final String ORGANIZATIONCODE = "jicai";
    private static final Integer CONSIGNEE_FLAG_TRUE = 1;
    private static final Integer CONSIGNEE_FLAG_FALSE = 0;
    private static final Integer CONSIGNEE_FLAG_NOT = 2;
    private static final String BATCH_ORDER_TYPE = "\u6279\u91cf\u8ba2\u5355";
    private static final String USER_TEMPORDER_KEY = "user_tempOrder_key";
    private static final String USER_DEALORDER_KEY = "user_dealOrder_key";
    private static final Integer CONSIGNEE_FLAG = 0;
    public static final String UPLOAD_RESULT_DATA_SESSION = "BATCH_UPLOAD_RESULT_DATA";
    public static final String UPLOAD_RESULT_DATA_FLAG = "\u5bfc\u5165\u7ed3\u679c\u4e0b\u8f7d";
    public static final String VALUE_ADDED_TAX_SPECIAL_INVOICE = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
    public static final String VALUE_ADDED_TAX_NOMAL_INVOICE = "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
    public static final String IMPORT_SUCCESS = "\u5bfc\u5165\u6210\u529f";
    public static final String DEFAULT_ADDRESS_YES = "\u662f";
    public static final String DEFAULT_ADDRESS_NO = "\u5426";
    private static final String PAY_TYPE_CODE = "1";
    private static final String ORDER_USE_ASSET = "1";
    private static final String ORDER_USE_IMPEL = "2";
    private static final String ORDER_USE_GIFT = "3";
    @MotanReferer
    private MallTempOrderApi mallTempOrderApi;
    @MotanReferer
    private MallTempOrderQueryApi mallTempOrderQueryApi;
    @MotanReferer
    private MallTempOrderInfoQueryApi mallTempOrderInfoQueryApi;
    @MotanReferer
    private MallTempOrderInfoApi mallTempOrderInfoApi;
    @MotanReferer
    private MallParentOrderApi mallParentOrderApi;
    @MotanReferer
    private MallParentOrderQueryApi mallParentOrderQueryApi;
    @MotanReferer
    private CartApi cartApi;
    @MotanReferer
    private GoodsConfigApi goodsConfigApi;
    @MotanReferer
    private OutsideProductApi outsideProductApi;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private StoreApi storeApi;
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private MemberApi memberApi;
    @MotanReferer
    private MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    private MallAttachmentApi mallAttachmentApi;
    @MotanReferer
    private InvoiceInfoApi invoiceInfoApi;
    @MotanReferer
    private ProductFashionApi productFashionApi;
    @MotanReferer
    private CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    private GoodsApi goodsApi;
    @MotanReferer
    private CoreCompanyApi coreCompanyApi;
    @MotanReferer
    private AddressApi addressApi;
    @MotanReferer
    private QueryInformationApi queryInformationApi;
    @MotanReferer
    private WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;
    @MotanReferer
    private WfWorkFlowRelationApi wfWorkFlowRelationApi;
    @MotanReferer
    private CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    private SystemLogApi systemLogApi;
    @MotanReferer
    private QuotaApi quotaApi;
    ThreadPoolExecutor orderValidatePool = null;
    @MotanReferer
    HandleAddressNoApi handleAddressNoApi;

    public BaseResponse getCartGoods(String userId, String storeNo, String goodsCode, String addressId) {
        if (Lang.isEmpty((Object)userId)) {
            return new BaseResponse(false, "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        MemberAddressDto memberAddressDto = this.memberAddressApi.findDtoByIdAndIsDelete(addressId, false);
        CartDto userCart = this.cartApi.getUserCart(userId);
        ArrayList allCartItem = new ArrayList();
        if (!Lang.isEmpty((Object)userCart)) {
            allCartItem.addAll(userCart.getCartItems());
        }
        ArrayList<CartGoodsVo> cartGoodsVos = new ArrayList<CartGoodsVo>();
        if (!Lang.isEmpty((Object)storeNo) && !Lang.isEmpty((Object)goodsCode)) {
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(goodsCode));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List goods = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            if (!Lang.isEmpty((Object)goods)) {
                ArrayList<String> goodsIds = new ArrayList<String>();
                for (CartItemDto cartItemDto : allCartItem) {
                    goodsIds.add(cartItemDto.getGoodsId());
                    if (!StringUtils.equals((CharSequence)storeNo, (CharSequence)cartItemDto.getStoreId()) || !StringUtils.equals((CharSequence)((GoodsConfigDto)goods.get(0)).getGoodsId(), (CharSequence)cartItemDto.getGoodsId())) continue;
                    this.buildCartGoodsVoData(cartItemDto, (GoodsConfigDto)goods.get(0), cartGoodsVos, memberAddressDto);
                    break;
                }
                if (!goodsIds.contains(((GoodsConfigDto)goods.get(0)).getGoodsId())) {
                    CartGoodsVo cartGoodsVo = new CartGoodsVo();
                    cartGoodsVo.setGoodsId(((GoodsConfigDto)goods.get(0)).getGoodsId());
                    List productFashionId = this.productFashionApi.findProductFashionIdBySku(((GoodsConfigDto)goods.get(0)).getSku());
                    cartGoodsVo.setProductFashId((String)productFashionId.get(0));
                    cartGoodsVo.setStoreId(((GoodsConfigDto)goods.get(0)).getUserId());
                    cartGoodsVo.setSalePrice(((GoodsConfigDto)goods.get(0)).getPrice());
                    cartGoodsVo.setProductName(((GoodsConfigDto)goods.get(0)).getTitle());
                    cartGoodsVo.setProductPicture(((GoodsConfigDto)goods.get(0)).getLogoUrl());
                    cartGoodsVo.setSku(((GoodsConfigDto)goods.get(0)).getSku());
                    cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode() == null ? "" : memberAddressDto.getProvinceCode());
                    cartGoodsVo.setCityCode(memberAddressDto.getCityCode() == null ? "" : memberAddressDto.getCityCode());
                    cartGoodsVo.setTownCode(memberAddressDto.getTownCode() == null ? "" : memberAddressDto.getTownCode());
                    cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode() == null ? "" : memberAddressDto.getCountryCode());
                    cartGoodsVos.add(cartGoodsVo);
                }
            }
            return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", cartGoodsVos);
        }
        if (Lang.isEmpty((Object)storeNo) && !Lang.isEmpty((Object)goodsCode)) {
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(goodsCode));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List goods = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            if (!Lang.isEmpty((Object)goods)) {
                ArrayList<String> goodsIds = new ArrayList<String>();
                for (CartItemDto cartItemDto : allCartItem) {
                    goodsIds.add(cartItemDto.getGoodsId());
                    if (!StringUtils.equals((CharSequence)((GoodsConfigDto)goods.get(0)).getGoodsId(), (CharSequence)cartItemDto.getGoodsId())) continue;
                    this.buildCartGoodsVoData(cartItemDto, (GoodsConfigDto)goods.get(0), cartGoodsVos, memberAddressDto);
                    break;
                }
                if (!goodsIds.contains(((GoodsConfigDto)goods.get(0)).getGoodsId())) {
                    CartGoodsVo cartGoodsVo = new CartGoodsVo();
                    cartGoodsVo.setGoodsId(((GoodsConfigDto)goods.get(0)).getGoodsId());
                    List productFashionId = this.productFashionApi.findProductFashionIdBySku(((GoodsConfigDto)goods.get(0)).getSku());
                    cartGoodsVo.setProductFashId((String)productFashionId.get(0));
                    cartGoodsVo.setStoreId(((GoodsConfigDto)goods.get(0)).getUserId());
                    cartGoodsVo.setSalePrice(((GoodsConfigDto)goods.get(0)).getPrice());
                    cartGoodsVo.setProductName(((GoodsConfigDto)goods.get(0)).getTitle());
                    cartGoodsVo.setProductPicture(((GoodsConfigDto)goods.get(0)).getLogoUrl());
                    cartGoodsVo.setSku(((GoodsConfigDto)goods.get(0)).getSku());
                    cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode() == null ? "" : memberAddressDto.getProvinceCode());
                    cartGoodsVo.setCityCode(memberAddressDto.getCityCode() == null ? "" : memberAddressDto.getCityCode());
                    cartGoodsVo.setTownCode(memberAddressDto.getTownCode() == null ? "" : memberAddressDto.getTownCode());
                    cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode() == null ? "" : memberAddressDto.getCountryCode());
                    cartGoodsVos.add(cartGoodsVo);
                }
            }
            return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", cartGoodsVos);
        }
        if (!Lang.isEmpty((Object)storeNo) && Lang.isEmpty((Object)goodsCode)) {
            for (CartItemDto cartItemDto : allCartItem) {
                if (!StringUtils.equals((CharSequence)storeNo, (CharSequence)cartItemDto.getStoreId())) continue;
                String sku = this.productFashionApi.findSkuByProductFashionId(cartItemDto.getProductFashId());
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                goodsConfigQuery.setSkus(Arrays.asList(sku));
                goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                List goodsConfigDtos = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                if (Lang.isEmpty((Object)goodsConfigDtos)) continue;
                this.buildCartGoodsVoData(cartItemDto, (GoodsConfigDto)goodsConfigDtos.get(0), cartGoodsVos, memberAddressDto);
            }
            return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", cartGoodsVos);
        }
        for (CartItemDto cartItemDto : allCartItem) {
            String sku = this.productFashionApi.findSkuByProductFashionId(cartItemDto.getProductFashId());
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(sku));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List goodsConfigDtos = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            if (Lang.isEmpty((Object)goodsConfigDtos)) continue;
            this.buildCartGoodsVoData(cartItemDto, (GoodsConfigDto)goodsConfigDtos.get(0), cartGoodsVos, memberAddressDto);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", cartGoodsVos);
    }

    private void buildCartGoodsVoData(CartItemDto cartItemDto, GoodsConfigDto goodsConfigDto, List<CartGoodsVo> cartGoodsVos, MemberAddressDto memberAddressDto) {
        CartGoodsVo cartGoodsVo = new CartGoodsVo();
        cartGoodsVo.setGoodsId(cartItemDto.getGoodsId());
        cartGoodsVo.setStoreId(cartItemDto.getStoreId());
        cartGoodsVo.setSalePrice(goodsConfigDto.getPrice());
        cartGoodsVo.setProductFashId(cartItemDto.getProductFashId());
        cartGoodsVo.setProductName(goodsConfigDto.getTitle());
        cartGoodsVo.setProductPicture(goodsConfigDto.getLogoUrl());
        cartGoodsVo.setSku(goodsConfigDto.getSku());
        cartGoodsVo.setProvinceCode(memberAddressDto.getProvinceCode() == null ? "" : memberAddressDto.getProvinceCode());
        cartGoodsVo.setCityCode(memberAddressDto.getCityCode() == null ? "" : memberAddressDto.getCityCode());
        cartGoodsVo.setTownCode(memberAddressDto.getTownCode() == null ? "" : memberAddressDto.getTownCode());
        cartGoodsVo.setCountyCode(memberAddressDto.getCountryCode() == null ? "" : memberAddressDto.getCountryCode());
        cartGoodsVos.add(cartGoodsVo);
    }

    private CartGoodsVo buildCartGoodsVoData(GoodsConfigDto goodsConfigDto, MemberAddressDto addressDto) {
        CartGoodsVo cartGoodsVo = new CartGoodsVo();
        cartGoodsVo.setGoodsId(goodsConfigDto.getGoodsId());
        List productFashionId = this.productFashionApi.findProductFashionIdBySku(goodsConfigDto.getSku());
        cartGoodsVo.setProductFashId((String)productFashionId.get(0));
        cartGoodsVo.setStoreId(goodsConfigDto.getUserId());
        cartGoodsVo.setSalePrice(goodsConfigDto.getPrice());
        cartGoodsVo.setProductName(goodsConfigDto.getTitle());
        cartGoodsVo.setProductPicture(goodsConfigDto.getLogoUrl());
        cartGoodsVo.setSku(goodsConfigDto.getSku());
        cartGoodsVo.setProvinceCode(addressDto.getProvinceCode() == null ? "" : addressDto.getProvinceCode());
        cartGoodsVo.setCityCode(addressDto.getCityCode() == null ? "" : addressDto.getCityCode());
        cartGoodsVo.setCountyCode(addressDto.getCountryCode() == null ? "" : addressDto.getCountryCode());
        cartGoodsVo.setTownCode(addressDto.getTownCode() == null ? "" : addressDto.getTownCode());
        return cartGoodsVo;
    }

    public BaseResponse getAllStore() {
        List stores = this.storeApi.findByTpye(StoreDto.STORE_TYPE_SUPLIER);
        for (StoreDto store : stores) {
            store.getStoreExt().setStore(null);
            if (!Lang.isEmpty((Object)store.getNavs())) {
                for (StoreNavDto storeNavDto : store.getNavs()) {
                    storeNavDto.setStore(null);
                }
            }
            if (Lang.isEmpty((Object)store.getCategory())) continue;
            store.getCategory().setStores(null);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)stores);
    }

    public BaseResponse checkGoodsStatus(CheckGoodsStockVo checkGoodsStockVo, String userId) {
        log.info("*****************\u6821\u9a8c\u5546\u54c1\u72b6\u6001\u548c\u5e93\u5b58\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)checkGoodsStockVo));
        if (Lang.isEmpty((Object)checkGoodsStockVo.getGoodsCode())) {
            return new BaseResponse(false, "\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u7801");
        }
        if (Lang.isEmpty((Object)checkGoodsStockVo.getNums())) {
            return new BaseResponse(false, "\u8bf7\u8f93\u5165\u5546\u54c1\u6570\u91cf");
        }
        GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
        goodsConfigQuery.setSkus(Arrays.asList(checkGoodsStockVo.getGoodsCode()));
        goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
        this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
        List goodsConfigDtos = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
        if (Lang.isEmpty((Object)goodsConfigDtos)) {
            return new BaseResponse(false, "\u5546\u54c1\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        MemberAddressDto addressDto = this.memberAddressApi.findDtoByIdAndIsDelete(checkGoodsStockVo.getAddressId(), false);
        if (Lang.isEmpty((Object)addressDto)) {
            return new BaseResponse(false, "\u8bf7\u5148\u9009\u62e9\u5730\u5740");
        }
        GoodsConfigDto goodsConfigDto = (GoodsConfigDto)goodsConfigDtos.get(0);
        CartGoodsVo cartGoodsVo = this.buildCartGoodsVoData(goodsConfigDto, addressDto);
        if (!Lang.isEmpty((Object)checkGoodsStockVo.getStoreId()) && !StringUtils.equals((CharSequence)cartGoodsVo.getStoreId(), (CharSequence)checkGoodsStockVo.getStoreId())) {
            return new BaseResponse(false, "\u5546\u54c1\u4e0d\u5728\u8be5\u5e97\u94fa\u4e0b,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CartDto userCart = this.cartApi.getUserCart(userId);
        ArrayList skus = new ArrayList();
        if (!Lang.isEmpty((Object)userCart)) {
            List cartItems = userCart.getCartItems();
            cartItems.forEach(cartItem -> {
                String sku = this.productFashionApi.findSkuByProductFashionId(cartItem.getProductFashId());
                skus.add(sku);
            });
        }
        FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
        StoreDto store = new StoreDto();
        requetVo.setProvinceCode(addressDto.getProvinceCode());
        requetVo.setCityCode(addressDto.getCityCode());
        requetVo.setCountyCode(addressDto.getAreaCode());
        requetVo.setTownCode(addressDto.getTownCode());
        ArrayList<FashionNumsVo> fashionNums = new ArrayList<FashionNumsVo>();
        FashionNumsVo fashionNumsVo = new FashionNumsVo(cartGoodsVo.getProductFashId(), checkGoodsStockVo.getGoodsCode(), new Long(checkGoodsStockVo.getNums().intValue()));
        fashionNums.add(fashionNumsVo);
        requetVo.setFashionNums(fashionNums);
        store.setId(cartGoodsVo.getStoreId());
        log.info("\u5f00\u59cb\u8fdb\u884c\u5e93\u5b58\u6821\u9a8c......");
        long queryFashionStockStateTime = System.currentTimeMillis();
        HandlerRespVo fashionStockState = this.outsideProductApi.getFashionStockState(store, requetVo);
        log.info("\u67e5\u8be2\u7b2c\u4e09\u65b9\u5e93\u5b58\u72b6\u6001\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionStockStateTime));
        if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
            log.info("\u8c03\u7528\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)fashionStockState.getMessage());
            return new BaseResponse(false, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        List data = (List)fashionStockState.getData();
        if (Lang.isEmpty((Object)data)) {
            return new BaseResponse(false, "\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u8d2d\u4e70");
        }
        FashionStockStateVo fashionStockStateVo = (FashionStockStateVo)data.get(0);
        if (!fashionStockStateVo.getOnSale().booleanValue()) {
            return new BaseResponse(false, "\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u4e0d\u53ef\u8d2d\u4e70");
        }
        if (0 == fashionStockStateVo.getStockFlag()) {
            return new BaseResponse(false, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u8d2d\u4e70");
        }
        if (!Lang.isEmpty(skus) && !skus.contains(checkGoodsStockVo.getGoodsCode())) {
            log.info("\u5e93\u5b58\u6821\u9a8c\u901a\u8fc7\uff0c\u5546\u54c1\u4e0d\u5728\u8d2d\u7269\u8f66.....");
            return new BaseResponse(true, "\u6821\u9a8c\u901a\u8fc7", (Object)cartGoodsVo);
        }
        if (!checkGoodsStockVo.isChoiceFlag()) {
            return new BaseResponse(true, "\u6821\u9a8c\u901a\u8fc7", (Object)cartGoodsVo);
        }
        return new BaseResponse(true, "\u6821\u9a8c\u901a\u8fc7");
    }

    public BaseResponse saveTempOrder(MallTempOrderVo mallTempOrderVo) {
        mallTempOrderVo.setOrganizationCode(ORGANIZATIONCODE);
        if (Lang.isEmpty((Object)mallTempOrderVo.getMemberAddressId())) {
            return new BaseResponse(false, "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)mallTempOrderVo.getInvoiceTitle()) && Lang.isEmpty((Object)mallTempOrderVo.getCompanyId())) {
            return new BaseResponse(false, "\u5f00\u7968\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        MallTempOrderDto mallTempOrderDto = (MallTempOrderDto)BeanMapper.map((Object)mallTempOrderVo, MallTempOrderDto.class);
        return this.mallTempOrderApi.saveMallTempOrder(mallTempOrderDto);
    }

    public BaseResponse queryTempOrder(String memberId) {
        long start = System.currentTimeMillis();
        long queryStart = System.currentTimeMillis();
        List mallTempOrders = this.mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        log.info("\u67e5\u8be2\u4e34\u65f6\u8ba2\u5355\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - queryStart));
        ArrayList tempBatchOrderVos = new ArrayList();
        mallTempOrders.parallelStream().forEach(mallTempOrder -> {
            TempBatchOrderVo tempBatchOrderVo = new TempBatchOrderVo();
            tempBatchOrderVo.setTempOrderId(mallTempOrder.getId());
            tempBatchOrderVo.setMemberAddressId(mallTempOrder.getMemberAddressId());
            tempBatchOrderVo.setProvinceCode(mallTempOrder.getProvinceCode());
            tempBatchOrderVo.setCityCode(mallTempOrder.getCityCode());
            tempBatchOrderVo.setTownCode(mallTempOrder.getTownCode());
            tempBatchOrderVo.setCountryCode(mallTempOrder.getCountryCode());
            tempBatchOrderVo.setMemberAddressDetail(mallTempOrder.getMemberAddress());
            if (CONSIGNEE_FLAG_NOT.equals(mallTempOrder.getConsigneeFlag())) {
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getInvoiceAddress());
            } else if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())) {
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getAddressDetail());
            } else if (CONSIGNEE_FLAG_TRUE.equals(mallTempOrder.getConsigneeFlag())) {
                tempBatchOrderVo.setInvoiceAddress(mallTempOrder.getMemberAddress());
            }
            if ("004".equals(mallTempOrder.getInvoiceType())) {
                long companyStart = System.currentTimeMillis();
                if (!Lang.isEmpty((Object)mallTempOrder.getCompanyId())) {
                    CoreCompanyDto coreCompanyDto = this.coreCompanyApi.getCoreCompanyInfoById(mallTempOrder.getCompanyId());
                    log.info("\u67e5\u8be2\u5f00\u7968\u673a\u6784\u4fe1\u606f\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - companyStart));
                    tempBatchOrderVo.setBankAccount(coreCompanyDto.getBankAccount());
                    tempBatchOrderVo.setBankInfo(coreCompanyDto.getBankDeposit());
                    tempBatchOrderVo.setCompanyAddress(coreCompanyDto.getAddress());
                    tempBatchOrderVo.setCompanyPhone(coreCompanyDto.getPhone());
                    tempBatchOrderVo.setInvoiceTitle(coreCompanyDto.getInvoiceName());
                    tempBatchOrderVo.setInvoiceOrganization(coreCompanyDto.getName());
                    tempBatchOrderVo.setTaxIdentification(coreCompanyDto.getTaxpayerNum());
                }
            } else if ("007".equals(mallTempOrder.getInvoiceType())) {
                tempBatchOrderVo.setInvoiceTitle(mallTempOrder.getInvoiceTitle());
                tempBatchOrderVo.setTaxIdentification(mallTempOrder.getTaxIdentification());
            }
            ArrayList tempBatchListVos = new ArrayList();
            mallTempOrder.getMallTempGoods().parallelStream().forEach(mallTempGoods -> {
                long goodsStart = System.currentTimeMillis();
                GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                goodsConfigQuery.setSkus(Arrays.asList(mallTempGoods.getSku()));
                goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                List goodsConfigDtos = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                log.info("\u67e5\u8be2goods\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - goodsStart));
                if (!Lang.isEmpty((Object)goodsConfigDtos)) {
                    GoodsConfigDto goodsConfigDto = (GoodsConfigDto)goodsConfigDtos.get(0);
                    TempBatchListVo tempBatchListVo = new TempBatchListVo();
                    tempBatchListVo.setNum(mallTempGoods.getNum());
                    tempBatchListVo.setGoodsId(goodsConfigDto.getGoodsId());
                    long priceStart = System.currentTimeMillis();
                    BigDecimal salePrice = this.goodsApi.findSalePriceById(goodsConfigDto.getGoodsId());
                    log.info("\u67e5\u8be2\u4ef7\u683c\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - priceStart));
                    tempBatchListVo.setPrice(salePrice);
                    tempBatchListVo.setSku(mallTempGoods.getSku());
                    BigDecimal sumPrice = salePrice.multiply(new BigDecimal(mallTempGoods.getNum()));
                    sumPrice.setScale(2, 1);
                    tempBatchListVo.setTotalPrice(sumPrice);
                    tempBatchListVo.setGoodsName(goodsConfigDto.getTitle());
                    tempBatchListVo.setStoreName(goodsConfigDto.getStoreName());
                    tempBatchListVos.add(tempBatchListVo);
                }
            });
            tempBatchOrderVo.setTempBatchLists(tempBatchListVos);
            tempBatchOrderVos.add(tempBatchOrderVo);
        });
        log.info("\u4e34\u65f6\u8ba2\u5355\u67e5\u8be2\u5904\u7406\u603b\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - start));
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", tempBatchOrderVos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResponse submitMallOrder(MallOrderSubmitVo mallOrderSubmitVoData, String memberId, HttpServletRequest request) {
        log.info("mallOrderSubmitVoData ->{}", (Object)JSON.toJSONString((Object)mallOrderSubmitVoData));
        MallOrderSubmitVo mallOrderSubmitVo = new MallOrderSubmitVo();
        mallOrderSubmitVo.setOrderUse(mallOrderSubmitVoData.getOrderUse());
        mallOrderSubmitVo.setPayType(mallOrderSubmitVoData.getPayType());
        mallOrderSubmitVo.setRemark(mallOrderSubmitVoData.getRemark());
        mallOrderSubmitVo.setFreight(mallOrderSubmitVoData.getFreight());
        mallOrderSubmitVo.setMallAttachments(mallOrderSubmitVoData.getMallAttachments());
        String tempOrderJson = (String)request.getSession().getAttribute(USER_TEMPORDER_KEY + memberId);
        List tempOrderVos = JSONArray.parseArray((String)tempOrderJson, TempOrderVo.class);
        List orderMainDtos = null;
        MemberDto memberDto = this.memberApi.findMemberById(memberId);
        long buildOrderStart = System.currentTimeMillis();
        BaseResponse parentOrderSaveResult = this.saveParentOrderInfo(mallOrderSubmitVo, memberId);
        log.info("\u5904\u7406\u7236\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - buildOrderStart));
        ArrayList<String> sucOrderNos = new ArrayList<String>();
        if (parentOrderSaveResult.isSuccess() && !Lang.isEmpty((Object)tempOrderVos)) {
            MallParentOrderDto mallParentOrderDto = (MallParentOrderDto)parentOrderSaveResult.getResult();
            tempOrderVos.forEach(tempOrder -> {
                tempOrder.setParentOrderId(mallParentOrderDto.getId());
                String requestId = String.format("%s-%s", tempOrder.getTmpOrderNo(), tempOrder.getMemberAddrId());
                tempOrder.setRequestId(requestId);
                tempOrder.getStoreList().forEach(tempOrderStoreVo -> tempOrderStoreVo.setType("4"));
            });
            long createOrderTime = System.currentTimeMillis();
            BaseResponse orderBaseRsp = this.orderMainApi.batchCreateOrder(tempOrderVos, memberId, mallOrderSubmitVo.getOrderUse(), mallOrderSubmitVo.getPayType());
            if (!orderBaseRsp.isSuccess()) {
                log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)orderBaseRsp.getResultMessage());
                return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
            }
            orderMainDtos = (List)orderBaseRsp.getResult();
            log.info("......\u751f\u6210\u8ba2\u5355\u4e3a{}", (Object)orderMainDtos.stream().map(cart.api.dto.order.OrderMainDto::getOrderNo).collect(Collectors.toList()).toString());
            List sumPrices = orderMainDtos.stream().map(cart.api.dto.order.OrderMainDto::getSumPrice).collect(Collectors.toList());
            for (BigDecimal sumPrice : sumPrices) {
                if (BigDecimal.ZERO.compareTo(sumPrice) != 0) continue;
                this.cancelAllOrder(orderMainDtos, mallParentOrderDto);
                return new BaseResponse("error", "\u8ba2\u5355\u6709\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            long quotaPrice = System.currentTimeMillis();
            BaseResponse quotaSumPrice = this.quotaApi.setQuotaSumPrice(orderMainDtos);
            log.info("\u7d2f\u52a0\u91d1\u989d\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - quotaPrice));
            if (!quotaSumPrice.isSuccess()) {
                log.info("\u9650\u989d\u7ba1\u7406\u7d2f\u52a0\u91d1\u989d\u5931\u8d25:{}", (Object)quotaSumPrice.getResultMessage());
                this.cancelAllOrder(orderMainDtos, mallParentOrderDto);
                return new BaseResponse("error", "\u4e0b\u5355\u91d1\u989d\u5df2\u8d85\u51fa\u9650\u5236\u989d\u5ea6,\u4e0b\u5355\u5931\u8d25");
            }
            this.batchCreateInvoices(orderMainDtos, mallOrderSubmitVo, memberDto);
            MallParentOrderDto parentOrderDto = this.supplyParentOrderData(orderMainDtos, mallOrderSubmitVo.getFreight());
            log.info("......\u751f\u6210\u8ba2\u5355\u603b\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - createOrderTime));
            log.info(".................\u5f00\u59cb\u9884\u5360\u5e93\u5b58.........");
            boolean takeOrderFlag = true;
            String errorMsg = "";
            Long occupyStockTime = System.currentTimeMillis();
            HashMap<String, Object> orderMap = new HashMap<String, Object>();
            HashMap<String, String> errorMap = new HashMap<String, String>();
            HashMap<String, Future<Map>> resultMap = new HashMap<String, Future<Map>>();
            try {
                for (Object orderMainDto : orderMainDtos) {
                    sucOrderNos.add(orderMainDto.getOrderNo());
                    orderMap.put(orderMainDto.getOrderNo(), orderMainDto);
                    log.info("\u8ba2\u5355[{}]\u5f00\u59cb\u9884\u5360\u5e93\u5b58....", (Object)orderMainDto.getOrderNo());
                    Future<Map> future = pool.submit(() -> this.lambda$submitMallOrder$5((cart.api.dto.order.OrderMainDto)orderMainDto));
                    resultMap.put(orderMainDto.getOrderNo(), future);
                }
                if (!Lang.isEmpty(resultMap)) {
                    Set resultSet = resultMap.entrySet();
                    for (Map.Entry entry2 : resultSet) {
                        String orderNo = (String)entry2.getKey();
                        Future returnFuture = (Future)entry2.getValue();
                        Map returnMap = (Map)returnFuture.get();
                        String returnCode = returnMap.get("returnCode").toString();
                        if ("success".equals(returnCode)) continue;
                        takeOrderFlag = false;
                        errorMsg = (String)returnMap.get("returnMsg");
                        log.info("\u8ba2\u5355[{}]\uff1a\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff1aerrorCode:{},msg:{}", new Object[]{orderNo, returnCode, errorMsg});
                        errorMap.put(orderNo, errorMsg);
                    }
                }
            }
            catch (Exception e) {
                log.info("\u9884\u5360\u5e93\u5b58\u5931\u8d25:{}", (Throwable)e);
                try {
                    this.quotaApi.subtractPrice(orderMainDtos);
                    this.cancelAllOrder(orderMainDtos, mallParentOrderDto);
                    return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
                }
                catch (Exception re) {
                    log.info("\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38:{}", (Throwable)re);
                    return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
                }
            }
            log.info("##\u9884\u5360\u5e93\u5b58\u603b\u8017\u65f6##\uff1a{}ms", (Object)(System.currentTimeMillis() - occupyStockTime));
            if (takeOrderFlag) {
                log.info("...........\u5f00\u542f\u5ba1\u6838\u6d41.............");
                WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
                HashMap<String, Object> bussinessDataMap = new HashMap<String, Object>();
                UserInformationVo userInformationVo = this.getOperateInformation(memberId);
                String organizationName = userInformationVo.getWholeJobName();
                bussinessDataMap.put("organizationName", organizationName);
                bussinessDataMap.put("orderTime", new Date());
                MemberVo memberInfo = this.memberApi.getMemberInfo(memberId);
                ArrayList<String> list = new ArrayList<String>();
                if (!Lang.isEmpty((Object)parentOrderDto)) {
                    list.add(parentOrderDto.getParentOrderNo());
                    flowRequestDto.setTotalMoney(parentOrderDto.getTotalMoney());
                }
                flowRequestDto.setMemberId(memberId);
                flowRequestDto.setBussinessDataMap(bussinessDataMap);
                flowRequestDto.setOrderIds(list);
                flowRequestDto.setWorkflowId(mallOrderSubmitVoData.getProcessId());
                flowRequestDto.setUserId(memberInfo.getUser().getId());
                flowRequestDto.setRealName(memberInfo.getMember().getRealName());
                flowRequestDto.setReason(mallOrderSubmitVoData.getRemark());
                flowRequestDto.setBussinessCode(AuditBusinessCode.JICAI_BATCH_ORDER_AUDIT.getBusinessCode());
                flowRequestDto.setFlowIdentificationCode(WorkFlowCode.ORDER_WORKFLOW_CODE.getCode());
                flowRequestDto.setCorePositionCode("JC_BUYER");
                flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.JICAI_BATCH_ORDER_AUDIT.getInstance());
                flowRequestDto.setTiaoxian(mallOrderSubmitVoData.getTianxianDepartMentId());
                log.info("............\u5f00\u542f\u5ba1\u6838\u6d41\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)flowRequestDto));
                try {
                    long startWorkFlow = System.currentTimeMillis();
                    this.workFlowServiceApi.startWorkFlow(flowRequestDto);
                    log.info("............\u5ba1\u6838\u6d41\u5f00\u542f\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startWorkFlow));
                    takeOrderFlag = true;
                }
                catch (Exception e) {
                    log.error("\u63d0\u4ea4\u8ba2\u5355\u5ba1\u6838\u5de5\u4f5c\u6d41\u5931\u8d25\uff01", (Throwable)e);
                    try {
                        this.cancelAllOrder(orderMainDtos, mallParentOrderDto);
                        this.quotaApi.subtractPrice(orderMainDtos);
                    }
                    catch (Exception re) {
                        log.info("\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Throwable)e);
                    }
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String stackTraceStr = stringWriter.toString();
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    if (e instanceof AuditorNotFoundException) {
                        log.info(Lang.isEmpty((Object)e.getMessage()) ? "\u673a\u6784\u8d1f\u8d23\u4eba\u672a\u914d\u7f6e" : e.getLocalizedMessage());
                    } else {
                        log.info("\u63d0\u4ea4\u5ba1\u6838\u6d41\u5931\u8d25");
                    }
                    takeOrderFlag = false;
                }
            }
            if (takeOrderFlag) {
                this.mallTempOrderApi.deleteMallTempOrder(memberId);
                log.info("............\u6e05\u7a7a\u4e34\u65f6\u8ba2\u5355\u6210\u529f...........");
                log.info("\u751f\u6210\u8ba2\u5355\u603b\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - buildOrderStart));
                String orderNos = Joiner.on((String)",").skipNulls().join(sucOrderNos);
                return new BaseResponse("success", "\u4e0b\u5355\u6210\u529f", (Object)orderNos);
            }
            HashMap errorInfoMap = new HashMap();
            if (!Lang.isEmpty(errorMap)) {
                Set errorEntry = errorMap.entrySet();
                errorEntry.forEach(entry -> {
                    cart.api.dto.order.OrderMainDto orderMainDto = (cart.api.dto.order.OrderMainDto)orderMap.get(entry.getKey());
                    orderMainDto.getOrderItems().forEach(orderItem -> errorInfoMap.put(orderItem.getSku(), entry.getValue()));
                    this.saveErrorInfo((String)entry.getValue(), memberId, orderMainDto.getAddressId());
                });
                try {
                    this.cancelAllOrder(orderMainDtos, parentOrderDto);
                    this.quotaApi.subtractPrice(orderMainDtos);
                    return new BaseResponse("error", "\u4e0b\u5355\u5931\u8d25", errorInfoMap);
                }
                catch (Exception exception) {
                    log.info("....\u51cf\u5c11\u7d2f\u989d\u5931\u8d25:{}", (Throwable)exception);
                }
                return new BaseResponse("error", "\u4e0b\u5355\u5931\u8d25", errorInfoMap);
            }
            try {
                this.cancelAllOrder(orderMainDtos, parentOrderDto);
                this.quotaApi.subtractPrice(orderMainDtos);
                return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
            }
            catch (Exception e) {
                log.info("....\u51cf\u5c11\u7d2f\u989d\u5931\u8d25:{}", (Throwable)e);
                return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
            }
        }
        log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)parentOrderSaveResult.getResultMessage());
        return new BaseResponse("error", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
    }

    private void saveErrorInfo(String addressId, String memberId, String errorInfo) {
        this.mallTempOrderApi.updateTempOrder(errorInfo, addressId, memberId);
    }

    private void cancelAllOrder(List<cart.api.dto.order.OrderMainDto> orderMainDtos, MallParentOrderDto mallParentOrderDto) {
        try {
            List orderIds = orderMainDtos.stream().map(cart.api.dto.order.OrderMainDto::getId).collect(Collectors.toList());
            this.orderMainApi.changeStatus(orderIds, "9");
            this.mallParentOrderApi.changeStatus(BatchOrderStatus.ORDER_STATUS_ERROR.getCode(), mallParentOrderDto.getId());
        }
        catch (Exception e) {
            log.info(".......\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38{}", (Throwable)e);
        }
    }

    public BaseResponse checkMallOrder(String sumfreight, String memberId, String userId, HttpServletRequest request) {
        String tempOrderJson = (String)request.getSession().getAttribute(USER_TEMPORDER_KEY + memberId);
        List tempOrderVos = JSONArray.parseArray((String)tempOrderJson, TempOrderVo.class);
        String tempOrderDataJson = (String)request.getSession().getAttribute(USER_DEALORDER_KEY + memberId);
        List mallOrderList = JSONArray.parseArray((String)tempOrderDataJson, TempMallOrderVo.class);
        log.info(".............\u6821\u9a8c\u8ba2\u5355\u9650\u989d..............");
        BigDecimal newOrderSumPirce = tempOrderVos.stream().map(TempOrderVo::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        List tempOrderStores = tempOrderVos.stream().map(TempOrderVo::getStoreList).collect(Collectors.toList());
        ArrayList tempOrderItemList = new ArrayList();
        tempOrderStores.parallelStream().forEach(tempOrderStoreVo -> tempOrderStoreVo.stream().forEach(orderStoreVo -> tempOrderItemList.addAll(orderStoreVo.getOrderItems())));
        String values = this.systemConfigApi.getConfigValue(ORGANIZATIONCODE, "LIMIT_ORDER_PRICE", "LIMIT_ORDER_PRICE", Boolean.valueOf(true), Boolean.valueOf(true));
        newOrderSumPirce = newOrderSumPirce.add(new BigDecimal(sumfreight));
        BigDecimal limit = new BigDecimal(values).multiply(new BigDecimal(10000));
        if (newOrderSumPirce.setScale(2, 5).compareTo(limit.setScale(2, 5)) > 0) {
            return new BaseResponse("001", "\u60a8\u6b64\u6b21\u4e0b\u5355\u7684\u91d1\u989d\u8d85\u8fc7" + values + "\u4e07\uff0c\u4e0d\u53ef\u4e0b\u5355");
        }
        long quotaStart = System.currentTimeMillis();
        BaseResponse quotaResponse = this.quotaApi.batchIsExceedQuota(tempOrderItemList, userId);
        if (quotaResponse.isSuccess()) {
            return new BaseResponse("001", quotaResponse.getResultMessage());
        }
        log.info("..................\u8ba2\u5355\u9650\u989d\u6821\u9a8c\u901a\u8fc7.................");
        log.info("\u6821\u9a8c\u8ba2\u5355\u9650\u989d\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - quotaStart));
        log.info("...................\u6821\u9a8c\u901a\u8fc7,\u6267\u884c\u4e0b\u5355\u6d41\u7a0b...............");
        return new BaseResponse("003", "\u5171\u751f\u6210" + tempOrderVos.size() + "\u5f20\u8ba2\u5355\uff0c\u603b\u4e0b\u5355\u91d1\u989d\u4e3a" + newOrderSumPirce + "\u5143\uff0c\u662f\u5426\u786e\u8ba4\u4e0b\u5355\uff1f");
    }

    public BaseResponse getOrderFee(String memberId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        long dealDatatTime = System.currentTimeMillis();
        List tempMallOrderVos = this.dealMallTempOrderData(memberId);
        log.info("\u5904\u7406\u8ba2\u5355\u6570\u636e\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - dealDatatTime));
        long mergeStart = System.currentTimeMillis();
        List tempBatchPurchaseOrderVos = this.dealMallBatchPurchaseData(new ArrayList(tempMallOrderVos));
        log.info("\u5408\u5e76\u8ba2\u5355\u5904\u7406\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - mergeStart));
        long buildTempOrder = System.currentTimeMillis();
        BaseResponse baseResponse = this.orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        log.info("\u751f\u6210\u4e34\u65f6\u8ba2\u5355\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - buildTempOrder));
        BigDecimal sumOrdersFee = BigDecimal.ZERO;
        if (baseResponse.isSuccess()) {
            List tempOrderVos = (List)baseResponse.getResult();
            if (!Lang.isEmpty((Object)tempOrderVos)) {
                request.getSession().setAttribute(USER_TEMPORDER_KEY + memberId, (Object)JSON.toJSONString((Object)tempOrderVos));
                try {
                    BaseResponse response;
                    Future responseFuture = getFreightPool.submit(new GetFreightThread(this, tempOrderVos));
                    if (!Lang.isEmpty(responseFuture.get()) && !Lang.isEmpty((Object)(response = (BaseResponse)responseFuture.get()).getResult())) {
                        sumOrdersFee = (BigDecimal)response.getResult();
                    }
                    log.info("\u8ba2\u5355\u603b\u8fd0\u8d39\uff1a{}", (Object)sumOrdersFee);
                }
                catch (Exception e) {
                    log.info("\u83b7\u53d6\u8fd0\u8d39\u5931\u8d25\uff1a{}", (Throwable)e);
                    return new BaseResponse(false, "\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        } else {
            return new BaseResponse(false, "\u751f\u6210\u4e34\u65f6\u8ba2\u5355\u65f6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        log.info("\u67e5\u8be2\u8fd0\u8d39\u603b\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f\uff01", (Object)sumOrdersFee);
    }

    public BaseResponse getTempOrderInfo(String memberId) {
        MallTempOrderInfoFindVo mallTempOrderInfoFindVo = new MallTempOrderInfoFindVo();
        MallTempOrderInfoDto mallTempOrderInfo = this.mallTempOrderInfoQueryApi.findMallOrderInfoByMemberId(memberId);
        MallTempOrderInfoVo mallTempOrderInfoVo = (MallTempOrderInfoVo)BeanMapper.map((Object)mallTempOrderInfo, MallTempOrderInfoVo.class);
        mallTempOrderInfoFindVo.setMallTempOrderInfoVo(mallTempOrderInfoVo);
        List mallAttachmentDtos = this.mallAttachmentApi.findMallAttachments(memberId);
        List mallAttachmentVos = BeanMapper.mapList((Iterable)mallAttachmentDtos, MallAttachmentDto.class, MallAttachmentVo.class);
        mallTempOrderInfoFindVo.setMallAttachmentVos(mallAttachmentVos);
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)mallTempOrderInfoFindVo);
    }

    public BaseResponse saveTempOrderInfo(MallTempOrderInfoVo mallTempOrderInfoVo, String memberId) {
        MallTempOrderInfoDto mallTempOrderInfo = this.mallTempOrderInfoQueryApi.findMallOrderInfoByMemberId(memberId);
        if (!Lang.isEmpty((Object)mallTempOrderInfo)) {
            this.mallTempOrderInfoApi.deleteTempOrderInfo(mallTempOrderInfo);
        }
        MallTempOrderInfoDto mallTempOrderInfoDto = (MallTempOrderInfoDto)BeanMapper.map((Object)mallTempOrderInfoVo, MallTempOrderInfoDto.class);
        mallTempOrderInfoDto.setMemberId(memberId);
        BaseResponse baseResponse = this.mallTempOrderInfoApi.saveMallTempOrderInfo(mallTempOrderInfoDto);
        return baseResponse;
    }

    public CoreCompanyDto getCoreCompanyInfoById(String companyId) {
        return this.coreCompanyApi.getCoreCompanyInfoById(companyId);
    }

    public BaseResponse deleteOrderInfo(List<String> temOrderId) {
        BaseResponse baseResponse = this.mallTempOrderApi.deleteMallTempOrder(temOrderId);
        return baseResponse;
    }

    public BaseResponse updateOrderInfo(String temOrderId) {
        long startTime = System.currentTimeMillis();
        MallTempOrderDto mallTempOrder = this.mallTempOrderQueryApi.findMallTempOrderById(temOrderId);
        long queryAddress = System.currentTimeMillis();
        MemberAddressDto memberAddress = this.memberAddressApi.findById(mallTempOrder.getMemberAddressId());
        log.info("\u67e5\u8be2\u5730\u5740\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - queryAddress));
        MallOrderUpdateVo mallOrderUpdateVo = (MallOrderUpdateVo)BeanMapper.map((Object)mallTempOrder, MallOrderUpdateVo.class);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(memberAddress.getProvinceName()).append(memberAddress.getCityName() == null ? "" : memberAddress.getCityName()).append(memberAddress.getAreaName() == null ? "" : memberAddress.getAreaName()).append(memberAddress.getTownName() == null ? "" : memberAddress.getTownName()).append(memberAddress.getAddressDetail());
        mallOrderUpdateVo.setMemberAddressName(strBuffer.toString());
        mallOrderUpdateVo.setMemberProviceCode(memberAddress.getProvinceCode() == null ? "" : memberAddress.getProvinceCode());
        mallOrderUpdateVo.setMemberCityCode(memberAddress.getCityCode() == null ? "" : memberAddress.getCityCode());
        mallOrderUpdateVo.setMemberAreaCode(memberAddress.getAreaCode() == null ? "" : memberAddress.getAreaCode());
        mallOrderUpdateVo.setMemberTownCode(memberAddress.getTownCode() == null ? "" : memberAddress.getTownCode());
        mallOrderUpdateVo.setCountryCode(memberAddress.getCountryCode() == null ? "" : memberAddress.getCountryCode());
        mallOrderUpdateVo.setMemberProviceName(memberAddress.getProvinceName());
        mallOrderUpdateVo.setMemberCityName(memberAddress.getCityName());
        mallOrderUpdateVo.setMemberAreaName(memberAddress.getAreaName());
        mallOrderUpdateVo.setMemberTownName(memberAddress.getTownName());
        mallOrderUpdateVo.setMemberName(memberAddress.getUsername());
        mallOrderUpdateVo.setMemberAddressNo(memberAddress.getAddressNo());
        mallOrderUpdateVo.setTel(memberAddress.getTel());
        if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())) {
            long addrStart = System.currentTimeMillis();
            String consigneeProvinceName = this.addressApi.findShortNameById(mallTempOrder.getConsigneeProvinceCode());
            String consigneeCityName = this.addressApi.findShortNameById(mallTempOrder.getConsigneeCityCode());
            log.info("\u67e5\u8be2\u5730\u5740\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - addrStart));
            mallOrderUpdateVo.setConsigneeProvinceName(consigneeProvinceName);
            mallOrderUpdateVo.setConsigneeCityName(consigneeCityName);
            StringBuffer invoiceAddress = new StringBuffer();
            invoiceAddress.append(consigneeProvinceName).append(consigneeCityName).append(mallOrderUpdateVo.getAddressDetail());
            invoiceAddress.append(consigneeProvinceName);
            invoiceAddress.append(consigneeCityName);
            invoiceAddress.append(mallOrderUpdateVo.getAddressDetail());
            mallOrderUpdateVo.setInvoiceAddress(invoiceAddress.toString());
        }
        ArrayList<MallGoodsUpdateVo> mallGoodsUpdateVos = new ArrayList<MallGoodsUpdateVo>();
        MallGoodsUpdateVo mallGoodsUpdateVo = null;
        for (MallTempGoodsDto mallTempGoodsDto : mallTempOrder.getMallTempGoods()) {
            mallGoodsUpdateVo = new MallGoodsUpdateVo();
            GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
            goodsConfigQuery.setSkus(Arrays.asList(mallTempGoodsDto.getSku()));
            goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
            this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            List goodsConfigDtos = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
            GoodsConfigDto goodsConfig = (GoodsConfigDto)goodsConfigDtos.get(0);
            mallGoodsUpdateVo.setGoodsId(mallTempGoodsDto.getGoodsId());
            mallGoodsUpdateVo.setNum(mallTempGoodsDto.getNum());
            mallGoodsUpdateVo.setProductFashId(mallTempGoodsDto.getProductFashionId());
            mallGoodsUpdateVo.setProductName(goodsConfig.getTitle());
            mallGoodsUpdateVo.setProductPicture(goodsConfig.getLogoUrl());
            mallGoodsUpdateVo.setSalePrice(goodsConfig.getPrice());
            mallGoodsUpdateVo.setSku(mallTempGoodsDto.getSku());
            mallGoodsUpdateVo.setStoreId(goodsConfig.getUserId());
            mallGoodsUpdateVos.add(mallGoodsUpdateVo);
        }
        mallOrderUpdateVo.setMallGoodsUpdateVos(mallGoodsUpdateVos);
        if ("004".equals(mallOrderUpdateVo.getInvoiceType())) {
            CoreCompanyDto coreCompanyDto = this.coreCompanyApi.findById(mallTempOrder.getCompanyId());
            mallOrderUpdateVo.setCompanyAddressAndPhone(coreCompanyDto.getAddress() + " " + coreCompanyDto.getPhone());
            mallOrderUpdateVo.setBankAndAccount(coreCompanyDto.getBankDeposit() + " " + coreCompanyDto.getBankAccount());
        }
        log.info("\u4fee\u6539\u4fe1\u606f\u67e5\u8be2\u5904\u7406\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        return new BaseResponse(true, "\u4fe1\u606f\u67e5\u8be2\u6210\u529f", (Object)mallOrderUpdateVo);
    }

    private BaseResponse<MallParentOrderDto> saveParentOrderInfo(MallOrderSubmitVo mallOrderSubmitVo, String memberId) {
        UserInformationVo operateInformation = this.getOperateInformation(memberId);
        String organizationName = operateInformation.getWholeJobName();
        MallParentOrderDto mallParentOrder = new MallParentOrderDto();
        mallParentOrder.setMemberId(memberId);
        mallParentOrder.setMemberName(operateInformation.getMember().getRealName());
        if ("1".equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("\u8d44\u4ea7");
        } else if (ORDER_USE_IMPEL.equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("\u6fc0\u52b1\u54c1");
        } else if (ORDER_USE_GIFT.equals(mallOrderSubmitVo.getOrderUse())) {
            mallParentOrder.setOrderUse("\u798f\u5229");
        }
        if ("1".equals(mallOrderSubmitVo.getPayType())) {
            mallParentOrder.setPayType("\u5728\u7ebf\u652f\u4ed8");
        }
        mallParentOrder.setFreight(mallOrderSubmitVo.getFreight());
        mallParentOrder.setRemark(mallOrderSubmitVo.getRemark());
        mallParentOrder.setCompanyName(organizationName);
        mallParentOrder.setParentOrderNo(this.orderMainApi.generateOrderNo());
        mallParentOrder.setPurchaseNo(this.orderMainApi.generateOrderNo());
        mallParentOrder.setStatus(BatchOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        mallParentOrder.setSupplierName("");
        mallParentOrder.setOrderType(BATCH_ORDER_TYPE);
        MallParentOrderDto mallParentOrderDto = null;
        try {
            mallParentOrderDto = this.mallParentOrderApi.saveMallParentOrder(mallParentOrder);
            List mallAttachmentVos = mallOrderSubmitVo.getMallAttachments();
            MallParentOrderDto finalMallParentOrderDto = mallParentOrderDto;
            mallAttachmentVos.parallelStream().forEach(mallAttachmentVo -> {
                mallAttachmentVo.setAttachmentCorrelation(finalMallParentOrderDto.getParentOrderNo());
                mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.MALL_BATCH_ORDER_ATTACHMENT.getValue());
                mallAttachmentVo.setBusinessDescription(MallAttachmentBusinessCode.MALL_BATCH_ORDER_ATTACHMENT.getDescription());
                mallAttachmentVo.setOrganizationCode(ORGANIZATIONCODE);
            });
            if (!Lang.isEmpty((Object)mallAttachmentVos)) {
                List mallAttachmentDtos = BeanMapper.mapList((Iterable)mallAttachmentVos, MallAttachmentVo.class, MallAttachmentDto.class);
                this.mallAttachmentApi.batchSave(mallAttachmentDtos);
            }
        }
        catch (Exception e) {
            log.info("*****************\u7cfb\u7edf\u5f02\u5e38\uff0c\u7236\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25*****************8");
            return new BaseResponse(false, "\u7236\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        }
        return new BaseResponse(true, "\u7236\u8ba2\u5355\u4fdd\u5b58\u6210\u529f", (Object)mallParentOrderDto);
    }

    private MallParentOrderDto supplyParentOrderData(List<cart.api.dto.order.OrderMainDto> orderMainDtos, BigDecimal freight) {
        BigDecimal totalPriceOfAllOrders = BigDecimal.ZERO;
        BigDecimal totalFreight = BigDecimal.ZERO;
        cart.api.dto.order.OrderMainDto orderMainDto = null;
        MallParentOrderDto mallParentOrder = null;
        if (!Lang.isEmpty(orderMainDtos)) {
            totalPriceOfAllOrders = orderMainDtos.stream().map(cart.api.dto.order.OrderMainDto::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalFreight = orderMainDtos.stream().map(cart.api.dto.order.OrderMainDto::getFreight).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderMainDto = orderMainDtos.get(0);
            MallParentOrderDto mallParentOrderDto = this.mallParentOrderQueryApi.findParentOrderById(orderMainDto.getParentOrderId());
            mallParentOrderDto.setTotalMoney(totalPriceOfAllOrders);
            mallParentOrderDto.setFreight(totalFreight);
            if (!Lang.isEmpty((Object)freight)) {
                mallParentOrderDto.setGoodsPrice(totalPriceOfAllOrders.subtract(freight));
            } else {
                mallParentOrderDto.setGoodsPrice(totalPriceOfAllOrders);
            }
            mallParentOrder = this.mallParentOrderApi.saveMallParentOrder(mallParentOrderDto);
        }
        return mallParentOrder;
    }

    public UserInformationVo getOperateInformation(String memberId) {
        UserInformationVo informationVo = new UserInformationVo();
        Map queryUser = this.queryInformationApi.queryUser(memberId);
        List companyPositions = (List)queryUser.get("companyPositions");
        StringBuilder companyName = new StringBuilder();
        companyPositions.forEach(companyPosition -> {
            String positionCode = (String)companyPosition.get("positionCode");
            List companyNameList = (List)companyPosition.get("companyNames");
            companyNameList.forEach(name -> companyName.append((String)name));
        });
        informationVo.setMember((MemberDto)queryUser.get("member"));
        informationVo.setUser((CoreUserDto)queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }

    private BaseResponse batchCreateInvoices(List<cart.api.dto.order.OrderMainDto> orderMainDtos, MallOrderSubmitVo mallOrderSubmitVo, MemberDto memberDto) {
        Long invoiceStart = System.currentTimeMillis();
        BaseResponse baseResponse = new BaseResponse();
        ArrayList orderInvoiceDtos = new ArrayList();
        orderMainDtos.forEach(n -> {
            OrderInvoiceDto orderInvoiceDto = new OrderInvoiceDto();
            OrderSubmitVo orderSubmitVo = new OrderSubmitVo();
            orderSubmitVo.setInvoiceInfos(new ArrayList());
            orderSubmitVo.setAddressId(n.getAddressId());
            orderSubmitVo.setNeedBills(Boolean.valueOf(true));
            orderSubmitVo.setOrderUsageCode(mallOrderSubmitVo.getOrderUse());
            orderSubmitVo.setPayMethodCode(mallOrderSubmitVo.getPayType());
            List tempInvoiceVos = n.getTempInvoiceVoList();
            Boolean hasShippingFee = false;
            BigDecimal freight = n.getFreight();
            BigDecimal evenShippingFee = BigDecimal.ZERO;
            if (freight.compareTo(BigDecimal.ZERO) > 0) {
                hasShippingFee = true;
                evenShippingFee = freight.divide(new BigDecimal(tempInvoiceVos.size()), 2, 4);
            }
            ArrayList<InvoiceInfoVo> invoiceInfoVos = new ArrayList<InvoiceInfoVo>();
            for (int i = 0; i < tempInvoiceVos.size(); ++i) {
                TempInvoiceVo tempInvoiceVo = (TempInvoiceVo)tempInvoiceVos.get(i);
                ArrayList<InvoiceItemInfoVo> invoiceInfoItems = new ArrayList<InvoiceItemInfoVo>();
                InvoiceInfoVo invoiceInfoVo = new InvoiceInfoVo();
                String invocieType = tempInvoiceVo.getInvoiceType();
                invoiceInfoVo.setInvoiceType(invocieType);
                if (invocieType.equals("007")) {
                    String invoiceName = tempInvoiceVo.getInvoiceName();
                    String identificationCode = tempInvoiceVo.getInvoiceCode();
                    if (!Lang.isEmpty((Object)invoiceName) || !Lang.isEmpty((Object)identificationCode)) {
                        invoiceInfoVo.setName(invoiceName);
                        invoiceInfoVo.setIdentificationCode(identificationCode);
                    }
                }
                invoiceInfoVo.setCoreConpanyId(tempInvoiceVo.getCompanyId());
                List tempInvoiceItemVos = tempInvoiceVo.getTempInvoiceItemVos();
                for (TempInvoiceItemVo tempInvoiceItemVo : tempInvoiceItemVos) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setCount(Integer.valueOf(tempInvoiceItemVo.getCount()));
                    invoiceItemInfoVo.setFreigh(Lang.isEmpty((Object)tempInvoiceItemVo.getFreigh()) ? false : tempInvoiceItemVo.getFreigh());
                    invoiceItemInfoVo.setGoodsId(tempInvoiceItemVo.getGoodsId());
                    invoiceItemInfoVo.setPrice(tempInvoiceItemVo.getSalePrice());
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                if (hasShippingFee.booleanValue()) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setGoodsId("shippingFee");
                    invoiceItemInfoVo.setPrice(evenShippingFee);
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                InvoiceReceiverVo receiverVo = new InvoiceReceiverVo();
                TempInvoiceAddrVo tempInvoiceAddrVo = tempInvoiceVo.getTempInvoiceAddrVo();
                if (tempInvoiceAddrVo.isSameAsAchiever()) {
                    receiverVo.setSameAsAchiever(Boolean.valueOf(true));
                } else {
                    receiverVo.setSameAsAchiever(Boolean.valueOf(false));
                }
                receiverVo.setAddress(tempInvoiceAddrVo.getAddress());
                receiverVo.setName(tempInvoiceAddrVo.getName());
                receiverVo.setPhone(tempInvoiceAddrVo.getPhone());
                receiverVo.setCityCode(tempInvoiceAddrVo.getCityCode());
                receiverVo.setProvinceCode(tempInvoiceAddrVo.getProvinceCode());
                invoiceInfoVo.setInvoiceItems(invoiceInfoItems);
                invoiceInfoVo.setInvoiceReceiver(receiverVo);
                invoiceInfoVos.add(invoiceInfoVo);
            }
            for (InvoiceItemInfoVo invoiceItemInfoVo : ((InvoiceInfoVo)invoiceInfoVos.get(invoiceInfoVos.size() - 1)).getInvoiceItems()) {
                if (!"shippingFee".equals(invoiceItemInfoVo.getGoodsId())) continue;
                invoiceItemInfoVo.setPrice(freight.subtract(evenShippingFee.multiply(new BigDecimal(invoiceInfoVos.size() - 1))));
            }
            orderSubmitVo.setInvoiceInfos(invoiceInfoVos);
            orderInvoiceDto.setMemberDto(memberDto);
            OrderMainDto memberOrderMainDto = (OrderMainDto)BeanMapper.map((Object)n, OrderMainDto.class);
            orderInvoiceDto.setOrderMainDto(memberOrderMainDto);
            orderInvoiceDto.setOrderSubmitVo(orderSubmitVo);
            orderInvoiceDtos.add(orderInvoiceDto);
        });
        baseResponse = this.memberInvoinceApi.createOrderInvoices(orderInvoiceDtos);
        log.info("\u751f\u6210\u53d1\u7968\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - invoiceStart));
        if (baseResponse.isSuccess()) {
            log.info("\u751f\u6210\u53d1\u7968\u6210\u529f");
        } else {
            log.info("\u751f\u6210\u53d1\u7968\u5931\u8d25");
        }
        return baseResponse;
    }

    private Map<String, String> submitOrderCheckGoods(String memberId, List<TempMallOrderVo> mallOrderList) {
        List mallTempOrders = this.mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        HashMap<String, String> checkResultMap = new HashMap<String, String>();
        mallOrderList.parallelStream().forEach(mallTempOrder -> {
            FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
            MemberAddressDto addressDto = this.memberAddressApi.findDtoByIdAndIsDelete(mallTempOrder.getMemberAddrId(), false);
            requetVo.setProvinceCode(addressDto.getProvinceCode());
            requetVo.setCityCode(addressDto.getCityCode());
            requetVo.setCountyCode(addressDto.getAreaCode());
            requetVo.setTownCode(addressDto.getTownCode());
            ArrayList<FashionNumsVo> fashionNums = new ArrayList<FashionNumsVo>();
            FashionNumsVo fashionNumsVo = new FashionNumsVo(mallTempOrder.getProductFashionId(), mallTempOrder.getSku(), new Long(mallTempOrder.getCount().intValue()));
            fashionNums.add(fashionNumsVo);
            requetVo.setFashionNums(fashionNums);
            StoreDto store = new StoreDto();
            store.setId(mallTempOrder.getStoreId());
            HandlerRespVo fashionStockState = this.outsideProductApi.getFashionStockState(store, requetVo);
            if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                log.info("\u8c03\u7528\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)fashionStockState.getMessage());
            } else {
                List data = (List)fashionStockState.getData();
                if (Lang.isEmpty((Object)data)) {
                    checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_NOT.getDescription());
                } else {
                    for (FashionStockStateVo stockStateVo : data) {
                        if (!stockStateVo.getOnSale().booleanValue() && "1".equals(stockStateVo.getNotsaleReason())) {
                            checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_UNDER.getDescription());
                            break;
                        }
                        if (0 != stockStateVo.getStockFlag()) continue;
                        checkResultMap.put(mallTempOrder.getSku(), GoodsStockStatus.STOCK_STATUS_IS_LESS.getDescription());
                        break;
                    }
                }
            }
        });
        return checkResultMap;
    }

    private List<TempMallOrderVo> dealMallTempOrderData(String memberId) {
        List mallTempOrders = this.mallTempOrderQueryApi.findAllMallTempOrder(memberId);
        Vector<TempMallOrderVo> tempMallOrders = new Vector<TempMallOrderVo>();
        mallTempOrders.parallelStream().forEach(mallTempOrder -> mallTempOrder.getMallTempGoods().forEach(tempGoods -> {
            TempMallOrderVo orderVo = new TempMallOrderVo();
            orderVo.setSku(tempGoods.getSku());
            orderVo.setCount(tempGoods.getNum());
            orderVo.setMemberAddrId(mallTempOrder.getMemberAddressId());
            orderVo.setStoreId(tempGoods.getStoreId());
            orderVo.setProductFashionId(tempGoods.getProductFashionId());
            orderVo.setGoodsId(tempGoods.getGoodsId());
            MemberAddressDto memberAddressDto = this.memberAddressApi.findByIdAndIsDelete(mallTempOrder.getMemberAddressId(), false);
            orderVo.setProvinceCode(memberAddressDto.getProvinceCode());
            orderVo.setCityCode(memberAddressDto.getCityCode());
            orderVo.setTownCode(memberAddressDto.getTownCode());
            orderVo.setAreaCode(memberAddressDto.getAreaCode());
            orderVo.setAddressDetail(memberAddressDto.getAddressDetail());
            orderVo.setPhone(memberAddressDto.getPhone());
            orderVo.setUsername(memberAddressDto.getUsername());
            MemberInVoiceVo inVoiceVO = new MemberInVoiceVo();
            inVoiceVO.setType(mallTempOrder.getInvoiceType());
            if (CONSIGNEE_FLAG_NOT.equals(mallTempOrder.getConsigneeFlag())) {
                inVoiceVO.setSameAsAchiever(true);
                MemberAddressDto invoiceAddress = this.memberAddressApi.findByAddressNoAndIsDelete(mallTempOrder.getInvoiceAddressNo(), memberId);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(invoiceAddress.getProvinceName()).append(invoiceAddress.getCityName() == null ? "" : invoiceAddress.getCityName()).append(invoiceAddress.getAreaName() == null ? "" : invoiceAddress.getAreaName()).append(invoiceAddress.getTownName() == null ? "" : invoiceAddress.getTownName()).append(invoiceAddress.getAddressDetail());
                inVoiceVO.setAddressDetail(stringBuffer.toString());
                inVoiceVO.setConsigneeName(invoiceAddress.getUsername());
                inVoiceVO.setConsigneeCityCode(invoiceAddress.getCityCode());
                inVoiceVO.setConsigneeProvinceCode(invoiceAddress.getProvinceCode());
                inVoiceVO.setInvoiceAddressNo(invoiceAddress.getAddressNo());
                inVoiceVO.setConsigneePhone(invoiceAddress.getPhone());
            } else if (CONSIGNEE_FLAG_TRUE.equals(mallTempOrder.getConsigneeFlag())) {
                inVoiceVO.setSameAsAchiever(true);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(memberAddressDto.getProvinceName() == null ? "" : memberAddressDto.getProvinceName()).append(memberAddressDto.getCityName() == null ? "" : memberAddressDto.getCityName()).append(memberAddressDto.getAreaName() == null ? "" : memberAddressDto.getAreaName()).append(memberAddressDto.getTownName() == null ? "" : memberAddressDto.getTownName()).append(memberAddressDto.getAddressDetail());
                inVoiceVO.setAddressDetail(stringBuffer.toString());
                inVoiceVO.setConsigneeName(memberAddressDto.getUsername());
                inVoiceVO.setConsigneeCityCode(memberAddressDto.getCityCode());
                inVoiceVO.setConsigneeProvinceCode(memberAddressDto.getProvinceCode());
                inVoiceVO.setConsigneePhone(memberAddressDto.getPhone());
                inVoiceVO.setInvoiceAddressNo(memberAddressDto.getAddressNo());
            } else if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrder.getConsigneeFlag())) {
                inVoiceVO.setSameAsAchiever(false);
                inVoiceVO.setAddressDetail(mallTempOrder.getAddressDetail());
                inVoiceVO.setConsigneeName(mallTempOrder.getConsigneeName());
                inVoiceVO.setConsigneeCityCode(mallTempOrder.getConsigneeCityCode());
                inVoiceVO.setConsigneeProvinceCode(mallTempOrder.getConsigneeProvinceCode());
                inVoiceVO.setConsigneePhone(mallTempOrder.getConsigneePhone());
            }
            if ("004".equals(mallTempOrder.getInvoiceType())) {
                inVoiceVO.setCompanyId(mallTempOrder.getCompanyId());
            } else if ("007".equals(mallTempOrder.getInvoiceType())) {
                inVoiceVO.setInvoiceName(mallTempOrder.getInvoiceTitle());
                inVoiceVO.setInvoiceCode(mallTempOrder.getTaxIdentification());
            }
            orderVo.setMemberInVoiceVo(inVoiceVO);
            tempMallOrders.add(orderVo);
        }));
        return tempMallOrders;
    }

    private List<TempBatchPurchaseOrderVo> dealMallBatchPurchaseData(List<TempMallOrderVo> mallTempOrderVos) {
        ArrayList<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = new ArrayList<TempBatchPurchaseOrderVo>();
        for (TempMallOrderVo tempMallOrderVo : mallTempOrderVos) {
            MemberInvoiceItemVo memberInvoiceItemVo = new MemberInvoiceItemVo();
            memberInvoiceItemVo.setSku(tempMallOrderVo.getSku());
            memberInvoiceItemVo.setCount(tempMallOrderVo.getCount().intValue());
            memberInvoiceItemVo.setGoodsId(tempMallOrderVo.getGoodsId());
            ArrayList<MemberInvoiceItemVo> memberInvoiceItemVoList = new ArrayList<MemberInvoiceItemVo>();
            memberInvoiceItemVoList.add(memberInvoiceItemVo);
            tempMallOrderVo.getMemberInVoiceVo().setMemberInvoiceItemVos(memberInvoiceItemVoList);
        }
        while (mallTempOrderVos.size() > 0) {
            ArrayList<FashionDetailVo> fashionDetailVoList = new ArrayList<FashionDetailVo>();
            ArrayList tempDetailVoList = new ArrayList();
            TempMallOrderVo orderVoA = mallTempOrderVos.get(0);
            FashionDetailVo fashionDetailVoA = new FashionDetailVo();
            fashionDetailVoA.setCount(orderVoA.getCount());
            fashionDetailVoA.setGoodsId(orderVoA.getGoodsId());
            fashionDetailVoA.setProductFashionId(orderVoA.getProductFashionId());
            fashionDetailVoList.add(fashionDetailVoA);
            String memberAddrId = orderVoA.getMemberAddrId();
            String areaCode = orderVoA.getMemberAddrId();
            MemberInVoiceVo memberInVoiceA = orderVoA.getMemberInVoiceVo();
            ArrayList<MemberInVoiceVo> toBeHandledIvoiceVos = new ArrayList<MemberInVoiceVo>();
            toBeHandledIvoiceVos.add(memberInVoiceA);
            ArrayList<TempMallOrderVo> doneTempMallOrderVos = new ArrayList<TempMallOrderVo>();
            doneTempMallOrderVos.add(orderVoA);
            for (int i = 1; i <= mallTempOrderVos.size() - 1; ++i) {
                TempMallOrderVo orderVoB = mallTempOrderVos.get(i);
                if (!StringUtils.equals((CharSequence)orderVoA.getUsername(), (CharSequence)orderVoB.getUsername()) || !StringUtils.equals((CharSequence)orderVoA.getProvinceCode(), (CharSequence)orderVoB.getProvinceCode()) || !StringUtils.equals((CharSequence)orderVoA.getCityCode(), (CharSequence)orderVoB.getCityCode()) || !StringUtils.equals((CharSequence)orderVoA.getTownCode(), (CharSequence)orderVoB.getTownCode()) || !StringUtils.equals((CharSequence)orderVoA.getAreaCode(), (CharSequence)orderVoB.getAreaCode()) || !StringUtils.equals((CharSequence)orderVoA.getAddressDetail(), (CharSequence)orderVoB.getAddressDetail()) || !StringUtils.equals((CharSequence)orderVoA.getPhone(), (CharSequence)orderVoB.getPhone()) || !StringUtils.equals((CharSequence)orderVoA.getStoreId(), (CharSequence)orderVoB.getStoreId())) continue;
                Optional<FashionDetailVo> detailVoOptional = fashionDetailVoList.stream().filter(fashionDetailVo -> StringUtils.equals((CharSequence)fashionDetailVo.getGoodsId(), (CharSequence)orderVoB.getGoodsId())).findFirst();
                FashionDetailVo detailVo = null;
                if (detailVoOptional.isPresent()) {
                    detailVo = detailVoOptional.get();
                }
                if (!Lang.isEmpty(detailVo)) {
                    detailVo.setCount(Integer.valueOf(detailVo.getCount() + orderVoB.getCount()));
                } else {
                    FashionDetailVo fashionDetailVoB = new FashionDetailVo();
                    fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
                    fashionDetailVoB.setCount(orderVoB.getCount());
                    fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
                    fashionDetailVoList.add(fashionDetailVoB);
                }
                doneTempMallOrderVos.add(orderVoB);
                toBeHandledIvoiceVos.add(orderVoB.getMemberInVoiceVo());
            }
            mallTempOrderVos.removeAll(doneTempMallOrderVos);
            ArrayList<TempInvoiceVo> tempInvoiceVoList = new ArrayList<TempInvoiceVo>();
            ArrayList<MemberInVoiceVo> doneComparedInvoiceVos = new ArrayList<MemberInVoiceVo>();
            while (toBeHandledIvoiceVos.size() > 0) {
                MemberInVoiceVo inVoiceVOA = (MemberInVoiceVo)toBeHandledIvoiceVos.get(0);
                TempInvoiceVo tempInvoiceVoA = this.dealMemberInvoice(inVoiceVOA);
                List memberInvoiceItemVos = inVoiceVOA.getMemberInvoiceItemVos();
                doneComparedInvoiceVos.add(inVoiceVOA);
                for (int j = 1; j <= toBeHandledIvoiceVos.size() - 1; ++j) {
                    MemberInVoiceVo inVoiceVOB = (MemberInVoiceVo)toBeHandledIvoiceVos.get(j);
                    if (!StringUtils.equals((CharSequence)inVoiceVOA.getType(), (CharSequence)inVoiceVOB.getType()) || !StringUtils.equals((CharSequence)inVoiceVOA.getInvoiceCode(), (CharSequence)inVoiceVOB.getInvoiceCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeName(), (CharSequence)inVoiceVOB.getConsigneeName()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneePhone(), (CharSequence)inVoiceVOB.getConsigneePhone()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeProvinceCode(), (CharSequence)inVoiceVOB.getConsigneeProvinceCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeCityCode(), (CharSequence)inVoiceVOB.getConsigneeCityCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getAddressDetail(), (CharSequence)inVoiceVOB.getAddressDetail()) || !StringUtils.equals((CharSequence)inVoiceVOA.getInvoiceName(), (CharSequence)inVoiceVOB.getInvoiceName()) || !StringUtils.equals((CharSequence)inVoiceVOA.getCompanyId(), (CharSequence)inVoiceVOB.getCompanyId())) continue;
                    memberInvoiceItemVos.addAll(inVoiceVOB.getMemberInvoiceItemVos());
                    doneComparedInvoiceVos.add(inVoiceVOB);
                }
                List tempInvoiceItemVos = BeanMapper.mapList((Iterable)memberInvoiceItemVos, MemberInvoiceItemVo.class, TempInvoiceItemVo.class);
                tempInvoiceVoA.setTempInvoiceItemVos(tempInvoiceItemVos);
                tempInvoiceVoList.add(tempInvoiceVoA);
                toBeHandledIvoiceVos.removeAll(doneComparedInvoiceVos);
            }
            TempBatchPurchaseOrderVo tempBatchPurchaseOrderVo = new TempBatchPurchaseOrderVo();
            tempBatchPurchaseOrderVo.setFashionDetailVoList(fashionDetailVoList);
            tempBatchPurchaseOrderVo.setTempInvoiceVoList(tempInvoiceVoList);
            tempBatchPurchaseOrderVo.setAreaCode(areaCode);
            tempBatchPurchaseOrderVo.setOrganizationCode(ORGANIZATIONCODE);
            tempBatchPurchaseOrderVo.setMemberAddrId(memberAddrId);
            tempBatchPurchaseOrderVos.add(tempBatchPurchaseOrderVo);
        }
        return tempBatchPurchaseOrderVos;
    }

    private TempInvoiceVo dealMemberInvoice(MemberInVoiceVo inVoiceVOA) {
        TempInvoiceVo tempInvoiceVo = new TempInvoiceVo();
        tempInvoiceVo.setInvoiceName(inVoiceVOA.getInvoiceName());
        tempInvoiceVo.setInvoiceCode(inVoiceVOA.getInvoiceCode());
        tempInvoiceVo.setInvoiceType(inVoiceVOA.getType());
        tempInvoiceVo.setCompanyId(inVoiceVOA.getCompanyId());
        TempInvoiceAddrVo tempInvoiceAddrVo = new TempInvoiceAddrVo();
        tempInvoiceAddrVo.setProvinceCode(inVoiceVOA.getConsigneeProvinceCode());
        tempInvoiceAddrVo.setCityCode(inVoiceVOA.getConsigneeCityCode());
        tempInvoiceAddrVo.setName(inVoiceVOA.getConsigneeName());
        tempInvoiceAddrVo.setPhone(inVoiceVOA.getConsigneePhone());
        tempInvoiceAddrVo.setAddress(inVoiceVOA.getAddressDetail());
        tempInvoiceAddrVo.setSameAsAchiever(inVoiceVOA.isSameAsAchiever());
        tempInvoiceVo.setTempInvoiceAddrVo(tempInvoiceAddrVo);
        return tempInvoiceVo;
    }

    public BaseResponse batchImport(HttpServletRequest req) {
        String memberId = (String)req.getSession().getAttribute("member_id");
        log.info("memberId={}", (Object)memberId);
        long startImport = System.currentTimeMillis();
        MultipartHttpServletRequest mReq = (MultipartHttpServletRequest)req;
        MultipartFile file = mReq.getFile("file");
        String fileName = file.getOriginalFilename();
        int startRow = 2;
        if (Lang.isEmpty((Object)fileName)) {
            return new BaseResponse("\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\u540d");
        }
        ArrayList<ExcelImportDataVo> importDataVoList = new ArrayList<ExcelImportDataVo>();
        HashMap<String, ExcelImportDataVo> importMap = new HashMap<String, ExcelImportDataVo>();
        try {
            ExcelImportDataVo importDataVo;
            InputStream inputStream = file.getInputStream();
            List excelData = ReadExcel.readSingleExcel((InputStream)inputStream, (String)file.getOriginalFilename());
            Integer falseDataCount = 0;
            Integer successDataCount = 0;
            int size = excelData.size();
            int pageSize = 200;
            log.info("\u6279\u91cf\u5904\u7406{}\u6761\u6570\u636e", (Object)pageSize);
            for (int i = startRow; i < size; ++i) {
                importDataVo = new ExcelImportDataVo();
                List excelRow = (List)excelData.get(i);
                if (excelRow.size() < 10) continue;
                boolean emptyRow = true;
                for (int j = 1; j < 9; ++j) {
                    if (Lang.isEmpty(excelRow.get(j))) continue;
                    emptyRow = false;
                    break;
                }
                if (emptyRow || size <= 2) continue;
                importDataVo.setStoreName(excelRow.get(1).toString());
                importDataVo.setSku(excelRow.get(2).toString());
                importDataVo.setNum(Integer.valueOf(Integer.parseInt(excelRow.get(3).toString())));
                importDataVo.setMemberAddressCode(excelRow.get(4).toString());
                importDataVo.setInvoiceType(excelRow.get(5).toString());
                importDataVo.setInvoiceTitle(excelRow.get(6).toString());
                importDataVo.setTaxIdentification(excelRow.get(7).toString());
                importDataVo.setInvoiceAddressCode(excelRow.get(8).toString());
                importDataVo.setDataFlage(String.valueOf(i - 1));
                importMap.put(String.valueOf(i - 1), importDataVo);
                importDataVoList.add(importDataVo);
            }
            Integer importSize = importDataVoList.size();
            Integer integer = this.mallTempOrderQueryApi.countMallTempOrder(memberId);
            if (integer + importSize > 1000) {
                log.error("\u6700\u591a\u53ef\u6dfb\u52a01000\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u4e0a\u4f20\uff0c\u8bf7\u8fd4\u56de\u4fee\u6539");
                return new BaseResponse("\u6700\u591a\u53ef\u6dfb\u52a01000\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u4e0a\u4f20\uff0c\u8bf7\u8fd4\u56de\u4fee\u6539");
            }
            if (!Lang.isEmpty(importDataVoList)) {
                int importDataVoListSize = importDataVoList.size();
                ArrayList goodFutureList = new ArrayList();
                ArrayList memberAddressFutureList = new ArrayList();
                ArrayList validateTaxIdentificationRespFutureList = new ArrayList();
                ArrayList validateInvoiceAddressRespFutureList = new ArrayList();
                int pageIndex = 1;
                while ((double)pageIndex <= Math.ceil((double)importDataVoListSize / (double)pageSize)) {
                    int n = (pageIndex - 1) * pageSize;
                    int endIndex = pageSize * pageIndex;
                    endIndex = endIndex < importDataVoListSize ? endIndex : importDataVoListSize;
                    List list = importDataVoList.subList(n, endIndex);
                    ArrayList<ValidataGoods> validataGoodsList = new ArrayList<ValidataGoods>();
                    ArrayList<ValidataMemberAddress> validataMemberAddressList = new ArrayList<ValidataMemberAddress>();
                    ArrayList<ValidateTaxIdentification> validateTaxIdentificationList = new ArrayList<ValidateTaxIdentification>();
                    ArrayList<ValidateInvoiceAddress> validateInvoiceAddressList = new ArrayList<ValidateInvoiceAddress>();
                    for (ExcelImportDataVo excelImportDataVo : list) {
                        String dataFlage = excelImportDataVo.getDataFlage();
                        ValidataGoods validataGoods = new ValidataGoods();
                        ValidataMemberAddress validataMemberAddress = new ValidataMemberAddress();
                        ValidateTaxIdentification validateTaxIdentification = new ValidateTaxIdentification();
                        ValidateInvoiceAddress validateInvoiceAddress = new ValidateInvoiceAddress();
                        validataGoods.setStoreName(excelImportDataVo.getStoreName());
                        validataGoods.setSku(excelImportDataVo.getSku());
                        validataGoods.setDataFlag(dataFlage);
                        validataGoodsList.add(validataGoods);
                        validataMemberAddress.setMemberId(memberId);
                        validataMemberAddress.setDataFlag(dataFlage);
                        validataMemberAddress.setAddressNo(excelImportDataVo.getMemberAddressCode());
                        validataMemberAddressList.add(validataMemberAddress);
                        validateTaxIdentification.setTaxIdentification(excelImportDataVo.getTaxIdentification());
                        validateTaxIdentification.setDataFlag(dataFlage);
                        validateTaxIdentificationList.add(validateTaxIdentification);
                        validateInvoiceAddress.setMemberId(memberId);
                        validateInvoiceAddress.setDataFlag(dataFlage);
                        validateInvoiceAddress.setInvoiceAddressNo(excelImportDataVo.getInvoiceAddressCode());
                        validateInvoiceAddressList.add(validateInvoiceAddress);
                    }
                    Future goodsFuture = this.orderValidatePool.submit(new /* Unavailable Anonymous Inner Class!! */);
                    goodFutureList.add(goodsFuture);
                    Future memberAddressFuture = this.orderValidatePool.submit(new /* Unavailable Anonymous Inner Class!! */);
                    memberAddressFutureList.add(memberAddressFuture);
                    Future taxIdentificationFuture = this.orderValidatePool.submit(new /* Unavailable Anonymous Inner Class!! */);
                    validateTaxIdentificationRespFutureList.add(taxIdentificationFuture);
                    Future invoiceAddressFuture = this.orderValidatePool.submit(new /* Unavailable Anonymous Inner Class!! */);
                    validateInvoiceAddressRespFutureList.add(invoiceAddressFuture);
                    if (endIndex == importDataVoListSize) break;
                    ++pageIndex;
                }
                for (Future future : goodFutureList) {
                    Map validataGoodsRespMap = (Map)future.get();
                    for (String key : validataGoodsRespMap.keySet()) {
                        ValidataGoodsResp validataGoodsResp = (ValidataGoodsResp)validataGoodsRespMap.get(key);
                        importDataVo = (ExcelImportDataVo)importMap.get(key);
                        if (!"0".equals(validataGoodsResp.getResult())) continue;
                        if (!Lang.isEmpty((Object)importDataVo.getSku()) && !Lang.isEmpty((Object)importDataVo.getStoreName())) {
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff0c").append(importDataVo.getImportResult()).toString());
                                continue;
                            }
                            importDataVo.setImportResult("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff0c");
                            continue;
                        }
                        if (Lang.isEmpty((Object)importDataVo.getSku())) {
                            if (!Lang.isEmpty((Object)importDataVo.getStoreName())) {
                                if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                    importDataVo.setImportResult(new StringBuffer("\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                    continue;
                                }
                                importDataVo.setImportResult("\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff0c");
                                continue;
                            }
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u5e97\u94fa\u672a\u586b\u5199\uff0c\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                continue;
                            }
                            importDataVo.setImportResult("\u5e97\u94fa\u672a\u586b\u5199\uff0c\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff0c");
                            continue;
                        }
                        if (!Lang.isEmpty((Object)importDataVo.getStoreName())) continue;
                        if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                            importDataVo.setImportResult(new StringBuffer("\u5e97\u94fa\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                            continue;
                        }
                        importDataVo.setImportResult("\u5e97\u94fa\u672a\u586b\u5199\uff0c");
                    }
                }
                for (Future future : memberAddressFutureList) {
                    Map validataMemberAddressRespMap = (Map)future.get();
                    for (String key : validataMemberAddressRespMap.keySet()) {
                        ValidataMemberAddressResp validataMemberAddressResp = (ValidataMemberAddressResp)validataMemberAddressRespMap.get(key);
                        importDataVo = (ExcelImportDataVo)importMap.get(key);
                        if ("0".equals(validataMemberAddressResp.getResult())) {
                            if (!Lang.isEmpty((Object)importDataVo.getMemberAddressCode())) {
                                if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                    importDataVo.setImportResult(new StringBuffer("\u6536\u8d27\u5730\u5740\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c").append(importDataVo.getImportResult()).toString());
                                    continue;
                                }
                                importDataVo.setImportResult("\u6536\u8d27\u5730\u5740\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c");
                                continue;
                            }
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u6536\u8d27\u5730\u5740\u7f16\u53f7\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                continue;
                            }
                            importDataVo.setImportResult("\u6536\u8d27\u5730\u5740\u7f16\u53f7\u672a\u586b\u5199\uff0c");
                            continue;
                        }
                        importDataVo.setMemberAddressId(validataMemberAddressResp.getMemberAddressId());
                        importDataVo.setMemberAddress(validataMemberAddressResp.getMemberAddress());
                        importDataVo.setMemberProviceCode(validataMemberAddressResp.getMemberProviceCode());
                        importDataVo.setMemberCityCode(validataMemberAddressResp.getMemberCityCode());
                        importDataVo.setMemberCountryCode(validataMemberAddressResp.getMemberCountryCode());
                        importDataVo.setMemberTownCode(validataMemberAddressResp.getMemberTownCode());
                    }
                }
                for (Future future : validateTaxIdentificationRespFutureList) {
                    Map validateTaxIdentificationRespMap = (Map)future.get();
                    for (String key : validateTaxIdentificationRespMap.keySet()) {
                        ValidateTaxIdentificationResp validateTaxIdentificationResp = (ValidateTaxIdentificationResp)validateTaxIdentificationRespMap.get(key);
                        importDataVo = (ExcelImportDataVo)importMap.get(key);
                        if ("0".equals(validateTaxIdentificationResp.getResult())) {
                            if (!Lang.isEmpty((Object)importDataVo.getTaxIdentification())) {
                                if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                    importDataVo.setImportResult(new StringBuffer("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728\uff0c").append(importDataVo.getImportResult()).toString());
                                    continue;
                                }
                                importDataVo.setImportResult("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728\uff0c");
                                continue;
                            }
                            if (!"004".equals(validateTaxIdentificationResp.getInvoiceType())) continue;
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                continue;
                            }
                            importDataVo.setImportResult("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u586b\u5199\uff0c");
                            continue;
                        }
                        importDataVo.setCompanyId(validateTaxIdentificationResp.getCoreCompanyId());
                    }
                }
                for (Future future : validateInvoiceAddressRespFutureList) {
                    Map validateInvoiceAddressRespMap = (Map)future.get();
                    for (String key : validateInvoiceAddressRespMap.keySet()) {
                        ValidateInvoiceAddressResp validateInvoiceAddressResp = (ValidateInvoiceAddressResp)validateInvoiceAddressRespMap.get(key);
                        importDataVo = (ExcelImportDataVo)importMap.get(key);
                        if ("0".equals(validateInvoiceAddressResp.getResult())) {
                            if (!Lang.isEmpty((Object)importDataVo.getInvoiceAddressCode())) {
                                if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                    importDataVo.setImportResult(new StringBuffer("\u53d1\u7968\u5730\u5740\u7f16\u7801\u4e0d\u5b58\u5728\uff0c").append(importDataVo.getImportResult()).toString());
                                    continue;
                                }
                                importDataVo.setImportResult("\u53d1\u7968\u5730\u5740\u7f16\u7801\u4e0d\u5b58\u5728\uff0c");
                                continue;
                            }
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u53d1\u7968\u5730\u5740\u7f16\u7801\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                continue;
                            }
                            importDataVo.setImportResult("\u53d1\u7968\u5730\u5740\u7f16\u7801\u672a\u586b\u5199\uff0c");
                            continue;
                        }
                        importDataVo.setInvoiceAddressId(validateInvoiceAddressResp.getMemberAddressId());
                        importDataVo.setInvoiceAddress(validateInvoiceAddressResp.getInvoiceAddress());
                    }
                }
                for (int i = 0; i < importDataVoList.size(); ++i) {
                    Integer n;
                    importDataVo = (ExcelImportDataVo)importDataVoList.get(i);
                    if (Lang.isEmpty((Object)importDataVo.getNum())) {
                        if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                            importDataVo.setImportResult(new StringBuffer("\u5546\u54c1\u6570\u91cf\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                        } else {
                            importDataVo.setImportResult("\u5546\u54c1\u6570\u91cf\u672a\u586b\u5199\uff0c");
                        }
                    }
                    if (Lang.isEmpty((Object)importDataVo.getInvoiceType())) {
                        if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                            importDataVo.setImportResult(new StringBuffer("\u53d1\u7968\u7c7b\u578b\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                        } else {
                            importDataVo.setImportResult("\u53d1\u7968\u7c7b\u578b\u672a\u586b\u5199\uff0c");
                        }
                    } else {
                        if (VALUE_ADDED_TAX_NOMAL_INVOICE.equals(importDataVo.getInvoiceType()) && Lang.isEmpty((Object)importDataVo.getInvoiceTitle())) {
                            if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                importDataVo.setImportResult(new StringBuffer("\u53d1\u7968\u62ac\u5934\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                            } else {
                                importDataVo.setImportResult("\u53d1\u7968\u62ac\u5934\u672a\u586b\u5199\uff0c");
                            }
                        }
                        if (VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(importDataVo.getInvoiceType())) {
                            if (Lang.isEmpty((Object)importDataVo.getTaxIdentification())) {
                                if (!Lang.isEmpty((Object)importDataVo.getImportResult())) {
                                    importDataVo.setImportResult(new StringBuffer("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u586b\u5199\uff0c").append(importDataVo.getImportResult()).toString());
                                } else {
                                    importDataVo.setImportResult("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u586b\u5199\uff0c");
                                }
                            }
                            importDataVo.setInvoiceTitle("");
                        }
                    }
                    if (Lang.isEmpty((Object)importDataVo.getImportResult())) {
                        Integer n2 = successDataCount;
                        n = successDataCount = Integer.valueOf(successDataCount + 1);
                        importDataVo.setImportResult(IMPORT_SUCCESS);
                        continue;
                    }
                    Integer n2 = falseDataCount;
                    n = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    importDataVo.setImportResult(new StringBuffer("\u5bfc\u5165\u5931\u8d25\uff1a").append(importDataVo.getImportResult()).toString());
                    importDataVo.setImportResult(importDataVo.getImportResult().substring(0, importDataVo.getImportResult().length() - 1));
                }
            }
            UploadCountVo uploadCountVo = new UploadCountVo();
            uploadCountVo.setFalseDataCount(falseDataCount);
            uploadCountVo.setSuccessDataCount(successDataCount);
            long l = System.currentTimeMillis();
            BaseResponse baseResponse = this.uploadSave(importDataVoList, memberId);
            log.info("\u4fdd\u5b58\u8017\u65f6{}", (Object)(System.currentTimeMillis() - l));
            log.info("\u6211\u4fdd\u5b58\u5b8c\u4e0a\u4f20\u6570\u636e\u55bd-_-");
            log.info("\u6279\u91cf\u5bfc\u5165\u6570\u636e\u4e0a\u4f20\u5b8c\u6210{}", (Object)(System.currentTimeMillis() - startImport));
            if (baseResponse.isSuccess()) {
                req.getSession().setAttribute(UPLOAD_RESULT_DATA_SESSION, (Object)JSON.toJSONString(importDataVoList));
                log.info("\u6211\u5df2\u7ecf\u5c06\u5bfc\u5165\u7ed3\u679c\u5b58\u5165session\u4e86-_-:{}", (Object)JSON.toJSONString(importDataVoList));
                return new BaseResponse(true, "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", (Object)uploadCountVo);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25{}", (Throwable)e);
            return new BaseResponse("\u6587\u4ef6\u5bfc\u5165\u51fa\u9519");
        }
        return new BaseResponse("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
    }

    public BaseResponse uploadSave(List<ExcelImportDataVo> importDataVoList, String memberId) {
        MallTempOrderVo mallTempOrderVo = new MallTempOrderVo();
        try {
            if (!Lang.isEmpty(importDataVoList)) {
                for (ExcelImportDataVo excelImportData : importDataVoList) {
                    if (!IMPORT_SUCCESS.equals(excelImportData.getImportResult())) continue;
                    ArrayList<MallTempGoodsVo> tempGoodsVoList = new ArrayList<MallTempGoodsVo>();
                    MallTempGoodsVo tempGoodsVo = new MallTempGoodsVo();
                    GoodsConfigQuery goodsConfigQuery = new GoodsConfigQuery();
                    goodsConfigQuery.setSkus(Arrays.asList(excelImportData.getSku()));
                    goodsConfigQuery.setOrganizationCode(ORGANIZATIONCODE);
                    this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                    List goods = this.goodsConfigApi.findGoodsConfig(goodsConfigQuery);
                    List productFashionIds = this.productFashionApi.findProductFashionIdBySku(excelImportData.getSku());
                    if (!Lang.isEmpty((Object)goods) && !Lang.isEmpty((Object)productFashionIds)) {
                        tempGoodsVo.setStoreId(((GoodsConfigDto)goods.get(0)).getUserId());
                        tempGoodsVo.setGoodsId(((GoodsConfigDto)goods.get(0)).getGoodsId());
                        tempGoodsVo.setProductFashionId((String)productFashionIds.get(0));
                    }
                    tempGoodsVo.setSku(excelImportData.getSku());
                    tempGoodsVo.setNum(excelImportData.getNum());
                    tempGoodsVoList.add(tempGoodsVo);
                    mallTempOrderVo.setMallTempGoods(tempGoodsVoList);
                    mallTempOrderVo.setMemberAddressId(excelImportData.getMemberAddressId());
                    mallTempOrderVo.setInvoiceAddressId(excelImportData.getInvoiceAddressId());
                    mallTempOrderVo.setInvoiceAddress(excelImportData.getInvoiceAddress());
                    mallTempOrderVo.setMemberAddress(excelImportData.getMemberAddress());
                    if (VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(excelImportData.getInvoiceType())) {
                        mallTempOrderVo.setInvoiceType("004");
                    } else {
                        mallTempOrderVo.setInvoiceType("007");
                    }
                    mallTempOrderVo.setInvoiceTitle(excelImportData.getInvoiceTitle());
                    mallTempOrderVo.setTaxIdentification(excelImportData.getTaxIdentification());
                    mallTempOrderVo.setInvoiceAddressNo(excelImportData.getInvoiceAddressCode());
                    mallTempOrderVo.setMemberAddressNo(excelImportData.getMemberAddressCode());
                    mallTempOrderVo.setProvinceCode(excelImportData.getMemberProviceCode());
                    mallTempOrderVo.setCityCode(excelImportData.getMemberCityCode());
                    mallTempOrderVo.setCountryCode(excelImportData.getMemberCountryCode());
                    mallTempOrderVo.setTownCode(excelImportData.getMemberTownCode());
                    mallTempOrderVo.setMemberId(memberId);
                    mallTempOrderVo.setCompanyId(excelImportData.getCompanyId());
                    if (StringUtils.equals((CharSequence)excelImportData.getInvoiceAddressCode(), (CharSequence)excelImportData.getMemberAddressCode())) {
                        mallTempOrderVo.setConsigneeFlag(CONSIGNEE_FLAG_TRUE);
                    } else {
                        mallTempOrderVo.setConsigneeFlag(CONSIGNEE_FLAG_NOT);
                    }
                    this.saveTempOrder(mallTempOrderVo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e34\u65f6\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25{}", (Throwable)e);
            return new BaseResponse("\u4e34\u65f6\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        }
        return new BaseResponse(true, "\u4e34\u65f6\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u6210\u529f");
    }

    public void downLoadExcel(HttpServletRequest req, HttpServletResponse response, String parame) {
        String memberId = (String)req.getSession().getAttribute("member_id");
        log.info("memberId={}", (Object)memberId);
        try {
            Integer cell9;
            Integer cell8;
            CartDto userCart;
            List memberAddress;
            Object importResult;
            String fileName = "batchImportTemplete.xlsx";
            ClassPathResource resource = new ClassPathResource(fileName);
            InputStream inputStream = resource.getInputStream();
            Workbook workbook = ReadExcelUtil.getWorkbook((InputStream)inputStream, (String)fileName);
            log.info("=======================workbook={}", (Object)workbook);
            String headerValue = String.format("attachment; filename=\"%s\"", fileName);
            response.setHeader("Content-Disposition", headerValue);
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ArrayList<AttachmentAddressVo> attachmentAddressVos = new ArrayList<AttachmentAddressVo>();
            ArrayList<AttachmentGoodsVo> attachmentGoodsVos = new ArrayList<AttachmentGoodsVo>();
            ArrayList<AttachmentInvoiceVo> attachmentInvoiceVos = new ArrayList<AttachmentInvoiceVo>();
            List excelImportDataVos = new ArrayList();
            if (UPLOAD_RESULT_DATA_FLAG.equals(parame) && (importResult = req.getSession().getAttribute(UPLOAD_RESULT_DATA_SESSION)) != null) {
                excelImportDataVos = JSON.parseArray((String)importResult.toString(), ExcelImportDataVo.class);
                log.info("\u6211\u83b7\u53d6\u5230\u7f13\u5b58\u4e2d\u7684\u5bfc\u5165\u6570\u636e\u4e86-_-");
            }
            if (!Lang.isEmpty((Object)(memberAddress = this.memberAddressApi.findByMemberId(memberId)))) {
                for (MemberAddressDto address : memberAddress) {
                    AttachmentAddressVo attachmentAddressVo = (AttachmentAddressVo)BeanMapper.map((Object)address, AttachmentAddressVo.class);
                    if (Lang.isEmpty((Object)address.getProvinceName())) {
                        address.setProvinceName("");
                    }
                    if (Lang.isEmpty((Object)address.getCityName())) {
                        address.setCityName("");
                    }
                    if (Lang.isEmpty((Object)address.getAreaName())) {
                        address.setAreaName("");
                    }
                    if (Lang.isEmpty((Object)address.getTownName())) {
                        address.setTownName("");
                    }
                    attachmentAddressVo.setAddress(new StringBuffer().append(address.getProvinceName()).append(address.getCityName()).append(address.getAreaName()).append(address.getTownName()).toString());
                    if (!Lang.isEmpty((Object)address.getIsDefault())) {
                        if (address.getIsDefault().booleanValue()) {
                            attachmentAddressVo.setDefaultAddess(DEFAULT_ADDRESS_YES);
                        } else {
                            attachmentAddressVo.setDefaultAddess(DEFAULT_ADDRESS_NO);
                        }
                    } else {
                        attachmentAddressVo.setDefaultAddess("");
                    }
                    attachmentAddressVos.add(attachmentAddressVo);
                }
            }
            log.info("\u6211\u83b7\u53d6\u5230\u5730\u5740\u6e05\u5355\u4e86-_-");
            DecimalFormat df = new DecimalFormat("#.00");
            MemberDto memberDto = this.memberApi.findMemberById(memberId);
            if (!Lang.isEmpty((Object)memberDto.getCoreUser()) && !Lang.isEmpty((Object)(userCart = this.cartApi.getUserCart(memberDto.getCoreUser().getId())))) {
                long start = System.currentTimeMillis();
                for (CartItemDto cartItem : userCart.getCartItems()) {
                    AttachmentGoodsVo attachmentGoodsVo = new AttachmentGoodsVo();
                    long queryCartItem = System.currentTimeMillis();
                    MallBatchResponDto good = this.goodsApi.mallBatchGoodsQuery(cartItem.getGoodsId());
                    log.info("\u8c03\u7528goodsApi{}", (Object)(System.currentTimeMillis() - queryCartItem));
                    if (Lang.isEmpty((Object)good)) continue;
                    attachmentGoodsVo.setSku(good.getSku());
                    attachmentGoodsVo.setName(good.getName());
                    attachmentGoodsVo.setPrice(good.getSalePrice().toString());
                    attachmentGoodsVo.setNum(cartItem.getCount().toString());
                    long queryStore = System.currentTimeMillis();
                    StoreDto store = this.storeApi.findByStoreId(cartItem.getStoreId());
                    log.info("\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f{}", (Object)(System.currentTimeMillis() - queryStore));
                    attachmentGoodsVo.setStore(store.getStoreExt().getStoreName());
                    attachmentGoodsVo.setTotal(good.getSalePrice().multiply(new BigDecimal(df.format(cartItem.getCount().doubleValue()))).toString());
                    attachmentGoodsVos.add(attachmentGoodsVo);
                }
                long end = System.currentTimeMillis();
                log.info("\u67e5\u8be2\u5546\u54c1\u6e05\u5355\u6d88\u8017\u65f6\u95f4{}", (Object)(start - end));
            }
            log.info("\u6211\u83b7\u53d6\u5230\u5546\u54c1\u6e05\u5355\u4e86-_-");
            long coreCompanyTime = System.currentTimeMillis();
            CoreCompanyDto coreCompany = this.coreCompDepartUserApi.getBuyerCompany(memberDto.getCoreUser().getId());
            log.info("\u67e5\u8be2\u5f53\u524d\u673a\u6784\u8017\u65f6{}", (Object)(System.currentTimeMillis() - coreCompanyTime));
            ArrayList<CoreCompanyDto> userRelatedCompany = new ArrayList<CoreCompanyDto>();
            long time = System.currentTimeMillis();
            userRelatedCompany.add(coreCompany);
            this.getParentCompny(coreCompany, userRelatedCompany);
            log.info("\u67e5\u8be2\u4e0a\u7ea7\u673a\u6784\u8017\u65f6{}", (Object)(System.currentTimeMillis() - time));
            long time2 = System.currentTimeMillis();
            this.getChildCompany(coreCompany, userRelatedCompany);
            log.info("\u83b7\u53d6\u4e0b\u7ea7\u673a\u6784\u8017\u65f6{}", (Object)(System.currentTimeMillis() - time2));
            long time3 = System.currentTimeMillis();
            if (!Lang.isEmpty(userRelatedCompany)) {
                for (CoreCompanyDto userCompany : userRelatedCompany) {
                    AttachmentInvoiceVo attachmentInvoiceVo = new AttachmentInvoiceVo();
                    if ("004".equals(userCompany.getInvoiceType())) {
                        attachmentInvoiceVo.setInvoiceType(VALUE_ADDED_TAX_SPECIAL_INVOICE);
                    } else {
                        attachmentInvoiceVo.setInvoiceType(VALUE_ADDED_TAX_NOMAL_INVOICE);
                    }
                    attachmentInvoiceVo.setName(userCompany.getName());
                    attachmentInvoiceVo.setPhone(userCompany.getPhone());
                    attachmentInvoiceVo.setAddress(userCompany.getAddress());
                    attachmentInvoiceVo.setTaxpayerNum(userCompany.getTaxpayerNum());
                    attachmentInvoiceVo.setBankDeposit(userCompany.getBankDeposit());
                    attachmentInvoiceVo.setBankAccount(userCompany.getBankAccount());
                    attachmentInvoiceVos.add(attachmentInvoiceVo);
                }
            }
            log.info("\u5904\u7406\u5f00\u7968\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - time3));
            log.info("\u6211\u83b7\u53d6\u5230\u5f00\u7968\u4fe1\u606f\u4e86-_-");
            Sheet sheetFirst = workbook.getSheetAt(0);
            Integer initRowIndex = 2;
            Integer initIndex = 1;
            if (!Lang.isEmpty(excelImportDataVos)) {
                for (ExcelImportDataVo excelImportDataVo : excelImportDataVos) {
                    if (Lang.isEmpty((Object)excelImportDataVo)) continue;
                    sheetFirst.setDefaultColumnWidth(20);
                    CellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setBorderBottom((short)1);
                    cellStyle.setBorderLeft((short)1);
                    cellStyle.setBorderRight((short)1);
                    cellStyle.setBorderTop((short)1);
                    cellStyle.setAlignment((short)2);
                    Font font = workbook.createFont();
                    if (IMPORT_SUCCESS.equals(excelImportDataVo.getImportResult())) {
                        font.setColor((short)8);
                    } else {
                        font.setColor((short)10);
                    }
                    font.setFontHeightInPoints((short)12);
                    cellStyle.setFont(font);
                    Row row = sheetFirst.createRow(initRowIndex.intValue());
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue((double)initIndex.intValue());
                    if (IMPORT_SUCCESS.equals(excelImportDataVo.getImportResult())) {
                        cell0.setCellStyle(cellStyle);
                    } else {
                        CellStyle cellStyle1 = workbook.createCellStyle();
                        cellStyle1.setBorderBottom((short)1);
                        cellStyle1.setBorderLeft((short)1);
                        cellStyle1.setBorderRight((short)1);
                        cellStyle1.setBorderTop((short)1);
                        cellStyle1.setAlignment((short)2);
                        Font font1 = workbook.createFont();
                        font1.setColor((short)8);
                        font1.setFontHeightInPoints((short)12);
                        cellStyle1.setFont(font1);
                        cell0.setCellStyle(cellStyle1);
                    }
                    Cell cell1 = row.createCell(1);
                    cell1.setCellValue(excelImportDataVo.getStoreName());
                    cell1.setCellStyle(cellStyle);
                    Cell cell2 = row.createCell(2);
                    cell2.setCellValue(excelImportDataVo.getSku());
                    cell2.setCellStyle(cellStyle);
                    Cell cell3 = row.createCell(3);
                    if (Lang.isEmpty((Object)excelImportDataVo.getNum())) {
                        cell3.setCellValue("");
                    } else {
                        cell3.setCellValue((double)excelImportDataVo.getNum().intValue());
                    }
                    cell3.setCellStyle(cellStyle);
                    Cell cell4 = row.createCell(4);
                    cell4.setCellValue(excelImportDataVo.getMemberAddressCode());
                    cell4.setCellStyle(cellStyle);
                    Cell cell5 = row.createCell(5);
                    cell5.setCellValue(excelImportDataVo.getInvoiceType());
                    cell5.setCellStyle(cellStyle);
                    Cell cell6 = row.createCell(6);
                    cell6.setCellValue(excelImportDataVo.getInvoiceTitle());
                    cell6.setCellStyle(cellStyle);
                    Cell cell7 = row.createCell(7);
                    cell7.setCellValue(excelImportDataVo.getTaxIdentification());
                    cell7.setCellStyle(cellStyle);
                    cell8 = row.createCell(8);
                    cell8.setCellValue(excelImportDataVo.getInvoiceAddressCode());
                    cell8.setCellStyle(cellStyle);
                    cell9 = row.createCell(9);
                    cell9.setCellValue(excelImportDataVo.getImportResult());
                    cell9.setCellStyle(cellStyle);
                    Integer n = initRowIndex;
                    Integer n2 = initRowIndex = Integer.valueOf(initRowIndex + 1);
                    n = initIndex;
                    n2 = initIndex = Integer.valueOf(initIndex + 1);
                }
                log.info("\u6211\u5df2\u7ecf\u5b8c\u6210\u7b2c\u4e00\u4e2asheet\u7684\u521b\u5efa-_-");
            }
            Sheet sheetSecond = workbook.getSheetAt(1);
            Integer initRowIndexSecond = 2;
            if (!Lang.isEmpty(attachmentAddressVos)) {
                for (AttachmentAddressVo attachmentAddressVo : attachmentAddressVos) {
                    if (Lang.isEmpty((Object)attachmentAddressVo)) continue;
                    sheetSecond.setDefaultColumnWidth(20);
                    CellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setBorderBottom((short)1);
                    cellStyle.setBorderLeft((short)1);
                    cellStyle.setBorderRight((short)1);
                    cellStyle.setBorderTop((short)1);
                    cellStyle.setAlignment((short)2);
                    Font font = workbook.createFont();
                    font.setColor((short)8);
                    font.setFontHeightInPoints((short)12);
                    cellStyle.setFont(font);
                    Row row = sheetSecond.createRow(initRowIndexSecond.intValue());
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue(attachmentAddressVo.getAddressNo());
                    cell0.setCellStyle(cellStyle);
                    Cell cell1 = row.createCell(1);
                    cell1.setCellValue(attachmentAddressVo.getUsername());
                    cell1.setCellStyle(cellStyle);
                    Cell cell2 = row.createCell(2);
                    cell2.setCellValue(attachmentAddressVo.getAddress());
                    cell2.setCellStyle(cellStyle);
                    Cell cell3 = row.createCell(3);
                    cell3.setCellValue(attachmentAddressVo.getAddressDetail());
                    cell3.setCellStyle(cellStyle);
                    Cell cell4 = row.createCell(4);
                    cell4.setCellValue(attachmentAddressVo.getPhone());
                    cell4.setCellStyle(cellStyle);
                    Cell cell5 = row.createCell(5);
                    cell5.setCellValue(attachmentAddressVo.getDefaultAddess());
                    cell5.setCellStyle(cellStyle);
                    cell8 = initRowIndexSecond;
                    cell9 = initRowIndexSecond = Integer.valueOf(initRowIndexSecond + 1);
                }
                log.info("\u6211\u5df2\u7ecf\u5b8c\u6210\u7b2c\u4e8c\u4e2asheet\u7684\u521b\u5efa-_-");
            }
            Sheet sheetThird = workbook.getSheetAt(2);
            Integer initRowIndexThird = 2;
            Integer initIndexThird = 1;
            if (!Lang.isEmpty(attachmentGoodsVos)) {
                for (AttachmentGoodsVo attachmentGoodsVo : attachmentGoodsVos) {
                    if (Lang.isEmpty((Object)attachmentGoodsVo)) continue;
                    sheetThird.setDefaultColumnWidth(20);
                    CellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setBorderBottom((short)1);
                    cellStyle.setBorderLeft((short)1);
                    cellStyle.setBorderRight((short)1);
                    cellStyle.setBorderTop((short)1);
                    cellStyle.setAlignment((short)2);
                    Font font = workbook.createFont();
                    font.setColor((short)8);
                    font.setFontHeightInPoints((short)12);
                    cellStyle.setFont(font);
                    Row row = sheetThird.createRow(initRowIndexThird.intValue());
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue((double)initIndexThird.intValue());
                    cell0.setCellStyle(cellStyle);
                    Cell cell1 = row.createCell(1);
                    cell1.setCellValue(attachmentGoodsVo.getStore());
                    cell1.setCellStyle(cellStyle);
                    Cell cell2 = row.createCell(2);
                    cell2.setCellValue(attachmentGoodsVo.getSku());
                    cell2.setCellStyle(cellStyle);
                    Cell cell3 = row.createCell(3);
                    cell3.setCellValue(attachmentGoodsVo.getName());
                    cell3.setCellStyle(cellStyle);
                    Cell cell4 = row.createCell(4);
                    cell4.setCellValue(String.valueOf(attachmentGoodsVo.getPrice()));
                    cell4.setCellStyle(cellStyle);
                    Cell cell5 = row.createCell(5);
                    cell5.setCellValue(String.valueOf(attachmentGoodsVo.getNum()));
                    cell5.setCellStyle(cellStyle);
                    Cell cell6 = row.createCell(6);
                    cell6.setCellValue(String.valueOf(attachmentGoodsVo.getTotal()));
                    cell6.setCellStyle(cellStyle);
                    Integer n = initRowIndexThird;
                    Integer n3 = initRowIndexThird = Integer.valueOf(initRowIndexThird + 1);
                    n = initIndexThird;
                    n3 = initIndexThird = Integer.valueOf(initIndexThird + 1);
                }
                log.info("\u6211\u5df2\u7ecf\u5b8c\u6210\u7b2c\u4e09\u4e2asheet\u7684\u521b\u5efa-_-");
            }
            Sheet sheetFourth = workbook.getSheetAt(3);
            Integer initRowIndexFourth = 2;
            Integer initIndexFourth = 1;
            if (!Lang.isEmpty(attachmentInvoiceVos)) {
                for (AttachmentInvoiceVo attachmentInvoiceVo : attachmentInvoiceVos) {
                    if (Lang.isEmpty((Object)attachmentInvoiceVo)) continue;
                    sheetFourth.setDefaultColumnWidth(20);
                    CellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setBorderBottom((short)1);
                    cellStyle.setBorderLeft((short)1);
                    cellStyle.setBorderRight((short)1);
                    cellStyle.setBorderTop((short)1);
                    cellStyle.setAlignment((short)2);
                    Font font = workbook.createFont();
                    font.setColor((short)8);
                    font.setFontHeightInPoints((short)12);
                    cellStyle.setFont(font);
                    Row row = sheetFourth.createRow(initRowIndexFourth.intValue());
                    Cell cell0 = row.createCell(0);
                    cell0.setCellValue((double)initIndexFourth.intValue());
                    cell0.setCellStyle(cellStyle);
                    Cell cell1 = row.createCell(1);
                    cell1.setCellValue(attachmentInvoiceVo.getInvoiceType());
                    cell1.setCellStyle(cellStyle);
                    Cell cell2 = row.createCell(2);
                    cell2.setCellValue(attachmentInvoiceVo.getName());
                    cell2.setCellStyle(cellStyle);
                    Cell cell3 = row.createCell(3);
                    cell3.setCellValue(attachmentInvoiceVo.getTaxpayerNum());
                    cell3.setCellStyle(cellStyle);
                    Cell cell4 = row.createCell(4);
                    cell4.setCellValue(attachmentInvoiceVo.getAddress());
                    cell4.setCellStyle(cellStyle);
                    Cell cell5 = row.createCell(5);
                    cell5.setCellValue(attachmentInvoiceVo.getPhone());
                    cell5.setCellStyle(cellStyle);
                    Cell cell6 = row.createCell(6);
                    cell6.setCellValue(attachmentInvoiceVo.getBankDeposit());
                    cell6.setCellStyle(cellStyle);
                    Cell cell7 = row.createCell(7);
                    cell7.setCellValue(attachmentInvoiceVo.getBankAccount());
                    cell7.setCellStyle(cellStyle);
                    Integer n = initRowIndexFourth;
                    Integer n4 = initRowIndexFourth = Integer.valueOf(initRowIndexFourth + 1);
                    n = initIndexFourth;
                    n4 = initIndexFourth = Integer.valueOf(initIndexFourth + 1);
                }
                log.info("\u6211\u5df2\u7ecf\u5b8c\u6210\u7b2c\u56db\u4e2asheet\u7684\u521b\u5efa-_-");
            }
            workbook.write((OutputStream)out);
            out.close();
            log.info("\u6d41\u5df2\u5173\u95ed \u65b0\u9c9c\u7684\u8868\u683c\u51fa\u7089\u4e86-_-");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getParentCompny(CoreCompanyDto company, List<CoreCompanyDto> userRelatedCompany) {
        CoreCompanyDto companyParent = company.getParent();
        if (companyParent.getCompanyLevel() != CoreCompanyDto.COMPANY_LEVEL_ONE) {
            CoreCompanyDto companyInfo = this.coreCompanyApi.getCoreCompanyInfoById(companyParent.getId());
            userRelatedCompany.add(companyInfo);
            this.getParentCompny(companyParent, userRelatedCompany);
        }
    }

    private void getChildCompany(CoreCompanyDto company, List<CoreCompanyDto> userRelatedCompany) {
        List childCompany = this.coreCompanyApi.getChildByParentId(company.getId());
        if (childCompany == null) {
            log.debug("\u83b7\u53d6\u7236\u8282\u70b9" + company.getName() + "\u4e0b\u7684\u6240\u6709\u5b69\u5b50\u8282\u70b9:null");
            return;
        }
        for (CoreCompanyDto companyChild : childCompany) {
            CoreCompanyDto companyInfo = this.coreCompanyApi.getCoreCompanyInfoById(companyChild.getId());
            userRelatedCompany.add(companyInfo);
            this.getChildCompany(companyInfo, userRelatedCompany);
        }
    }

    public void changeMemberAddressNo() {
        this.handleAddressNoApi.handleAddressNo();
    }

    public TiaoXianCompanyVo getBatchOrderiaoXianCompany(TiaoXianRequestVo tianXianRequestVo) {
        return this.getTiaoXianCompany(tianXianRequestVo);
    }

    public TiaoXianCompanyVo getTiaoXianCompany(TiaoXianRequestVo tianXianRequestVo) {
        TiaoXianCompanyVo tiaoXianCompanyVo = new TiaoXianCompanyVo();
        CoreCompanyDto coreCompany = null;
        coreCompany = this.coreCompDepartUserApi.getCompanyByUserIdAndPositon(tianXianRequestVo.getUserId(), "JC_CGJBR");
        if (!Lang.isEmpty((Object)coreCompany)) {
            if (coreCompany.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_FOUR) {
                String isOpen;
                String parentCode = this.getParentCode(coreCompany);
                Boolean isIncludeCode = false;
                String excuArray = this.systemConfigApi.getConfigValue(ORGANIZATIONCODE, "WORKFLOWSTRIPEREXCU", "WORKFLOWSTRIPEREXCU", Boolean.valueOf(true), Boolean.valueOf(true));
                if (!Lang.isEmpty((Object)excuArray) && !Lang.isEmpty((Object)parentCode)) {
                    String[] includeArray;
                    for (String value : includeArray = excuArray.split(",")) {
                        if (!value.equals(parentCode)) continue;
                        isIncludeCode = true;
                        break;
                    }
                }
                if (!isIncludeCode.booleanValue() && !Lang.isEmpty((Object)(isOpen = this.systemConfigApi.getConfigValue(ORGANIZATIONCODE, "OPENCONFIGWORKFLOWSTRIPER", "OPENCONFIGWORKFLOWSTRIPER", Boolean.valueOf(true), Boolean.valueOf(true)))) && isOpen.equals("true")) {
                    WfWorkFlowRelationDto wfWorkFlowRelation;
                    List workFlowRelations = this.wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
                    WfWorkFlowDefinitionDto wfWorkFlowDefinition = null;
                    if (!Lang.isEmpty((Object)workFlowRelations) && !Lang.isEmpty((Object)(wfWorkFlowRelation = (WfWorkFlowRelationDto)workFlowRelations.get(0)))) {
                        wfWorkFlowDefinition = wfWorkFlowRelation.getWorkFlowDefinition();
                    }
                    String valus = this.systemConfigApi.getConfigValue(ORGANIZATIONCODE, "WORKFLOWSTRIPERMONEY", "WORKFLOWSTRIPERMONEY", Boolean.valueOf(true), Boolean.valueOf(true));
                    Double thirdTiaoxianMoney = 0.0;
                    String thirdTiaoxianUnit = "5\u4e07";
                    String thirdTiaoxianMoneyStr = "50000";
                    if (!Lang.isEmpty((Object)valus)) {
                        if (!Lang.isEmpty((Object)wfWorkFlowDefinition)) {
                            JSONArray jsonArray = JSON.parseArray((String)valus);
                            for (int i = 0; i < jsonArray.size(); ++i) {
                                JSONObject obj = jsonArray.getJSONObject(i);
                                String companyCode = obj.getString("companyCode");
                                if (!wfWorkFlowDefinition.getCompanyCode().equals(companyCode)) continue;
                                thirdTiaoxianMoneyStr = obj.getString("money");
                                thirdTiaoxianUnit = obj.getString("unit");
                            }
                        }
                        try {
                            thirdTiaoxianMoney = Double.parseDouble(thirdTiaoxianMoneyStr);
                        }
                        catch (Exception e) {
                            log.info("\u8c03\u7ebf\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                            e.printStackTrace();
                        }
                    }
                    BigDecimal totalMoney = tianXianRequestVo.getTotalMoney();
                    if (coreCompany != null) {
                        switch (coreCompany.getCompanyLevel()) {
                            case 4: {
                                this.handleThirdTiaoXian(tiaoXianCompanyVo, Double.valueOf(totalMoney.doubleValue()), coreCompany, thirdTiaoxianMoney, thirdTiaoxianUnit);
                            }
                        }
                    }
                }
            }
            List workFlowRelations = this.wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
            ArrayList<WfWorkFlowDefinitionDto> wfWorkFlowDefinitions = new ArrayList<WfWorkFlowDefinitionDto>();
            for (WfWorkFlowRelationDto wf_r : workFlowRelations) {
                if (wf_r.getWorkFlowDefinition().getIsDelete() != null && wf_r.getWorkFlowDefinition().getIsDelete().booleanValue()) continue;
                wfWorkFlowDefinitions.add(wf_r.getWorkFlowDefinition());
            }
            tiaoXianCompanyVo.setWfWorkFlowDefinitions(wfWorkFlowDefinitions);
        }
        return tiaoXianCompanyVo;
    }

    private String getParentCode(CoreCompanyDto coreCompany) {
        String parentId = coreCompany.getParent().getId();
        CoreCompanyDto coreCompanyP1 = this.coreCompanyApi.getParentCompany(parentId, CoreCompanyDto.COMPANY_LEVEL_TWO);
        return coreCompanyP1.getCode();
    }

    public void handleThirdTiaoXian(TiaoXianCompanyVo tiaoXianCompanyVo, Double sumCartPrice, CoreCompanyDto coreCompany, Double thirdTiaoxianMoney, String thirdTiaoxianUnit) {
        if (sumCartPrice > thirdTiaoxianMoney) {
            CoreCompanyDto coreCompanyParent = coreCompany.getParent();
            Integer departmentLevel = 1;
            List tiaoXianDepartment = this.coreDepartmentApi.findTiaoXianDepartment(coreCompanyParent.getId(), departmentLevel);
            tiaoXianCompanyVo.setIsTiaoXian(Boolean.valueOf(true));
            tiaoXianCompanyVo.setTianXianDepartmentDtos(tiaoXianDepartment);
            tiaoXianCompanyVo.setThirdTiaoxianMoney(new BigDecimal(thirdTiaoxianMoney));
        }
    }

    public List<TempOrderVo> getMallTempOrderData(String memberId) {
        List mallOrderList = this.dealMallTempOrderData(memberId);
        List tempBatchPurchaseOrderVos = this.dealMallBatchPurchaseData(mallOrderList);
        log.info("..........\u8ba2\u5355\u5408\u5e76\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tempBatchPurchaseOrderVos));
        BaseResponse baseResponse = this.orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        if (baseResponse.isSuccess()) {
            return (List)baseResponse.getResult();
        }
        return null;
    }

    public MemberVo findMemberVo(String memberId, String userId) {
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            log.info("memberId:{}", (Object)memberId);
            memberVo = this.memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            log.info("userId:{}", (Object)userId);
            memberVo = this.memberApi.getMemberInfoByUserId(userId);
        }
        return memberVo;
    }

    public byte[] Zip(List<ZipExportStructure> dataList) throws IOException {
        long time = Calendar.getInstance().getTimeInMillis();
        byte[] b = new byte[]{};
        if (dataList == null || dataList.size() <= 0) {
            return b;
        }
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        ZipOutputStream zipOS = new ZipOutputStream(ms);
        zipOS.setLevel(6);
        for (ZipExportStructure ob : dataList) {
            ZipEntry entry = new ZipEntry(ob.getFileName());
            byte[] filecontent = ob.getContent();
            entry.setTime(time);
            entry.setSize(filecontent.length);
            zipOS.putNextEntry(entry);
            zipOS.write(filecontent, 0, filecontent.length);
        }
        if (zipOS != null) {
            zipOS.finish();
            b = ms.toByteArray();
            zipOS.close();
            ms.close();
        }
        return b;
    }

    public MallTempOrderVo saveNewTempOrder(MallTempOrderVo mallTempOrderVo) {
        MemberAddressDto memberAddressDto = this.memberAddressApi.findDtoByIdAndIsDelete(mallTempOrderVo.getMemberAddressId(), false);
        StringBuffer memberBuffer = new StringBuffer();
        if (!Lang.isEmpty((Object)memberAddressDto)) {
            memberBuffer.append(memberAddressDto.getProvinceName()).append(memberAddressDto.getCityName() == null ? "" : memberAddressDto.getCityName()).append(memberAddressDto.getAreaName() == null ? "" : memberAddressDto.getAreaName()).append(memberAddressDto.getTownName() == null ? "" : memberAddressDto.getTownName()).append(memberAddressDto.getAddressDetail());
            mallTempOrderVo.setMemberAddress(memberBuffer.toString());
        }
        mallTempOrderVo.setProvinceCode(memberAddressDto.getProvinceCode() == null ? "" : memberAddressDto.getProvinceCode());
        mallTempOrderVo.setCityCode(memberAddressDto.getCityCode() == null ? "" : memberAddressDto.getCityCode());
        mallTempOrderVo.setTownCode(memberAddressDto.getTownCode() == null ? "" : memberAddressDto.getTownCode());
        mallTempOrderVo.setCountryCode(memberAddressDto.getCountryCode() == null ? "" : memberAddressDto.getCountryCode());
        if (CONSIGNEE_FLAG_FALSE.equals(mallTempOrderVo.getConsigneeFlag())) {
            String provinceName = this.addressApi.findShortNameById(mallTempOrderVo.getConsigneeProvinceCode());
            StringBuffer stringBuffer = new StringBuffer();
            if (!Lang.isEmpty((Object)mallTempOrderVo.getConsigneeCityCode())) {
                String cityName = this.addressApi.findShortNameById(mallTempOrderVo.getConsigneeCityCode());
                stringBuffer.append(provinceName).append(cityName).append(mallTempOrderVo.getAddressDetail());
            }
            mallTempOrderVo.setAddressDetail(stringBuffer.toString());
        } else if (CONSIGNEE_FLAG_TRUE.equals(mallTempOrderVo.getConsigneeFlag())) {
            mallTempOrderVo.setInvoiceAddress(mallTempOrderVo.getMemberAddress());
            mallTempOrderVo.setInvoiceAddressId(mallTempOrderVo.getMemberAddressId());
            mallTempOrderVo.setInvoiceAddressNo(mallTempOrderVo.getMemberAddressNo());
        }
        return mallTempOrderVo;
    }

    public void afterPropertiesSet() throws Exception {
        this.orderValidatePool = new ThreadPoolExecutor(5, 20, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        pool = new ThreadPoolExecutor(5, 20, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        occupyStockPool = new ThreadPoolExecutor(5, 20, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
        getFreightPool = new ThreadPoolExecutor(5, 20, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20000));
    }

    public void destroy() throws Exception {
        this.orderValidatePool.shutdown();
    }

    private /* synthetic */ Map lambda$submitMallOrder$5(cart.api.dto.order.OrderMainDto orderMainDto) throws Exception {
        Map returnMap = this.orderMainApi.occupyStock(orderMainDto);
        return returnMap;
    }

    static /* synthetic */ SystemLogApi access$000(MallBatchOrderServiceImpl x0) {
        return x0.systemLogApi;
    }

    static /* synthetic */ GoodsConfigApi access$100(MallBatchOrderServiceImpl x0) {
        return x0.goodsConfigApi;
    }

    static /* synthetic */ MemberAddressApi access$200(MallBatchOrderServiceImpl x0) {
        return x0.memberAddressApi;
    }

    static /* synthetic */ CoreCompanyApi access$300(MallBatchOrderServiceImpl x0) {
        return x0.coreCompanyApi;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }

    static /* synthetic */ OrderMainApi access$500(MallBatchOrderServiceImpl x0) {
        return x0.orderMainApi;
    }
}

