/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test;

import java.util.Date;
import junit.framework.TestCase;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.test.mock.ActivitiMockSupport;

public abstract class ActivitiTestCase
extends TestCase {
    protected String configurationResource = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    private ActivitiMockSupport mockSupport;

    public void assertProcessEnded(String processInstanceId) {
        TestHelper.assertProcessEnded(this.processEngine, processInstanceId);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.processEngine == null) {
            this.initializeProcessEngine();
            this.initializeServices();
            this.initializeMockSupport();
        }
    }

    protected void runTest() throws Throwable {
        TestHelper.annotationMockSupportSetup(((Object)((Object)this)).getClass(), this.getName(), this.mockSupport);
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
        super.runTest();
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
        TestHelper.annotationMockSupportTeardown(this.mockSupport);
    }

    protected void initializeProcessEngine() {
        this.processEngine = TestHelper.getProcessEngine(this.getConfigurationResource());
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historicDataService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
    }

    protected void initializeMockSupport() {
        if (ActivitiMockSupport.isMockSupportPossible(this.processEngine)) {
            this.mockSupport = new ActivitiMockSupport(this.processEngine);
        }
    }

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.getClock().reset();
        if (this.mockSupport != null) {
            this.mockSupport.reset();
        }
        super.tearDown();
    }

    public static void closeProcessEngines() {
        TestHelper.closeProcessEngines();
    }

    public void setCurrentTime(Date currentTime) {
        this.processEngineConfiguration.getClock().setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ActivitiMockSupport getMockSupport() {
        return this.mockSupport;
    }

    public ActivitiMockSupport mockSupport() {
        return this.mockSupport;
    }
}

