/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.DynamicBpmnService;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.test.AbstractTestCase;
import org.activiti.engine.impl.test.JobTestHelper;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.junit.Assert;

public abstract class AbstractActivitiTestCase
extends AbstractTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Collections.singletonList("ACT_GE_PROPERTY");
    protected ProcessEngine processEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;

    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.setAuthenticatedUserId(null);
    }

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
            this.validateHistoryData();
        }
        catch (AssertionFailedError e) {
            log.error("\n");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("\n");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId, true);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.processEngineConfiguration.getClock().reset();
            this.closeDownProcessEngine();
        }
    }

    protected void validateHistoryData() {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().finished().list();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                List historicActivityInstances;
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no process definition id", (Object)historicProcessInstance.getProcessDefinitionId());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no process definition key", (Object)historicProcessInstance.getProcessDefinitionKey());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no process definition version", (Object)historicProcessInstance.getProcessDefinitionVersion());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no process definition key", (Object)historicProcessInstance.getDeploymentId());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no start activiti id", (Object)historicProcessInstance.getStartActivityId());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
                AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
                String processInstanceId = historicProcessInstance.getId();
                List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                    for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                        AbstractActivitiTestCase.assertEquals((String)processInstanceId, (String)historicTaskInstance.getProcessInstanceId());
                        if (historicTaskInstance.getClaimTime() != null) {
                            AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no work time"), (Object)historicTaskInstance.getWorkTimeInMillis());
                        }
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no id"), (Object)historicTaskInstance.getId());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process instance id"), (Object)historicTaskInstance.getProcessInstanceId());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no execution id"), (Object)historicTaskInstance.getExecutionId());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process definition id"), (Object)historicTaskInstance.getProcessDefinitionId());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no task definition key"), (Object)historicTaskInstance.getTaskDefinitionKey());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no create time"), (Object)historicTaskInstance.getCreateTime());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                        AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                    }
                }
                if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) == null || historicActivityInstances.size() <= 0) continue;
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractActivitiTestCase.assertEquals((String)processInstanceId, (String)historicActivityInstance.getProcessInstanceId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no activity id"), (Object)historicActivityInstance.getActivityId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no activity type"), (Object)historicActivityInstance.getActivityType());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no process definition id"), (Object)historicActivityInstance.getProcessDefinitionId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no process instance id"), (Object)historicActivityInstance.getProcessInstanceId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no execution id"), (Object)historicActivityInstance.getExecutionId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no start time"), (Object)historicActivityInstance.getStartTime());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no end time"), (Object)historicActivityInstance.getEndTime());
                }
            }
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map<String, Long> tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("\n");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getDbSqlSession();
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.dynamicBpmnService = this.processEngine.getDynamicBpmnService();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicActivityInstances;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            AbstractActivitiTestCase.assertEquals((String)processInstanceId, (String)historicProcessInstance.getId());
            AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
            AbstractActivitiTestCase.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
            if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractActivitiTestCase.assertEquals((String)processInstanceId, (String)historicTaskInstance.getProcessInstanceId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                }
            }
            if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) != null && historicActivityInstances.size() > 0) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractActivitiTestCase.assertEquals((String)processInstanceId, (String)historicActivityInstance.getProcessInstanceId());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no start time"), (Object)historicActivityInstance.getStartTime());
                    AbstractActivitiTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getActivityId() + " has no end time"), (Object)historicActivityInstance.getEndTime());
                }
            }
        }
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(this.processEngineConfiguration, maxMillisToWait, intervalMillis, condition);
    }

    public void executeJobExecutorForTime(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    protected void assertHistoricTasksDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... taskNames) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String taskName : taskNames) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId())).taskName(taskName)).list();
                AbstractActivitiTestCase.assertTrue((historicTaskInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractActivitiTestCase.assertNotNull((Object)historicTaskInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractActivitiTestCase.assertNull((Object)historicTaskInstance.getDeleteReason());
                        continue;
                    }
                    AbstractActivitiTestCase.assertTrue((boolean)historicTaskInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void assertHistoricActivitiesDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... activityIds) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String activityId : activityIds) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId(activityId).processInstanceId(processInstance.getId()).list();
                AbstractActivitiTestCase.assertTrue((String)"Could not find historic activities", (historicActivityInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractActivitiTestCase.assertNotNull((Object)historicActivityInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractActivitiTestCase.assertNull((Object)historicActivityInstance.getDeleteReason());
                        continue;
                    }
                    AbstractActivitiTestCase.assertTrue((boolean)historicActivityInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }
}

