/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.compatibility;

import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActiviti5CompatibilityHandlerFactory
implements Activiti5CompatibilityHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActiviti5CompatibilityHandlerFactory.class);
    protected String compatibilityHandlerClassName;

    @Override
    public Activiti5CompatibilityHandler createActiviti5CompatibilityHandler() {
        if (this.compatibilityHandlerClassName == null) {
            this.compatibilityHandlerClassName = "org.activiti.compatibility.DefaultActiviti5CompatibilityHandler";
        }
        try {
            Activiti5CompatibilityHandler handler = (Activiti5CompatibilityHandler)Class.forName(this.compatibilityHandlerClassName).newInstance();
            return handler;
        }
        catch (Exception e) {
            logger.info("Activiti 5 compatibility handler implementation not found or error during instantiation : " + e.getMessage() + ". Activiti 5 backwards compatibility disabled.");
            return null;
        }
    }

    public String getCompatibilityHandlerClassName() {
        return this.compatibilityHandlerClassName;
    }

    public void setCompatibilityHandlerClassName(String compatibilityHandlerClassName) {
        this.compatibilityHandlerClassName = compatibilityHandlerClassName;
    }
}

