/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.util.Activiti5Util;

public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
        if (instance == null) {
            throw new ActivitiObjectNotFoundException("No historic process instance found with id: " + this.processInstanceId, HistoricProcessInstance.class);
        }
        if (instance.getEndTime() == null) {
            throw new ActivitiException("Process instance is still running, cannot delete historic process instance: " + this.processInstanceId);
        }
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, instance.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.deleteHistoricProcessInstance(this.processInstanceId);
            return null;
        }
        commandContext.getHistoricProcessInstanceEntityManager().delete(this.processInstanceId);
        return null;
    }
}

