/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.InactiveActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.ExecutionGraphUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior
implements InactiveActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)InclusiveGatewayActivityBehavior.class.getName());

    @Override
    public void execute(DelegateExecution execution) {
        execution.inactivate();
        this.executeInclusiveGatewayLogic((ExecutionEntity)execution);
    }

    @Override
    public void executeInactive(ExecutionEntity executionEntity) {
        this.executeInclusiveGatewayLogic(executionEntity);
    }

    protected void executeInclusiveGatewayLogic(ExecutionEntity execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        this.lockFirstParentScope(execution);
        List<ExecutionEntity> allExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        Iterator executionIterator = allExecutions.iterator();
        boolean oneExecutionCanReachGateway = false;
        while (!oneExecutionCanReachGateway && executionIterator.hasNext()) {
            ExecutionEntity executionEntity = (ExecutionEntity)executionIterator.next();
            if (!executionEntity.getActivityId().equals(execution.getCurrentActivityId())) {
                boolean canReachGateway = ExecutionGraphUtil.isReachable(execution.getProcessDefinitionId(), executionEntity.getActivityId(), execution.getCurrentActivityId());
                if (!canReachGateway) continue;
                oneExecutionCanReachGateway = true;
                continue;
            }
            if (!executionEntity.getActivityId().equals(execution.getCurrentActivityId()) || !executionEntity.isActive()) continue;
            oneExecutionCanReachGateway = true;
        }
        if (!oneExecutionCanReachGateway) {
            logger.debug("Inclusive gateway cannot be reached by any execution and is activated");
            Collection<ExecutionEntity> executionsInGateway = executionEntityManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(execution.getCurrentActivityId(), execution.getProcessInstanceId());
            for (ExecutionEntity executionEntityInGateway : executionsInGateway) {
                if (executionEntityInGateway.getId().equals(execution.getId())) continue;
                commandContext.getHistoryManager().recordActivityEnd(executionEntityInGateway, null);
                executionEntityManager.deleteExecutionAndRelatedData(executionEntityInGateway, null);
            }
            commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(execution, true);
        }
    }
}

