/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected boolean terminateAll;
    protected boolean terminateMultiInstance;

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        if (this.terminateAll) {
            this.terminateAllBehaviour(execution, commandContext, executionEntityManager);
        } else if (this.terminateMultiInstance) {
            this.terminateMultiInstanceRoot(execution, commandContext, executionEntityManager);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void terminateAllBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity rootExecutionEntity = executionEntityManager.findByRootProcessInstanceId(execution.getRootProcessInstanceId());
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        this.deleteExecutionEntities(executionEntityManager, rootExecutionEntity, deleteReason);
        this.endAllHistoricActivities(rootExecutionEntity.getId(), deleteReason);
        commandContext.getHistoryManager().recordProcessInstanceEnd(rootExecutionEntity.getId(), deleteReason, execution.getCurrentActivityId());
    }

    protected void defaultTerminateEndEventBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity scopeExecutionEntity = executionEntityManager.findFirstScope((ExecutionEntity)execution);
        this.sendProcessInstanceCancelledEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        if (scopeExecutionEntity.isProcessInstanceType() && scopeExecutionEntity.getSuperExecutionId() == null) {
            this.endAllHistoricActivities(scopeExecutionEntity.getId(), deleteReason);
            this.deleteExecutionEntities(executionEntityManager, scopeExecutionEntity, deleteReason);
            commandContext.getHistoryManager().recordProcessInstanceEnd(scopeExecutionEntity.getId(), deleteReason, execution.getCurrentActivityId());
        } else if (scopeExecutionEntity.getCurrentFlowElement() != null && scopeExecutionEntity.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)scopeExecutionEntity.getCurrentFlowElement();
            scopeExecutionEntity.setDeleteReason(deleteReason);
            if (subProcess.hasMultiInstanceLoopCharacteristics()) {
                Context.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                multiInstanceBehavior.leave(scopeExecutionEntity);
            } else {
                Context.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                ExecutionEntity outgoingFlowExecution = executionEntityManager.createChildExecution(scopeExecutionEntity.getParent());
                outgoingFlowExecution.setCurrentFlowElement(scopeExecutionEntity.getCurrentFlowElement());
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(outgoingFlowExecution, true);
            }
        } else if (scopeExecutionEntity.getParentId() == null && scopeExecutionEntity.getSuperExecutionId() != null) {
            ExecutionEntity callActivityExecution = scopeExecutionEntity.getSuperExecution();
            CallActivity callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement();
            if (callActivity.hasMultiInstanceLoopCharacteristics()) {
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)callActivity.getBehavior();
                multiInstanceBehavior.leave(callActivityExecution);
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false);
            } else {
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false);
                ExecutionEntity superExecutionEntity = (ExecutionEntity)executionEntityManager.findById(scopeExecutionEntity.getSuperExecutionId());
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(superExecutionEntity, true);
            }
        }
    }

    protected void endAllHistoricActivities(String processInstanceId, String deleteReason) {
        if (!Context.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            return;
        }
        List<HistoricActivityInstanceEntity> historicActivityInstances = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
            historicActivityInstance.markEnded(deleteReason);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config == null || !config.getEventDispatcher().isEnabled()) continue;
            config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance));
        }
    }

    protected void terminateMultiInstanceRoot(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity miRootExecutionEntity = executionEntityManager.findFirstMultiInstanceRoot((ExecutionEntity)execution);
        if (miRootExecutionEntity != null) {
            ExecutionEntity siblingExecution = executionEntityManager.createChildExecution(miRootExecutionEntity.getParent());
            siblingExecution.setCurrentFlowElement(miRootExecutionEntity.getCurrentFlowElement());
            this.deleteExecutionEntities(executionEntityManager, miRootExecutionEntity, this.createDeleteReason(miRootExecutionEntity.getActivityId()));
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(siblingExecution, true);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void deleteExecutionEntities(ExecutionEntityManager executionEntityManager, ExecutionEntity rootExecutionEntity, String deleteReason) {
        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(rootExecutionEntity);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            executionEntityManager.deleteExecutionAndRelatedData(childExecutions.get(i), deleteReason);
        }
        executionEntityManager.deleteExecutionAndRelatedData(rootExecutionEntity, deleteReason);
    }

    protected void sendProcessInstanceCancelledEvent(DelegateExecution execution, FlowElement terminateEndEvent) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (execution.isProcessInstanceType() && execution.getSuperExecutionId() == null || execution.getParentId() == null && execution.getSuperExecutionId() != null)) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), execution.getCurrentFlowElement()));
        }
        this.dispatchExecutionCancelled(execution, terminateEndEvent);
    }

    protected void dispatchExecutionCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        FlowElement flowElement;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        for (DelegateExecution delegateExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(delegateExecution, terminateEndEvent);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, terminateEndEvent);
        }
        if ((flowElement = execution.getCurrentFlowElement()) instanceof FlowNode) {
            this.dispatchActivityCancelled(execution, terminateEndEvent);
        }
    }

    protected void dispatchActivityCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType((FlowNode)execution.getCurrentFlowElement()), terminateEndEvent));
    }

    protected String createDeleteReason(String activityId) {
        return "terminate end event (" + activityId + ")";
    }

    public boolean isTerminateAll() {
        return this.terminateAll;
    }

    public void setTerminateAll(boolean terminateAll) {
        this.terminateAll = terminateAll;
    }

    public boolean isTerminateMultiInstance() {
        return this.terminateMultiInstance;
    }

    public void setTerminateMultiInstance(boolean terminateMultiInstance) {
        this.terminateMultiInstance = terminateMultiInstance;
    }
}

