/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.invocation.ExpressionGetInvocation;
import org.activiti.engine.impl.delegate.invocation.ExpressionSetInvocation;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.DelegateInterceptor;

public class JuelExpression
implements Expression {
    private String expressionText;
    private ValueExpression valueExpression;

    public JuelExpression(ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
    }

    @Override
    public Object getValue(VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        return this.getValueFromContext(elContext, Context.getProcessEngineConfiguration().getDelegateInterceptor());
    }

    @Override
    public void setValue(Object value, VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while evaluating expression: " + this.expressionText, e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }

    @Override
    public Object getValue(ExpressionManager expressionManager, DelegateInterceptor delegateInterceptor, Map<String, Object> availableVariables) {
        ELContext elContext = expressionManager.getElContext(availableVariables);
        return this.getValueFromContext(elContext, delegateInterceptor);
    }

    private Object getValueFromContext(ELContext elContext, DelegateInterceptor delegateInterceptor) {
        try {
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
            delegateInterceptor.handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ActivitiException("Unknown property used in expression: " + this.expressionText, pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ActivitiException("Unknown method used in expression: " + this.expressionText, mnfe);
        }
        catch (Exception ele) {
            throw new ActivitiException("Error while evaluating expression: " + this.expressionText, ele);
        }
    }
}

