/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cfg.TransactionPropagation;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncJobAddedNotification
implements CommandContextCloseListener {
    private static Logger log = LoggerFactory.getLogger(AsyncJobAddedNotification.class);
    protected JobEntity job;
    protected AsyncExecutor asyncExecutor;

    public AsyncJobAddedNotification(JobEntity job, AsyncExecutor asyncExecutor) {
        this.job = job;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                if (log.isTraceEnabled()) {
                    log.trace("notifying job executor of new job");
                }
                AsyncJobAddedNotification.this.asyncExecutor.executeAsyncJob(AsyncJobAddedNotification.this.job);
                return null;
            }
        });
    }

    @Override
    public void closing(CommandContext commandContext) {
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
    }
}

