/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.variable.JsonTypeConverter;
import org.activiti.engine.impl.variable.SerializableType;
import org.activiti.engine.impl.variable.ValueFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongJsonType
extends SerializableType {
    private static final Logger logger = LoggerFactory.getLogger(LongJsonType.class);
    private final int minLength;
    private ObjectMapper objectMapper;
    private boolean serializePOJOsInVariablesToJson;
    private JsonTypeConverter jsonTypeConverter;

    public LongJsonType(int minLength, ObjectMapper objectMapper, boolean serializePOJOsInVariablesToJson, JsonTypeConverter jsonTypeConverter) {
        this.minLength = minLength;
        this.objectMapper = objectMapper;
        this.serializePOJOsInVariablesToJson = serializePOJOsInVariablesToJson;
        this.jsonTypeConverter = jsonTypeConverter;
    }

    @Override
    public String getTypeName() {
        return "longJson";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass()) || this.objectMapper.canSerialize(value.getClass()) && this.serializePOJOsInVariablesToJson) {
            try {
                return this.objectMapper.writeValueAsString(value).length() >= this.minLength;
            }
            catch (JsonProcessingException e) {
                logger.error("Error writing json variable of type " + value.getClass(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            logger.error("Error writing long json variable " + valueFields.getName(), (Throwable)e);
        }
        try {
            valueFields.setTextValue2(value.getClass().getName());
            return json.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ActivitiException("Error getting bytes from json variable", e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        Object jsonValue = null;
        try {
            jsonValue = this.jsonTypeConverter.convertToValue(this.objectMapper.readTree(bytes), valueFields);
        }
        catch (Exception e) {
            logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
        }
        return jsonValue;
    }
}

