/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.DecisionTableAwareConverter;

public class DecisionTaskJsonConverter
extends BaseBpmnJsonConverter
implements DecisionTableAwareConverter {
    protected Map<String, String> decisionTableMap;

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        DecisionTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        DecisionTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("DecisionTask", DecisionTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "DecisionTask";
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setType("dmn");
        JsonNode decisionTableReferenceNode = this.getProperty("decisiontaskdecisiontablereference", elementNode);
        if (decisionTableReferenceNode != null && decisionTableReferenceNode.has("id") && !decisionTableReferenceNode.get("id").isNull()) {
            String decisionTableId = decisionTableReferenceNode.get("id").asText();
            if (this.decisionTableMap != null) {
                String decisionTableKey = this.decisionTableMap.get(decisionTableId);
                FieldExtension decisionTableKeyField = new FieldExtension();
                decisionTableKeyField.setFieldName("decisionTableReferenceKey");
                decisionTableKeyField.setStringValue(decisionTableKey);
                serviceTask.getFieldExtensions().add(decisionTableKeyField);
            }
        }
        return serviceTask;
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    @Override
    public void setDecisionTableMap(Map<String, String> decisionTableMap) {
        this.decisionTableMap = decisionTableMap;
    }

    protected void addExtensionAttributeToExtension(ExtensionElement element, String attributeName, String value) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute("http://activiti.com/modeler", attributeName);
        extensionAttribute.setNamespacePrefix("modeler");
        extensionAttribute.setValue(value);
        element.addAttribute(extensionAttribute);
    }
}

