/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.listener.WorkflowDefinitionConversionListener;
import org.activiti.workflow.simple.definition.WorkflowDefinition;

public class DefaultWorkflowDefinitionConversionListener
implements WorkflowDefinitionConversionListener {
    private static final long serialVersionUID = -145978383684020118L;
    private static final String START_EVENT_ID = "start";
    private static final String END_EVENT_ID = "end";

    @Override
    public void beforeStepsConversion(WorkflowDefinitionConversion conversion) {
        this.initializeProcess(conversion);
    }

    protected void initializeProcess(WorkflowDefinitionConversion conversion) {
        WorkflowDefinition workflowDefinition = conversion.getWorkflowDefinition();
        Process process = conversion.getProcess();
        process.setId(this.generateProcessId(workflowDefinition));
        process.setName(workflowDefinition.getName());
        process.setDocumentation(workflowDefinition.getDescription());
        if (workflowDefinition.getCategory() != null) {
            conversion.getBpmnModel().setTargetNamespace(workflowDefinition.getCategory());
        }
        conversion.setProcess(process);
        StartEvent startEvent = new StartEvent();
        startEvent.setId(START_EVENT_ID);
        if (workflowDefinition.getStartFormDefinition() != null && workflowDefinition.getStartFormDefinition().getFormKey() != null) {
            startEvent.setFormKey(workflowDefinition.getStartFormDefinition().getFormKey());
        }
        process.addFlowElement((FlowElement)startEvent);
        conversion.setLastActivityId(startEvent.getId());
    }

    protected String generateProcessId(WorkflowDefinition workflowDefinition) {
        String processId = null;
        if (workflowDefinition.getId() != null) {
            processId = workflowDefinition.getId();
        } else if (workflowDefinition.getName() != null) {
            processId = workflowDefinition.getName().replace(" ", "_");
        }
        return processId;
    }

    @Override
    public void afterStepsConversion(WorkflowDefinitionConversion conversion) {
        Process process = conversion.getProcess();
        EndEvent endEvent = new EndEvent();
        endEvent.setId(END_EVENT_ID);
        process.addFlowElement((FlowElement)endEvent);
        SequenceFlow sequenceFlow = new SequenceFlow();
        sequenceFlow.setId(conversion.getUniqueNumberedId("sequenceFlow"));
        sequenceFlow.setSourceRef(conversion.getLastActivityId());
        sequenceFlow.setTargetRef(END_EVENT_ID);
        process.addFlowElement((FlowElement)sequenceFlow);
        SequenceFlowMapping sequenceFlowMapping = this.generateSequenceflowMappings(process);
        for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
            List<SequenceFlow> outgoingSequenceFlow;
            List<SequenceFlow> incomingSequenceFlow = sequenceFlowMapping.getIncomingSequenceFlowMapping().get(flowNode.getId());
            if (incomingSequenceFlow != null) {
                flowNode.setIncomingFlows(incomingSequenceFlow);
            }
            if ((outgoingSequenceFlow = sequenceFlowMapping.getOutgoingSequenceFlowMapping().get(flowNode.getId())) == null) continue;
            flowNode.setOutgoingFlows(outgoingSequenceFlow);
        }
    }

    protected SequenceFlowMapping generateSequenceflowMappings(Process process) {
        HashMap<String, List<SequenceFlow>> incomingSequenceFlowMapping = new HashMap<String, List<SequenceFlow>>();
        HashMap<String, List<SequenceFlow>> outgoingSequenceFlowMapping = new HashMap<String, List<SequenceFlow>>();
        for (FlowElement flowElement : process.findFlowElementsOfType(SequenceFlow.class)) {
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            String srcId = sequenceFlow.getSourceRef();
            String targetId = sequenceFlow.getTargetRef();
            if (outgoingSequenceFlowMapping.get(srcId) == null) {
                outgoingSequenceFlowMapping.put(srcId, new ArrayList());
            }
            outgoingSequenceFlowMapping.get(srcId).add(sequenceFlow);
            if (incomingSequenceFlowMapping.get(targetId) == null) {
                incomingSequenceFlowMapping.put(targetId, new ArrayList());
            }
            incomingSequenceFlowMapping.get(targetId).add(sequenceFlow);
        }
        SequenceFlowMapping mapping = new SequenceFlowMapping();
        mapping.setIncomingSequenceFlowMapping(incomingSequenceFlowMapping);
        mapping.setOutgoingSequenceFlowMapping(outgoingSequenceFlowMapping);
        return mapping;
    }

    static class SequenceFlowMapping {
        protected HashMap<String, List<SequenceFlow>> incomingSequenceFlowMapping;
        protected HashMap<String, List<SequenceFlow>> outgoingSequenceFlowMapping;

        SequenceFlowMapping() {
        }

        public HashMap<String, List<SequenceFlow>> getIncomingSequenceFlowMapping() {
            return this.incomingSequenceFlowMapping;
        }

        public void setIncomingSequenceFlowMapping(HashMap<String, List<SequenceFlow>> incomingSequenceFlowMapping) {
            this.incomingSequenceFlowMapping = incomingSequenceFlowMapping != null ? incomingSequenceFlowMapping : new HashMap();
        }

        public HashMap<String, List<SequenceFlow>> getOutgoingSequenceFlowMapping() {
            return this.outgoingSequenceFlowMapping;
        }

        public void setOutgoingSequenceFlowMapping(HashMap<String, List<SequenceFlow>> outgoingSequenceFlowMapping) {
            this.outgoingSequenceFlowMapping = outgoingSequenceFlowMapping != null ? outgoingSequenceFlowMapping : new HashMap();
        }
    }
}

