/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.security;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class IdentityServiceUserDetailsService
implements UserDetailsService {
    private final IdentityService identityService;

    public IdentityServiceUserDetailsService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public UserDetails loadUserByUsername(String userId) throws UsernameNotFoundException {
        User user = null;
        try {
            user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        }
        catch (ActivitiException activitiException) {
            // empty catch block
        }
        if (null == user) {
            throw new UsernameNotFoundException(String.format("user (%s) could not be found", userId));
        }
        boolean active = true;
        ArrayList<GroupGrantedAuthority> grantedAuthorityList = new ArrayList<GroupGrantedAuthority>();
        List groupsForUser = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        for (Group g : groupsForUser) {
            grantedAuthorityList.add(new GroupGrantedAuthority(g));
        }
        return new org.springframework.security.core.userdetails.User(user.getId(), user.getPassword(), active, active, active, active, grantedAuthorityList);
    }

    public static class GroupGrantedAuthority
    implements GrantedAuthority {
        private final Group group;

        public GroupGrantedAuthority(Group group) {
            this.group = group;
        }

        public Group getGroup() {
            return this.group;
        }

        public String getAuthority() {
            return this.group.getName();
        }
    }
}

