/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.arrimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.DATDictionary;
import org.ansj.recognition.TermArrRecognition;
import org.ansj.util.Graph;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;
import org.nlpcn.commons.lang.viterbi.Node;
import org.nlpcn.commons.lang.viterbi.Viterbi;
import org.nlpcn.commons.lang.viterbi.function.Score;
import org.nlpcn.commons.lang.viterbi.function.Values;

public class PersonRecognition
implements TermArrRecognition {
    private static final int B = 0;
    private static final int C = 1;
    private static final int D = 2;
    private static final int E = 3;
    private static final int K = 4;
    private static final int L = 5;
    private static final int M = 6;
    private static final int X = 7;
    private static final int Y = 8;
    private static final int Z = 9;
    private static final int A = 10;
    private static final Log LOG = LogFactory.getLog();
    private static final Map<Integer, Double> transition = new HashMap<Integer, Double>();
    private PersonNode[][] nodes = null;
    private int beginOff;

    @Override
    public void recognition(Graph graph) {
        int i;
        Term[] terms = graph.terms;
        Object from = null;
        Object first = null;
        Object sencond = null;
        Object third = null;
        Object last = null;
        Object fromPna = null;
        Object fPna = null;
        Object sPna = null;
        Object tPna = null;
        Object lPna = null;
        this.nodes = new PersonNode[terms.length + 1][11];
        this.beginOff = terms[0].getOffe();
        ArrayList<Term> replaceTerm = new ArrayList<Term>();
        this.termSplit(terms, replaceTerm);
        Viterbi<PersonNode> viterbi = this.getPersonNodeViterbi(terms);
        ArrayList result = new ArrayList(viterbi.compute((Score)new Score<PersonNode>(){

            public Double score(Node<PersonNode> from, Node<PersonNode> to) {
                if (from == null || to == null) {
                    return null;
                }
                Double tValue = (Double)transition.get(((PersonNode)from.getT()).tag * 1000 + ((PersonNode)to.getT()).tag);
                if (tValue == null || from.getScore() == null) {
                    return null;
                }
                return from.getScore() + to.getSelfScore() + tValue;
            }

            public boolean sort() {
                return true;
            }
        }));
        int off = 0;
        int len = result.size() - 1;
        block0: for (i = 1; i < len; ++i) {
            PersonNode p1 = (PersonNode)result.get(i);
            PersonNode p2 = null;
            if (p1.tag != 0 && p1.tag != 7) {
                off += p1.name.length();
                continue;
            }
            ArrayList<Term> tempList = new ArrayList<Term>();
            tempList.add(terms[off]);
            off += p1.name.length();
            for (int j = i + 1; j < result.size(); ++j) {
                p2 = (PersonNode)result.get(j);
                tempList.add(terms[off]);
                off += p2.name.length();
                if (p2.tag != 3 && p2.tag != 2 && p2.tag != 9) continue;
                TermUtil.insertTerm(terms, tempList, TermNatures.NR);
                i = j;
                continue block0;
            }
        }
        for (i = 0; i < replaceTerm.size(); ++i) {
            int beginIndex;
            Term term = (Term)replaceTerm.get(i);
            len = 0;
            int end = term.getOffe() - this.beginOff + term.getName().length();
            for (int j = term.getOffe() - this.beginOff; j < end; ++j) {
                if (terms[j] == null) continue;
                len += terms[j].getName().length();
            }
            if (len != term.getName().length() || terms[beginIndex = term.getOffe() - this.beginOff] == null) continue;
            Term f1 = terms[beginIndex].from();
            for (int j = beginIndex; j < end; ++j) {
                terms[j] = null;
            }
            terms[term.getOffe() - this.beginOff] = term;
            TermUtil.termLink(f1, term);
            TermUtil.termLink(term, terms[beginIndex + term.getName().length()]);
        }
        this.foreign(terms);
    }

    private void foreign(Term[] terms) {
        List<Term> list = new ArrayList<Term>();
        Term term = null;
        Object temp = null;
        boolean mid = false;
        for (int i = 0; i < terms.length; ++i) {
            term = terms[i];
            if (term == null) continue;
            if (DATDictionary.foreign(term)) {
                mid = "\u00b7".equals(term.getName());
                if (mid && list.size() == 0) {
                    mid = false;
                    continue;
                }
                list.add(term);
                continue;
            }
            if (mid) {
                list = list.subList(0, list.size() - 1);
                mid = false;
            }
            if (list.size() == 0) continue;
            if (list.size() == 1) {
                mid = false;
                list.clear();
                continue;
            }
            TermUtil.insertTerm(terms, list, TermNatures.NRF);
            list.clear();
        }
    }

    private Viterbi<PersonNode> getPersonNodeViterbi(Term[] terms) {
        for (int i = 0; i < terms.length - 1; ++i) {
            Term sencond;
            Term first = terms[i];
            if (first == null) continue;
            PersonNatureAttr fPna = this.getPersonNature(first);
            this.setNode(first, 10);
            if (fPna.getY() > 0.0f) {
                this.setNode(first, 8);
            }
            if (fPna == null || !fPna.isActive() || (sencond = first.to()).getOffe() == terms.length || sencond.getName().length() > 2) continue;
            Term third = sencond.to();
            Term from = first.from();
            if (first.getName().length() == 2) {
                this.setNode(from, 4);
                this.setNode(from, 6);
                this.setNode(first, 7);
                this.setNode(sencond, 2);
                this.setNode(third, 6);
                this.setNode(third, 5);
                continue;
            }
            this.setNode(from, 4);
            this.setNode(from, 6);
            this.setNode(first, 0);
            this.setNode(third, 6);
            this.setNode(third, 5);
            if (sencond.getName().length() == 2) {
                this.setNode(sencond, 9);
                continue;
            }
            this.setNode(sencond, 3);
            if (third.getOffe() == terms.length || third.getName().length() > 1) continue;
            this.setNode(first, 0);
            this.setNode(sencond, 1);
            this.setNode(third, 2);
            this.setNode(third.to(), 6);
            this.setNode(third.to(), 5);
        }
        PersonNatureAttr begin = DATDictionary.person("BEGIN");
        this.nodes[0][6] = null;
        this.nodes[0][4] = new PersonNode(4, "B", -Math.log(begin.getK()));
        this.nodes[0][10] = new PersonNode(10, "B", -Math.log(begin.getA()));
        PersonNatureAttr end = DATDictionary.person("END");
        this.nodes[terms.length][5] = new PersonNode(5, "E", -Math.log(end.getL()));
        this.nodes[terms.length][6] = null;
        this.nodes[terms.length][10] = new PersonNode(10, "E", -Math.log(end.getA()));
        return new Viterbi((Object[][])this.nodes, (Values)new Values<PersonNode>(){

            public int step(Node<PersonNode> node) {
                return ((PersonNode)node.getObj()).name.length();
            }

            public double selfSscore(Node<PersonNode> node) {
                return ((PersonNode)node.getObj()).score;
            }
        });
    }

    private void termSplit(Term[] terms, List<Term> replaceTerm) {
        for (int i = 0; i < terms.length - 1; ++i) {
            AnsjItem item;
            String name;
            PersonNatureAttr fPna;
            int len;
            Term first = terms[i];
            if (first == null || (len = first.getName().length()) == 1 || len == 3 || (fPna = first.termNatures().personAttr).getU() <= 0.0f && fPna.getV() <= 0.0f) continue;
            replaceTerm.add(first);
            if (first.getName().length() == 2) {
                name = String.valueOf(first.getName().charAt(0));
                terms[i] = new Term(name, first.getOffe(), DATDictionary.getItem(name));
                name = String.valueOf(first.getName().charAt(1));
                terms[i + 1] = new Term(name, first.getOffe() + 1, DATDictionary.getItem(name));
                TermUtil.termLink(first.from(), terms[i]);
                TermUtil.termLink(terms[i], terms[i + 1]);
                TermUtil.termLink(terms[i + 1], first.to());
                continue;
            }
            if (fPna.getU() > 0.0f) {
                name = first.getName().substring(0, 2);
                item = DATDictionary.getItem(name);
                if (item != AnsjItem.NULL) {
                    terms[i] = new Term(name, first.getOffe(), item);
                    terms[i + 1] = null;
                    name = String.valueOf(first.getName().charAt(2));
                    terms[i + 2] = new Term(name, first.getOffe() + 2, DATDictionary.getItem(name));
                    TermUtil.termLink(first.from(), terms[i]);
                    TermUtil.termLink(terms[i], terms[i + 2]);
                    TermUtil.termLink(terms[i + 2], first.to());
                    continue;
                }
                name = String.valueOf(first.getName().charAt(0));
                terms[i] = new Term(name, first.getOffe(), DATDictionary.getItem(name));
                name = String.valueOf(first.getName().charAt(1));
                terms[i + 1] = new Term(name, first.getOffe() + 1, DATDictionary.getItem(name));
                name = String.valueOf(first.getName().charAt(2));
                terms[i + 2] = new Term(name, first.getOffe() + 2, DATDictionary.getItem(name));
                TermUtil.termLink(first.from(), terms[i]);
                TermUtil.termLink(terms[i], terms[i + 1]);
                TermUtil.termLink(terms[i + 1], terms[i + 2]);
                TermUtil.termLink(terms[i + 2], first.to());
                continue;
            }
            name = first.getName().substring(1, 3);
            item = DATDictionary.getItem(name);
            if (item != AnsjItem.NULL) {
                terms[i + 1] = new Term(name, first.getOffe() + 1, item);
                terms[i + 2] = null;
                name = String.valueOf(first.getName().charAt(0));
                terms[i] = new Term(name, first.getOffe(), DATDictionary.getItem(name));
                TermUtil.termLink(first.from(), terms[i]);
                TermUtil.termLink(terms[i], terms[i + 1]);
                TermUtil.termLink(terms[i + 1], first.to());
                continue;
            }
            name = String.valueOf(first.getName().charAt(0));
            terms[i] = new Term(name, first.getOffe(), DATDictionary.getItem(name));
            name = String.valueOf(first.getName().charAt(1));
            terms[i + 1] = new Term(name, first.getOffe() + 1, DATDictionary.getItem(name));
            name = String.valueOf(first.getName().charAt(2));
            terms[i + 2] = new Term(name, first.getOffe() + 2, DATDictionary.getItem(name));
            TermUtil.termLink(first.from(), terms[i]);
            TermUtil.termLink(terms[i], terms[i + 1]);
            TermUtil.termLink(terms[i + 1], terms[i + 2]);
            TermUtil.termLink(terms[i + 2], first.to());
        }
    }

    private void setAllNode(String name, int offe, boolean skip) {
        AnsjItem item = DATDictionary.getItem(String.valueOf(name));
        if (skip && item == AnsjItem.NULL || item.getStatus() < 2) {
            return;
        }
        Term term = new Term(name, offe, item);
        for (int j = 0; j < 11; ++j) {
            this.setNode(term, j);
        }
    }

    private void setNode(Term term, int tag) {
        int index = term.getOffe() - this.beginOff + 1;
        PersonNatureAttr pna = this.getPersonNature(term);
        double score = 0.0;
        switch (tag) {
            case 0: {
                score = pna.getB();
                break;
            }
            case 1: {
                score = pna.getC();
                break;
            }
            case 2: {
                score = pna.getD();
                break;
            }
            case 3: {
                score = pna.getE();
                break;
            }
            case 4: {
                score = pna.getK();
                break;
            }
            case 5: {
                score = pna.getL();
                break;
            }
            case 6: {
                score = pna.getM();
                break;
            }
            case 7: {
                score = pna.getX();
                break;
            }
            case 8: {
                score = pna.getY();
                break;
            }
            case 9: {
                score = pna.getZ();
                break;
            }
            case 10: {
                score = pna.getA();
            }
        }
        if (this.nodes[index][tag] == null) {
            this.nodes[index][tag] = new PersonNode(tag, term.getName(), score);
        }
    }

    private PersonNatureAttr getPersonNature(Term term) {
        if (term.termNatures().personAttr != PersonNatureAttr.NULL) {
            return term.termNatures().personAttr;
        }
        PersonNatureAttr person = DATDictionary.person(term.getName());
        if (person != null) {
            return person;
        }
        person = DATDictionary.person(":" + term.getNatureStr());
        if (person == null) {
            return PersonNatureAttr.NULL;
        }
        return person;
    }

    static {
        transition.put(7002, 0.35999);
        transition.put(8000, -3.73687);
        transition.put(8006, -0.43878);
        transition.put(8005, 0.28621);
        transition.put(9007, -2.52373);
        transition.put(9008, -3.11504);
        transition.put(9000, -1.83448);
        transition.put(9005, 0.26402);
        transition.put(9006, -0.06501);
        transition.put(8008, -1.8832);
        transition.put(8007, -4.32692);
        transition.put(4008, 0.28621);
        transition.put(4007, -0.49013);
        transition.put(3006, -0.49013);
        transition.put(4000, 0.42897);
        transition.put(2005, 0.48905);
        transition.put(2006, -0.10071);
        transition.put(5010, -0.02154);
        transition.put(1002, 0.76553);
        transition.put(3008, -3.73687);
        transition.put(3007, -4.02912);
        transition.put(6000, -0.30355);
        transition.put(2000, -2.05756);
        transition.put(5004, -0.49884);
        transition.put(6008, -0.43878);
        transition.put(6007, -0.78341);
        transition.put(3000, -2.80074);
        transition.put(2007, -2.94393);
        transition.put(2008, -3.83297);
        transition.put(10004, -0.1584);
        transition.put(10010, 0.89299);
        transition.put(3005, 0.46686);
        transition.put(3, 0.79864);
        transition.put(1, 0.76553);
        transition.put(9, 0.26402);
    }

    class PersonNode {
        public int tag;
        public String name;
        public double score;

        public PersonNode(int tag, String name, double score) {
            this.tag = tag;
            this.name = name;
            this.score = score;
        }

        public String toString() {
            return this.name + "," + this.tag + "," + this.score;
        }
    }
}

