/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.metadata.Column;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.RegularUtil;

public interface TypeMetadata {
    public static final TypeMetadata ILLEGAL = new TypeMetadata(){
        private final String name = "ILLEGAL";

        @Override
        public CATEGORY getCategory() {
            return CATEGORY.NONE;
        }

        @Override
        public CATEGORY_GROUP getCategoryGroup() {
            return CATEGORY_GROUP.NONE;
        }

        @Override
        public String getName() {
            return "ILLEGAL";
        }

        @Override
        public int ignoreLength() {
            return -1;
        }

        @Override
        public int ignorePrecision() {
            return -1;
        }

        @Override
        public int ignoreScale() {
            return -1;
        }

        @Override
        public boolean support() {
            return false;
        }

        @Override
        public void setArray(boolean array) {
        }

        @Override
        public Class compatible() {
            return null;
        }

        @Override
        public Class transfer() {
            return null;
        }

        @Override
        public List<DatabaseType> databaseTypes() {
            return new ArrayList<DatabaseType>();
        }

        @Override
        public Object convert(Object value, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Object obj, Field field) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz, boolean array) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, Boolean placeholder) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return null;
        }

        @Override
        public Refer config() {
            return new Refer();
        }
    };
    public static final TypeMetadata NONE = new TypeMetadata(){
        private final String name = "NONE";

        @Override
        public CATEGORY getCategory() {
            return CATEGORY.NONE;
        }

        @Override
        public String getName() {
            return "NONE";
        }

        @Override
        public int ignoreLength() {
            return -1;
        }

        @Override
        public int ignorePrecision() {
            return -1;
        }

        @Override
        public int ignoreScale() {
            return -1;
        }

        @Override
        public boolean support() {
            return true;
        }

        @Override
        public void setArray(boolean array) {
        }

        @Override
        public Refer config() {
            return new Refer();
        }

        @Override
        public Class compatible() {
            return null;
        }

        @Override
        public Class transfer() {
            return null;
        }

        @Override
        public CATEGORY_GROUP getCategoryGroup() {
            return CATEGORY_GROUP.NONE;
        }

        @Override
        public List<DatabaseType> databaseTypes() {
            return new ArrayList<DatabaseType>();
        }

        @Override
        public Object convert(Object value, Object def) {
            return value;
        }

        @Override
        public Object convert(Object value, Class target) {
            return value;
        }

        @Override
        public Object convert(Object value, Class target, Object def) {
            return value;
        }

        @Override
        public Object convert(Object value, Class target, boolean array) {
            return value;
        }

        @Override
        public Object convert(Object value, Class target, boolean array, Object def) {
            return value;
        }

        @Override
        public Object convert(Object value, Object obj, Field field) {
            return value;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object read(Object value, Object def, Class clazz, boolean array) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, Boolean placeholder) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return value;
        }
    };

    default public boolean equals(TypeMetadata metadata) {
        if (null == metadata) {
            return false;
        }
        if (this.getOrigin() == metadata) {
            return true;
        }
        if (this == metadata) {
            return true;
        }
        if (this == metadata.getOrigin()) {
            return true;
        }
        return this.getOrigin() == metadata.getOrigin();
    }

    public CATEGORY getCategory();

    public CATEGORY_GROUP getCategoryGroup();

    public String getName();

    default public TypeMetadata getOrigin() {
        return this;
    }

    public int ignoreLength();

    public int ignorePrecision();

    public int ignoreScale();

    public boolean support();

    default public String formula() {
        return null;
    }

    default public boolean isArray() {
        return false;
    }

    public void setArray(boolean var1);

    public Refer config();

    public Class compatible();

    public Class transfer();

    public List<DatabaseType> databaseTypes();

    public Object convert(Object var1, Object var2);

    default public Object convert(Object value, Class target) {
        return this.convert(value, target, false);
    }

    public Object convert(Object var1, Class var2, boolean var3);

    default public Object convert(Object value, Class target, Object def) {
        return this.convert(value, target, false, def);
    }

    public Object convert(Object var1, Class var2, boolean var3, Object var4);

    public Object convert(Object var1, Object var2, Field var3);

    default public Object read(Object value, Object def, Class clazz) {
        return this.read(value, def, clazz, false);
    }

    public Object read(Object var1, Object var2, Class var3, boolean var4);

    default public Object write(Object value, Object def, Boolean placeholder) {
        return this.write(value, def, false, placeholder);
    }

    public Object write(Object var1, Object var2, boolean var3, Boolean var4);

    public static TypeMetadata parse(DatabaseType database, Column meta, LinkedHashMap<String, TypeMetadata> alias, Map<String, String> spells) {
        List<String> items;
        if (null == meta) {
            return null;
        }
        boolean array = false;
        String originType = meta.getOriginType();
        if (null == originType) {
            return null;
        }
        String typeName = originType;
        String up = typeName.toUpperCase();
        TypeMetadata typeMetadata = meta.getTypeMetadata();
        if (null != typeMetadata && NONE != typeMetadata && meta.getParseLvl() >= 2 && meta.getDatabaseType() == database) {
            return typeMetadata;
        }
        Integer length = meta.getLength();
        Integer precision = meta.getPrecision();
        Integer scale = meta.getScale();
        if (typeName.contains("[]")) {
            array = true;
            typeName = typeName.replace("[]", "");
        }
        if (typeName.startsWith("_")) {
            typeName = typeName.substring(1);
            array = true;
        }
        if ((typeName = typeName.trim().replace("'", "")).toUpperCase().contains("IDENTITY")) {
            meta.autoIncrement(true);
            if (typeName.contains(" ")) {
                typeName = typeName.split(" ")[0];
            }
        }
        if (null == (typeMetadata = TypeMetadata.parse(alias, spells, typeName)) || NONE == typeMetadata) {
            try {
                List<List<String>> fetches = RegularUtil.fetchs(up, "\\((\\d+)\\)");
                if (!fetches.isEmpty()) {
                    if (fetches.size() == 2) {
                        precision = BasicUtil.parseInt(fetches.get(0).get(1), null);
                        scale = BasicUtil.parseInt(fetches.get(1).get(1), null);
                    } else {
                        items = fetches.get(0);
                        typeName = typeName.replace(items.get(0), "");
                        Integer num = BasicUtil.parseInt(items.get(1), null);
                        typeMetadata = TypeMetadata.parse(alias, spells, typeName);
                        if (null != typeMetadata) {
                            CATEGORY_GROUP group = typeMetadata.getCategoryGroup();
                            if (group == CATEGORY_GROUP.NUMBER) {
                                precision = num;
                            } else if (group == CATEGORY_GROUP.DATETIME) {
                                scale = num;
                            } else if (group == CATEGORY_GROUP.INTERVAL) {
                                precision = num;
                            } else {
                                length = num;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null == typeMetadata || NONE == typeMetadata) {
            try {
                List<List<String>> fetchs = RegularUtil.fetchs(up, "\\((\\d+)\\s*,\\s*(\\d)\\)");
                if (!fetchs.isEmpty()) {
                    items = fetchs.get(0);
                    String full = items.get(0);
                    typeName = typeName.replace(full, "").trim();
                    precision = BasicUtil.parseInt(items.get(1), 0);
                    scale = BasicUtil.parseInt(items.get(2), 0);
                    typeMetadata = TypeMetadata.parse(alias, spells, typeName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((null == typeMetadata || NONE == typeMetadata) && typeName.contains("(")) {
            String tmp = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
            if (tmp.contains(",")) {
                String[] lens = tmp.split("\\,");
                if (BasicUtil.isNumber(lens[0])) {
                    precision = BasicUtil.parseInt(lens[0], null);
                    scale = BasicUtil.parseInt(lens[1], null);
                } else {
                    meta.setChildTypeName(lens[0]);
                    meta.setSrid(BasicUtil.parseInt(lens[1], null));
                }
            } else if (BasicUtil.isNumber(tmp)) {
                precision = BasicUtil.parseInt(tmp, null);
            } else {
                meta.setChildTypeName(tmp);
            }
            typeName = typeName.substring(0, typeName.indexOf("("));
        }
        if (null == typeMetadata || NONE == typeMetadata) {
            typeMetadata = TypeMetadata.parse(alias, spells, typeName);
        }
        if (null != typeMetadata && NONE != typeMetadata) {
            meta.setTypeMetadata(typeMetadata);
            meta.setTypeName(typeMetadata.getName(), false);
        } else {
            meta.setFullType(originType);
            meta.setTypeMetadata(NONE);
        }
        meta.setOriginType(originType);
        meta.setArray(array);
        int ignoreLength = MetadataReferHolder.ignoreLength(database, typeMetadata);
        int ignorePrecision = MetadataReferHolder.ignorePrecision(database, typeMetadata);
        int ignoreScale = MetadataReferHolder.ignoreScale(database, typeMetadata);
        if (null != precision && precision > 0) {
            if (ignorePrecision != 1) {
                meta.setPrecision(precision);
            } else if (ignoreLength != 1 && (null == length || length <= 0)) {
                length = precision;
            }
        }
        if (null != scale && scale > -1 && ignoreScale != 1) {
            meta.setScale(scale);
        }
        if (null != length) {
            meta.setLength(length);
        }
        if (null != database && database != DatabaseType.NONE) {
            meta.setParseLvl(2);
        }
        meta.setDatabaseType(database);
        return typeMetadata;
    }

    public static TypeMetadata parse(LinkedHashMap<String, TypeMetadata> alias, Map<String, String> spells, String name) {
        if (null == name) {
            return null;
        }
        TypeMetadata type = null;
        name = name.toUpperCase();
        if (null != alias) {
            type = alias.get(name);
        }
        if (null == type) {
            try {
                type = StandardTypeMetadata.valueOf(name);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (null == type && null != spells) {
            if (null != alias) {
                type = alias.get(spells.get(name));
            }
            if (null == type) {
                try {
                    type = StandardTypeMetadata.valueOf(spells.get(name));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (null == type) {
            try {
                type = StandardTypeMetadata.valueOf(name.replace(" ", "_"));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return type;
    }

    public static class Refer {
        private String meta;
        private String formula;
        private int ignoreLength = -1;
        private int ignorePrecision = -1;
        private int ignoreScale = -1;
        private String[] lengthRefers;
        private String[] precisionRefers;
        private String[] scaleRefers;

        public Refer() {
        }

        public Refer(String meta, String formula, String lengthRefer, String precisionRefer, String scaleRefer, int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.setMeta(meta);
            this.setFormula(formula);
            this.setLengthRefer(lengthRefer);
            this.setScaleRefer(scaleRefer);
            this.setPrecisionRefer(precisionRefer);
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public Refer(String lengthRefer, String precisionRefer, String scaleRefer, int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.setLengthRefer(lengthRefer);
            this.setScaleRefer(scaleRefer);
            this.setPrecisionRefer(precisionRefer);
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public Refer(String lengthRefer, String precisionRefer, String scaleRefer) {
            this.setLengthRefer(lengthRefer);
            this.setScaleRefer(scaleRefer);
            this.setPrecisionRefer(precisionRefer);
        }

        public Refer(int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public int ignoreLength() {
            return this.ignoreLength;
        }

        public Refer setIgnoreLength(int ignoreLength) {
            this.ignoreLength = ignoreLength;
            return this;
        }

        public int ignorePrecision() {
            return this.ignorePrecision;
        }

        public Refer setIgnorePrecision(int ignorePrecision) {
            this.ignorePrecision = ignorePrecision;
            return this;
        }

        public int ignoreScale() {
            return this.ignoreScale;
        }

        public Refer setIgnoreScale(int ignoreScale) {
            this.ignoreScale = ignoreScale;
            return this;
        }

        public String[] getLengthRefers() {
            return this.lengthRefers;
        }

        public String getLengthRefer() {
            if (null != this.lengthRefers && this.lengthRefers.length > 0) {
                return this.lengthRefers[0];
            }
            return null;
        }

        public Refer setLengthRefers(String[] lengthRefers) {
            this.lengthRefers = lengthRefers;
            return this;
        }

        public Refer setLengthRefer(String lengthRefer) {
            this.lengthRefers = BasicUtil.isNotEmpty(lengthRefer) ? lengthRefer.split(",") : null;
            return this;
        }

        public String[] getPrecisionRefers() {
            return this.precisionRefers;
        }

        public String getPrecisionRefer() {
            if (null != this.precisionRefers && this.precisionRefers.length > 0) {
                return this.precisionRefers[0];
            }
            return null;
        }

        public Refer setPrecisionRefers(String[] precisionRefers) {
            this.precisionRefers = precisionRefers;
            return this;
        }

        public Refer setPrecisionRefer(String precisionRefer) {
            this.precisionRefers = BasicUtil.isNotEmpty(precisionRefer) ? precisionRefer.split(",") : null;
            return this;
        }

        public String[] getScaleRefers() {
            return this.scaleRefers;
        }

        public String getScaleRefer() {
            if (null != this.scaleRefers && this.scaleRefers.length > 0) {
                return this.scaleRefers[0];
            }
            return null;
        }

        public Refer setScaleRefers(String[] scaleRefers) {
            this.scaleRefers = scaleRefers;
            return this;
        }

        public Refer setScaleRefer(String scaleRefer) {
            this.scaleRefers = BasicUtil.isNotEmpty(scaleRefer) ? scaleRefer.split(",") : null;
            return this;
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public String getMeta() {
            return this.meta;
        }

        public void setMeta(String meta) {
            this.meta = meta;
        }

        public Refer merge(Refer copy) {
            if (null != copy) {
                String meta = copy.getMeta();
                String formula = copy.getFormula();
                int ignoreLength = copy.ignoreLength();
                int ignorePrecision = copy.ignorePrecision;
                int ignoreScale = copy.ignoreScale();
                if (BasicUtil.isNotEmpty(meta)) {
                    this.meta = meta;
                }
                if (BasicUtil.isNotEmpty(formula)) {
                    this.formula = formula;
                }
                if (-1 != ignoreLength) {
                    this.ignoreLength = ignoreLength;
                }
                if (-1 != ignorePrecision) {
                    this.ignorePrecision = ignorePrecision;
                }
                if (-1 != ignoreScale) {
                    this.ignoreScale = ignoreScale;
                }
                String[] lengthRefers = copy.getLengthRefers();
                String[] precisionRefers = copy.getPrecisionRefers();
                String[] scaleRefers = copy.getScaleRefers();
                if (null != lengthRefers && lengthRefers.length > 0) {
                    this.lengthRefers = lengthRefers;
                }
                if (null != precisionRefers && precisionRefers.length > 0) {
                    this.precisionRefers = precisionRefers;
                }
                if (null != scaleRefers && scaleRefers.length > 0) {
                    this.scaleRefers = scaleRefers;
                }
            }
            return this;
        }
    }

    public static enum CATEGORY {
        CHAR(CATEGORY_GROUP.STRING, 0, 1, 1),
        TEXT(CATEGORY_GROUP.STRING, 1, 1, 1),
        BOOLEAN(CATEGORY_GROUP.BOOLEAN, 1, 1, 1),
        BYTES(CATEGORY_GROUP.BYTES, 0, 1, 1),
        BLOB(CATEGORY_GROUP.BYTES, 1, 1, 1),
        INT(CATEGORY_GROUP.NUMBER, 0, 1, 1),
        FLOAT(CATEGORY_GROUP.NUMBER, 1, 0, 0),
        DATE(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        TIME(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        DATETIME(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        TIMESTAMP(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        COLLECTION(CATEGORY_GROUP.COLLECTION, 1, 1, 1),
        GEOMETRY(CATEGORY_GROUP.GEOMETRY, 1, 1, 1),
        INTERVAL(CATEGORY_GROUP.INTERVAL, 1, 2, 3),
        OTHER(CATEGORY_GROUP.OTHER, 1, 1, 1),
        NONE(CATEGORY_GROUP.NONE, 1, 1, 1);

        private final CATEGORY_GROUP group;
        private final int ignoreLength;
        private final int ignorePrecision;
        private final int ignoreScale;
        private Refer config;

        private CATEGORY(CATEGORY_GROUP group, int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.group = group;
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public CATEGORY_GROUP group() {
            return this.group;
        }

        public Refer config() {
            if (null == this.config) {
                this.config = new Refer();
                this.config.setIgnoreLength(this.ignoreLength).setIgnorePrecision(this.ignorePrecision).setIgnoreScale(this.ignoreScale);
            }
            return this.config;
        }
    }

    public static enum CATEGORY_GROUP {
        STRING,
        NUMBER,
        BOOLEAN,
        BYTES,
        DATETIME,
        COLLECTION,
        GEOMETRY,
        INTERVAL,
        OTHER,
        NONE;

    }
}

