/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DomUtil {
    public static Element element(boolean shelf, Element root, List<String> tags) {
        Element result = null;
        if (shelf && tags.contains(root.getName())) {
            return root;
        }
        Iterator it = root.elementIterator();
        while (it.hasNext() && null == result) {
            Element e = (Element)it.next();
            if (tags.contains(e.getName())) {
                result = e;
                break;
            }
            result = DomUtil.element(e, tags);
        }
        return result;
    }

    public static Element element(boolean shelf, Element root, String tags) {
        return DomUtil.element(shelf, root, BeanUtil.array2list(new String[][]{tags.split(",")}));
    }

    public static List<Element> elements(boolean shelf, Element root, List<String> tags, boolean recursion) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (shelf && tags.contains(root.getName())) {
            list.add(root);
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (tags.contains(e.getName())) {
                list.add(e);
            }
            if (!recursion) continue;
            List<Element> items = DomUtil.elements(e, tags, recursion);
            list.addAll(items);
        }
        return list;
    }

    public static List<Element> elements(boolean shelf, Element root, String tags, boolean recursion) {
        return DomUtil.elements(shelf, root, BeanUtil.array2list(new String[][]{tags.split(",")}), recursion);
    }

    public static List<Element> elements(boolean shelf, Element root, List<String> tags) {
        return DomUtil.elements(shelf, root, tags, true);
    }

    public static List<Element> elements(boolean shelf, Element root, String tags) {
        return DomUtil.elements(shelf, root, tags, true);
    }

    public static List<Element> elements(boolean shelf, List<Element> roots, String tags) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element root : roots) {
            elements.addAll(DomUtil.elements(shelf, root, tags));
        }
        return elements;
    }

    public static Element element(Element root, List<String> tags) {
        return DomUtil.element(false, root, tags);
    }

    public static Element element(Element root, String tags) {
        return DomUtil.element(false, root, tags);
    }

    public static List<Element> elements(Element root, List<String> tags, boolean recursion) {
        return DomUtil.elements(false, root, tags, recursion);
    }

    public static List<Element> elements(Element root, String tags, boolean recursion) {
        return DomUtil.elements(false, root, tags, recursion);
    }

    public static List<Element> elements(Element root, List<String> tags) {
        return DomUtil.elements(false, root, tags);
    }

    public static List<Element> elements(Element root, String tags) {
        return DomUtil.elements(false, root, tags);
    }

    public static List<Element> elements(List<Element> roots, String tags) {
        return DomUtil.elements(false, roots, tags);
    }

    public static Element element(Element root, List<String> tags, String attribute, String value) {
        Element result = null;
        Iterator it = root.elementIterator();
        while (it.hasNext() && null == result) {
            Element e = (Element)it.next();
            if (tags.contains(e.getName()) && value.equals(e.attributeValue(attribute))) {
                result = e;
                break;
            }
            result = DomUtil.element(e, tags, attribute, value);
        }
        return result;
    }

    public static Element element(Element root, String tags, String attribute, String value) {
        return DomUtil.element(root, BeanUtil.array2list(new String[][]{tags.split(",")}), attribute, value);
    }

    public static List<Element> elements(Element root, List<String> tags, String attribute, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (tags.contains(e.getName()) && value.equals(e.attributeValue(attribute))) {
                list.add(e);
            }
            List<Element> items = DomUtil.elements(e, tags, attribute, value);
            list.addAll(items);
        }
        return list;
    }

    public static List<Element> elements(Element root, String tags, String attribute, String value) {
        return DomUtil.elements(root, BeanUtil.array2list(new String[][]{tags.split(",")}), attribute, value);
    }

    public static Element element(Element root, String attribute, String value) {
        Element result = null;
        Iterator it = root.elementIterator();
        while (it.hasNext() && null == result) {
            Element e = (Element)it.next();
            if (value.equals(e.attributeValue(attribute))) {
                result = e;
                break;
            }
            result = DomUtil.element(e, attribute, value);
        }
        return result;
    }

    public static List<Element> elements(Element root, String attribute, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (value.equals(e.attributeValue(attribute))) {
                list.add(e);
            }
            List<Element> items = DomUtil.elements(e, attribute, value);
            list.addAll(items);
        }
        return list;
    }

    public static boolean contains(Element box, Element item) {
        List elements = box.elements();
        if (null != elements) {
            for (Element element : elements) {
                if (element == item) {
                    return true;
                }
                if (!DomUtil.contains(element, item)) continue;
                return true;
            }
        }
        return false;
    }

    public static String format(String xml) {
        String result = null;
        Object writer = null;
        try {
            Document document = DocumentHelper.parseText((String)xml);
            result = DomUtil.format(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Document document) {
        String result = null;
        XMLWriter writer = null;
        try {
            StringWriter stringWriter = new StringWriter();
            OutputFormat format = new OutputFormat("\t", true);
            writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(document);
            writer.flush();
            result = stringWriter.getBuffer().toString();
        }
        catch (Exception ignored) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Node note) {
        String result = null;
        XMLWriter writer = null;
        try {
            StringWriter stringWriter = new StringWriter();
            OutputFormat format = new OutputFormat("\t", true);
            writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(note);
            writer.flush();
            result = stringWriter.getBuffer().toString();
        }
        catch (Exception ignored) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static List<Element> afters(Element element, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        List elements = element.getParent().elements();
        int index = elements.indexOf(element);
        for (int i = index + 1; i < elements.size(); ++i) {
            Element item = (Element)elements.get(i);
            if (!item.getName().equalsIgnoreCase(tag)) continue;
            list.add(item);
        }
        return list;
    }

    public static List<Element> befores(Element element, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        List elements = element.getParent().elements();
        int index = elements.indexOf(element);
        for (int i = elements.size() - 1; i > index; --i) {
            Element item = (Element)elements.get(i);
            if (!item.getName().equalsIgnoreCase(tag)) continue;
            list.add(item);
        }
        return list;
    }

    public static List<Element> betweens(Element start, Element end, String ... tags) {
        ArrayList<Element> list = new ArrayList<Element>();
        List elements = start.getParent().elements();
        int fr = elements.indexOf(start);
        int to = elements.indexOf(end);
        int index = elements.indexOf(start);
        for (int i = fr + 1; i < to; ++i) {
            Element item = (Element)elements.get(i);
            if (null != tags && tags.length != 0 && !BasicUtil.contains(tags, item.getName())) continue;
            list.add(item);
        }
        return list;
    }

    public static void remove(Element parent, List<Element> removes) {
        List elements = parent.elements();
        for (Element remove : removes) {
            elements.remove(remove);
        }
    }
}

