/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.Run;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.AbstractDriverAdapter;
import org.anyline.data.entity.Join;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.run.ProcedureRun;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.transaction.TransactionState;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.Role;
import org.anyline.entity.authorize.User;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.CommandException;
import org.anyline.exception.CommandQueryException;
import org.anyline.exception.CommandUpdateException;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.proxy.TransactionProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.encrypt.MD5Util;
import org.anyline.util.regular.RegularUtil;

public class AbstractJDBCAdapter
extends AbstractDriverAdapter
implements JDBCAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public DatabaseType type() {
        return DatabaseType.COMMON;
    }

    public boolean supportCatalog() {
        return true;
    }

    public boolean supportSchema() {
        return true;
    }

    public String name(Type type) {
        return types.get(type);
    }

    public boolean match(DataRuntime runtime, String feature, String adapterKey, boolean compensate) {
        return super.match(runtime, feature, adapterKey, compensate);
    }

    public boolean match(String feature, List<String> keywords, boolean compensate) {
        return super.match(feature, keywords, compensate);
    }

    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    public long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        String name = dest.getName();
        if (name.contains("(")) {
            String[] cols;
            for (String col : cols = name.substring(name.indexOf("(") + 1, name.lastIndexOf(")")).split(",")) {
                dest.addColumn(new Column(col));
            }
            dest.setName(name.substring(0, name.indexOf("(")));
        }
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        swt = InterceptorProxy.prepareInsert((DataRuntime)runtime, (String)random, (Table)dest, (RunPrepare)prepare, (ConfigStore)configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareInsert(runtime, random, dest, prepare, configs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        org.anyline.data.run.Run run = this.buildInsertRun(runtime, dest, prepare, configs, obj, (Boolean)true, (Boolean)true, conditions);
        if (ConfigStore.IS_AUTO_CHECK_METADATA((ConfigStore)configs)) {
            dest.setColumns(this.columns(runtime, random, false, dest, false));
        }
        if (null == run) {
            return 0L;
        }
        long cnt = 0L;
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeInsert((DataRuntime)runtime, (String)random, (org.anyline.data.run.Run)run, (Table)dest, (RunPrepare)prepare, (ConfigStore)configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeInsert(runtime, random, run, dest, prepare, configs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        cnt = this.insert(runtime, random, prepare, configs, run, null);
        if (null != this.dmListener) {
            this.dmListener.afterInsert(runtime, random, run, cnt, dest, prepare, configs, cmd_success, cnt, millis);
        }
        InterceptorProxy.afterInsert((DataRuntime)runtime, (String)random, (org.anyline.data.run.Run)run, (Table)dest, (RunPrepare)prepare, (ConfigStore)configs, (boolean)cmd_success, (long)cnt, (long)(System.currentTimeMillis() - fr));
        return cnt;
    }

    public org.anyline.data.run.Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... conditions) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = run.getBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        this.checkName(runtime, null, dest);
        builder.append("INSERT INTO ");
        this.name(runtime, builder, (Metadata)dest);
        LinkedHashMap cols = dest.getColumns();
        if (null != cols && !cols.isEmpty()) {
            builder.append("(");
            boolean first = true;
            for (Column col : cols.values()) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                this.name(runtime, builder, col);
            }
            builder.append(")");
        }
        builder.append("\n");
        org.anyline.data.run.Run query = this.buildQueryRun(runtime, prepare, configs, placeholder, unicode, conditions);
        if (query.isValid()) {
            String cmd = query.getFinalQuery();
            builder.append(cmd);
            run.setValues(query.getRunValues());
        }
        return run;
    }

    public org.anyline.data.run.Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    public void fillInsertContent(DataRuntime runtime, org.anyline.data.run.Run run, Table dest, DataSet set, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        LinkedHashMap pks = null;
        this.checkName(runtime, null, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null != generator) {
            pks = set.getRow(0).getPrimaryColumns();
            columns.putAll(pks);
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (Metadata)dest);
        if (dest instanceof PartitionTable) {
            PartitionTable pt = (PartitionTable)dest;
            this.fillInsertCreateTemplate(runtime, run, pt, configs);
        }
        builder.append("(");
        this.delimiter(builder, Column.names(columns));
        builder.append(")");
        builder.append(" VALUES ");
        int dataSize = set.size();
        boolean el = ConfigStore.IS_AUTO_CHECK_EL_VALUE((ConfigStore)configs);
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue()) && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), BeanUtil.getMapKeys((Map)pks), null);
            }
            builder.append(this.insertValue(runtime, run, row, i == 0, true, placeholder, false, true, el, columns));
            if (batch > 1 || i >= dataSize - 1) continue;
            builder.append(this.batchInsertSeparator());
        }
        builder.append(this.insertFoot(configs, columns));
    }

    public void fillInsertContent(DataRuntime runtime, org.anyline.data.run.Run run, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        this.checkName(runtime, null, dest);
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, configs, placeholder, unicode, columns);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        Object first = list.iterator().next();
        LinkedHashMap pks = null;
        if (null != generator) {
            pks = EntityAdapterProxy.primaryKeys(first.getClass());
            columns.putAll(pks);
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (Metadata)dest);
        if (dest instanceof PartitionTable) {
            PartitionTable pt = (PartitionTable)dest;
            this.fillInsertCreateTemplate(runtime, run, pt, configs);
        }
        builder.append("(");
        this.delimiter(builder, Column.names(columns));
        builder.append(")");
        builder.append(" VALUES ");
        boolean el = ConfigStore.IS_AUTO_CHECK_EL_VALUE((ConfigStore)configs);
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (List)Column.names(columns));
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append(this.insertValue(runtime, run, obj, idx == 0, true, placeholder, false, true, el, columns));
            if (idx < dataSize - 1 && batch <= 1) {
                builder.append(this.batchInsertSeparator());
            }
            ++idx;
        }
        builder.append(this.insertFoot(configs, columns));
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    public String batchInsertSeparator() {
        return ",";
    }

    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    protected org.anyline.data.run.Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = run.getBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        this.checkName(runtime, null, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null == placeholder) {
            placeholder = configs.getPlaceholder();
        }
        if (null == placeholder) {
            placeholder = true;
        }
        int type = 1;
        StringBuilder valuesBuilder = new StringBuilder();
        DataRow row = null;
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (null == unicode) {
                unicode = row.getUnicode();
            }
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            type = 2;
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            LinkedHashMap pks = EntityAdapterProxy.primaryKeys(obj.getClass());
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
        }
        if (null == unicode) {
            unicode = configs.getUnicode();
        }
        run.setOriginType(type);
        LinkedHashMap<String, Column> cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        if (null == cols || cols.isEmpty()) {
            throw new CommandException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + obj.getClass().getName() + ":" + BeanUtil.object2json((Object)obj) + "]");
        }
        boolean replaceEmptyNull = false;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            replaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL((ConfigStore)configs);
        }
        boolean el = ConfigStore.IS_AUTO_CHECK_EL_VALUE((ConfigStore)configs);
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (Metadata)dest);
        builder.append("(");
        valuesBuilder.append(") VALUES (");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : cols.values()) {
            if (!first) {
                builder.append(", ");
                valuesBuilder.append(", ");
            }
            first = false;
            String key = column.getName();
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            }
            this.delimiter(builder, key);
            if (el && BasicUtil.checkEl((String)str)) {
                value = str.substring(2, str.length() - 1);
                valuesBuilder.append(value);
                continue;
            }
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                value = this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)value);
                valuesBuilder.append(value);
                continue;
            }
            insertColumns.add(key);
            if (this.supportInsertPlaceholder() && placeholder.booleanValue()) {
                if ("NULL".equals(value = this.convert(runtime, valuesBuilder, value, column, true, unicode, configs))) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                this.addRunValue(runtime, (org.anyline.data.run.Run)run, Compare.EQUAL, column, value);
                continue;
            }
            if (null == unicode) {
                unicode = false;
            }
            this.convert(runtime, valuesBuilder, value, column, false, unicode, configs);
        }
        valuesBuilder.append(")");
        builder.append((CharSequence)valuesBuilder);
        builder.append(this.insertFoot(configs, cols));
        run.setInsertColumns(insertColumns);
        return run;
    }

    protected org.anyline.data.run.Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public String generatedKey() {
        return super.generatedKey();
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, org.anyline.data.run.Run run, String[] pks) {
        return super.insert(runtime, random, data, configs, run, pks);
    }

    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public org.anyline.data.run.Run buildUpdateRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, placeholder, unicode, columns);
    }

    public org.anyline.data.run.Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected Boolean checkOverride(Object obj, ConfigStore configs) {
        return super.checkOverride(obj, configs);
    }

    protected Boolean checkOverrideSync(Object obj, ConfigStore configs) {
        return super.checkOverrideSync(obj, configs);
    }

    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        DataSet set;
        block11: {
            set = null;
            List inputs = procedure.getInputs();
            List outputs = procedure.getOutputs();
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][cmd:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            long millis = -1L;
            try {
                ACTION.SWITCH swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, procedure);
                }
                long fr = System.currentTimeMillis();
                set = this.actuator.querys((DriverAdapter)this, runtime, random, procedure, navi);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, DateUtil.format((long)millis), procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, procedure.getName(), inputs, outputs, true, (Object)set, millis);
                    }
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}]", (Object)random, (Object)DateUtil.format((long)millis));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("query \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    CommandQueryException ex = new CommandQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return set;
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    public org.anyline.data.run.Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    public List<org.anyline.data.run.Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    public org.anyline.data.run.Run fillQueryContent(DataRuntime runtime, org.anyline.data.run.Run run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    protected org.anyline.data.run.Run fillQueryContent(DataRuntime runtime, XMLRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    protected org.anyline.data.run.Run fillQueryContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    protected org.anyline.data.run.Run fillQueryContent(DataRuntime runtime, StringBuilder builder, TableRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, builder, run, placeholder, unicode);
    }

    protected org.anyline.data.run.Run fillQueryContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        StringBuilder builder = run.getBuilder();
        this.fillQueryContent(runtime, builder, run, placeholder, unicode);
        List unions = run.getUnions();
        if (null != unions) {
            for (org.anyline.data.run.Run union : unions) {
                builder.append("\n UNION ");
                if (union.isUnionAll()) {
                    builder.append(" ALL ");
                }
                builder.append("\n");
                this.fillQueryContent(runtime, builder, union, placeholder, unicode);
                run.getRunValues().addAll(union.getRunValues());
            }
        }
        run.appendOrderStore();
        run.checkValid();
        return run;
    }

    public String mergeFinalQuery(DataRuntime runtime, org.anyline.data.run.Run run) {
        return super.mergeFinalQuery(runtime, run);
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        RunValue rv = new RunValue();
        int code = compare.getCode();
        if (code > 100) {
            builder.append(" NOT");
            code -= 100;
        }
        if (null == value) {
            value = "";
        }
        if (placeholder.booleanValue()) {
            if (compare == Compare.LIKE_SIMPLE) {
                builder.append(" LIKE ?");
            } else if (code == 50) {
                builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?", "'%'"));
            } else if (code == 51) {
                builder.append(" LIKE ").append(this.concat(runtime, "?", "'%'"));
            } else if (code == 52) {
                builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?"));
            }
            rv.setValue(value);
        } else {
            value = BeanUtil.first((Object)value);
            rv.setPlaceholder(Boolean.valueOf(false));
            if (compare == Compare.LIKE_SIMPLE) {
                builder.append(" LIKE '").append(value).append("'");
            } else if (code == 50) {
                builder.append(" LIKE '%").append(value).append("%'");
            } else if (code == 51) {
                builder.append(" LIKE '").append(value).append("%'");
            } else if (code == 52) {
                builder.append(" LIKE '%").append(value).append("'");
            }
        }
        return rv;
    }

    public List<RunValue> createConditionExists(DataRuntime runtime, StringBuilder builder, Compare compare, RunPrepare prepare, Boolean placeholder, Boolean unicode) {
        ArrayList<RunValue> values = new ArrayList<RunValue>();
        org.anyline.data.run.Run run = this.buildQueryRun(runtime, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), placeholder, unicode, new String[0]);
        if (null != run) {
            String sql = run.getBaseQuery(placeholder);
            sql = BasicUtil.tab((String)sql);
            List vs = run.getValues();
            for (Object v : vs) {
                RunValue rv = new RunValue();
                rv.setValue(v);
                values.add(rv);
            }
            if (compare.getCode() == 19) {
                builder.append(" NOT");
            }
            builder.append(" EXISTS(\n").append(sql).append("\n)");
        }
        return values;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        return super.createConditionFindInSet(runtime, builder, column, compare, value, placeholder, unicode);
    }

    public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        Object first;
        Collection collection;
        RunPrepare prepare = null;
        if (value instanceof RunPrepare) {
            prepare = (RunPrepare)value;
        }
        if (value instanceof Collection && !(collection = (Collection)value).isEmpty() && (first = collection.iterator().next()) instanceof RunPrepare) {
            prepare = (RunPrepare)first;
        }
        if (null != prepare) {
            return this.createConditionIn(runtime, builder, compare, prepare, placeholder, unicode);
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                return null;
            }
            if (values.size() == 1) {
                return this.createConditionIn(runtime, builder, compare, values.iterator().next(), placeholder, unicode);
            }
            if (compare == Compare.NOT_IN) {
                builder.append(" NOT");
            }
            builder.append(" IN (");
            boolean first2 = true;
            for (Object v : values) {
                if (!first2) {
                    builder.append(", ");
                }
                first2 = false;
                if (placeholder.booleanValue()) {
                    this.convert(runtime, builder, value, null, placeholder, unicode, null);
                    continue;
                }
                if (v instanceof Number) {
                    builder.append(v);
                    continue;
                }
                builder.append("'").append(v).append("'");
            }
            builder.append(")");
        } else if (placeholder.booleanValue()) {
            if (compare == Compare.NOT_IN) {
                builder.append(" != ? ");
            } else {
                builder.append(" = ? ");
            }
        } else {
            if (compare == Compare.NOT_IN) {
                builder.append(" != ");
            } else {
                builder.append(" = ");
            }
            if (value instanceof Number) {
                builder.append(value);
            } else {
                builder.append("'").append(value).append("'");
            }
        }
        return null;
    }

    public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, RunPrepare prepare, Boolean placeholder, Boolean unicode) {
        ArrayList<RunValue> values = new ArrayList<RunValue>();
        org.anyline.data.run.Run run = this.buildQueryRun(runtime, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), placeholder, unicode, new String[0]);
        if (null != run) {
            if (compare == Compare.NOT_IN) {
                builder.append(" NOT");
            }
            builder.append(" IN (");
            String sql = run.getBaseQuery(placeholder);
            sql = BasicUtil.tab((String)sql);
            List vs = run.getValues();
            for (Object v : vs) {
                RunValue rv = new RunValue();
                rv.setValue(v);
                values.add(rv);
            }
            builder.append(sql).append(")\n");
        }
        return values;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, org.anyline.data.run.Run run) {
        if (run instanceof ProcedureRun) {
            ProcedureRun pr = (ProcedureRun)run;
            return this.querys(runtime, random, pr.getProcedure(), configs.getPageNavi());
        }
        String cmd = this.mergeFinalQuery(runtime, run);
        if (BasicUtil.isEmpty((Object)cmd)) {
            return new DataSet().setTable(table);
        }
        List values = run.getValues();
        return this.select(runtime, random, system, ACTION.DML.SELECT, table, configs, run, cmd, values);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.maps(runtime, random, configs, run);
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.map(runtime, random, configs, run);
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        List<org.anyline.data.run.Run> runs = this.buildQuerySequence(runtime, next, names);
        if (null != runs && !runs.isEmpty()) {
            org.anyline.data.run.Run run = runs.get(0);
            if (!run.isValid()) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][sequence:" + names);
                }
                return new DataRow();
            }
            DataSet set = this.select(runtime, random, true, (Table)null, null, run);
            if (!set.isEmpty()) {
                return set.getRow(0);
            }
        }
        return new DataRow();
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    public String mergeFinalTotal(DataRuntime runtime, org.anyline.data.run.Run run) {
        String base = run.getBuilder().toString();
        String sql = SQLUtil.mergeFinalTotal((String)base);
        return sql;
    }

    public long count(DataRuntime runtime, String random, org.anyline.data.run.Run run) {
        long total = 0L;
        DataSet set = this.select(runtime, random, false, ACTION.DML.COUNT, null, null, run, run.getTotalQuery(), run.getValues());
        total = ((DataSet)set.toUpperKey(new String[0])).getInt(0, "CNT", 0);
        return total;
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        org.anyline.data.run.Run run = this.buildQueryRun(runtime, prepare, configs, true, true, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTableName(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return false;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeExists(runtime, random, run);
        }
        long fr = System.currentTimeMillis();
        try {
            Map<String, Object> map = this.map(runtime, random, configs, run);
            result = null == map ? false : BasicUtil.parseBoolean((Object)map.get("IS_EXISTS"), (Boolean)false);
        }
        catch (Exception e) {
            return false;
        }
        Long millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterExists(runtime, random, run, true, result, millis.longValue());
        }
        return result;
    }

    public String mergeFinalExists(DataRuntime runtime, org.anyline.data.run.Run run) {
        String sql = "SELECT EXISTS(\n" + run.getBuilder().toString() + "\n) IS_EXISTS";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        boolean result;
        block11: {
            result = false;
            ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
            boolean cmd_success = false;
            List list = new ArrayList();
            List inputs = procedure.getInputs();
            List outputs = procedure.getOutputs();
            long fr = System.currentTimeMillis();
            String sql = " {";
            boolean returnIndex = false;
            if (procedure.hasReturn()) {
                sql = sql + "? = ";
                returnIndex = true;
            }
            sql = sql + "call " + procedure.getName() + "(";
            int sizeIn = inputs.size();
            int sizeOut = outputs.size();
            int size = sizeIn + sizeOut;
            for (int i = 0; i < size; ++i) {
                sql = sql + "?";
                if (i >= size - 1) continue;
                sql = sql + ",";
            }
            sql = sql + ")}";
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            long millis = -1L;
            try {
                list = this.actuator.execute((DriverAdapter)this, runtime, random, procedure, sql, inputs, outputs);
                cmd_success = true;
                procedure.setResult(list);
                result = true;
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, DateUtil.format((long)millis), sql, LogUtil.param((List)inputs), LogUtil.param(list)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, sql, inputs, list, true, (Object)result, millis);
                    }
                }
                if (null != this.dmListener) {
                    this.dmListener.afterExecute(runtime, random, procedure, result, millis);
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}]\n[output param:{}]", new Object[]{random, DateUtil.format((long)millis), list});
                }
            }
            catch (Exception e) {
                result = false;
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    CommandUpdateException ex = new CommandUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                    ex.setCmd(sql);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return result;
    }

    public org.anyline.data.run.Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    public void fillExecuteContent(DataRuntime runtime, org.anyline.data.run.Run run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    public List<org.anyline.data.run.Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRun(runtime, dest, configs, obj, placeholder, unicode, columns);
    }

    public List<org.anyline.data.run.Run> buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, configs, placeholder, unicode, key, values);
    }

    public List<org.anyline.data.run.Run> buildTruncateRun(DataRuntime runtime, Table table) {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode, String key, Object values) {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        if (null == table && null != configs) {
            table = configs.table();
        }
        if (!(null != table || null != key && null != values || null != configs && !configs.isEmptyCondition())) {
            return null;
        }
        TableRun run = new TableRun(runtime, table);
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            this.delimiter(builder, key);
            if (batch > 1) {
                builder.append(" = ?");
                ArrayList list = null;
                if (values instanceof List) {
                    list = (ArrayList)values;
                } else {
                    list = new ArrayList();
                    for (Object item : cons) {
                        list.add(item);
                    }
                }
                run.setValues(key, list);
                run.setVol(1);
                run.setBatch(batch);
            } else {
                if (cons.size() > 1) {
                    builder.append(" IN(");
                    int idx = 0;
                    for (Object obj : cons) {
                        if (idx > 0) {
                            builder.append(", ");
                        }
                        builder.append("?");
                        ++idx;
                    }
                    builder.append(")");
                } else if (cons.size() == 1) {
                    for (Object obj : cons) {
                        builder.append("=?");
                    }
                } else {
                    throw new CommandUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                }
                this.addRunValue(runtime, (org.anyline.data.run.Run)run, Compare.IN, new Column(key), values);
            }
        } else {
            this.delimiter(builder, key);
            builder.append("=?");
            this.addRunValue(runtime, (org.anyline.data.run.Run)run, Compare.EQUAL, new Column(key), values);
        }
        runs.add((org.anyline.data.run.Run)run);
        return runs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<org.anyline.data.run.Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        TableRun run = new TableRun(runtime, table);
        run.setOriginType(2);
        run.setConfigStore(configs);
        run.init();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)table);
        if (null == configs || configs.isEmptyCondition()) {
            builder.append(" WHERE ");
            List<String> keys = new ArrayList();
            if (null != columns && columns.length > 0) {
                for (String col : columns) {
                    keys.add(col);
                }
            } else if (obj instanceof DataRow) {
                keys = ((DataRow)obj).getPrimaryKeys();
            } else {
                keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
            }
            int size = keys.size();
            if (size <= 0) throw new CommandUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                this.delimiter(builder, key).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true));
                this.addRunValue(runtime, (org.anyline.data.run.Run)run, Compare.EQUAL, new Column(key), value);
            }
        } else {
            run.appendCondition((DriverAdapter)this, true, Boolean.valueOf(true), Boolean.valueOf(true));
        }
        run.setBuilder(builder);
        runs.add((org.anyline.data.run.Run)run);
        return runs;
    }

    public void fillDeleteRunContent(DataRuntime runtime, org.anyline.data.run.Run run, Boolean placeholder, Boolean unicode) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r, placeholder, unicode);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        List joins;
        AutoPrepare prepare = (AutoPrepare)run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)run.getTable());
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (RunPrepare join : joins) {
                Join jn = join.getJoin();
                builder.append("\n\t").append(jn.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String jionTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (Metadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)jionTableAlias)) {
                    builder.append("  ").append(jionTableAlias);
                }
                builder.append(" ON ").append(jn.getConditions().getRunText(runtime, Boolean.valueOf(false)));
            }
        }
        run.appendCondition((DriverAdapter)this, true, placeholder, unicode);
        run.appendGroup(runtime, placeholder, unicode);
        run.appendOrderStore();
        run.checkValid();
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, org.anyline.data.run.Run run) {
        return super.delete(runtime, random, configs, run);
    }

    public LinkedHashMap<String, Column> metadata(DataRuntime runtime, RunPrepare prepare, boolean comment) {
        LinkedHashMap columns = null;
        String random = this.random(runtime);
        long fr = System.currentTimeMillis();
        try {
            org.anyline.data.run.Run run = this.buildQueryRun(runtime, prepare, null, true, true, null);
            String sql = run.getFinalQuery(Boolean.valueOf(false));
            columns = this.actuator.metadata((DriverAdapter)this, runtime, random, run, comment);
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:metadata][\u6267\u884c\u8017\u65f6:{}]", (Object)random, (Object)DateUtil.format((long)(System.currentTimeMillis() - fr)));
            }
            if (comment) {
                HashMap<String, Object> tables = new HashMap<String, Object>();
                for (Column column : columns.values()) {
                    Table table = column.getTable(false);
                    if (null == table || !BasicUtil.isNotEmpty((Object)table.getName()) || tables.containsKey(table.getIdentity())) continue;
                    tables.put(table.getIdentity(), table);
                }
                String col_sql = sql.toUpperCase().split("FROM")[0];
                List chks = RegularUtil.fetch((String)col_sql, (String)"\\S+\\s+AS\\s+\\S+");
                for (Object col : chks) {
                    String[] tmps = ((String)col).split("AS");
                    String original = tmps[0];
                    String label = tmps[1];
                    if (original.contains(".")) {
                        String[] names = original.split("\\.");
                        String table = names[1];
                        original = names[1];
                    }
                    original = original.trim();
                    Column column = (Column)columns.get(label = label.trim());
                    if (null == column) continue;
                    column.setOriginName(original);
                }
                if (tables.isEmpty()) {
                    List tmps = RegularUtil.fetch((String)sql, (String)"(\\s+FROM\\s+\\S+)|(\\s+JOIN\\s+\\S+)");
                    for (String tmp : tmps) {
                        String name = tmp.trim().split("\\s+")[1].trim();
                        tables.put(name.toUpperCase(), new Table(name));
                    }
                }
                for (Table table : tables.values()) {
                    LinkedHashMap ccols = this.columns(runtime, random, false, table, false);
                    for (Column ccol : ccols.values()) {
                        String name = ccol.getName();
                        for (Column column : columns.values()) {
                            if (!column.getTableName(false).equals(ccol.getTableName(false))) continue;
                            String label = column.getName();
                            String original = column.getOriginName();
                            if (!name.equalsIgnoreCase(label) && !name.equalsIgnoreCase(original)) continue;
                            column.setComment(ccol.getComment());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            columns = new LinkedHashMap();
            e.printStackTrace();
        }
        log.info("{}[action:metadata][\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((long)(System.currentTimeMillis() - fr)), LogUtil.format((int)columns.size(), (int)34)});
        return columns;
    }

    public Database database(DataRuntime runtime, String random) {
        Catalog catalog = this.catalog(runtime, random);
        if (null != catalog) {
            return new Database(catalog.getName());
        }
        return super.database(runtime, random);
    }

    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, Database query) {
        return super.databases(runtime, random, greedy, query);
    }

    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, Database query) {
        return super.databases(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        return super.buildQueryProductRun(runtime);
    }

    public List<org.anyline.data.run.Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        return super.buildQueryVersionRun(runtime);
    }

    public List<org.anyline.data.run.Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query) throws Exception {
        return super.buildQueryDatabasesRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initDatabaseFieldRefer() {
        return super.initDatabaseFieldRefer();
    }

    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    public <T extends Database> List<T> databases(DataRuntime runtime, int index, boolean create, List<T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    public Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set) throws Exception {
        return super.database(runtime, index, create, meta, set);
    }

    public Database database(DataRuntime runtime, boolean create, Database meta) throws Exception {
        return super.database(runtime, create, meta);
    }

    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    public String product(DataRuntime runtime, boolean create, String product) {
        return this.actuator.product((DriverAdapter)this, runtime, create, product);
    }

    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    public String version(DataRuntime runtime, boolean create, String version) {
        return this.actuator.version((DriverAdapter)this, runtime, create, version);
    }

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, Catalog query) {
        return super.catalogs(runtime, random, query);
    }

    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, Catalog query) {
        return super.catalogs(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initCatalogFieldRefer() {
        return super.initCatalogFieldRefer();
    }

    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, meta, set);
    }

    public Catalog catalog(DataRuntime runtime, boolean create, Catalog meta) throws Exception {
        if (null == meta) {
            Table table = new Table();
            this.checkSchema(runtime, table);
            meta = table.getCatalog();
        }
        return meta;
    }

    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Schema query) {
        return super.schemas(runtime, random, query);
    }

    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Schema query) {
        return super.schemas(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initSchemaFieldRefer() {
        return super.initSchemaFieldRefer();
    }

    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    public Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set) throws Exception {
        return super.schema(runtime, index, create, meta, set);
    }

    public Schema schema(DataRuntime runtime, boolean create, Schema meta) throws Exception {
        if (null == meta) {
            Table table = new Table();
            this.checkSchema(runtime, table);
            meta = table.getSchema();
        }
        return meta;
    }

    public <T extends Metadata> T checkName(DataRuntime runtime, String random, T meta) throws RuntimeException {
        if (null == meta) {
            return null;
        }
        String name = meta.getName();
        if (null != name && name.contains(".")) {
            String[] ks = name.split("\\.");
            if (ks.length == 3) {
                meta.setCatalog(ks[0]);
                meta.setSchema(ks[1]);
                meta.setName(ks[2]);
            } else if (ks.length == 2) {
                meta.setSchema(ks[0]);
                meta.setName(ks[1]);
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5b9e\u522bschema\u6216catalog(\u5b50\u7c7b\u672a" + this.getClass().getSimpleName() + "\u5b9e\u73b0)");
            }
        }
        return meta;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, greedy, query, types, struct, configs);
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Table query, ConfigStore configs) {
        super.tableMap(runtime, random, greedy, query, configs);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, query, types, struct, configs);
    }

    public List<org.anyline.data.run.Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryTablesRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initTableFieldRefer() {
        return super.initTableFieldRefer();
    }

    public List<org.anyline.data.run.Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, query, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        return this.actuator.tables((DriverAdapter)this, runtime, create, previous, query, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        return this.actuator.tables((DriverAdapter)this, runtime, create, previous, query, types);
    }

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends Table> T init(DataRuntime runtime, int index, T meta, Table query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Table> T detail(DataRuntime runtime, int index, T meta, Table query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, View query, int types, int struct, ConfigStore configs) {
        return super.views(runtime, random, greedy, query, types, struct, configs);
    }

    protected void viewMap(DataRuntime runtime, String random, boolean greedy, View query, ConfigStore configs) {
        super.viewMap(runtime, random, greedy, query, configs);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        return super.views(runtime, random, query, types, struct, configs);
    }

    public List<org.anyline.data.run.Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, View query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryViewsRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initViewFieldRefer() {
        return super.initViewFieldRefer();
    }

    public List<org.anyline.data.run.Run> buildQueryViewsCommentRun(DataRuntime runtime, View query, int types) throws Exception {
        return super.buildQueryViewsCommentRun(runtime, query, types);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, View query, DataSet set) throws Exception {
        return super.views(runtime, index, create, previous, query, set);
    }

    public <T extends View> List<T> views(DataRuntime runtime, int index, boolean create, List<T> previous, View query, DataSet set) throws Exception {
        return super.views(runtime, index, create, previous, query, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        return this.actuator.views((DriverAdapter)this, runtime, create, previous, query, types);
    }

    public <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> previous, View query, int types) throws Exception {
        return this.actuator.views((DriverAdapter)this, runtime, create, previous, query, types);
    }

    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        return super.ddl(runtime, random, view, init);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlRun(runtime, view);
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    public <T extends View> T init(DataRuntime runtime, int index, T meta, View query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends View> T detail(DataRuntime runtime, int index, T meta, View query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        return super.masters(runtime, random, greedy, query, types, struct, configs);
    }

    protected void masterMap(DataRuntime runtime, String random, boolean greedy, MasterTable query, ConfigStore configs) {
        super.masterMap(runtime, random, greedy, query, configs);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, MasterTable query, int types, int struct, ConfigStore configs) {
        return super.masters(runtime, random, query, types, struct, configs);
    }

    public List<org.anyline.data.run.Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, MasterTable query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initMasterTableFieldRefer() {
        return super.initMasterTableFieldRefer();
    }

    public List<org.anyline.data.run.Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, MasterTable query, int types) throws Exception {
        return super.buildQueryMasterTablesCommentRun(runtime, query, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, MasterTable query, DataSet set) throws Exception {
        return super.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> List<T> masters(DataRuntime runtime, int index, boolean create, List<T> previous, MasterTable query, DataSet set) throws Exception {
        return super.masters(runtime, index, create, previous, query, set);
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, MasterTable meta, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, meta, ddls, set);
    }

    public <T extends MasterTable> T init(DataRuntime runtime, int index, T meta, MasterTable query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta, MasterTable query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        return super.partitions(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query, int types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, greedy, query, types);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, LinkedHashMap<String, T> previous, PartitionTable query, DataSet set) throws Exception {
        return super.partitions(runtime, total, index, create, previous, query, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query) throws Exception {
        return super.partitions(runtime, create, previous, query);
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, Column query, boolean primary, ConfigStore configs) {
        return super.columns(runtime, random, greedy, table, query, primary, configs);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Column query, ConfigStore configs) {
        return super.columns(runtime, random, greedy, tables, query, configs);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Column query) throws Exception {
        return this.actuator.metadata((DriverAdapter)this, runtime, create, previous, query);
    }

    public List<org.anyline.data.run.Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Column query, ConfigStore configs) throws Exception {
        Table table = query.getTable();
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        Catalog catalog = null;
        Schema schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, (Metadata)table);
            builder.append(" WHERE 1=0");
        }
        return runs;
    }

    public MetadataFieldRefer initColumnFieldRefer() {
        return super.initColumnFieldRefer();
    }

    public List<org.anyline.data.run.Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Collection<? extends Table> tables, Column query, ConfigStore configs) throws Exception {
        return super.buildQueryColumnsRun(runtime, metadata, tables, query, configs);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table table, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, table, query, set);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, query, set);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Collection<? extends Table> tables, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, tables, query, set);
    }

    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        if (null == meta) {
            meta = new Column();
        }
        Table table = query.getTable();
        MetadataFieldRefer refer = this.refer(runtime, Column.class);
        String catalog = row.getString(refer.maps("CATALOG"));
        String schema = row.getString(refer.maps("SCHEMA"));
        schema = (String)BasicUtil.evl((Object[])new String[]{schema, meta.getSchemaName()});
        if (null != table) {
            if (null == catalog) {
                catalog = table.getCatalogName();
            }
            if (null == schema) {
                schema = table.getSchemaName();
            }
        }
        if (null != catalog) {
            catalog = catalog.trim();
        }
        if (null != schema) {
            schema = schema.trim();
        }
        if (null == meta) {
            meta = new Column();
        }
        meta.setCatalog(catalog);
        meta.setSchema(schema);
        if (null != table) {
            meta.setTable(table);
        } else {
            String tableName = row.getString(refer.maps("TABLE"));
            table = new Table((String)BasicUtil.evl((Object[])new String[]{tableName, meta.getTableName(true), tableName}));
            table.setCatalog(catalog);
            table.setSchema(schema);
            meta.setTable(table);
        }
        String name = row.getString(refer.maps("NAME"));
        meta.setName(name);
        meta.setMetadata(row);
        return meta;
    }

    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        Boolean autoincrement;
        String tmp;
        if (null == meta) {
            return null;
        }
        MetadataFieldRefer refer = this.refer(runtime, Column.class);
        if (null == meta.getPosition()) {
            meta.setPosition(this.getInt(row, refer, "POSITION", null));
        }
        meta.setComment(this.getString(row, refer, "COMMENT", meta.getComment()));
        String type = this.getString(row, refer, "TYPE");
        if (null != type && type.contains(" ") && null != (tmp = row.getString(new String[]{"UDT_NAME", "DATA_TYPE", "TYPENAME", "DATA_TYPE_NAME"}))) {
            type = tmp;
        }
        meta.setOriginType((String)BasicUtil.evl((Object[])new String[]{type, meta.getTypeName()}));
        TypeMetadata typeMetadata = this.typeMetadata(runtime, meta);
        TypeMetadata.Refer trefer = this.dataTypeMetadataRefer(runtime, typeMetadata);
        String def = this.getString(row, refer, "DEFAULT_VALUE", meta.getDefaultValue() + "");
        def = def.trim();
        if (BasicUtil.isNotEmpty((Object)def)) {
            while (def.startsWith("(") && def.endsWith(")")) {
                def = def.substring(1, def.length() - 1);
            }
            while (def.startsWith("'") && def.endsWith("'")) {
                def = def.substring(1, def.length() - 1);
            }
            meta.setDefaultValue((Object)def);
        }
        meta.setDefaultConstraint(row.getString("DEFAULT_CONSTRAINT"));
        if (-1 == meta.isAutoIncrement()) {
            meta.autoIncrement(row.getBoolean("IS_AUTOINCREMENT", null));
        }
        if (-1 == meta.isAutoIncrement()) {
            meta.autoIncrement(row.getBoolean("IDENTITY", null));
        }
        if (-1 == meta.isAutoIncrement() && null != (autoincrement = this.matchBoolean(row, refer, "AUTO_INCREMENT_CHECK", "AUTO_INCREMENT_CHECK_VALUE")) && autoincrement.booleanValue()) {
            meta.autoIncrement(Boolean.valueOf(true));
        }
        meta.setObjectId(this.getLong(row, refer, "OBJECT_ID", null));
        Boolean primary = this.matchBoolean(row, refer, "PRIMARY_CHECK", "PRIMARY_CHECK_VALUE");
        if (null != primary && primary.booleanValue()) {
            meta.setPrimary(1);
        }
        if (row.getBoolean("PK", Boolean.FALSE).booleanValue()) {
            meta.primary(1);
        }
        if (-1 == meta.isNullable()) {
            try {
                meta.nullable(this.getBoolean(row, refer, "NULLABLE", null));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            Integer len = row.getInt(null, trefer.getLengthRefers());
            if (null == len) {
                len = -1;
            }
            meta.setLength(len);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            Integer precision = row.getInt(null, trefer.getPrecisionRefers());
            if (null == precision) {
                precision = -1;
            }
            meta.setPrecision(precision);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Integer scale = row.getInt(null, trefer.getScaleRefers());
            meta.setScale(scale);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (null == meta.getCharset()) {
            meta.setCharset(this.getString(row, refer, "CHARSET"));
        }
        if (null == meta.getCollate()) {
            meta.setCollate(this.getString(row, refer, "COLLATE"));
        }
        if (null == meta.getTypeMetadata()) {
            this.typeMetadata(runtime, meta);
        }
        return meta;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Tag query) {
        Table table = query.getTable();
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        String key = CacheProxy.key((DataRuntime)runtime, (String)"table_tags", (boolean)greedy, (Table)table);
        LinkedHashMap tags = CacheProxy.tags((String)key);
        if (null != tags && !tags.isEmpty()) {
            return tags;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            int qty_jdbc;
            int qty_metadata;
            int qty_dialect;
            int qty_total;
            block19: {
                qty_total = 0;
                qty_dialect = 0;
                qty_metadata = 0;
                qty_jdbc = 0;
                try {
                    List<org.anyline.data.run.Run> runs = this.buildQueryTagsRun(runtime, greedy, query);
                    if (null != runs) {
                        int idx = 0;
                        for (org.anyline.data.run.Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                            tags = this.tags(runtime, idx, true, tags, query, set);
                            ++idx;
                        }
                    }
                    if (null != tags) {
                        qty_dialect = tags.size();
                        qty_total = tags.size();
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block19;
                    e.printStackTrace();
                }
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[tags][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[tags][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, qty_metadata, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                log.error("tags exception:", (Throwable)e);
            }
            log.error("{}[tags][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != tags) {
            CacheProxy.cache((String)key, (Object)tags);
        } else {
            tags = new LinkedHashMap();
        }
        int index = 0;
        for (Tag tag : tags.values()) {
            if (null == tag.getPosition() || -1 == tag.getPosition()) {
                tag.setPosition(Integer.valueOf(index++));
            }
            if (tag.isAutoIncrement() != 1) {
                tag.autoIncrement(Boolean.valueOf(false));
            }
            if (tag.isPrimaryKey() != 1) {
                tag.setPrimary(Boolean.valueOf(false));
            }
            if (null != tag.getTable() || greedy) continue;
            tag.setTable(table);
        }
        return tags;
    }

    public List<org.anyline.data.run.Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query) throws Exception {
        return super.buildQueryTagsRun(runtime, greedy, query);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Tag query, DataSet set) throws Exception {
        return super.tags(runtime, index, create, previous, query, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Tag query) throws Exception {
        return super.tags(runtime, create, tags, query);
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, PrimaryKey query) {
        return super.primary(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, PrimaryKey query) throws Exception {
        return super.buildQueryPrimaryRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initPrimaryKeyFieldRefer() {
        return super.initPrimaryKeyFieldRefer();
    }

    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        return (T)super.init(runtime, index, primary, query, set);
    }

    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, PrimaryKey query, DataSet set) throws Exception {
        return (T)super.detail(runtime, index, meta, query, set);
    }

    public PrimaryKey primary(DataRuntime runtime, PrimaryKey query) throws Exception {
        return super.primary(runtime, query);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, ForeignKey query) {
        return super.foreigns(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, ForeignKey query) throws Exception {
        return super.buildQueryForeignsRun(runtime, greedy, query);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, LinkedHashMap<String, T> previous, ForeignKey query, DataSet set) throws Exception {
        return super.foreigns(runtime, index, previous, query, set);
    }

    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Index query) {
        return super.indexes(runtime, random, greedy, query);
    }

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Index query) {
        return super.indexes(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Index query) {
        return super.buildQueryIndexesRun(runtime, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Collection<? extends Table> tables) {
        return super.buildQueryIndexesRun(runtime, greedy, tables);
    }

    public MetadataFieldRefer initIndexFieldRefer() {
        return super.initIndexFieldRefer();
    }

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, List<T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Index query) throws Exception {
        return this.actuator.indexes((DriverAdapter)this, runtime, create, previous, query);
    }

    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Constraint query) {
        return super.constraints(runtime, random, greedy, query);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Constraint query) {
        return super.constraints(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        return super.buildQueryConstraintsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initConstraintFieldRefer() {
        return super.initConstraintFieldRefer();
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, List<T> previous, Constraint query, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, previous, query, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Constraint query, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, previous, query, set);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Trigger query) {
        return super.triggers(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query) {
        return super.buildQueryTriggersRun(runtime, greedy, query);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Trigger query, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, previous, query, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Procedure query) {
        return super.procedures(runtime, random, greedy, query);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Procedure query) {
        return super.procedures(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query) {
        return super.buildQueryProceduresRun(runtime, greedy, query);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Procedure query, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, previous, query, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlRun(runtime, procedure);
    }

    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Function query) {
        return super.functions(runtime, random, greedy, query);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Function query) {
        return super.functions(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query) {
        return super.buildQueryFunctionsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initFunctionFieldRefer() {
        return super.initFunctionFieldRefer();
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> previous, Function query) throws Exception {
        return super.functions(runtime, create, previous, query);
    }

    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Sequence query) {
        return super.sequences(runtime, random, greedy, query);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Sequence query) {
        return super.sequences(runtime, random, query);
    }

    public List<org.anyline.data.run.Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query) {
        return super.buildQuerySequencesRun(runtime, greedy, query);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> previous, Sequence query) throws Exception {
        return super.sequences(runtime, create, previous, query);
    }

    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<org.anyline.data.run.Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    public <T extends Metadata> T search(List<T> metas, Catalog catalog, Schema schema, String name) {
        return (T)super.search(metas, catalog, schema, name);
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return (T)super.schema(schemas, catalog, name);
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return (T)super.catalog(catalogs, name);
    }

    public <T extends Database> T database(List<T> databases, String name) {
        return (T)super.database(databases, name);
    }

    public Object convert(DataRuntime runtime, StringBuilder builder, Object value, Column column, Boolean placeholder, Boolean unicode, ConfigStore configs) {
        if (placeholder.booleanValue()) {
            builder.append("?");
        } else {
            Object write = this.write(runtime, column, value, false, unicode);
            builder.append(write);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, org.anyline.data.run.Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        run.action((ACTION)action);
        if (BasicUtil.isNotEmpty((Object)sql)) {
            meta.addRun((Run)run);
            if (meta.execute()) {
                try {
                    this.update(runtime, random, null, null, null, run);
                }
                finally {
                    CacheProxy.clear();
                }
            }
            result = true;
        }
        return result;
    }

    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, (Metadata)meta);
        if (BasicUtil.isNotEmpty((Object)meta.getMasterName())) {
            this.partitionOf(runtime, builder, meta);
        }
        this.partitionFor(runtime, builder, meta);
        this.body(runtime, builder, meta);
        this.partitionBy(runtime, builder, meta);
        this.inherit(runtime, builder, meta);
        this.engine(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.keys(runtime, builder, meta);
        this.distribution(runtime, builder, meta);
        this.materialize(runtime, builder, meta);
        this.property(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        runs.addAll(this.buildAppendColumnCommentRun(runtime, meta));
        runs.addAll(this.buildAppendPrimaryRun(runtime, meta));
        runs.addAll(this.buildAppendIndexRun(runtime, meta));
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, meta, columns);
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, true);
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        pks = null != primary ? primary.getColumns() : meta.primarys();
        if (!pks.isEmpty() && pks.size() > 1) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            for (Column pk : pks.values()) {
                if (!first) {
                    builder.append(", ");
                }
                this.delimiter(builder, pk.getName());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta) {
        String params;
        String engine = meta.getEngine();
        if (BasicUtil.isNotEmpty((Object)engine)) {
            builder.append("\nENGINE = ").append(engine);
        }
        if (BasicUtil.isNotEmpty((Object)(params = meta.getEngineParameters()))) {
            builder.append(" ").append(params);
        }
        return builder;
    }

    public StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta) {
        LinkedHashMap columns = meta.getColumns();
        if ((null == columns || columns.isEmpty()) && BasicUtil.isEmpty((Object)meta.getInherit())) {
            return builder;
        }
        builder.append("(");
        this.columns(runtime, builder, meta);
        this.indexes(runtime, builder, meta);
        builder.append(")");
        return builder;
    }

    public StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table meta) {
        LinkedHashMap columMap = meta.getColumns();
        Collection columns = null;
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        if (null != primary) {
            pks = primary.getColumns();
        } else {
            pks = meta.primarys();
            primary = new PrimaryKey();
            primary.setTable(meta);
            for (Column col : pks.values()) {
                primary.addColumn(col);
            }
            meta.setPrimaryKey(primary);
        }
        if (null == pks) {
            pks = new LinkedHashMap();
        }
        if (null != columMap && null != (columns = columMap.values()) && !columns.isEmpty()) {
            int idx = 0;
            for (Column column : columns) {
                TypeMetadata metadata = column.getTypeMetadata();
                if (null == metadata) {
                    metadata = this.typeMetadata(runtime, column);
                    column.setTypeMetadata(metadata);
                }
                if (pks.containsKey(column.getName().toUpperCase())) {
                    column.setNullable(Boolean.valueOf(false));
                }
                builder.append("\n\t");
                if (idx > 0) {
                    builder.append(", ");
                }
                column.setAction(ACTION.DDL.COLUMN_ADD);
                this.delimiter(builder, column.getName(), false).append(" ");
                this.define(runtime, builder, column, ACTION.DDL.TABLE_CREATE);
                ++idx;
            }
            if (!pks.isEmpty()) {
                builder.append("\n\t");
                this.primary(runtime, builder, meta);
            }
        }
        return builder;
    }

    public StringBuilder indexes(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.indexes(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.keys(runtime, builder, meta);
    }

    public StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.distribution(runtime, builder, meta);
    }

    public StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.materialize(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (null != meta.getProperty()) {
            builder.append(" ").append(meta.getProperty());
        }
        return builder;
    }

    public StringBuilder option(DataRuntime runtime, StringBuilder builder, Table meta) {
        List options = meta.options();
        if (null != options && !options.isEmpty()) {
            builder.append("\n");
            for (String option : options) {
                builder.append(option).append("\n");
            }
        }
        return builder;
    }

    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table.Partition partition = meta.getPartition();
        if (null == partition) {
            return builder;
        }
        if (null != meta.getMaster()) {
            return builder;
        }
        Table.Partition.TYPE type = partition.getType();
        if (null == type) {
            return builder;
        }
        builder.append(" PARTITION BY ").append(type.name()).append("(");
        LinkedHashMap columns = partition.getColumns();
        if (null != columns) {
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
        }
        builder.append(")");
        return builder;
    }

    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table master = meta.getMaster();
        if (null == master) {
            return builder;
        }
        builder.append(" PARTITION OF ");
        if (null == master) {
            throw new CommandException("\u672a\u63d0\u4f9b Master Table");
        }
        this.name(runtime, builder, (Metadata)master);
        return builder;
    }

    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table master = meta.getMaster();
        if (null == master) {
            return builder;
        }
        Table.Partition partition = meta.getPartition();
        Table.Partition.TYPE type = null;
        if (null != partition) {
            type = partition.getType();
        }
        if (null == type && null != master.getPartition()) {
            type = master.getPartition().getType();
        }
        if (null == type) {
            return builder;
        }
        builder.append(" FOR VALUES");
        if (type == Table.Partition.TYPE.LIST) {
            List list = partition.getValues();
            if (null == list) {
                throw new CommandException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u679a\u4e3e\u503c(Partition.list)");
            }
            builder.append(" IN(");
            boolean first = true;
            for (Object item : list) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                if (item instanceof Number) {
                    builder.append(item);
                    continue;
                }
                builder.append("'").append(item).append("'");
            }
            builder.append(")");
        } else if (type == Table.Partition.TYPE.RANGE) {
            Object from = partition.getMin();
            Object to = partition.getMax();
            if (BasicUtil.isEmpty((Object)from) || BasicUtil.isEmpty((Object)to)) {
                throw new CommandException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u8303\u56f4\u503c(Partition.from/to)");
            }
            builder.append(" FROM (");
            if (from instanceof Number) {
                builder.append(from);
            } else {
                builder.append("'").append(from).append("'");
            }
            builder.append(")");
            builder.append(" TO (");
            if (to instanceof Number) {
                builder.append(to);
            } else {
                builder.append("'").append(to).append("'");
            }
            builder.append(")");
        } else if (type == Table.Partition.TYPE.HASH) {
            int modulus = partition.getModulus();
            if (modulus == 0) {
                throw new CommandException("\u672a\u63d0\u4f9b\u5206\u533a\u8868MODULUS");
            }
            builder.append(" WITH(MODULUS ").append(modulus).append(",REMAINDER ").append(partition.getRemainder()).append(")");
        }
        return builder;
    }

    public StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (BasicUtil.isNotEmpty((Object)meta.getInherit())) {
            LinkedHashMap columns = meta.getColumns();
            if (null == columns || columns.isEmpty()) {
                // empty if block
            }
            builder.append(" INHERITS(");
            this.name(runtime, builder, (Metadata)meta.getInherit());
            builder.append(")");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        this.buildCreateRunHead(runtime, builder, meta);
        this.buildCreateRunOption(runtime, builder, meta);
        builder.append(" AS \n").append(meta.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append("CREATE VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        return builder;
    }

    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunOption(runtime, builder, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" AS \n").append(meta.getDefinition());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(meta.getKeyword()).append(" ");
        this.checkViewExists(runtime, builder, true);
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        this.addColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, meta, ACTION.DDL.COLUMN_ADD);
        this.addColumnClose(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta, slice));
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            List<org.anyline.data.run.Run> cmts;
            String ucomment;
            String comment;
            List<org.anyline.data.run.Run> nulls;
            int unullable;
            int nullable;
            List<org.anyline.data.run.Run> defs;
            List list;
            String uname;
            String name;
            if (null == update.getTable(false)) {
                update.setTable(meta.getTable(false));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(name = meta.getName()), (Object)(uname = update.getName())) && !uname.endsWith(ConfigTable.ALTER_COLUMN_TYPE_SUFFIX)) {
                runs.addAll(this.buildRenameRun(runtime, meta, slice));
            }
            String type = this.type(runtime, null, meta).toString();
            String utype = this.type(runtime, null, update).toString();
            boolean exe = false;
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, meta);
                if (null != list) {
                    runs.addAll(list);
                    exe = true;
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, meta))) {
                runs.addAll(list);
                exe = true;
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef) && null != (defs = this.buildChangeDefaultRun(runtime, meta, slice))) {
                runs.addAll(defs);
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable()) && null != (nulls = this.buildChangeNullableRun(runtime, meta, slice))) {
                runs.addAll(nulls);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment())) && null != (cmts = this.buildChangeCommentRun(runtime, meta, slice))) {
                runs.addAll(cmts);
            }
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        if (meta instanceof Tag) {
            Tag tag = (Tag)meta;
            return this.buildDropRun(runtime, tag, slice);
        }
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        this.dropColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.name(runtime, builder, (Column)meta.getUpdate());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeTypeRun(runtime, meta, slice);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" ADD ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public List<org.anyline.data.run.Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeNullableRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeCommentRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAppendCommentRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta, slice);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.define(runtime, builder, meta, action);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        int ignoreLength = -1;
        int ignorePrecision = -1;
        int ignoreScale = -1;
        String typeName = meta.getTypeName();
        TypeMetadata type = this.typeMetadata(runtime, meta);
        if (null != type) {
            if (!type.support()) {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301:" + meta.getName() + " " + typeName);
            }
            typeName = type.getName();
        }
        MetadataFieldRefer refer = this.refer(runtime, Column.class);
        TypeMetadata.Refer trefer = this.dataTypeMetadataRefer(runtime, type);
        ignoreLength = trefer.ignoreLength();
        ignorePrecision = trefer.ignorePrecision();
        ignoreScale = trefer.ignoreScale();
        return this.type(runtime, builder, meta, typeName, ignoreLength, ignorePrecision, ignoreScale);
    }

    public StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.aggregation(runtime, builder, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.nullable(runtime, builder, meta, action);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    public StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.unique(runtime, builder, meta);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.increment(runtime, builder, meta);
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" ADD TAG ");
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, (Column)meta, ACTION.DDL.COLUMN_ADD);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        Tag update = meta.getUpdate();
        if (null != update) {
            String ucomment;
            String comment;
            int unullable;
            int nullable;
            List list;
            String uname;
            String name = meta.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith(ConfigTable.ALTER_COLUMN_TYPE_SUFFIX)) {
                runs.addAll(this.buildRenameRun(runtime, meta, slice));
            }
            meta.setName(uname);
            String type = this.type(runtime, null, (Column)meta).toString();
            String utype = this.type(runtime, null, (Column)update).toString();
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, (Column)meta);
                if (null != list) {
                    runs.addAll(list);
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, (Column)meta))) {
                runs.addAll(list);
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef)) {
                runs.addAll(this.buildChangeDefaultRun(runtime, meta, slice));
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable())) {
                runs.addAll(this.buildChangeNullableRun(runtime, meta, slice));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment()))) {
                runs.addAll(this.buildChangeCommentRun(runtime, meta, slice));
            }
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.name(runtime, builder, (Column)meta.getUpdate());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeNullableRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeCommentRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeTypeRun(runtime, meta, slice);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, origin, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        if (null != meta) {
            Table table = null;
            table = null != meta ? meta.getTable() : origin.getTable();
            if (null != origin) {
                runs.addAll(this.buildDropRun(runtime, origin, slice));
            }
            if (null != meta && !meta.isDrop()) {
                runs.addAll(this.buildAddRun(runtime, meta, slice));
            }
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
        } else {
            run.slice(slice);
        }
        builder.append(" DROP CONSTRAINT ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            String onUpdate;
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
            builder.append(" ADD");
            if (BasicUtil.isNotEmpty((Object)meta.getName())) {
                builder.append(" CONSTRAINT ").append(meta.getName());
            }
            builder.append(" FOREIGN KEY (");
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
            builder.append(" REFERENCES ").append(meta.getReference().getName()).append("(");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(", ");
                }
                this.name(runtime, builder, column.getReference());
                first = false;
            }
            builder.append(")");
            String onDelete = meta.onDelete();
            if (BasicUtil.isNotEmpty((Object)onDelete)) {
                builder.append(" ON DELETE ").append(onDelete);
            }
            if (BasicUtil.isNotEmpty((Object)(onUpdate = meta.onUpdate()))) {
                builder.append(" ON UPDATE ").append(onUpdate);
            }
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        builder.append(" DROP FOREIGN KEY ").append(meta.getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        String name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "index_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE");
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        } else if (meta.isFulltext()) {
            builder.append(" FULLTEXT");
        } else if (meta.isSpatial()) {
            builder.append(" SPATIAL");
        }
        builder.append(" INDEX ");
        this.delimiter(builder, meta.getName(), false);
        builder.append(" ON ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append("(");
        int qty = 0;
        LinkedHashMap columns = meta.getColumns();
        Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
        for (Column column : columns.values()) {
            if (qty > 0) {
                builder.append(", ");
            }
            this.delimiter(builder, column.getName(), false);
            Order.TYPE order = meta.getOrder(column.getName());
            if (BasicUtil.isNotEmpty((Object)order)) {
                builder.append(" ").append(order);
            }
            ++qty;
        }
        builder.append(")");
        this.type(runtime, builder, meta);
        this.property(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        List<org.anyline.data.run.Run> runs = this.buildDropRun(runtime, meta);
        Index update = (Index)meta.getUpdate();
        if (null != update) {
            runs.addAll(this.buildAddRun(runtime, update));
        } else {
            runs.addAll(this.buildAddRun(runtime, meta));
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        if (meta.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)table);
            builder.append(" DROP CONSTRAINT ");
            this.name(runtime, builder, (Metadata)meta);
        } else {
            builder.append("DROP INDEX ");
            this.name(runtime, builder, (Metadata)meta);
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append(" ON ");
                this.name(runtime, builder, (Metadata)table);
            }
        }
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.property(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkIndexExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        String name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "constraint_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append(" ADD CONSTRAINT ").append(name);
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        }
        builder.append("(");
        boolean first = true;
        Collection cols = meta.getColumns().values();
        for (Column column : cols) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            this.delimiter(builder, column.getName(), false);
            String order = column.getOrder();
            if (!BasicUtil.isNotEmpty((Object)order)) continue;
            builder.append(" ").append(order);
        }
        builder.append(")");
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append(" DROP CONSTRAINT ").append(meta.getName());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER CONSTRAINT ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, meta.getUpdate().getName());
        return runs;
    }

    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(meta.getName());
        builder.append(" ").append(meta.getTime().sql()).append(" ");
        List events = meta.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" ON ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        this.each(runtime, builder, meta);
        builder.append("\n").append(meta.getDefinition());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        builder.append("ALTER TRIGGER ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.name(runtime, builder, (Metadata)catalog).append(".");
        }
        if (!this.empty((Metadata)schema)) {
            this.name(runtime, builder, (Metadata)schema).append(".");
        }
        this.delimiter(builder, meta.getName());
        builder.append(" RENAME TO ");
        this.name(runtime, builder, meta.getUpdate());
        return runs;
    }

    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (meta.isEach()) {
            builder.append(" FOR EACH ROW ");
        } else {
            builder.append(" FOR EACH STATEMENT ");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE PROCEDURE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append("(\n");
        List ins = meta.getInputs();
        List outs = meta.getOutputs();
        boolean first = true;
        for (Parameter parameter : ins) {
            if (parameter.isOutput()) continue;
            if (!first) {
                builder.append(", ");
            }
            this.parameter(runtime, builder, parameter);
        }
        for (Parameter parameter : outs) {
            if (!first) {
                builder.append(", ");
            }
            this.parameter(runtime, builder, parameter);
        }
        builder.append("\n)");
        String returnType = meta.getReturnType();
        if (BasicUtil.isNotEmpty((Object)returnType)) {
            builder.append(" RETURNS ").append(returnType);
        }
        builder.append("\n");
        builder.append(meta.getDefinition());
        return runs;
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP PROCEDURE ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER PROCEDURE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.name(runtime, builder, meta.getUpdate());
        return runs;
    }

    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        boolean in = parameter.isInput();
        boolean out = parameter.isOutput();
        if (in) {
            builder.append("IN");
        }
        if (out) {
            builder.append("OUT");
        }
        builder.append(" ").append(parameter.getName());
        TypeMetadata type = parameter.getColumnType();
        Column column = new Column();
        column.setTypeMetadata(type);
        TypeMetadata.Refer adapter = this.dataTypeMetadataRefer(runtime, type);
        TypeMetadata.Refer config = this.dataTypeMetadataRefer(runtime, type);
        int ignoreLength = config.ignoreLength();
        int ignorePrecision = config.ignorePrecision();
        int ignoreScale = config.ignoreScale();
        this.type(runtime, builder, column, type.getName(), ignoreLength, ignorePrecision, ignoreScale);
        return builder;
    }

    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP FUNCTION ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER FUNCTION ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, ((Function)meta.getUpdate()).getName());
        return runs;
    }

    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP SEQUENCE ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<org.anyline.data.run.Run> runs = new ArrayList<org.anyline.data.run.Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((org.anyline.data.run.Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER SEQUENCE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, ((Sequence)meta.getUpdate()).getName());
        return runs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, org.anyline.data.run.Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        run.action((ACTION)action);
        if (BasicUtil.isNotEmpty((Object)sql)) {
            meta.addRun((Run)run);
            if (meta.execute()) {
                try {
                    this.update(runtime, random, null, null, null, run);
                }
                finally {
                    CacheProxy.clear();
                }
            }
            result = true;
        }
        return result;
    }

    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, List<org.anyline.data.run.Run> runs) {
        return super.execute(runtime, random, meta, action, runs);
    }

    public boolean create(DataRuntime runtime, Role role) throws Exception {
        return super.create(runtime, role);
    }

    public boolean rename(DataRuntime runtime, Role origin, Role update) throws Exception {
        return super.rename(runtime, origin, update);
    }

    public boolean drop(DataRuntime runtime, Role role) throws Exception {
        return super.drop(runtime, role);
    }

    public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy, Role query) throws Exception {
        return super.roles(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, Role role) throws Exception {
        return super.buildCreateRun(runtime, role);
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, Role origin, Role update) throws Exception {
        return super.buildRenameRun(runtime, origin, update);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, Role role) throws Exception {
        return super.buildDropRun(runtime, role);
    }

    public List<org.anyline.data.run.Run> buildQueryRolesRun(DataRuntime runtime, boolean greedy, Role query) throws Exception {
        return super.buildQueryRolesRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initRoleFieldRefer() {
        return super.initRoleFieldRefer();
    }

    public <T extends Role> List<T> roles(DataRuntime runtime, int index, boolean create, List<T> previous, Role query, DataSet set) throws Exception {
        return super.roles(runtime, index, create, previous, query, set);
    }

    public <T extends Role> T init(DataRuntime runtime, int index, T meta, Role query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Role> T detail(DataRuntime runtime, int index, T meta, Role query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public boolean create(DataRuntime runtime, User user) throws Exception {
        return super.create(runtime, user);
    }

    public boolean rename(DataRuntime runtime, User origin, User update) throws Exception {
        return super.rename(runtime, origin, update);
    }

    public boolean drop(DataRuntime runtime, User user) throws Exception {
        return super.drop(runtime, user);
    }

    public <T extends User> List<T> users(DataRuntime runtime, String random, boolean greedy, User query) throws Exception {
        return super.users(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildCreateRun(DataRuntime runtime, User user) throws Exception {
        return super.buildCreateRun(runtime, user);
    }

    public List<org.anyline.data.run.Run> buildRenameRun(DataRuntime runtime, User origin, User update) throws Exception {
        return super.buildRenameRun(runtime, origin, update);
    }

    public List<org.anyline.data.run.Run> buildDropRun(DataRuntime runtime, User user) throws Exception {
        return super.buildDropRun(runtime, user);
    }

    public List<org.anyline.data.run.Run> buildQueryUsersRun(DataRuntime runtime, boolean greedy, User query) throws Exception {
        return super.buildQueryUsersRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initUserFieldRefer() {
        return super.initUserFieldRefer();
    }

    public <T extends User> List<T> users(DataRuntime runtime, int index, boolean create, List<T> previous, User query, DataSet set) throws Exception {
        return super.users(runtime, index, create, previous, query, set);
    }

    public <T extends User> T init(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends User> T detail(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public <T extends Privilege> List<T> privileges(DataRuntime runtime, String random, boolean greedy, Privilege query) throws Exception {
        return super.privileges(runtime, random, greedy, query);
    }

    public List<org.anyline.data.run.Run> buildQueryPrivilegesRun(DataRuntime runtime, boolean greedy, Privilege query) throws Exception {
        return super.buildQueryPrivilegesRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initPrivilegeFieldRefer() {
        return super.initPrivilegeFieldRefer();
    }

    public <T extends Privilege> List<T> privileges(DataRuntime runtime, int index, boolean create, List<T> previous, Privilege query, DataSet set) throws Exception {
        return super.privileges(runtime, index, create, previous, query, set);
    }

    public <T extends Privilege> T init(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Privilege> T detail(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    public boolean grant(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.grant(runtime, user, privileges);
    }

    public boolean grant(DataRuntime runtime, User user, Role ... roles) throws Exception {
        return super.grant(runtime, user, roles);
    }

    public boolean grant(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        return super.grant(runtime, role, privileges);
    }

    public List<org.anyline.data.run.Run> buildGrantRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.buildGrantRun(runtime, user, privileges);
    }

    public List<org.anyline.data.run.Run> buildGrantRun(DataRuntime runtime, User user, Role ... roles) throws Exception {
        return super.buildGrantRun(runtime, user, roles);
    }

    public List<org.anyline.data.run.Run> buildGrantRun(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        return super.buildGrantRun(runtime, role, privileges);
    }

    public boolean revoke(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.revoke(runtime, user, privileges);
    }

    public boolean revoke(DataRuntime runtime, User user, Role ... roles) throws Exception {
        return super.revoke(runtime, user, roles);
    }

    public boolean revoke(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        return super.revoke(runtime, role, privileges);
    }

    public List<org.anyline.data.run.Run> buildRevokeRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.buildRevokeRun(runtime, user, privileges);
    }

    public List<org.anyline.data.run.Run> buildRevokeRun(DataRuntime runtime, User user, Role ... roles) throws Exception {
        return super.buildRevokeRun(runtime, user, roles);
    }

    public List<org.anyline.data.run.Run> buildRevokeRun(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        return super.buildRevokeRun(runtime, role, privileges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet select(DataRuntime runtime, String random, boolean system, ACTION.DML action, Table table, ConfigStore configs, org.anyline.data.run.Run run, String sql, List<Object> values) {
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (BasicUtil.isEmpty((Object)sql)) {
            if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION((ConfigStore)configs)) {
                throw new CommandQueryException("\u672a\u6307\u5b9a\u547d\u4ee4");
            }
            log.error("\u672a\u6307\u5b9a\u547d\u4ee4");
            return new DataSet().setTable(table);
        }
        configs.add(run);
        if (null == random) {
            random = this.random(runtime);
        }
        DataSet set = new DataSet();
        set.setTable(table);
        boolean exe = configs.execute();
        if (!exe) {
            if (!log.isInfoEnabled()) return set;
            if (!ConfigStore.IS_LOG_SQL((ConfigStore)configs)) return set;
            log.info("{}[action:select][\u8df3\u8fc7\u6267\u884c]{}", (Object)random, (Object)run.log(action, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))));
            return set;
        }
        LinkedHashMap columns = new LinkedHashMap();
        if (!system && ConfigStore.IS_AUTO_CHECK_METADATA((ConfigStore)configs) && null != table) {
            columns = this.columns(runtime, random, false, table, false);
        }
        TransactionState prepare_state = null;
        try {
            DataRuntime rt = runtime;
            boolean[] process = new boolean[]{false};
            List prepares = configs.prepares();
            if (null != prepares && !prepares.isEmpty()) {
                prepare_state = TransactionProxy.start();
                for (RunPrepare prepare : prepares) {
                    long fr = System.currentTimeMillis();
                    org.anyline.data.run.Run r = this.buildQueryRun(runtime, prepare, configs, true, true, new String[0]);
                    log.warn("{}[action:execute][\u524d\u7f6e\u547d\u4ee4][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, DateUtil.format((long)(System.currentTimeMillis() - fr)), r.log(ACTION.DML.SELECT, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)))});
                    this.actuator.execute((DriverAdapter)this, runtime, random, configs, r);
                }
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(action, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))));
            }
            set = this.actuator.select((DriverAdapter)this, runtime, random, system, action, table, configs, run, sql, values, columns);
            LinkedHashMap metadatas = set.getMetadatas();
            if (!system && (null == metadatas || metadatas.isEmpty()) && ConfigStore.IS_CHECK_EMPTY_SET_METADATA((ConfigStore)configs)) {
                metadatas.putAll(this.metadata(runtime, (RunPrepare)new DefaultTextPrepare(sql), false));
            }
            boolean slow = false;
            long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
            long times = configs.getLastExecuteTime();
            if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && times > SLOW_SQL_MILLIS) {
                slow = true;
                log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, DateUtil.format((long)times), run.log(ACTION.DML.SELECT, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)))});
                if (null != this.dmListener) {
                    this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, (Object)set, times);
                }
            }
            if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}]", (Object)random, (Object)DateUtil.format((long)times));
                log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((long)configs.getLastPackageTime()), set.size()});
            }
            if ((!system || !ConfigStore.IS_LOG_QUERY_RESULT_EXCLUDE_METADATA((ConfigStore)configs)) && ConfigStore.IS_LOG_QUERY_RESULT((ConfigStore)configs) && log.isInfoEnabled()) {
                log.info("{}[\u67e5\u8be2\u7ed3\u679c]{}", (Object)random, (Object)LogUtil.table((DataSet)set));
            }
            set.setDatalink(runtime.datasource());
            if (null == prepare_state) return set;
        }
        catch (Exception e) {
            if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                e.printStackTrace();
            }
            if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)))});
            }
            if (!ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION((ConfigStore)configs)) return set;
            CommandQueryException ex = new CommandQueryException("query\u5f02\u5e38:" + e.toString(), e);
            ex.setCmd(sql);
            ex.setValues(values);
            throw ex;
        }
        try {
            TransactionProxy.commit((TransactionState)prepare_state);
            return set;
        }
        catch (Exception ex) {
            log.error("\u524d\u7f6e\u547d\u4ee4\u63d0\u4ea4\u5f02\u5e38", (Throwable)ex);
            return set;
        }
        finally {
            if (null != prepare_state) {
                try {
                    TransactionProxy.commit(prepare_state);
                }
                catch (Exception ex) {
                    log.error("\u524d\u7f6e\u547d\u4ee4\u63d0\u4ea4\u5f02\u5e38", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, DataSource datasource, T meta) {
        this.actuator.checkSchema((DriverAdapter)this, runtime, datasource, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        this.actuator.checkSchema((DriverAdapter)this, runtime, con, meta);
    }

    public <T extends Metadata> void checkSchema(DataRuntime runtime, T meta) {
        this.actuator.checkSchema((DriverAdapter)this, runtime, meta);
    }

    public <T extends Column> T column(Catalog catalog, Schema schema, Table table, String name, List<T> columns) {
        for (Column column : columns) {
            if (null == table || null == name) continue;
            String identity = BasicUtil.nvl((Object[])new Serializable[]{catalog, ""}) + "_" + BasicUtil.nvl((Object[])new Serializable[]{schema, ""}) + "_" + BasicUtil.nvl((Object[])new Serializable[]{table, ""}) + "_" + name;
            if (!(identity = MD5Util.crypto((String)identity.toUpperCase())).equals(column.getIdentity())) continue;
            return (T)column;
        }
        return null;
    }

    public String insertHead(ConfigStore configs) {
        return "INSERT INTO ";
    }

    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return "";
    }

    protected String insertValue(DataRuntime runtime, org.anyline.data.run.Run run, Object obj, boolean head, boolean child, Boolean placeholder, boolean alias, boolean scope, boolean el, LinkedHashMap<String, Column> columns) {
        boolean batch = run.getBatch() > 1;
        StringBuilder builder = new StringBuilder();
        if (scope && (!batch || head)) {
            builder.append("(");
        }
        int type = 1;
        if (obj instanceof DataRow) {
            type = 1;
        }
        run.setOriginType(type);
        Boolean unicode = null;
        boolean first = true;
        for (Column column : columns.values()) {
            boolean place = placeholder;
            boolean src = false;
            String key = column.getName();
            if (!(first || batch && !head)) {
                builder.append(", ");
            }
            first = false;
            Object value = null;
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                value = row.get(key);
                unicode = row.getUnicode();
            } else {
                value = obj instanceof Map ? ((Map)obj).get(key) : BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key));
            }
            if (value != null) {
                if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                    place = false;
                } else if (value instanceof String) {
                    String str = (String)value;
                    if (el && BasicUtil.checkEl((String)str)) {
                        src = true;
                        place = false;
                        value = str.substring(2, str.length() - 1);
                        if (child && str.toUpperCase().contains(".NEXTVAL")) {
                            value = null;
                        }
                    } else if ("NULL".equals(str)) {
                        value = null;
                    }
                }
            }
            if (src) {
                builder.append(value);
            } else if (!batch || head) {
                if (place) {
                    this.convert(runtime, builder, value, column, place, unicode, run.getConfigs());
                    this.addRunValue(runtime, run, Compare.EQUAL, column, value);
                } else {
                    if (null == unicode) {
                        unicode = false;
                    }
                    builder.append(this.write(runtime, null, value, place, unicode));
                }
            } else {
                this.addRunValue(runtime, run, Compare.EQUAL, column, value);
            }
            if (batch && !head || !alias) continue;
            builder.append(" AS ");
            this.delimiter(builder, key);
        }
        if (scope && (!batch || head)) {
            builder.append(")");
        }
        return builder.toString();
    }

    public String getPrimayKey(Object obj) {
        String key = null;
        if (obj instanceof Collection) {
            obj = ((Collection)obj).iterator().next();
        }
        key = obj instanceof DataRow ? ((DataRow)obj).getPrimaryKey() : EntityAdapterProxy.primaryKey(obj.getClass(), (boolean)true);
        return key;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }

    protected String dummy() {
        return "dual";
    }

    protected String pageLimit(DataRuntime runtime, org.anyline.data.run.Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrders())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = this.compressCondition(runtime, sql);
        return sql;
    }

    protected String pageLimitOffset(DataRuntime runtime, org.anyline.data.run.Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String regex = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(regex, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrders())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = this.compressCondition(runtime, sql);
        return sql;
    }

    protected String pageRowNum(DataRuntime runtime, org.anyline.data.run.Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrders();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append("SELECT ").append(cols).append(" FROM( \n");
            builder.append("SELECT TAB_I.*,ROWNUM AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append("\n").append(order);
            builder.append(")  TAB_I \n");
            builder.append(")  TAB_O WHERE PAGE_ROW_NUMBER_ >= ").append(first + 1L).append(" AND PAGE_ROW_NUMBER_ <= ").append(last + 1L);
        }
        return builder.toString();
    }

    protected String pageOffsetNext(DataRuntime runtime, org.anyline.data.run.Run run) {
        StringBuilder builder = new StringBuilder();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrders();
        long first = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append(sql).append("\n").append(order);
            builder.append(" OFFSET ").append(first).append(" ROWS FETCH NEXT ").append(navi.getPageRows()).append(" ROWS ONLY");
        }
        return builder.toString();
    }

    protected String pageSkip(DataRuntime runtime, org.anyline.data.run.Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrders())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            String sub = sql.substring(sql.toUpperCase().indexOf("SELECT") + 6);
            sql = "SELECT SKIP " + navi.getFirstRow() + " FIRST " + limit + sub;
        }
        return sql;
    }

    protected String pageTop(DataRuntime runtime, org.anyline.data.run.Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrders();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            long rows = navi.getPageRows();
            if (rows * navi.getCurPage() > navi.getTotalRow()) {
                rows = navi.getTotalRow() % (long)navi.getPageRows();
            }
            String asc = order;
            String desc = order.replace("ASC", "<A_ORDER>");
            desc = desc.replace("DESC", "ASC");
            desc = desc.replace("<A_ORDER>", "DESC");
            builder.append("SELECT " + cols + " FROM (\n ");
            builder.append("SELECT TOP ").append(rows).append(" * FROM (\n");
            builder.append("SELECT TOP ").append((long)navi.getPageRows() * navi.getCurPage()).append(" * ");
            builder.append(" FROM (" + sql + ") AS T0 ").append(asc).append("\n");
            builder.append(") AS T1 ").append(desc).append("\n");
            builder.append(") AS T2").append(asc);
        }
        return builder.toString();
    }

    protected String pageRowNumber(DataRuntime runtime, org.anyline.data.run.Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrders();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            LinkedHashMap pks;
            Table table;
            RunPrepare prepare;
            if (BasicUtil.isEmpty((Object)order) && null != (prepare = run.getPrepare()) && null != (table = prepare.getTable()) && !(pks = table.getPrimaryKeyColumns()).isEmpty()) {
                order = "ORDER BY " + BeanUtil.concat((Collection)Column.names((LinkedHashMap)pks));
            }
            if (BasicUtil.isEmpty((Object)order)) {
                order = "ORDER BY " + ConfigTable.DEFAULT_PRIMARY_KEY;
            }
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT _TAB_I.*,ROW_NUMBER() OVER(").append(order).append(") AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append(") AS _TAB_I \n");
            builder.append(") AS _TAB_O WHERE PAGE_ROW_NUMBER_ BETWEEN " + (first + 1L) + " AND " + (last + 1L));
        }
        return builder.toString();
    }

    protected String concatFun(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAnd(DataRuntime runtime, String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " & ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "BASE TABLE");
        types.put((Type)Table.TYPE.VIEW, "VIEW");
        types.put((Type)View.TYPE.NORMAL, "VIEW");
        types.put((Type)Metadata.TYPE.TABLE, "BASE TABLE");
        types.put((Type)Metadata.TYPE.VIEW, "VIEW");
    }
}

