/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.entity.Join;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.adapter.init.alias.PostgresGenusTypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.VirtualTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Order;
import org.anyline.entity.PageNavi;
import org.anyline.entity.VariableValue;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;

public abstract class PostgresGenusAdapter
extends AbstractJDBCAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public PostgresGenusAdapter() {
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", "NUMERIC_SCALE", 1, 0, 0));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, "DATETIME_PRECISION", 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, "DATETIME_PRECISION", 1, 1, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, "DATETIME_PRECISION", 1, 1, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, "DATETIME_PRECISION", 1, 1, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        for (PostgresGenusTypeMetadataAlias alias : PostgresGenusTypeMetadataAlias.values()) {
            this.reg(alias);
            this.alias(alias.name(), alias.standard());
        }
    }

    @Override
    public boolean supportCatalog() {
        return super.supportSchema();
    }

    @Override
    public boolean supportSchema() {
        return super.supportSchema();
    }

    @Override
    public String name(Type type) {
        return types.get(type);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, placeholder, unicode, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, placeholder, unicode, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    @Override
    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    @Override
    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRun(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    @Override
    public String generatedKey() {
        return super.generatedKey();
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        return super.insert(runtime, random, data, configs, run, pks);
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, RunPrepare prepare, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        Run run = this.initQueryRun(runtime, prepare);
        run.addCondition(conditions);
        if (run.checkValid()) {
            this.fillUpdateContent(runtime, (TableRun)run, data, configs, placeholder, unicode);
        }
        return run;
    }

    public void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        TablePrepare prepare = (TablePrepare)run.getPrepare();
        builder.append("UPDATE ");
        this.name(runtime, builder, (Metadata)prepare.getTable());
        String alias = prepare.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(this.tableAliasGuidd());
            this.delimiter(builder, alias);
        }
        builder.append("\n");
        builder.append("SET").append("\n");
        List keys = data.keys();
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append(key).append(" = ");
            Iterator value = data.get(key);
            if (value instanceof VariableValue) {
                VariableValue var = (VariableValue)value;
                this.delimiter(builder, var.value());
                continue;
            }
            builder.append("?");
            RunValue rv = new RunValue();
            rv.setValue((Object)value);
            run.addValue(rv);
        }
        RunPrepare master = null;
        List joins = prepare.getJoins();
        if (null != joins && !joins.isEmpty()) {
            master = (RunPrepare)joins.get(0);
            joins.remove(master);
            builder.append("\nFROM ");
            this.fillMasterTableContent(runtime, builder, run, master);
            for (RunPrepare join : joins) {
                this.fillJoinTableContent(runtime, builder, run, join);
            }
        }
        if (null != master) {
            Join join = master.getJoin();
            if (master instanceof VirtualTablePrepare) {
                join = ((VirtualTablePrepare)master).getPrepare().getJoin();
            }
            if (null != join) {
                String on = join.getConditions().getRunText(runtime, Boolean.valueOf(false));
                configs.and(on);
            }
        }
        this.init(runtime, (Run)run, configs, new String[0]);
        run.appendCondition(builder, (DriverAdapter)this, true, placeholder, unicode);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected Boolean checkOverride(Object obj, ConfigStore configs) {
        return super.checkOverride(obj, configs);
    }

    @Override
    protected Boolean checkOverrideSync(Object obj, ConfigStore configs) {
        return super.checkOverrideSync(obj, configs);
    }

    @Override
    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    @Override
    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    @Override
    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    @Override
    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return super.querys(runtime, random, procedure, navi);
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    @Override
    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                builder.append(key).append("('").append(name).append("') AS ").append(name);
            }
        }
        return runs;
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, XMLRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageLimitOffset(runtime, run);
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        RunValue rv = new RunValue();
        int code = compare.getCode();
        if (code > 100) {
            builder.append(" NOT");
            code -= 100;
        }
        String formula = compare.formula();
        if (null == value) {
            value = "";
        }
        if (placeholder.booleanValue()) {
            if (compare == Compare.LIKE_SIMPLE) {
                builder.append(formula).append("?");
            } else if (code == 50) {
                builder.append(formula).append(this.concat(runtime, "'%'", "?", "'%'"));
            } else if (code == 51) {
                builder.append(formula).append(this.concat(runtime, "?", "'%'"));
            } else if (code == 52) {
                builder.append(formula).append(this.concat(runtime, "'%'", "?"));
            }
            rv.setValue(value);
        } else {
            value = BeanUtil.first((Object)value);
            rv.setPlaceholder(Boolean.valueOf(false));
            if (compare == Compare.LIKE_SIMPLE) {
                builder.append(formula).append("'").append(value).append("'");
            } else if (code == 50) {
                builder.append(formula).append("'%").append(value).append("%'");
            } else if (code == 51) {
                builder.append(formula).append("'").append(value).append("%'");
            } else if (code == 52) {
                builder.append(formula).append("'%").append(value).append("'");
            }
        }
        return rv;
    }

    @Override
    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        return super.createConditionFindInSet(runtime, builder, column, compare, value, placeholder, unicode);
    }

    @Override
    public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return super.createConditionIn(runtime, builder, compare, value, placeholder, unicode);
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, system, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.maps(runtime, random, configs, run);
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.map(runtime, random, configs, run);
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return super.sequence(runtime, random, next, names);
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        return super.mergeFinalTotal(runtime, run);
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        return super.count(runtime, random, run);
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.exists(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        return super.mergeFinalExists(runtime, run);
    }

    public Run buildQueryLengthRun(DataRuntime runtime, String cn, ConfigStore configs) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT OCTET_LENGTH('").append(cn).append("') AS CNT");
        return run;
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return super.execute(runtime, random, procedure);
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRun(runtime, dest, configs, obj, placeholder, unicode, columns);
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, Boolean placeholder, Boolean unicode, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, configs, placeholder, unicode, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return super.buildTruncateRun(runtime, table);
    }

    @Override
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode, String column, Object values) {
        return super.buildDeleteRunFromTable(runtime, batch, table, configs, placeholder, unicode, column, values);
    }

    @Override
    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRunFromEntity(runtime, table, configs, obj, placeholder, unicode, columns);
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillDeleteRunContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        Catalog catalog = this.catalog(runtime, random);
        if (null != catalog) {
            return new Database(catalog.getName());
        }
        return super.database(runtime, random);
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, Database query) {
        return super.databases(runtime, random, greedy, query);
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, Database query) {
        return super.databases(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM PG_DATABASE WHERE DATISTEMPLATE=FALSE");
        configs.and(Compare.LIKE_SIMPLE, "datname", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initDatabaseFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Database.class);
        refer.map("NAME", "DATNAME");
        return refer;
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, int index, boolean create, List<T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set) throws Exception {
        return super.database(runtime, index, create, meta, set);
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database meta) throws Exception {
        return super.database(runtime, create, meta);
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        return super.product(runtime, create, product);
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        return super.version(runtime, create, version);
    }

    public <T extends Database> T init(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Database> T detail(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, Catalog query) {
        return super.catalogs(runtime, random, query);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, Catalog query) {
        return super.catalogs(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM pg_stat_database");
        configs.and(Compare.LIKE_SIMPLE, "datname", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initCatalogFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Catalog.class);
        refer.map("NAME", "datname");
        return refer;
    }

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, meta, set);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog meta) throws Exception {
        return super.catalog(runtime, create, meta);
    }

    public <T extends Catalog> T init(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Catalog> T detail(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Schema query) {
        return super.schemas(runtime, random, query);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Schema query) {
        return super.schemas(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM information_schema.schemata");
        configs.and(Compare.LIKE_SIMPLE, "schema_name", (Object)query.getName());
        configs.and("catalog_name", (Object)query.getCatalogName());
        runs.add((Run)run);
        return runs;
    }

    @Override
    public MetadataFieldRefer initSchemaFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Schema.class);
        refer.map("NAME", "schema_name");
        refer.map("CATALOG", "catalog_name");
        return refer;
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set) throws Exception {
        return super.schema(runtime, index, create, meta, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema meta) throws Exception {
        return super.schema(runtime, create, meta);
    }

    public <T extends Schema> T init(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Schema> T detail(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Table query, ConfigStore configs) {
        super.tableMap(runtime, random, greedy, query, configs);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, coalesce(obj_description(F.oid,'pg_class'), obj_description(F.relfilenode,'pg_class'))  AS TABLE_COMMENT\n");
        builder.append("FROM  INFORMATION_SCHEMA.TABLES AS M\n");
        builder.append("LEFT JOIN pg_namespace AS N ON N.NSPNAME = M.table_schema\n");
        builder.append("LEFT JOIN pg_class AS F ON M.TABLE_NAME = F.relname AND N.oid = F.relnamespace\n");
        builder.append("LEFT JOIN pg_inherits AS I ON I.inhrelid = F.oid\n");
        builder.append("WHERE I.inhrelid IS NULL\n");
        configs.and("M.table_schema", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.table_name", (Object)query.getName());
        if ((types & 2) != 2) {
            configs.and("M.TABLE_TYPE != 'VIEW'");
        }
        return runs;
    }

    protected List<Run> buildQueryTablesRunWithPartBound(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, coalesce(obj_description(F.oid,'pg_class'), obj_description(F.relfilenode,'pg_class'))  AS TABLE_COMMENT\n");
        builder.append("FROM  INFORMATION_SCHEMA.TABLES AS M\n");
        builder.append("LEFT JOIN pg_namespace AS N ON N.NSPNAME = M.table_schema\n");
        builder.append("LEFT JOIN pg_class AS F ON M.TABLE_NAME = F.relname AND N.oid = F.relnamespace\n");
        builder.append("LEFT JOIN pg_inherits AS I ON I.inhrelid = F.oid\n");
        builder.append("WHERE (I.inhrelid IS NULL  OR F.relpartbound IS NULL)\n");
        configs.and("M.table_schema", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.table_name", (Object)query.getName());
        if ((types & 2) != 2) {
            configs.and("M.TABLE_TYPE != 'VIEW'");
        }
        return runs;
    }

    @Override
    public MetadataFieldRefer initTableFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("TYPE", "TABLE_TYPE");
        refer.map("COMMENT", "TABLE_COMMENT");
        return refer;
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, query, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        return super.views(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, View query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.VIEWS");
        configs.and("TABLE_CATALOG", (Object)query.getCatalogName());
        configs.and("TABLE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initViewFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(View.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("DEFINITION", "VIEW_DEFINITION");
        return refer;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, View query, DataSet set) throws Exception {
        return super.views(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        return super.views(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        return super.ddl(runtime, random, view, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlRun(runtime, view);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        return super.masters(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, MasterTable query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, greedy, query, types, configs);
    }

    @Override
    public MetadataFieldRefer initMasterTableFieldRefer() {
        return super.initMasterTableFieldRefer();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, MasterTable query, DataSet set) throws Exception {
        return super.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, MasterTable query, int types) throws Exception {
        return super.masters(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public Table.Partition partition(DataRuntime runtime, String random, Table table) {
        return super.partition(runtime, random, table);
    }

    public List<Run> buildQueryTablePartitionRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT N.nspname AS SCHEMA_NAME, F.relname AS TABLE_NAME, M.partstrat AS PARTITION_TYPE, M.partattrs AS PARTITION_COLUMNS \n").append("FROM pg_partitioned_table AS M \n").append("LEFT JOIN pg_class AS F ON M.partrelid = F.oid\n").append("LEFT JOIN pg_namespace AS N ON F.relnamespace = N.oid");
        ConfigStore configs = run.getConfigs();
        configs.and("F.relname", (Object)table.getName());
        run = new SimpleRun(runtime);
        runs.add((Run)run);
        builder = run.getBuilder();
        builder.append("SELECT n.nspname AS SCHEMA_NAME, i2.relname as TABLE_NAME, c.relname AS PARTITION_NAME, pg_get_expr(c.relpartbound, c.oid) AS PARTITION_FOR\n");
        builder.append("FROM pg_class c \n");
        builder.append("LEFT JOIN pg_partitioned_table AS p ON c.oid = p.partrelid\n");
        builder.append("LEFT JOIN pg_namespace n ON n.oid = c.relnamespace \n");
        builder.append("LEFT JOIN (\n");
        builder.append("\tpg_inherits i \n");
        builder.append("\tINNER JOIN pg_class c2 ON i.inhparent = c2.oid \n");
        builder.append("\tLEFT JOIN pg_namespace n2 ON n2.oid = c2.relnamespace\n");
        builder.append("\t) i2 ON i2.inhrelid = c.oid \n");
        builder.append("\tWHERE c.relispartition = 'true'\n");
        configs = run.getConfigs();
        configs.and("n.nspname", (Object)table.getSchemaName());
        configs.and("i2.relname", (Object)table.getName());
        return runs;
    }

    public Table.Partition partition(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataSet set) throws Exception {
        return super.partition(runtime, index, create, meta, table, set);
    }

    public Table.Partition init(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        MetadataFieldRefer refer;
        String type;
        if (index == 0 && BasicUtil.isNotEmpty((Object)(type = this.getString(row, refer = this.refer(runtime, Table.Partition.class), "TYPE")))) {
            meta = new Table.Partition();
            if ("h".equalsIgnoreCase(type)) {
                meta.setType(Table.Partition.TYPE.HASH);
            } else if ("l".equalsIgnoreCase(type)) {
                meta.setType(Table.Partition.TYPE.LIST);
            } else if ("r".equalsIgnoreCase(type)) {
                meta.setType(Table.Partition.TYPE.RANGE);
            }
            LinkedHashMap cols = table.getColumns();
            String columns = this.getString(row, refer, "COLUMN");
            if (BasicUtil.isNotEmpty((Object)columns)) {
                String[] nums;
                block0: for (String num : nums = columns.split(" ")) {
                    for (Column col : cols.values()) {
                        if (!num.equals(col.getPosition())) continue;
                        meta.addColumn(col);
                        continue block0;
                    }
                }
            }
        }
        return meta;
    }

    public Table.Partition detail(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        if (index == 1) {
            MetadataFieldRefer refer = this.refer(runtime, Table.Partition.Slice.class);
            Table.Partition.Slice slice = new Table.Partition.Slice();
            slice.setName(this.getString(row, refer, "NAME"));
            String fors = this.getString(row, refer, "FOR");
            fors = fors.replace("'", "").replace("\"", "");
            Table.Partition.TYPE type = meta.getType();
            if (type == Table.Partition.TYPE.LIST) {
                String[] values;
                String vals = RegularUtil.cut((String)fors, (String[])new String[]{"(", ")"});
                for (String value : values = vals.split(",")) {
                    slice.addValue((Object)value.trim());
                }
            } else if (type == Table.Partition.TYPE.HASH) {
                String modules = RegularUtil.cut((String)fors, (String[])new String[]{"modulus", ","}).trim();
                int module = BasicUtil.parseInt((Object)modules, (Integer)0);
                String remainder = RegularUtil.cut((String)fors, (String[])new String[]{"remainder", ")"}).trim();
                int rem = BasicUtil.parseInt((Object)remainder, (Integer)0);
                table.getPartition().setModulus(module);
                slice.setModulus(module);
                slice.setRemainder(rem);
            } else if (type == Table.Partition.TYPE.RANGE) {
                String[] less = RegularUtil.cut((String)fors, (String[])new String[]{"FROM", "(", ")"}).split(",");
                String[] columns = RegularUtil.cut((String)fors, (String[])new String[]{"TO", "(", ")"}).split(",");
                int size = columns.length;
                for (int i = 0; i < size; ++i) {
                    slice.setLess(columns[i].trim(), (Object)less[i].trim());
                }
            }
            meta.addSlice(slice);
        }
        return meta;
    }

    public MetadataFieldRefer initTablePartitionFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.Partition.class);
        refer.map("TYPE", "PARTITION_TYPE");
        refer.map("COLUMN", "PARTITION_COLUMNS");
        return refer;
    }

    public MetadataFieldRefer initTablePartitionSliceFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.Partition.Slice.class);
        refer.map("NAME", "PARTITION_NAME");
        refer.map("FOR", "PARTITION_FOR");
        return refer;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        return super.partitions(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query, int types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT M.*, coalesce(obj_description(F.oid,'pg_class'), obj_description(F.relfilenode,'pg_class'))  AS TABLE_COMMENT, FM.relname AS MASTER_TABLE_NAME\n");
        builder.append("FROM  INFORMATION_SCHEMA.TABLES AS M\n");
        builder.append("LEFT JOIN pg_namespace AS N ON N.NSPNAME = M.table_schema\n");
        builder.append("LEFT JOIN pg_class AS F ON M.TABLE_NAME = F.relname AND N.oid = F.relnamespace\n");
        builder.append("LEFT JOIN pg_inherits AS I ON I.inhrelid = F.oid\n");
        builder.append("LEFT JOIN pg_class AS FM ON FM.oid = I.inhparent AND N.oid = FM.relnamespace\n");
        configs.and("FM.relname", (Object)query.getMasterName());
        configs.and("M.table_schema", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.table_name", (Object)query.getName());
        return runs;
    }

    public MetadataFieldRefer initPartitionTableFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(PartitionTable.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("COMMENT", "TABLE_COMMENT");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("TYPE", "TABLE_TYPE");
        refer.map("MASTER", "FM.MASTER_TABLE_NAME");
        return refer;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, LinkedHashMap<String, T> previous, PartitionTable query, DataSet set) throws Exception {
        return super.partitions(runtime, total, index, create, previous, query, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query) throws Exception {
        return super.partitions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, Column query, boolean primary, ConfigStore configs) {
        return super.columns(runtime, random, greedy, table, query, primary, configs);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Column query, ConfigStore configs) {
        return super.columns(runtime, random, greedy, query, configs);
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Column query, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, (Metadata)query.getTable());
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT M.*,pg_catalog.format_type ( FA.ATTTYPID, FA.ATTTYPMOD ) AS FULL_TYPE,FD.DESCRIPTION AS COLUMN_COMMENT \n");
            builder.append("FROM INFORMATION_SCHEMA.COLUMNS M\n");
            builder.append("LEFT JOIN PG_CLASS FC ON FC.RELNAME = M.TABLE_NAME\n");
            builder.append("LEFT JOIN PG_ATTRIBUTE FA ON FA.ATTNAME = M.COLUMN_NAME AND FA.ATTRELID = FC.OID\n");
            builder.append("LEFT JOIN PG_DESCRIPTION FD ON FD.OBJOID = FC.OID AND FD.OBJSUBID = M.ORDINAL_POSITION");
            configs.and("M.TABLE_CATALOG", (Object)query.getCatalogName());
            configs.and("M.TABLE_SCHEMA", (Object)query.getSchemaName());
            configs.and(Compare.LIKE_SIMPLE, "M.TABLE_NAME", (Object)query.getTableName());
            configs.order("M.TABLE_NAME");
        }
        return runs;
    }

    @Override
    public MetadataFieldRefer initColumnFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Column.class);
        refer.map("NAME", "COLUMN_NAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("NULLABLE", "IS_NULLABLE");
        refer.map("TYPE", "UDT_NAME,FULL_TYPE");
        refer.map("POSITION", "ORDINAL_POSITION");
        refer.map("COMMENT", "COLUMN_COMMENT");
        refer.map("DEFAULT_VALUE", "COLUMN_DEFAULT");
        refer.map("AUTO_INCREMENT_CHECK", "COLUMN_DEFAULT");
        refer.map("AUTO_INCREMENT_CHECK_VALUE", ".*nextval.*");
        return refer;
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Collection<? extends Table> tables, Column query, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*,pg_catalog.format_type ( FA.ATTTYPID, FA.ATTTYPMOD ) AS FULL_TYPE,FD.DESCRIPTION AS COLUMN_COMMENT \n");
        builder.append("FROM INFORMATION_SCHEMA.COLUMNS M\n");
        builder.append("LEFT JOIN PG_CLASS FC ON FC.RELNAME = M.TABLE_NAME\n");
        builder.append("LEFT JOIN PG_ATTRIBUTE  FA ON FA.ATTNAME = M.COLUMN_NAME AND FA.ATTRELID = FC.OID\n");
        builder.append("LEFT JOIN PG_DESCRIPTION FD ON FD.OBJOID = FC.OID AND FD.OBJSUBID = M.ORDINAL_POSITION\n");
        configs.and("M.TABLE_CATALOG", (Object)query.getCatalogName());
        configs.and("M.TABLE_SCHEMA", (Object)query.getSchemaName());
        configs.in("M.TABLE_NAME", (Object)Table.names(tables));
        configs.order("M.TABLE_NAME");
        return runs;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table table, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, table, query, set);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Column query) throws Exception {
        return super.columns(runtime, create, previous, query);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Collection<? extends Table> tables, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, tables, query, set);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Column query, ConfigStore configs) {
        return super.columns(runtime, random, greedy, tables, query, configs);
    }

    @Override
    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        return super.detail(runtime, index, meta, query, row);
    }

    public TypeMetadata.Refer dataTypeMetadataRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.dataTypeMetadataRefer(runtime, meta);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query) {
        return super.tags(runtime, random, greedy, table, query);
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query) throws Exception {
        return super.buildQueryTagsRun(runtime, greedy, query);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Tag query, DataSet set) throws Exception {
        return super.tags(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Tag query) throws Exception {
        return super.tags(runtime, create, previous, query);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, PrimaryKey query) {
        return super.primary(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, PrimaryKey query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT  m.conname, pg_get_constraintdef(m.oid, true) AS define\n");
        builder.append("FROM pg_constraint m \n");
        builder.append("LEFT JOIN pg_namespace ns ON m.connamespace = ns.oid \n");
        builder.append("LEFT JOIN pg_class ft ON m.conrelid = ft.oid \n");
        configs.and(Compare.LIKE_SIMPLE, "ft.relname", (Object)query.getTableName());
        configs.and("ns.nspname", (Object)query.getSchemaName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initPrimaryKeyFieldRefer() {
        return super.initPrimaryKeyFieldRefer();
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (!set.isEmpty()) {
            String[] cols;
            DataRow row = set.getRow(0);
            primary = new PrimaryKey();
            primary.setName(row.getString("CONNAME"));
            String define = row.getString("DEFINE");
            for (String col : cols = RegularUtil.cut((String)define, (String[])new String[]{"(", ")"}).split(",")) {
                Column column = new Column(col.trim().replace("\"", ""));
                column.setTable(table);
                primary.addColumn(column);
            }
        }
        return primary;
    }

    @Override
    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        return super.detail(runtime, index, primary, query, set);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, ForeignKey query) {
        return super.foreigns(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, ForeignKey query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT TC.CONSTRAINT_NAME,TC.TABLE_NAME AS TABLE_NAME, KCU.COLUMN_NAME AS COLUMN_NAME, KCU.ORDINAL_POSITION, CCU.TABLE_NAME AS REFERENCED_TABLE_NAME, CCU.COLUMN_NAME AS REFERENCED_COLUMN_NAME\n");
        builder.append("FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC\n");
        builder.append("JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU ON TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME\n");
        builder.append("JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS CCU ON CCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME\n");
        builder.append("WHERE TC.CONSTRAINT_TYPE = 'FOREIGN KEY'\n");
        configs.and(Compare.LIKE_SIMPLE, "TC.TABLE_NAME", (Object)query.getTableName());
        configs.order("KCU.ORDINAL_POSITION");
        return runs;
    }

    public MetadataFieldRefer initForeignKeyFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(ForeignKey.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("CATALOG", "");
        refer.map("SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("COLUMN_POSITION", "ORDINAL_POSITION");
        refer.map("REFERENCE_CATALOG", "REFERENCED_CATALOG_NAME");
        refer.map("REFERENCE_SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("REFERENCE_TABLE", "REFERENCED_TABLE_NAME");
        refer.map("REFERENCE_COLUMN", "REFERENCED_COLUMN_NAME");
        return refer;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, LinkedHashMap<String, T> previous, ForeignKey query, DataSet set) throws Exception {
        return super.foreigns(runtime, index, previous, query, set);
    }

    @Override
    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Index query) {
        return super.indexes(runtime, random, greedy, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Index query) {
        return super.indexes(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Index query) {
        Table table = query.getTable();
        String name = query.getName();
        ArrayList<Run> runs = new ArrayList<Run>();
        Run run = this.buildQueryIndexBody(runtime);
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        configs.and("ins.nspname", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "c.relname", (Object)query.getTableName());
        if (BasicUtil.isNotEmpty((Object)name)) {
            configs.and("AND i.indexrelid = '" + name + "'::regclass");
        }
        return runs;
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Collection<? extends Table> tables) {
        ArrayList<Run> runs = new ArrayList<Run>();
        Run run = this.buildQueryIndexBody(runtime);
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        if (null != tables && !tables.isEmpty()) {
            Table table = tables.iterator().next();
            configs.and("ins.nspname", (Object)table.getSchemaName());
        }
        List names = Table.names(tables);
        configs.in("c.relname", (Object)names);
        return runs;
    }

    protected Run buildQueryIndexBody(DataRuntime runtime) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT \n");
        builder.append("i.indkey AS COLUMN_POSITIONS,\n");
        builder.append("i.indoption AS COLUMN_ORDERS,\n");
        builder.append("c.relname AS TABLE_NAME,\n");
        builder.append("ins.nspname as SCHEMA_NAME, \n");
        builder.append("i.indexrelid::regclass as index_name,\n");
        builder.append("am.amname AS index_type,\n");
        builder.append("i.indisunique  as is_unique,\n");
        builder.append("i.indisprimary as is_primary,\n");
        builder.append("a.attnum as column_no,\n");
        builder.append("a.attname  as column_name \n");
        builder.append("FROM pg_index AS i\n");
        builder.append("LEFT JOIN pg_class AS c  ON i.indrelid = c.oid\n");
        builder.append("LEFT JOIN pg_class AS ci ON i.indexrelid = ci.oid\n");
        builder.append("LEFT JOIN pg_am AS am ON ci.relam = am.oid\n");
        builder.append("LEFT JOIN pg_attribute AS a ON a.attrelid = c.oid AND a.attnum = ANY(i.indkey)\n");
        builder.append("LEFT JOIN pg_namespace ins ON ins.oid = c.relnamespace\n");
        return run;
    }

    @Override
    public MetadataFieldRefer initIndexFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Index.class);
        refer.map("NAME", "INDEX_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("SCHEMA", "SCHEMA_NAME");
        refer.map("TYPE", "INDEX_TYPE");
        refer.map("PRIMARY_CHECK", "IS_PRIMARY");
        refer.map("PRIMARY_CHECK_VALUE", "T");
        refer.map("UNIQUE_CHECK", "IS_UNIQUE");
        refer.map("UNIQUE_CHECK_VALUE", "T");
        refer.map("CATALOG", "");
        refer.map("COLUMN", "column_name");
        refer.map("ORDER", "COLUMN_ORDERS");
        refer.map("POSITION", "COLUMN_POSITIONS");
        return refer;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, List<T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        String order;
        meta = super.detail(runtime, index, meta, query, row);
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        String columnName = row.getStringWithoutEmpty(refer.maps("COLUMN"));
        if (null == columnName) {
            return meta;
        }
        Column column = meta.getColumn((columnName = columnName.replace("\"", "")).toUpperCase());
        if (null == column) {
            column = new Column();
        }
        List positions = BeanUtil.array2list((Object[][])new String[][]{row.getStringNvl("POSITION", new String[]{""}).split(" ")});
        String no = row.getString("COLUMN_NO");
        int position = positions.indexOf(no);
        column.setPosition(Integer.valueOf(position));
        column.setName(columnName);
        meta.addColumn(column);
        meta.setPosition(column, Integer.valueOf(position));
        List orders = BeanUtil.array2list((Object[][])new String[][]{row.getStringNvl("ORDER", new String[]{""}).split(" ")});
        if (position >= 0 && null != (order = (String)orders.get(position))) {
            order = order.toUpperCase();
            Order.TYPE type = Order.TYPE.ASC;
            if (order.equals("1")) {
                type = Order.TYPE.DESC;
            }
            meta.setOrder(column, type);
        }
        return meta;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Constraint query) {
        return super.constraints(runtime, random, greedy, query);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        return super.buildQueryConstraintsRun(runtime, greedy, query);
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, List<T> previous, Constraint query, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Constraint query, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Trigger query) {
        return super.triggers(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query) {
        Table table = query.getTable();
        List events = query.getEvents();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        configs.and("TRIGGER_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "EVENT_OBJECT_TABLE", (Object)query.getTableName());
        configs.in("EVENT_MANIPULATION", (Object)events);
        return runs;
    }

    public MetadataFieldRefer initTriggerFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Trigger.class);
        refer.map("NAME", "TRIGGER_NAME");
        refer.map("CATALOG", "TRIGGER_CATALOG");
        refer.map("SCHEMA", "TRIGGER_SCHEMA");
        refer.map("TABLE", "EVENT_OBJECT_TABLE");
        refer.map("EVENT", "EVENT_MANIPULATION");
        refer.map("DEFINITION", "ACTION_STATEMENT");
        return refer;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Trigger query, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, previous, query, set);
    }

    public <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (null == (meta = super.init(runtime, index, meta, query, row))) {
            meta = new Trigger();
        }
        boolean each = false;
        if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
            each = true;
        }
        meta.setEach(each);
        try {
            String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
            String time = row.getString("ACTION_TIMING");
            meta.setTime(Trigger.TIME.valueOf((String)time));
            for (String event : events) {
                meta.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
            }
        }
        catch (Exception e) {
            log.error("\u5c01\u88c5trigger \u5f02\u5e38:", (Throwable)e);
        }
        return meta;
    }

    public <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Procedure query) {
        return super.procedures(runtime, random, greedy, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Procedure query) {
        return super.procedures(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query) {
        return super.buildQueryProceduresRun(runtime, greedy, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Procedure query, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlRun(runtime, procedure);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Function query) {
        return super.functions(runtime, random, greedy, query);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Function query) {
        return super.functions(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT\n").append("    P.*,\n").append("    N.NSPNAME AS SCHEMA_NAME,\n").append("    TYP.TYPNAME AS RETTYPE,\n").append("    OBJ_DESCRIPTION ( P.OID ) AS COMMENT,\n").append("    PG_GET_USERBYID ( P.PROOWNER ) AS OWNER_NAME,\n").append("    TYP.TYPNAME AS TYPE_NAME,\n").append("    TYPNS.NSPNAME AS RETTYPESCHEMA\n").append("FROM\n").append("    PG_PROC P \n").append("    LEFT JOIN PG_TYPE TYP ON TYP.OID = P.PRORETTYPE\n").append("    LEFT JOIN PG_NAMESPACE TYPNS ON TYPNS.OID = TYP.TYPNAMESPACE\n").append("    LEFT JOIN PG_NAMESPACE N ON N.OID = P.PRONAMESPACE \n").append("WHERE P.PROKIND <> 'a' \n");
        configs.and("AND N.NSPNAME", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "AND P.PRONAMEE", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initFunctionFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Function.class);
        refer.map("NAME", "proname");
        refer.map("SCHEMA", "schema_name");
        refer.map("COMMENT", "comment");
        refer.map("DEFINITION", "prosrc");
        return refer;
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> previous, Function query) throws Exception {
        return super.functions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public <T extends Function> T init(DataRuntime runtime, int index, T meta, Function query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Function> T detail(DataRuntime runtime, int index, T meta, Function query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Sequence query) {
        return super.sequences(runtime, random, greedy, query);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Sequence query) {
        return super.sequences(runtime, random, query);
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES");
        configs.and("SEQUENCE_CATALOG", (Object)query.getCatalogName());
        configs.and("SEQUENCE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "SEQUENCE_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString("SEQUENCE_NAME");
            Sequence sequence = new Sequence(name);
            previous.add(this.init(sequence, row));
        }
        return previous;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Sequence query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("SEQUENCE_NAME");
            Sequence sequence = (Sequence)previous.get(name.toUpperCase());
            previous.put(name.toUpperCase(), this.init(sequence, row));
        }
        return previous;
    }

    protected Sequence init(Sequence sequence, DataRow row) {
        if (null == sequence) {
            sequence = new Sequence();
        }
        sequence.setName(row.getString("SEQUENCE_NAME"));
        sequence.setCatalog(row.getString("SEQUENCE_CATALOG"));
        sequence.setSchema(row.getString("SEQUENCE_SCHEMA"));
        sequence.setLast(row.getLong("LAST_NUMBER", Integer.valueOf(0)));
        sequence.setMin(row.getLong("MIN_VALUE", Integer.valueOf(0)));
        sequence.setStart(row.getLong("START_VALUE", Integer.valueOf(0)));
        sequence.setMax(row.getLong("MINIMUM_VALUE", Integer.valueOf(0)));
        sequence.setIncrement(row.getInt("MAXIMUM_VALUE", Integer.valueOf(1)).intValue());
        sequence.setCache(row.getInt("CACHE_SIZE", Integer.valueOf(0)).intValue());
        sequence.setCycle(row.getBoolean("CYCLE_OPTION", null));
        return sequence;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> previous, Sequence query) throws Exception {
        return super.sequences(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    @Override
    public <T extends Metadata> T search(List<T> metas, Catalog catalog, Schema schema, String name) {
        return super.search(metas, catalog, schema, name);
    }

    @Override
    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return super.schema(schemas, catalog, name);
    }

    @Override
    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return super.catalog(catalogs, name);
    }

    @Override
    public <T extends Database> T database(List<T> databases, String name) {
        return super.database(databases, name);
    }

    @Override
    public Object convert(DataRuntime runtime, StringBuilder builder, Object value, Column column, Boolean placeholder, Boolean unicode, ConfigStore configs) {
        String type;
        String suffix = "";
        if (ConfigStore.IS_ENABLE_SQL_DATATYPE_CONVERT((ConfigStore)configs) && null != column && BasicUtil.isNotEmpty((Object)(type = column.getTypeName()))) {
            if (type.contains("(")) {
                type = type.split("\\(")[0];
            }
            suffix = "::" + type;
        }
        if (placeholder.booleanValue()) {
            builder.append("?").append(suffix);
        } else {
            Object write = this.write(runtime, column, value, false, unicode);
            builder.append(write).append(suffix);
        }
        return value;
    }

    public boolean slice() {
        return true;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    public boolean create(DataRuntime runtime, Catalog meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Catalog meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Catalog meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Catalog origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildChangeCommentRun(runtime, catalog);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildAddCommentRun(runtime, catalog);
    }

    public StringBuilder checkCatalogExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkCatalogExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.property(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, Schema meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Schema meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Schema meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Schema origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildChangeCommentRun(runtime, schema);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildAddCommentRun(runtime, schema);
    }

    public StringBuilder checkSchemaExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkSchemaExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.property(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public String keyword(Metadata meta) {
        if (meta instanceof Table) {
            return "TABLE";
        }
        return super.keyword(meta);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, meta, columns);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        Table update = new Table(meta.getUpdate().getName());
        this.name(runtime, builder, (Metadata)update);
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        LinkedHashMap columns;
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta && null != (columns = meta.getColumns())) {
            for (Column column : columns.values()) {
                runs.addAll(this.buildChangeCommentRun(runtime, column, false));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return this.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(runtime, builder, (Metadata)meta);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        String name = null;
        if (null != primary) {
            pks = primary.getColumns();
            name = primary.getName();
        } else {
            pks = meta.primarys();
        }
        if (BasicUtil.isEmpty(name)) {
            name = "pk_" + meta.getName();
        }
        if (!pks.isEmpty()) {
            this.checkName(runtime, null, meta);
            builder.append(",CONSTRAINT ");
            this.delimiter(builder, name);
            builder.append(" PRIMARY KEY (");
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            this.delimiter(builder, Column.names((LinkedHashMap)pks));
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionBy(runtime, builder, meta);
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionOf(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append("CREATE");
        if (meta.isMaterialize()) {
            builder.append(" MATERIALIZED");
        }
        builder.append(" VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        return builder;
    }

    @Override
    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunOption(runtime, builder, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        meta.setKeyword("TABLE");
        MasterTable tab = meta;
        return super.buildCreateRun(runtime, (Table)tab);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        meta.setKeyword("TABLE");
        PartitionTable tab = meta;
        return this.buildCreateRun(runtime, (Table)tab);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        run.slice(false);
        runs.add((Run)run);
        this.checkName(runtime, null, meta);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        builder.append(" RENAME ");
        this.delimiter(builder, meta.getName());
        builder.append(" TO ");
        this.delimiter(builder, ((Column)meta.getUpdate()).getName());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Column update = (Column)meta.getUpdate();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        builder.append(" ALTER COLUMN ");
        this.delimiter(builder, meta.getName());
        builder.append(" TYPE ");
        this.type(runtime, builder, update);
        String type = update.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        builder.append(" USING ");
        this.delimiter(builder, meta.getName());
        builder.append("::").append(type);
        return runs;
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.addColumnGuide(runtime, builder, meta);
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.dropColumnGuide(runtime, builder, meta);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != meta.getUpdate() ? ((Column)meta.getUpdate()).getDefaultValue() : meta.getDefaultValue();
        if (null != def) {
            String str = def.toString();
            if (str.contains("::")) {
                str = str.split("::")[0];
            }
            str = str.replace("'", "");
            def = str;
        }
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta.getTable(true)).append(" ALTER COLUMN ");
        this.delimiter(builder, meta.getName());
        if (null != def) {
            builder.append(" SET DEFAULT '").append(def).append("'");
        } else {
            builder.append(" DROP DEFAULT");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        int nullable = meta.isNullable();
        int uNullable = ((Column)meta.getUpdate()).isNullable();
        if (nullable != -1 && uNullable != -1 && nullable != uNullable) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true)).append(" ALTER ");
            this.delimiter(builder, meta.getName());
            if (uNullable == 0) {
                builder.append(" SET ");
            } else {
                builder.append(" DROP ");
            }
            builder.append(" NOT NULL");
            meta.setNullable(uNullable);
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            comment = update.getComment();
        }
        if (BasicUtil.isEmpty(comment)) {
            comment = meta.getComment();
        }
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, (Metadata)meta.getTable(true)).append(".");
            this.delimiter(builder, meta.getName());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return this.buildChangeCommentRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta, slice);
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.define(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        String type = meta.getTypeName();
        if (null == type) {
            type = "";
        }
        type = type.toLowerCase();
        boolean serial = false;
        if (ACTION.DDL.COLUMN_ADD == meta.getAction() && meta.isAutoIncrement() == 1) {
            serial = true;
        } else {
            Column update = (Column)meta.getUpdate();
            if (null != update && update.isAutoIncrement() != 1 && meta.isAutoIncrement() == 1) {
                serial = true;
            }
        }
        if (serial) {
            if ("int4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                meta.setType("SERIAL4");
            } else if ("int8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                meta.setType("SERIAL8");
            } else if ("int2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                meta.setType("SERIAL2");
            } else {
                meta.setType("SERIAL8");
            }
        } else if (type.equals("int") || type.contains("long") || type.contains("serial") || type.contains("short")) {
            if ("serial4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                meta.setType("int4");
            } else if ("serial8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                meta.setType("int8");
            } else if ("serial2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                meta.setType("int2");
            } else {
                meta.setType("int8");
            }
        }
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.nullable(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildRenameRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeNullableRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeCommentRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeTypeRun(runtime, meta, slice);
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            if (!this.slice(slice)) {
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, (Metadata)meta.getTable(true));
            } else {
                run.slice(slice);
            }
            builder.append(" ADD PRIMARY KEY (");
            Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, origin, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
        } else {
            run.slice(slice);
        }
        builder.append(" DROP CONSTRAINT ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (meta.isPrimary()) {
            log.info("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)meta.getName());
        } else {
            builder.append("DROP INDEX ");
            this.delimiter(builder, meta.getName());
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        return super.each(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        return super.parameter(runtime, builder, parameter);
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, DataSource datasource, T meta) {
        super.checkSchema(runtime, datasource, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        super.checkSchema(runtime, con, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, T meta) {
        super.checkSchema(runtime, meta);
    }

    public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema, boolean overrideRuntime, boolean overrideMeta) {
        super.correctSchemaFromJDBC(runtime, meta, catalog, schema, overrideRuntime, overrideMeta);
    }

    public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema) {
        this.correctSchemaFromJDBC(runtime, meta, catalog, schema, false, true);
    }

    public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return super.correctSchemaFromJDBC(catalog, schema);
    }

    public String columnFieldLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldLengthRefer(runtime, meta);
    }

    public String columnFieldPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldPrecisionRefer(runtime, meta);
    }

    public String columnFieldScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldScaleRefer(runtime, meta);
    }

    @Override
    public String insertHead(ConfigStore configs) {
        return super.insertHead(configs);
    }

    @Override
    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = new StringBuilder();
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        if (null != override) {
            builder.append(" ON CONFLICT");
            Constraint constraint = configs.overrideByConstraint();
            if (null != constraint) {
                builder.append(" ON CONSTRAINT ");
                this.delimiter(builder, constraint.getName());
            } else {
                ArrayList<String> bys = configs.overrideByColumns();
                if (null == bys) {
                    bys = configs.getPrimaryKeys();
                }
                if (null == bys) {
                    bys = new ArrayList<String>();
                }
                if (bys.isEmpty()) {
                    bys.add(ConfigTable.DEFAULT_PRIMARY_KEY);
                }
                builder.append("(").append(BeanUtil.concat(bys)).append(")");
            }
            if (override.booleanValue()) {
                builder.append(" DO UPDATE SET ");
                boolean first = true;
                for (Column column : columns.values()) {
                    if (!first) {
                        builder.append(", ");
                    }
                    first = false;
                    builder.append(column.getName()).append(" = EXCLUDED.");
                    this.delimiter(builder, column.getName(), false);
                }
            } else {
                builder.append(" DO NOTHING");
            }
        }
        return builder.toString();
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME) {
            return "now()";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATE) {
            return "CURRENT_DATE";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "CURRENT_TIME";
        }
        return null;
    }

    @Override
    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(runtime, args);
    }

    @Override
    protected String dummy() {
        return super.dummy();
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "BASE TABLE");
        types.put((Type)Table.TYPE.VIEW, "VIEW");
        types.put((Type)View.TYPE.NORMAL, "VIEW");
        types.put((Type)Metadata.TYPE.TABLE, "BASE TABLE");
        types.put((Type)Metadata.TYPE.VIEW, "VIEW");
    }
}

