/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.datasource;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;

public class ThreadConnectionHolder {
    protected static Log log = LogProxy.get(ThreadConnectionHolder.class);
    private static final ThreadLocal<Map<DataSource, Connection>> connections = new ThreadLocal();

    public static Connection get(DataSource ds) {
        Connection con = null;
        Map<DataSource, Connection> cons = connections.get();
        if (null != cons) {
            con = cons.get(ds);
        }
        if (null != con) {
            try {
                log.info("[\u83b7\u53d6\u7ebf\u7a0b\u5185\u4e8b\u52a1\u8fde\u63a5]");
                if (con.isClosed()) {
                    con = null;
                    log.info("[\u7ebf\u7a0b\u5185\u4e8b\u52a1\u8fde\u63a5\u5f02\u5e38\u5173\u95ed]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return con;
    }

    public static void set(DataSource ds, Connection con) {
        Map<DataSource, Connection> cons = connections.get();
        if (null == cons) {
            cons = new HashMap<DataSource, Connection>();
        }
        cons.put(ds, con);
        connections.set(cons);
    }

    public static void remove(DataSource ds) {
        Map<DataSource, Connection> cons = connections.get();
        if (null != cons) {
            cons.remove(ds);
        }
    }

    public static boolean contains(DataSource ds, Connection connection) {
        Map<DataSource, Connection> cons = connections.get();
        if (null != cons) {
            return connection == cons.get(ds);
        }
        return false;
    }
}

