/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.VariableBlock;
import org.anyline.data.prepare.init.AbstractCondition;
import org.anyline.data.prepare.init.DefaultVariableBlock;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.CommandParser;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class DefaultXMLCondition
extends AbstractCondition
implements Condition {
    private String text;
    protected List<VariableBlock> blocks = new ArrayList<VariableBlock>();

    @Override
    public DefaultXMLCondition clone() {
        DefaultXMLCondition clone = null;
        try {
            clone = (DefaultXMLCondition)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultXMLCondition();
        }
        clone.text = this.text;
        ArrayList cVariables = new ArrayList();
        HashMap<Variable, Variable> vmap = new HashMap<Variable, Variable>();
        for (Variable var : this.variables) {
            if (null == var) continue;
            Variable cvar = var.clone();
            vmap.put(var, cvar);
        }
        cVariables.addAll(vmap.values());
        clone.variables = cVariables;
        ArrayList<VariableBlock> cblocks = new ArrayList<VariableBlock>();
        for (VariableBlock block : this.blocks) {
            if (null == block) continue;
            VariableBlock cblock = block.clone();
            List<Variable> bvars = block.variables();
            for (Variable var : bvars) {
                Variable cvar = (Variable)vmap.get(var);
                cblock.variables().add(cvar);
            }
            cblocks.add(cblock);
        }
        clone.blocks = cblocks;
        clone.setSwt(this.swt);
        return clone;
    }

    public DefaultXMLCondition() {
        this.join = null;
    }

    public DefaultXMLCondition(String id, String text, boolean isStatic) {
        this.join = null;
        this.id = id;
        this.text = text;
        this.setVariableType(0);
        if (!isStatic) {
            this.parseText();
        } else {
            this.setVariableType(2);
        }
    }

    @Override
    public void init() {
        this.setActive(false);
        for (Variable variable : this.variables) {
            variable.init();
        }
    }

    @Override
    public void setValue(String variable, Object values) {
        this.runValuesMap.put(variable, values);
        if (null == variable) {
            return;
        }
        for (Variable v : this.variables) {
            if (null == v || !variable.equalsIgnoreCase(v.getKey())) continue;
            v.setValue(values);
            Compare.EMPTY_VALUE_SWITCH swt = v.getSwt();
            if (!BasicUtil.isNotEmpty((boolean)true, (Object)values) && swt != Compare.EMPTY_VALUE_SWITCH.NULL && swt != Compare.EMPTY_VALUE_SWITCH.SRC) continue;
            this.setActive(true);
        }
    }

    private void parseText() {
        this.parseText(this.text);
    }

    private void parseText(String text) {
        try {
            List boxes = RegularUtil.fetchs((String)text, (String)"\\$\\{.+?:.+?\\}", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            if (!boxes.isEmpty()) {
                String box = (String)((List)boxes.get(0)).get(0);
                String prev = RegularUtil.cut((String)text, (String[])new String[]{"${begin}", box});
                List<Variable> vars = CommandParser.parseTextVariable(ConfigTable.IS_ENABLE_PLACEHOLDER_REGEX_EXT, prev, Compare.EMPTY_VALUE_SWITCH.IGNORE);
                this.variables.addAll(vars);
                VariableBlock block = this.parseTextVarBox(text, box);
                if (null != block) {
                    this.blocks.add(block);
                    this.variables.addAll(block.variables());
                }
                String next = RegularUtil.cut((String)text, (String[])new String[]{box, "${end}"});
                this.parseText(next);
            } else {
                List<Variable> vars = CommandParser.parseTextVariable(ConfigTable.IS_ENABLE_PLACEHOLDER_REGEX_EXT, text, Compare.EMPTY_VALUE_SWITCH.IGNORE);
                if (!vars.isEmpty()) {
                    int type = vars.get(0).getType();
                    this.setVariableType(type);
                    if (type == 0) {
                        for (Variable var : vars) {
                            var.setKey(this.id);
                        }
                    }
                }
                this.variables.addAll(vars);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private VariableBlock parseTextVarBox(String text, String box) {
        if (null != box) {
            box = box.trim();
            String body = box.substring(2, box.length() - 1);
            List<Variable> vars = CommandParser.parseTextVariable(ConfigTable.IS_ENABLE_PLACEHOLDER_REGEX_EXT, body, Compare.EMPTY_VALUE_SWITCH.IGNORE);
            DefaultVariableBlock block = new DefaultVariableBlock(box, body);
            block.variables(vars);
            return block;
        }
        return null;
    }

    private void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getRunText(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        return this.getRunText(lvl, prefix, runtime, placeholder, unicode, this.text);
    }

    public String getRunText(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode, String text) {
        for (VariableBlock block : this.blocks) {
            String box = block.box();
            String body = block.body();
            boolean active = block.active();
            if (!active) {
                text = text.replace(box, "");
                this.variables.removeAll(block.variables());
                continue;
            }
            text = text.replace(box, body);
        }
        text = this.replaceVariable(lvl, prefix, runtime, placeholder, unicode, text);
        return text;
    }

    public String replaceVariable(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode, String text) {
        String value;
        List<Object> values;
        String result = text;
        this.runValues = new ArrayList();
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 3) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
            }
            if (BasicUtil.isNotEmpty(value)) {
                result = result.replace(var.getFullKey(), value);
                continue;
            }
            result = result.replace(var.getFullKey(), "NULL");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 2) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            if (null != value) {
                result = result.replace(var.getFullKey(), value);
                continue;
            }
            result = result.replace(var.getFullKey(), "");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 1) continue;
            List<Object> varValues = var.getValues();
            if (Compare.IN == var.getCompare()) {
                String replaceDst = "";
                for (int i = 0; i < varValues.size(); ++i) {
                    replaceDst = replaceDst + "?";
                    if (i >= varValues.size() - 1) continue;
                    replaceDst = replaceDst + ",";
                }
                result = result.replace(var.getFullKey(), replaceDst);
                for (Object obj : varValues) {
                    this.runValues.add(new RunValue(var.getKey(), obj));
                }
                continue;
            }
            result = result.replace(var.getFullKey(), "?");
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                value = varValues.get(0).toString();
            }
            this.runValues.add(new RunValue(var.getKey(), (Object)value));
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 0) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            this.runValues.add(new RunValue((String)null, (Object)value));
        }
        return result;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (Variable variable : this.variables) {
            if (null == variable) continue;
            List<Object> values = variable.getValues();
            if (this.swt != Compare.EMPTY_VALUE_SWITCH.BREAK || !BasicUtil.isEmpty((boolean)true, values)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.text;
    }
}

