/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.cache.CacheProvider;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.OriginRow;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.View;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.MD5Util;

public class CacheProxy {
    private static final ThreadLocal<OriginRow> thread_caches = new ThreadLocal();
    private static final ThreadLocal<OriginRow> thread_names = new ThreadLocal();
    private static OriginRow application_caches = new OriginRow();
    private static OriginRow application_names = new OriginRow();
    public static CacheProvider provider;

    public static void init(CacheProvider provider) {
        CacheProxy.provider = provider;
    }

    private static OriginRow caches() {
        OriginRow result = new OriginRow();
        if (ConfigTable.METADATA_CACHE_SCOPE == 1) {
            result = thread_caches.get();
            if (null == result) {
                result = new OriginRow();
                thread_caches.set(result);
            }
        } else if (ConfigTable.METADATA_CACHE_SCOPE == 9) {
            if (application_caches.isExpire(ConfigTable.METADATA_CACHE_SECOND * 1000)) {
                application_caches = new OriginRow();
            }
            result = application_caches;
        }
        return result;
    }

    private static OriginRow names() {
        OriginRow result = new OriginRow();
        if (ConfigTable.METADATA_CACHE_SCOPE == 1) {
            result = thread_names.get();
            if (null == result) {
                result = new OriginRow();
                thread_names.set(result);
            }
        } else if (ConfigTable.METADATA_CACHE_SCOPE == 9) {
            if (application_names.isExpire(ConfigTable.METADATA_CACHE_SECOND * 1000)) {
                application_names = new OriginRow();
            }
            result = application_names;
        }
        return result;
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        if (null != catalog) {
            key.append(catalog.getName());
        }
        key.append("_");
        if (null != schema) {
            key.append(schema.getName());
        }
        key.append("_").append(pattern).append("_").append(types);
        if (null != configs) {
            key.append(MD5Util.crypto((String)configs.json()));
        }
        return key.toString().toUpperCase();
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Table table) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        String name = null;
        String catalog = null;
        String schema = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalogName();
            schema = table.getSchemaName();
        }
        if (null != catalog) {
            key.append(catalog);
        }
        key.append("_");
        if (null != schema) {
            key.append(schema);
        }
        key.append("_").append(name);
        return key.toString().toUpperCase();
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        if (null != catalog) {
            key.append(catalog.getName());
        }
        key.append("_");
        if (null != schema) {
            key.append(schema.getName());
        }
        key.append("_").append(pattern);
        return key.toString().toUpperCase();
    }

    public static String name(String key) {
        return CacheProxy.names().getString(key.toUpperCase());
    }

    public static void name(String key, String origin) {
        CacheProxy.names().put(key.toUpperCase(), (Object)origin);
    }

    public static <T extends Table> List<T> tables(String cache) {
        List tables = (List)CacheProxy.caches().get(cache);
        return tables;
    }

    public static <T extends MasterTable> List<T> masters(String cache) {
        List tables = (List)CacheProxy.caches().get(cache);
        return tables;
    }

    public static <T extends EdgeTable> List<T> edges(String cache) {
        List tables = (List)CacheProxy.caches().get(cache);
        return tables;
    }

    public static <T extends VertexTable> List<T> vertexs(String cache) {
        List tables = (List)CacheProxy.caches().get(cache);
        return tables;
    }

    public static <T extends Table> void tables(String cache, List<T> tables) {
        CacheProxy.caches().put(cache, tables);
    }

    public static <T extends MasterTable> void masters(String cache, List<T> masters) {
        CacheProxy.caches().put(cache, masters);
    }

    public static <T extends VertexTable> void vertexs(String cache, List<T> vertexs) {
        CacheProxy.caches().put(cache, vertexs);
    }

    public static <T extends EdgeTable> void edges(String cache, List<T> edges) {
        CacheProxy.caches().put(cache, edges);
    }

    public static <T extends View> List<T> views(String cache) {
        List view = (List)CacheProxy.caches().get(cache);
        return view;
    }

    public static <T extends View> void views(String cache, List<T> view) {
        CacheProxy.caches().put(cache, view);
    }

    public static void cache(String cache, Object value) {
        CacheProxy.caches().put(cache, value);
    }

    public static <T extends Column> LinkedHashMap<String, T> columns(String key) {
        return (LinkedHashMap)CacheProxy.caches().get(key);
    }

    public static <T extends Tag> LinkedHashMap<String, T> tags(String key) {
        return (LinkedHashMap)CacheProxy.caches().get(key);
    }

    public static void clear() {
        CacheProxy.caches().clear();
        CacheProxy.names().clear();
    }
}

