/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.listener.init;

import java.util.Map;
import org.anyline.annotation.Component;
import org.anyline.bean.LoadListener;
import org.anyline.cache.CacheProvider;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.datasource.DataSourceMonitor;
import org.anyline.data.interceptor.CountInterceptor;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.interceptor.DeleteInterceptor;
import org.anyline.data.interceptor.ExecuteInterceptor;
import org.anyline.data.interceptor.InsertInterceptor;
import org.anyline.data.interceptor.QueryInterceptor;
import org.anyline.data.interceptor.UpdateInterceptor;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.listener.jdbc")
public class DataSourceLoadListener
implements LoadListener {
    private static Log log = LogProxy.get(DataSourceLoadListener.class);

    public void start() {
        CacheProvider provider = (CacheProvider)ConfigTable.environment().getBean(CacheProvider.class);
        CacheProxy.init(provider);
        InterceptorProxy.setQueryInterceptors(ConfigTable.environment().getBeans(QueryInterceptor.class));
        InterceptorProxy.setCountInterceptors(ConfigTable.environment().getBeans(CountInterceptor.class));
        InterceptorProxy.setUpdateInterceptors(ConfigTable.environment().getBeans(UpdateInterceptor.class));
        InterceptorProxy.setInsertInterceptors(ConfigTable.environment().getBeans(InsertInterceptor.class));
        InterceptorProxy.setDeleteInterceptors(ConfigTable.environment().getBeans(DeleteInterceptor.class));
        InterceptorProxy.setExecuteInterceptors(ConfigTable.environment().getBeans(ExecuteInterceptor.class));
        InterceptorProxy.setDDInterceptors(ConfigTable.environment().getBeans(DDInterceptor.class));
        PrimaryGenerator primaryGenerator = (PrimaryGenerator)ConfigTable.environment().getBean(PrimaryGenerator.class);
        DMListener dmListener = (DMListener)ConfigTable.environment().getBean(DMListener.class);
        DDListener ddListener = (DDListener)ConfigTable.environment().getBean(DDListener.class);
        Map adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        Map actuators = ConfigTable.environment().getBeans(DriverActuator.class);
        Map loaders = ConfigTable.environment().getBeans(DataSourceLoader.class);
        DataSourceMonitor monitor = (DataSourceMonitor)ConfigTable.environment().getBean(DataSourceMonitor.class);
        DriverAdapterHolder.setMonitor(monitor);
        if (null != adapters) {
            DriverAdapterHolder.setAdapters(adapters);
            for (DriverAdapter adapter : adapters.values()) {
                String delimiter;
                if (null != dmListener) {
                    adapter.setListener(dmListener);
                }
                if (null != ddListener) {
                    adapter.setListener(ddListener);
                }
                if (null != primaryGenerator) {
                    adapter.setGenerator(primaryGenerator);
                }
                if (null == (delimiter = ConfigTable.getString((String)("anyline.data.jdbc.delimiter." + adapter.type().name().toLowerCase())))) continue;
                adapter.setDelimiter(delimiter);
            }
        }
        if (null != loaders) {
            for (DataSourceLoader loader : loaders.values()) {
                loader.load();
            }
        }
        if (null == adapters || adapters.isEmpty()) {
            adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        }
        if (null == actuators || actuators.isEmpty()) {
            actuators = ConfigTable.environment().getBeans(DriverActuator.class);
        }
        if (null != actuators && null != adapters) {
            for (DriverActuator actuator : actuators.values()) {
                Class<? extends DriverAdapter> clazz = actuator.supportAdapterType();
                for (DriverAdapter adapter : adapters.values()) {
                    DriverActuator origin;
                    if (!ClassUtil.isInSub(adapter.getClass(), (Class[])new Class[]{clazz}) || null != (origin = adapter.getActuator()) && origin.priority() >= actuator.priority()) continue;
                    adapter.setActuator(actuator);
                }
            }
        }
        if (null != adapters) {
            for (DriverAdapter adapter : adapters.values()) {
                if (null != adapter.getActuator()) continue;
                log.warn("[not found actuator][adapter:{}]", (Object)adapter);
            }
        }
    }

    public void after() {
        if (ConfigTable.environment().containsBean("anyline.service.default")) {
            ConfigTable.environment().regAlias("anyline.service.default", "anyline.service");
            AnylineService service = (AnylineService)ConfigTable.environment().getBean("anyline.service.default", AnylineService.class);
            if (null != service) {
                ServiceProxy.init(service);
                Map services = ConfigTable.environment().getBeans(AnylineService.class);
                for (AnylineService item : services.values()) {
                    if (null != item.getDao()) continue;
                    item.setDao(service.getDao());
                }
            }
        }
    }
}

