/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TextRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.GroupStore;
import org.anyline.entity.OriginRow;
import org.anyline.util.BasicUtil;

public class DefaultTextPrepare
extends DefaultAutoPrepare
implements TextPrepare {
    private String up;
    private String order;
    private String having;
    private String group;
    private String where;

    public DefaultTextPrepare(String text) {
        this.text = text;
        this.chain = new DefaultAutoConditionChain();
        this.split();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Run build(DataRuntime runtime) {
        TextRun run = new TextRun();
        run.setPrepare(this);
        run.setRuntime(runtime);
        if (null != this.orders) {
            run.setOrders(this.orders);
        }
        if (null != this.group) {
            GroupStore groups = run.getGroups();
            groups.add(this.group);
        }
        if (null != this.having) {
            run.having(this.having);
        }
        if (null != this.where) {
            run.addCondition(this.where);
        }
        return run;
    }

    @Override
    public DataRow map(boolean empty, boolean join) {
        OriginRow row = new OriginRow();
        row.put("text", (Object)this.text);
        return row;
    }

    @Override
    public RunPrepare setContent(String content) {
        this.text = content;
        return this;
    }

    private void split() {
        this.text = this.text.replaceAll("\\s{2,}", " ");
        this.up = this.text.toUpperCase();
        this.order = this.split("ORDER BY");
        if (BasicUtil.isNotEmpty((Object)this.order)) {
            this.orders.add(this.order);
        }
        this.having = this.split("HAVING ");
        this.group = this.split("GROUP BY");
        this.where = this.split("WHERE ");
    }

    private String split(String type) {
        String chk;
        int idx = this.up.lastIndexOf(type);
        if (idx != -1 && BasicUtil.charCount((String)(chk = this.up.substring(idx)), (String)"(") == BasicUtil.charCount((String)chk, (String)")") && BasicUtil.charCount((String)chk, (String)"'") % 2 == 0) {
            this.up = this.up.substring(0, idx);
            String result = this.text.substring(idx + type.length());
            this.text = this.text.substring(0, idx);
            return result;
        }
        return null;
    }
}

