/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.VariableBlock;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;

public class DefaultVariableBlock
implements VariableBlock {
    protected List<Variable> variables = new ArrayList<Variable>();
    protected String box;
    protected String body;

    public DefaultVariableBlock() {
    }

    public DefaultVariableBlock(String box, String body) {
        this.box = box;
        this.body = body;
    }

    @Override
    public String box() {
        return this.box;
    }

    @Override
    public VariableBlock box(String box) {
        this.box = box;
        return this;
    }

    @Override
    public String body() {
        return this.body;
    }

    @Override
    public VariableBlock body(String body) {
        this.body = body;
        return this;
    }

    @Override
    public List<Variable> variables() {
        return this.variables;
    }

    @Override
    public VariableBlock variables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public VariableBlock add(Variable ... variables) {
        for (Variable variable : variables) {
            this.variables.add(variable);
        }
        return this;
    }

    @Override
    public boolean active() {
        for (Variable var : this.variables) {
            Compare.EMPTY_VALUE_SWITCH swt = var.getSwt();
            List<Object> values = var.getValues();
            if (BasicUtil.isEmpty(values)) {
                return false;
            }
            for (Object value : values) {
                if (!BasicUtil.isEmpty((Object)value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public VariableBlock clone() {
        DefaultVariableBlock clone = new DefaultVariableBlock();
        clone.box = this.box;
        clone.body = this.body;
        clone.variables = new ArrayList<Variable>();
        return clone;
    }
}

