/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.util.ConfigTable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringJDBCRuntime
extends JDBCRuntime
implements DataRuntime {
    protected JdbcTemplate processor;

    public SpringJDBCRuntime(String key, JdbcTemplate jdbc, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(jdbc);
        this.setAdapter(adapter);
    }

    public SpringJDBCRuntime() {
    }

    public JdbcTemplate jdbc() {
        return this.processor;
    }

    public DataSource getDataSource() {
        if (null != this.processor) {
            return this.processor.getDataSource();
        }
        return null;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (JdbcTemplate)processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAdapterKey() {
        JdbcTemplate jdbc;
        String result = null;
        boolean keep = DriverAdapterHolder.keepAdapter((DataRuntime)this, (Object)this.getProcessor());
        if (ConfigTable.KEEP_ADAPTER == 1) {
            result = this.adapterKey;
            keep = true;
        }
        if (!keep) {
            result = null;
        }
        if (null == result && null != (jdbc = this.jdbc())) {
            DataSource datasource = null;
            Connection con = null;
            try {
                datasource = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)datasource);
                DatabaseMetaData meta = con.getMetaData();
                String url = meta.getURL();
                result = DataSourceUtil.parseAdapterKey((String)url);
                if (null == this.adapterKey && ConfigTable.KEEP_ADAPTER == 1) {
                    this.adapterKey = result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getFeature(boolean connection) {
        keep = DriverAdapterHolder.keepAdapter((DataRuntime)this, (Object)this.getProcessor());
        feature = DriverAdapterHolder.feature((DataRuntime)this, (Object)this.getProcessor());
        url = null;
        driver = null;
        if (ConfigTable.KEEP_ADAPTER == 1) {
            feature = this.feature;
            url = this.url;
            driver = this.driver;
            keep = true;
        }
        if (!keep) {
            connection = true;
            driver = null;
            url = null;
        }
        if (null == feature) {
            if (connection || null == driver || null == url) {
                jdbc = this.jdbc();
                if (null != jdbc) {
                    datasource = null;
                    con = null;
                    try {
                        datasource = jdbc.getDataSource();
                        con = DataSourceUtils.getConnection((DataSource)datasource);
                        meta = con.getMetaData();
                        url = meta.getURL();
                        if (null == this.adapterKey && ConfigTable.KEEP_ADAPTER == 1) {
                            this.adapterKey = DataSourceUtil.parseAdapterKey((String)url);
                        }
                        feature = meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + url;
                        if (null != this.version) ** GOTO lbl40
                        this.version = meta.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                            DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
                        }
                    }
                }
            } else {
                feature = url;
            }
lbl40:
            // 5 sources

            if (null != driver) {
                feature = driver + "_" + feature;
            }
        }
        if (null == this.adapterKey && keep) {
            this.adapterKey = DataSourceUtil.parseAdapterKey((String)feature);
        }
        if (keep) {
            this.feature = feature;
            this.url = url;
        }
        this.setLastFeature(feature);
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        JdbcTemplate jdbc;
        if (null == this.version && null != (jdbc = this.jdbc())) {
            DataSource datasource = null;
            Connection con = null;
            try {
                datasource = jdbc.getDataSource();
                con = DataSourceUtils.getConnection((DataSource)datasource);
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                    DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
                }
            }
        }
        return this.version;
    }

    public boolean destroy() throws Exception {
        JDBCRuntimeHolder.instance().destroy(this.key);
        return true;
    }
}

