/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

public final class GlobCompiler
implements PatternCompiler {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;
    public static final int READ_ONLY_MASK = 8;
    private Perl5Compiler __perl5Compiler = new Perl5Compiler();

    private static boolean __isPerl5MetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '+' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '|' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '\\';
    }

    private static boolean __isGlobMetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '[' || ch == ']';
    }

    public static String globToPerl5(char[] pattern, int options) {
        boolean starCannotMatchNull = false;
        StringBuffer buffer = new StringBuffer(2 * pattern.length);
        boolean inCharSet = false;
        boolean questionMatchesZero = (options & 4) != 0;
        starCannotMatchNull = (options & 2) != 0;
        block11: for (int ch = 0; ch < pattern.length; ++ch) {
            switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    if (starCannotMatchNull) {
                        buffer.append(".+");
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    if (questionMatchesZero) {
                        buffer.append(".?");
                        continue block11;
                    }
                    buffer.append('.');
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) continue block11;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (GlobCompiler.__isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && GlobCompiler.__isPerl5MetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public Pattern compile(char[] pattern, int options) throws MalformedPatternException {
        int perlOptions = 0;
        if ((options & 1) != 0) {
            perlOptions |= 1;
        }
        if ((options & 8) != 0) {
            perlOptions |= 0x8000;
        }
        return this.__perl5Compiler.compile(GlobCompiler.globToPerl5(pattern, options), perlOptions);
    }

    @Override
    public Pattern compile(char[] pattern) throws MalformedPatternException {
        return this.compile(pattern, 0);
    }

    @Override
    public Pattern compile(String pattern) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), 0);
    }

    @Override
    public Pattern compile(String pattern, int options) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), options);
    }
}

