/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.sasl;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.security.AuthenticationBroker;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.sasl.AnonymousMechanism;
import org.apache.activemq.transport.amqp.sasl.PlainMechanism;
import org.apache.activemq.transport.amqp.sasl.SaslMechanism;
import org.apache.qpid.proton.engine.Sasl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAuthenticator.class);
    private static final String[] mechanisms = new String[]{"PLAIN", "ANONYMOUS"};
    private final BrokerService brokerService;
    private final AmqpTransport transport;
    private final Sasl sasl;
    private AuthenticationBroker authenticator;

    public AmqpAuthenticator(AmqpTransport transport, Sasl sasl, BrokerService brokerService) {
        this.brokerService = brokerService;
        this.transport = transport;
        this.sasl = sasl;
        sasl.setMechanisms(mechanisms);
        sasl.server();
    }

    public boolean isDone() {
        return this.sasl.getOutcome() != Sasl.SaslOutcome.PN_SASL_NONE;
    }

    public String[] getSupportedMechanisms() {
        return mechanisms;
    }

    public void processSaslExchange(ConnectionInfo connectionInfo) {
        if (this.sasl.getRemoteMechanisms().length > 0) {
            SaslMechanism mechanism = this.getSaslMechanism(this.sasl.getRemoteMechanisms());
            if (mechanism != null) {
                LOG.debug("SASL [{}} Handshake started.", (Object)mechanism.getMechanismName());
                mechanism.processSaslStep(this.sasl);
                connectionInfo.setUserName(mechanism.getUsername());
                connectionInfo.setPassword(mechanism.getPassword());
                if (this.tryAuthenticate(connectionInfo, this.transport.getPeerCertificates())) {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                } else {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                LOG.debug("SASL [{}} Handshake complete.", (Object)mechanism.getMechanismName());
            } else {
                LOG.info("SASL: could not find supported mechanism");
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_PERM);
            }
        }
    }

    private SaslMechanism getSaslMechanism(String[] remoteMechanisms) {
        String primary = remoteMechanisms[0];
        if (primary.equalsIgnoreCase("PLAIN")) {
            return new PlainMechanism();
        }
        if (primary.equalsIgnoreCase("ANONYMOUS")) {
            return new AnonymousMechanism();
        }
        return null;
    }

    private boolean tryAuthenticate(ConnectionInfo info, X509Certificate[] peerCertificates) {
        try {
            return this.getAuthenticator().authenticate(info.getUserName(), info.getPassword(), peerCertificates) != null;
        }
        catch (Throwable error) {
            return false;
        }
    }

    private AuthenticationBroker getAuthenticator() {
        if (this.authenticator == null) {
            try {
                this.authenticator = (AuthenticationBroker)((Object)this.brokerService.getBroker().getAdaptor(AuthenticationBroker.class));
            }
            catch (Exception e) {
                LOG.debug("Failed to lookup AuthenticationBroker from Broker, will use a default Noop version.");
            }
            if (this.authenticator == null) {
                this.authenticator = new DefaultAuthenticationBroker();
            }
        }
        return this.authenticator;
    }

    private class DefaultAuthenticationBroker
    implements AuthenticationBroker {
        private DefaultAuthenticationBroker() {
        }

        @Override
        public SecurityContext authenticate(String username, String password, X509Certificate[] peerCertificates) throws SecurityException {
            return new SecurityContext(username){

                @Override
                public Set<Principal> getPrincipals() {
                    return null;
                }
            };
        }
    }
}

