/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    final TemporaryReplyQueueDestinationResolver destResolver = new TemporaryReplyQueueDestinationResolver();

    public TemporaryQueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public Destination getReplyTo() {
        try {
            this.destResolver.destinationReady();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for JMSReplyTo destination refresh", e);
        }
        return super.getReplyTo();
    }

    @Override
    protected ReplyHandler createReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        return new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    @Override
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, message);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        DefaultJmsMessageListenerContainer answer = new DefaultJmsMessageListenerContainer(this.endpoint, false);
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(this.destResolver);
        answer.setAutoStartup(true);
        if (this.endpoint.getMaxMessagesPerTask() >= 0) {
            answer.setMaxMessagesPerTask(this.endpoint.getMaxMessagesPerTask());
        }
        answer.setIdleConsumerLimit(this.endpoint.getIdleConsumerLimit());
        answer.setIdleTaskExecutionLimit(this.endpoint.getIdleTaskExecutionLimit());
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getConcurrentConsumers());
        if (this.endpoint.getMaxConcurrentConsumers() > 0) {
            answer.setMaxConcurrentConsumers(this.endpoint.getMaxConcurrentConsumers());
        }
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        if (this.endpoint.getReplyToCacheLevelName() != null) {
            if ("CACHE_NONE".equals(this.endpoint.getReplyToCacheLevelName())) {
                throw new IllegalArgumentException("ReplyToCacheLevelName cannot be CACHE_NONE when using temporary reply queues. The value must be either CACHE_CONSUMER, or CACHE_SESSION");
            }
            answer.setCacheLevelName(this.endpoint.getReplyToCacheLevelName());
        } else {
            answer.setCacheLevel(3);
        }
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setSessionTransacted(false);
        answer.setExceptionListener(new TemporaryReplyQueueExceptionListener(this.destResolver, this.endpoint.getExceptionListener()));
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler(new DefaultSpringErrorHandler(this.endpoint.getCamelContext(), TemporaryQueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            }
            answer.setTaskExecutor(this.endpoint.getTaskExecutor());
        }
        String name = "TemporaryQueueReplyManager[" + this.endpoint.getDestinationName() + "]";
        answer.setBeanName(name);
        if (answer.getConcurrentConsumers() > 1) {
            this.log.info("Using {}-{} concurrent consumers on {}", answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name);
        }
        return answer;
    }

    private final class TemporaryReplyQueueDestinationResolver
    implements DestinationResolver {
        private TemporaryQueue queue;
        private final AtomicBoolean refreshWanted = new AtomicBoolean(false);

        private TemporaryReplyQueueDestinationResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            AtomicBoolean atomicBoolean = this.refreshWanted;
            synchronized (atomicBoolean) {
                if (this.queue == null || this.refreshWanted.compareAndSet(true, false)) {
                    this.queue = session.createTemporaryQueue();
                    TemporaryQueueReplyManager.this.setReplyTo(this.queue);
                    if (TemporaryQueueReplyManager.this.log.isDebugEnabled()) {
                        TemporaryQueueReplyManager.this.log.debug("Refreshed Temporary ReplyTo Queue. New queue: {}", (Object)this.queue.getQueueName());
                    }
                    this.refreshWanted.notifyAll();
                }
            }
            return this.queue;
        }

        public void scheduleRefresh() {
            this.refreshWanted.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destinationReady() throws InterruptedException {
            if (this.refreshWanted.get()) {
                AtomicBoolean atomicBoolean = this.refreshWanted;
                synchronized (atomicBoolean) {
                    TemporaryQueueReplyManager.this.log.debug("Waiting for new Temporary ReplyTo queue to be assigned before we can continue");
                    this.refreshWanted.wait();
                }
            }
        }
    }

    private final class TemporaryReplyQueueExceptionListener
    implements ExceptionListener {
        private final TemporaryReplyQueueDestinationResolver destResolver;
        private final ExceptionListener delegate;

        private TemporaryReplyQueueExceptionListener(TemporaryReplyQueueDestinationResolver destResolver, ExceptionListener delegate) {
            this.destResolver = destResolver;
            this.delegate = delegate;
        }

        @Override
        public void onException(JMSException exception) {
            TemporaryQueueReplyManager.this.log.warn("Exception inside the DMLC for Temporary ReplyTo Queue for destination " + TemporaryQueueReplyManager.this.endpoint.getDestinationName() + ", refreshing ReplyTo destination", exception);
            this.destResolver.scheduleRefresh();
            if (this.delegate != null) {
                this.delegate.onException(exception);
            }
        }
    }
}

