/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.builder.DefaultFluentProducerTemplate;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ServiceHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelFluentProducerTemplateFactoryBean
extends AbstractCamelFactoryBean<FluentProducerTemplate> {
    @XmlTransient
    private FluentProducerTemplate template;
    @XmlAttribute
    @Metadata(description="Sets the default endpoint URI used by default for sending message exchanges")
    private String defaultEndpoint;
    @XmlAttribute
    @Metadata(description="Sets a custom maximum cache size to use in the backing cache pools.")
    private Integer maximumCacheSize;

    @Override
    public FluentProducerTemplate getObject() throws Exception {
        CamelContext context = this.getCamelContext();
        if (this.defaultEndpoint != null) {
            Endpoint endpoint = context.getEndpoint(this.defaultEndpoint);
            if (endpoint == null) {
                throw new IllegalArgumentException("No endpoint found for URI: " + this.defaultEndpoint);
            }
            this.template = new DefaultFluentProducerTemplate(context);
            this.template.setDefaultEndpoint(endpoint);
        } else {
            this.template = new DefaultFluentProducerTemplate(context);
        }
        if (this.maximumCacheSize != null) {
            this.template.setMaximumCacheSize(this.maximumCacheSize);
        }
        ServiceHelper.startService(this.template);
        return this.template;
    }

    @Override
    public Class<DefaultFluentProducerTemplate> getObjectType() {
        return DefaultFluentProducerTemplate.class;
    }

    @Override
    public void destroy() throws Exception {
        ServiceHelper.stopService(this.template);
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public Integer getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(Integer maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }
}

