/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v1;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v1.BaseCommandMarshaller;

public class MessageDispatchMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 21;
    }

    @Override
    public DataStructure createObject() {
        return new MessageDispatch();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessageDispatch info2 = (MessageDispatch)o;
        info2.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setMessage((Message)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setRedeliveryCounter(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageDispatch info2 = (MessageDispatch)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConsumerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getMessage(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessageDispatch info2 = (MessageDispatch)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getConsumerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getMessage(), dataOut, bs);
        dataOut.writeInt(info2.getRedeliveryCounter());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessageDispatch info2 = (MessageDispatch)o;
        info2.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setMessage((Message)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setRedeliveryCounter(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessageDispatch info2 = (MessageDispatch)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConsumerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getMessage(), dataOut);
        dataOut.writeInt(info2.getRedeliveryCounter());
    }
}

