/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v9;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v9.BaseCommandMarshaller;

public abstract class MessageMarshaller
extends BaseCommandMarshaller {
    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        int i;
        BrokerId[] value;
        int size2;
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        Message info2 = (Message)o;
        info2.beforeUnmarshall(wireFormat);
        info2.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setOriginalDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setOriginalTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setGroupID(this.tightUnmarshalString(dataIn, bs));
        info2.setGroupSequence(dataIn.readInt());
        info2.setCorrelationId(this.tightUnmarshalString(dataIn, bs));
        info2.setPersistent(bs.readBoolean());
        info2.setExpiration(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setPriority(dataIn.readByte());
        info2.setReplyTo((ActiveMQDestination)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setTimestamp(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setType(this.tightUnmarshalString(dataIn, bs));
        info2.setContent(this.tightUnmarshalByteSequence(dataIn, bs));
        info2.setMarshalledProperties(this.tightUnmarshalByteSequence(dataIn, bs));
        info2.setDataStructure(this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setTargetConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setCompressed(bs.readBoolean());
        info2.setRedeliveryCounter(dataIn.readInt());
        if (bs.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setArrival(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setUserID(this.tightUnmarshalString(dataIn, bs));
        info2.setRecievedByDFBridge(bs.readBoolean());
        info2.setDroppable(bs.readBoolean());
        if (bs.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setCluster(value);
        } else {
            info2.setCluster(null);
        }
        info2.setBrokerInTime(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setBrokerOutTime(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.afterUnmarshall(wireFormat);
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Message info2 = (Message)o;
        info2.beforeMarshall(wireFormat);
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getProducerId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getTransactionId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getOriginalDestination(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getMessageId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getOriginalTransactionId(), bs);
        rc += this.tightMarshalString1(info2.getGroupID(), bs);
        rc += this.tightMarshalString1(info2.getCorrelationId(), bs);
        bs.writeBoolean(info2.isPersistent());
        rc += this.tightMarshalLong1(wireFormat, info2.getExpiration(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getReplyTo(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getTimestamp(), bs);
        rc += this.tightMarshalString1(info2.getType(), bs);
        rc += this.tightMarshalByteSequence1(info2.getContent(), bs);
        rc += this.tightMarshalByteSequence1(info2.getMarshalledProperties(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getDataStructure(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getTargetConsumerId(), bs);
        bs.writeBoolean(info2.isCompressed());
        rc += this.tightMarshalObjectArray1(wireFormat, info2.getBrokerPath(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getArrival(), bs);
        rc += this.tightMarshalString1(info2.getUserID(), bs);
        bs.writeBoolean(info2.isRecievedByDFBridge());
        bs.writeBoolean(info2.isDroppable());
        rc += this.tightMarshalObjectArray1(wireFormat, info2.getCluster(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getBrokerInTime(), bs);
        return (rc += this.tightMarshalLong1(wireFormat, info2.getBrokerOutTime(), bs)) + 9;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        Message info2 = (Message)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getProducerId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getTransactionId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getOriginalDestination(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getMessageId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getOriginalTransactionId(), dataOut, bs);
        this.tightMarshalString2(info2.getGroupID(), dataOut, bs);
        dataOut.writeInt(info2.getGroupSequence());
        this.tightMarshalString2(info2.getCorrelationId(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalLong2(wireFormat, info2.getExpiration(), dataOut, bs);
        dataOut.writeByte(info2.getPriority());
        this.tightMarshalNestedObject2(wireFormat, info2.getReplyTo(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getTimestamp(), dataOut, bs);
        this.tightMarshalString2(info2.getType(), dataOut, bs);
        this.tightMarshalByteSequence2(info2.getContent(), dataOut, bs);
        this.tightMarshalByteSequence2(info2.getMarshalledProperties(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getDataStructure(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getTargetConsumerId(), dataOut, bs);
        bs.readBoolean();
        dataOut.writeInt(info2.getRedeliveryCounter());
        this.tightMarshalObjectArray2(wireFormat, info2.getBrokerPath(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getArrival(), dataOut, bs);
        this.tightMarshalString2(info2.getUserID(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalObjectArray2(wireFormat, info2.getCluster(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getBrokerInTime(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getBrokerOutTime(), dataOut, bs);
        info2.afterMarshall(wireFormat);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        int i;
        BrokerId[] value;
        int size2;
        super.looseUnmarshal(wireFormat, o, dataIn);
        Message info2 = (Message)o;
        info2.beforeUnmarshall(wireFormat);
        info2.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setOriginalDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setOriginalTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setGroupID(this.looseUnmarshalString(dataIn));
        info2.setGroupSequence(dataIn.readInt());
        info2.setCorrelationId(this.looseUnmarshalString(dataIn));
        info2.setPersistent(dataIn.readBoolean());
        info2.setExpiration(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setPriority(dataIn.readByte());
        info2.setReplyTo((ActiveMQDestination)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setTimestamp(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setType(this.looseUnmarshalString(dataIn));
        info2.setContent(this.looseUnmarshalByteSequence(dataIn));
        info2.setMarshalledProperties(this.looseUnmarshalByteSequence(dataIn));
        info2.setDataStructure(this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setTargetConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setCompressed(dataIn.readBoolean());
        info2.setRedeliveryCounter(dataIn.readInt());
        if (dataIn.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setArrival(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setUserID(this.looseUnmarshalString(dataIn));
        info2.setRecievedByDFBridge(dataIn.readBoolean());
        info2.setDroppable(dataIn.readBoolean());
        if (dataIn.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setCluster(value);
        } else {
            info2.setCluster(null);
        }
        info2.setBrokerInTime(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setBrokerOutTime(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.afterUnmarshall(wireFormat);
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        Message info2 = (Message)o;
        info2.beforeMarshall(wireFormat);
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getProducerId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getTransactionId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getOriginalDestination(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getMessageId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getOriginalTransactionId(), dataOut);
        this.looseMarshalString(info2.getGroupID(), dataOut);
        dataOut.writeInt(info2.getGroupSequence());
        this.looseMarshalString(info2.getCorrelationId(), dataOut);
        dataOut.writeBoolean(info2.isPersistent());
        this.looseMarshalLong(wireFormat, info2.getExpiration(), dataOut);
        dataOut.writeByte(info2.getPriority());
        this.looseMarshalNestedObject(wireFormat, info2.getReplyTo(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getTimestamp(), dataOut);
        this.looseMarshalString(info2.getType(), dataOut);
        this.looseMarshalByteSequence(wireFormat, info2.getContent(), dataOut);
        this.looseMarshalByteSequence(wireFormat, info2.getMarshalledProperties(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getDataStructure(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getTargetConsumerId(), dataOut);
        dataOut.writeBoolean(info2.isCompressed());
        dataOut.writeInt(info2.getRedeliveryCounter());
        this.looseMarshalObjectArray(wireFormat, info2.getBrokerPath(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getArrival(), dataOut);
        this.looseMarshalString(info2.getUserID(), dataOut);
        dataOut.writeBoolean(info2.isRecievedByDFBridge());
        dataOut.writeBoolean(info2.isDroppable());
        this.looseMarshalObjectArray(wireFormat, info2.getCluster(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getBrokerInTime(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getBrokerOutTime(), dataOut);
    }
}

