/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;

public class AxisServer {
    protected ConfigurationContext configContext;
    protected ListenerManager listenerManager;
    private boolean startOnDeploy;
    private boolean started = false;

    public AxisServer(boolean startOnDeploy) {
        this.startOnDeploy = startOnDeploy;
        this.listenerManager = new ListenerManager();
    }

    public AxisServer() {
        this(true);
    }

    public void deployService(String serviceClassName) throws AxisFault {
        if (this.configContext == null) {
            this.configContext = this.getConfigurationContext();
        }
        AxisConfiguration axisConfig = this.configContext.getAxisConfiguration();
        AxisService service = AxisService.createService(serviceClassName, axisConfig);
        axisConfig.addService(service);
        if (this.startOnDeploy) {
            this.start();
        }
    }

    protected void start() throws AxisFault {
        if (this.configContext == null) {
            this.configContext = this.getConfigurationContext();
        }
        if (!this.started) {
            this.listenerManager.startSystem(this.configContext);
            this.started = true;
        }
    }

    public void stop() throws AxisFault {
        if (this.configContext != null) {
            this.configContext.terminate();
        }
    }

    public void setConfigurationContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public ConfigurationContext getConfigurationContext() throws AxisFault {
        if (this.configContext == null) {
            this.configContext = this.createDefaultConfigurationContext();
        }
        return this.configContext;
    }

    protected ConfigurationContext createDefaultConfigurationContext() throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(null);
    }
}

